/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.taxa;

import com.stratadata.model3.user.User;
import com.stratadata.util.ui.DialogBase;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.uiutil.TextFieldUtils;
import jsbugs.userconnect.DialogSelectAnalyst;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBdb;
import model3.Taxon;
import net.miginfocom.swing.MigLayout;
import util.SBException;

public class DialogSelectTaxaAdvDict
extends DialogBase {
    private final SBdb sbdb;
    private final List<Taxon> selection = new ArrayList<Taxon>();
    private JLabel jLabel3;
    private JFormattedTextField jFormattedTextFieldDateFrom;
    private JLabel jLabel1;
    private JFormattedTextField jFormattedTextFieldDateTo;
    private JLabel label1;
    private JTextField jTextFieldUser;
    private JButton jButtonUser;
    private JSeparator separator1;

    public DialogSelectTaxaAdvDict(Frame parent, SBdb sbdb) {
        super((Window)parent);
        this.sbdb = sbdb;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Search Taxon Dictionary");
        TextFieldUtils.initSBDateFormatter(this.jFormattedTextFieldDateTo, null);
        TextFieldUtils.initSBDateFormatter(this.jFormattedTextFieldDateFrom, null);
        this.addOkButtonActionListener(e -> this.jButtonSearchActionPerformed(e));
    }

    private void jButtonUserActionPerformed() {
        try {
            DialogSelectAnalyst dialog = new DialogSelectAnalyst((JDialog)((Object)this), true, this.sbdb, true);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.selectedUser != null) {
                this.jTextFieldUser.setText(dialog.selectedUser.getAbr());
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, (Component)((Object)this));
        }
    }

    private void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("locale.UiText");
        this.jLabel3 = new JLabel();
        this.jFormattedTextFieldDateFrom = new JFormattedTextField();
        this.jLabel1 = new JLabel();
        this.jFormattedTextFieldDateTo = new JFormattedTextField();
        this.label1 = new JLabel();
        this.jTextFieldUser = new JTextField();
        this.jButtonUser = new JButton();
        this.separator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.setOkText(bundle.getString("button.search"));
        JPanel contentPanel = this.getContentPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("insets dialog,hidemode 3,gap 5 5", "[fill][left][fill]", "[fill][][]"));
        this.jLabel3.setText("Created or modified between:");
        contentPanel.add((Component)this.jLabel3, "cell 0 0");
        this.jFormattedTextFieldDateFrom.setPreferredSize(new Dimension(120, 22));
        this.jFormattedTextFieldDateFrom.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogSelectTaxaAdvDict this$0;
            {
                DialogSelectTaxaAdvDict dialogSelectTaxaAdvDict = this$0;
                Objects.requireNonNull(dialogSelectTaxaAdvDict);
                this.this$0 = dialogSelectTaxaAdvDict;
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.this$0.jFormattedTextFieldDateFromFocusLost(e);
            }
        });
        contentPanel.add((Component)this.jFormattedTextFieldDateFrom, "cell 1 0");
        this.jLabel1.setText("and");
        contentPanel.add((Component)this.jLabel1, "cell 2 0");
        this.jFormattedTextFieldDateTo.setToolTipText("Leave blank for today");
        this.jFormattedTextFieldDateTo.setPreferredSize(new Dimension(120, 22));
        contentPanel.add((Component)this.jFormattedTextFieldDateTo, "cell 2 0");
        this.label1.setText("By user:");
        contentPanel.add((Component)this.label1, "cell 0 1,alignx right,growx 0");
        this.jTextFieldUser.setPreferredSize(new Dimension(80, 22));
        this.jTextFieldUser.setToolTipText("Leave blank for any user");
        contentPanel.add((Component)this.jTextFieldUser, "cell 1 1,alignx left,growx 0");
        this.jButtonUser.setText(bundle.getString("ellipsis"));
        this.jButtonUser.setPreferredSize(new Dimension(30, 22));
        this.jButtonUser.addActionListener(e -> this.jButtonUserActionPerformed());
        contentPanel.add((Component)this.jButtonUser, "cell 1 1");
        contentPanel.add((Component)this.separator1, "cell 0 2 3 1");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void jButtonSearchActionPerformed(ActionEvent evt) {
        Date fromDate = (Date)this.jFormattedTextFieldDateFrom.getValue();
        if (fromDate == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Enter a start date", this.getTitle(), 2);
            return;
        }
        Date toDate = (Date)this.jFormattedTextFieldDateTo.getValue();
        if (toDate == null) {
            toDate = new Date();
        }
        Integer modifier = null;
        if (!this.jTextFieldUser.getText().isEmpty() && (modifier = (Integer)this.sbdb.getUserService().findUserByAbr(this.jTextFieldUser.getText().toUpperCase().trim()).map(User::getUserID).orElse(null)) == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Unrecognised analyst", this.getTitle(), 2);
            return;
        }
        try {
            this.selection.clear();
            this.selection.addAll(Taxon.search(this.sbdb, fromDate, toDate, modifier));
            if (this.selection.isEmpty()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "No taxa found", this.getTitle(), 2);
                return;
            }
            this.dispose();
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError("Error searching for taxa", e, (Component)((Object)this));
        }
    }

    private void jFormattedTextFieldDateFromFocusLost(FocusEvent evt) {
        if (this.jFormattedTextFieldDateFrom.getValue() != null && this.jFormattedTextFieldDateTo.getValue() == null) {
            this.jFormattedTextFieldDateTo.setValue(new Date());
        }
    }

    public List<Taxon> getSelection() {
        return this.selection;
    }
}

