/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.tools;

import com.stratadata.model3.user.Userdef;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import jsbugs.userconnect.SbugsSession;
import model3.Lastval;
import org.apache.commons.lang3.StringUtils;
import org.geotools.api.filter.FilterFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.util.logging.Logging;

public class SBLogger {
    public static final String FORMATTER_FORMAT = "[%1$tc] [%3$s] %4$s: %5$s%6$s%n";
    private static final int MAX_FILE_COUNT = 20;
    private static final int FILE_SIZE_LIMIT = 2000000;
    public static final String PREF_LOG_LEVEL = "LOGLEVEL";
    public static final String PREF_LOG_PATH = "LOGPATH";
    private static Level LOG_LEVEL = Level.WARNING;
    private static String LOG_PATH;

    public static void setup() throws SQLException {
        SBLogger.setGlobalLoggingLevel(Level.CONFIG);
        SBLogger.setConsoleHandlerLoggingLevel(Level.CONFIG);
        SBLogger.setLogPathFromSystemDefault();
        String userLogPathPref = Lastval.getString(SbugsSession.getDb(), PREF_LOG_PATH);
        if (!StringUtils.isBlank((CharSequence)userLogPathPref)) {
            LOG_PATH = userLogPathPref;
        }
        try {
            SBLogger.setFileHandler();
        }
        catch (IOException ioe) {
            System.out.println("Could not create directory for logging: " + ioe.getMessage());
            System.out.println("Using console output instead.");
            LOG_LEVEL = Level.CONFIG;
            SBLogger.setLoggingLevel();
        }
        String levelPref = Lastval.getString(SbugsSession.getDb(), PREF_LOG_LEVEL);
        if (!StringUtils.isBlank((CharSequence)levelPref)) {
            LOG_LEVEL = Level.parse(levelPref);
        }
        SBLogger.setLoggingLevel();
        Logger gt = Logging.getLogger((String)"org.geotools.util.factory");
        gt.setLevel(Level.WARNING);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Logger gtRenderer = Logging.getLogger(StreamingRenderer.class);
        gtRenderer.setLevel(Level.WARNING);
        gtRenderer.setFilter(new Filter(){

            @Override
            public boolean isLoggable(LogRecord record) {
                return record.getThrown() == null || !(record.getThrown() instanceof InterruptedException);
            }
        });
        StreamingRenderer sr = new StreamingRenderer();
        sr.paint((Graphics2D)null, (Rectangle)null, (AffineTransform)null);
    }

    public static void setGlobalLoggingLevel(Level level) {
        Logger globalLogger = Logger.getLogger("");
        globalLogger.setLevel(level);
    }

    public static void setConsoleHandlerLoggingLevel(Level level) {
        Logger globalLogger = Logger.getLogger("");
        for (Handler handler : globalLogger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            handler.setLevel(Level.FINE);
        }
    }

    public static LogStoreDefault getSystemDefaultLogPath() throws SQLException {
        LogStoreDefault defaultLocation = LogStoreDefault.SBUGS_FOLDER;
        String logStoreDefaultString = SbugsSession.getDb().getDatabasePref(PREF_LOG_PATH);
        if (!StringUtils.isBlank((CharSequence)logStoreDefaultString)) {
            try {
                defaultLocation = LogStoreDefault.valueOf(logStoreDefaultString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return defaultLocation;
    }

    private static void setLogPathFromSystemDefault() throws SQLException {
        LogStoreDefault defaultLocation = SBLogger.getSystemDefaultLogPath();
        LOG_PATH = defaultLocation.getPath();
    }

    private static void setLoggingLevel() {
        Logger globalLogger = Logger.getLogger("");
        for (Handler handler : globalLogger.getHandlers()) {
            if (!(handler instanceof FileHandler)) continue;
            handler.setLevel(LOG_LEVEL);
        }
    }

    public static void setLogLevel(String levelString) throws SQLException {
        if (StringUtils.isBlank((CharSequence)levelString)) {
            return;
        }
        Level parsedLevel = Level.parse(levelString);
        if (LOG_LEVEL != parsedLevel) {
            LOG_LEVEL = parsedLevel;
            SBLogger.setLoggingLevel();
            Lastval.putString(SbugsSession.getDb(), PREF_LOG_LEVEL, levelString);
        }
    }

    public static Level getLogLevel() {
        return LOG_LEVEL;
    }

    public static void setLogDirectory(File directory) throws SQLException, IOException {
        String oldPath = LOG_PATH;
        if (directory != null) {
            LOG_PATH = directory.getAbsolutePath();
        } else {
            SBLogger.setLogPathFromSystemDefault();
        }
        if (!oldPath.equals(LOG_PATH)) {
            try {
                SBLogger.setFileHandler();
            }
            catch (IOException ioe) {
                LOG_PATH = oldPath;
                throw ioe;
            }
        }
        Lastval.putString(SbugsSession.getDb(), PREF_LOG_PATH, directory != null ? directory.getAbsolutePath() : "");
    }

    private static void setFileHandler() throws IOException {
        Userdef user = SbugsSession.getDb().getUser();
        Path pathToLogs = Paths.get(LOG_PATH + File.separatorChar + user.getAbr(), new String[0]);
        File loggingDirectory = new File(pathToLogs.toString());
        if (!loggingDirectory.exists()) {
            System.out.println("Creating logging directory " + pathToLogs.toString());
            Files.createDirectories(pathToLogs, new FileAttribute[0]);
        }
        FileHandler handler = new FileHandler(pathToLogs.toString() + File.separatorChar + "sbugs_log_%g.log", 2000000, 20, true);
        Logger.getLogger(SBLogger.class.getName()).log(Level.CONFIG, "Setting log path to: {0}", pathToLogs.toString());
        SimpleFormatter simpleFormatter = new SimpleFormatter();
        handler.setFormatter(simpleFormatter);
        Logger globalLogger = Logger.getLogger("");
        for (Handler existingHandler : globalLogger.getHandlers()) {
            if (!(existingHandler instanceof FileHandler)) continue;
            existingHandler.close();
            globalLogger.removeHandler(existingHandler);
        }
        globalLogger.addHandler(handler);
    }

    public static void setDefaultLoggingLocation(LogStoreDefault logStoreDefault) throws SQLException {
        SbugsSession.getDb().putDatabasePref(PREF_LOG_PATH, logStoreDefault.name());
    }

    public static enum LogStoreDefault {
        SBUGS_FOLDER("StrataBugs directory"),
        USER_HOME("User's home directory");

        private final String descr;

        private LogStoreDefault(String descr) {
            this.descr = descr;
        }

        public String getPath() {
            switch (this.ordinal()) {
                default: {
                    return "logs";
                }
                case 1: 
            }
            return System.getProperty("user.home") + File.separatorChar + "StrataBugs_Log";
        }

        public String toString() {
            return this.descr;
        }
    }
}

