/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.uiutil;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.net.URL;
import jsbugs.uiutil.SVGHelper;
import util.SB;

public class CursorFactory {
    private static final String ICON_PATH = "/resources/cursor/";

    public static Cursor getMarqueeZoomCursor() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        URL url = CursorFactory.class.getResource("/resources/cursor/cursor_marquee.png");
        if (url != null) {
            Image cursorImage = tk.createImage(url);
            Cursor c = tk.createCustomCursor(cursorImage, new Point(1, 1), "CursorMarquee");
            return c;
        }
        System.out.println("Resource cursor null");
        return Cursor.getPredefinedCursor(5);
    }

    public static Cursor getDragMoveCursor() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        URL url = SB.class.getResource("/resources/cursor/cursor_drag_move.png");
        if (url != null) {
            Image cursorImage = tk.createImage(url);
            Cursor c = tk.createCustomCursor(cursorImage, new Point(1, 1), "CursorDragMove");
            return c;
        }
        System.out.println("Resource cursor null");
        return new Cursor(1);
    }

    public static Cursor getZoomCursor() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        URL url = CursorFactory.class.getResource("/resources/cursor/zoom_cursor.svg");
        if (url != null) {
            Image cursorImage = SVGHelper.buildPngImage(url, 128);
            Dimension cursorSize = tk.getBestCursorSize(32, 32);
            Cursor c = tk.createCustomCursor(cursorImage, new Point(cursorSize.width / 2, cursorSize.height / 2), "CursorMove");
            return c;
        }
        System.out.println("Resource cursor null");
        return Cursor.getPredefinedCursor(12);
    }
}

