/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.uiutil;

import java.text.NumberFormat;
import javax.swing.JTextField;
import jsbugs.uiutil.TextFieldUtils;
import org.apache.commons.lang3.StringUtils;

public class DecimalTextField
extends JTextField {
    private double displayUnitsMultiplier = 1.0;

    public void init(boolean allowNegative, Double maxValue, int maxPrecision) {
        TextFieldUtils.updateTextFieldToDecimalOnly(this, allowNegative, maxValue, maxPrecision);
    }

    public double getDisplayUnitsMultipler() {
        return this.displayUnitsMultiplier;
    }

    public void setDisplayUnitsMultipler(double value) {
        this.displayUnitsMultiplier = value;
    }

    public Double getDoubleValue() {
        if (StringUtils.isEmpty((CharSequence)this.getText())) {
            return null;
        }
        return Double.parseDouble(this.getText()) / this.displayUnitsMultiplier;
    }

    public void setDoubleValue(Double value) {
        if (value == null) {
            this.setText("");
            return;
        }
        this.setText(Double.toString(value * this.displayUnitsMultiplier));
    }

    public void setDoubleValue(Double value, int maxFractionalDigits) {
        if (value == null) {
            this.setText("");
            return;
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(maxFractionalDigits);
        nf.setGroupingUsed(false);
        this.setText(nf.format(value * this.displayUnitsMultiplier));
    }
}

