/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.uiutil;

import com.stratadata.model3.well.SectionType;
import com.stratadata.util.depth.DepthUnits;
import com.stratadata.util.depth.DepthUtils;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import util.SB;

public class DepthStringUtils {
    public static String getDepthStringValueOrEmpty(Double depth, DepthUnits units) {
        if (depth == null) {
            return "";
        }
        return String.valueOf(DepthUtils.convFromM((double)depth, (DepthUnits)units));
    }

    public static String getDepthStringValueOrEmpty(Double depth, DepthUnits units, SectionType type) {
        if (depth == null) {
            return "";
        }
        return BigDecimal.valueOf(DepthUtils.convFromM((double)depth, (DepthUnits)units, (SectionType)type)).toPlainString();
    }

    public static String getDepthStringValueOrEmpty(Double depth, DepthUnits units, SectionType type, int dp) {
        if (depth == null) {
            return "";
        }
        if (type == null) {
            return SB.floatString((double)DepthUtils.convFromM((double)depth, (DepthUnits)units), (int)dp).trim();
        }
        return SB.floatString((double)DepthUtils.convFromM((double)depth, (DepthUnits)units, (SectionType)type), (int)dp).trim();
    }

    public static Double getNullableDepthFromString(String depth, DepthUnits units) {
        if (StringUtils.isBlank((CharSequence)depth)) {
            return null;
        }
        double d = Double.parseDouble(depth.trim());
        return DepthUtils.convToM((double)d, (DepthUnits)units);
    }

    public static Double getNullableDepthFromString(String depth, DepthUnits units, SectionType type) {
        if (StringUtils.isBlank((CharSequence)depth)) {
            return null;
        }
        double d = Double.parseDouble(depth.trim());
        return DepthUtils.convToM((double)d, (DepthUnits)units, (SectionType)type);
    }
}

