/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.uiutil;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import jsbugs.uiutil.FillLayout;
import jsbugs.uiutil.GPane;

public class GlassPaneWrapper
extends JLayeredPane {
    private JPanel glassPanel = new GPane();
    private JComponent wrappedPanel;

    public GlassPaneWrapper(JComponent panel) {
        this.wrappedPanel = panel;
        this.init();
    }

    private void init() {
        this.glassPanel.setOpaque(false);
        this.glassPanel.setVisible(false);
        this.glassPanel.setBackground(new Color(0, 0, 0, 0));
        this.glassPanel.setLayout(new GridBagLayout());
        this.glassPanel.addMouseListener(new MouseAdapter(this){
            {
                Objects.requireNonNull(this$0);
            }
        });
        this.glassPanel.setFocusable(true);
        this.setLayout(new FillLayout());
        this.add(this.wrappedPanel);
        this.add(this.glassPanel);
        this.setLayer(this.wrappedPanel, JLayeredPane.DEFAULT_LAYER);
        this.setLayer(this.glassPanel, JLayeredPane.PALETTE_LAYER);
    }

    public void showGlassPanel() {
        this.setGlassPanelEnabled(true);
    }

    public void hideGlassPanel() {
        this.setGlassPanelEnabled(false);
    }

    public void setGlassPanelEnabled(boolean enabled) {
        this.glassPanel.setVisible(enabled);
        if (enabled) {
            this.glassPanel.requestFocusInWindow();
            this.glassPanel.setFocusTraversalKeysEnabled(false);
        }
    }
}

