/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.uiutil;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import jsbugs.uiutil.IDocumentInsertErrorListener;

public class IntegerNumberOnlyDocument
extends PlainDocument {
    private IDocumentInsertErrorListener listener = null;
    private boolean allowNegative = true;
    private Long maxValue = Long.MAX_VALUE;
    private String allowedValues = "0123456789-";

    public IntegerNumberOnlyDocument() {
    }

    public IntegerNumberOnlyDocument(IDocumentInsertErrorListener listener) {
        this.listener = listener;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str == null) {
            return;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (this.allowedValues.indexOf(str.charAt(i)) >= 0) continue;
            this.notifyOfInsertError();
            return;
        }
        String text = this.getText(0, offset) + str + this.getText(offset, this.getLength() - offset);
        if (this.getAllowNegative() && "-".equals(text)) {
            super.insertString(offset, str, attr);
            return;
        }
        boolean success = true;
        Long newValue = null;
        try {
            newValue = Long.parseLong(text);
        }
        catch (NumberFormatException ex) {
            success = false;
        }
        if (!success) {
            this.notifyOfInsertError();
            return;
        }
        if (!this.getAllowNegative() && newValue < 0L) {
            this.notifyOfInsertError();
            return;
        }
        if (newValue > this.getMaxValue()) {
            this.notifyOfInsertError();
            return;
        }
        super.insertString(offset, str, attr);
    }

    private void notifyOfInsertError() {
        if (this.listener != null) {
            this.listener.notifyOfInsertError();
        }
    }

    public boolean getAllowNegative() {
        return this.allowNegative;
    }

    public void setAllowNegative(boolean allowNegative) {
        this.allowNegative = allowNegative;
    }

    public Long getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
    }
}

