/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.uiutil;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;

public class SVGHelper {
    public static Image buildPngImage(URL svgFile, int size) {
        BufferedImage image = null;
        try {
            TranscoderInput transcoderInput = new TranscoderInput(svgFile.toString());
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            TranscoderOutput transcoderOutput = new TranscoderOutput((OutputStream)ostream);
            PNGTranscoder pngTranscoder = new PNGTranscoder();
            float fSize = size;
            pngTranscoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)Float.valueOf(fSize));
            pngTranscoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)Float.valueOf(fSize));
            pngTranscoder.transcode(transcoderInput, transcoderOutput);
            ByteArrayInputStream bis = new ByteArrayInputStream(ostream.toByteArray());
            image = ImageIO.read(bis);
        }
        catch (IOException | TranscoderException ex) {
            System.out.println("exception generating of size " + size + " from " + String.valueOf(svgFile));
            ex.printStackTrace();
        }
        return image;
    }
}

