/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.uiutil;

import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Objects;
import javax.swing.JFormattedTextField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jsbugs.uiutil.BeepInsertErrorListener;
import jsbugs.uiutil.ByteLimitedLengthDocument;
import jsbugs.uiutil.DecimalNumberOnlyDocument;
import jsbugs.uiutil.IntegerNumberOnlyDocument;
import jsbugs.uiutil.LimitedLengthDocument;

public class TextFieldUtils {
    public static <T> void trySetText(JTextField tf, T object) {
        if (object != null) {
            tf.setText(object.toString());
        }
    }

    public static JTextArea buildByteLimitedUTF8TextArea(int maxLengthInBytes) {
        JTextArea jArea = new JTextArea();
        ByteLimitedLengthDocument doc = new ByteLimitedLengthDocument(maxLengthInBytes, "UTF-8", new BeepInsertErrorListener());
        jArea.setDocument(doc);
        return jArea;
    }

    public static JTextField buildLimitedLengthTextField(int maxLength) {
        JTextField jText = new JTextField();
        LimitedLengthDocument doc = new LimitedLengthDocument(maxLength, new BeepInsertErrorListener());
        jText.setDocument(doc);
        return jText;
    }

    public static JTextArea buildLimitedLengthTextArea(int maxLength) {
        JTextArea jArea = new JTextArea();
        LimitedLengthDocument doc = new LimitedLengthDocument(maxLength, new BeepInsertErrorListener());
        jArea.setDocument(doc);
        return jArea;
    }

    public static DecimalNumberOnlyDocument buildDecimalDocument(boolean allowNegative, Double maxValue, int maxPrecision) {
        DecimalNumberOnlyDocument doc = new DecimalNumberOnlyDocument(new BeepInsertErrorListener());
        doc.setAllowNegative(allowNegative);
        doc.setMaxValue(maxValue);
        doc.setMaxPrecision(maxPrecision);
        return doc;
    }

    public static void updateTextFieldToDecimalOnly(final JTextField jText, final boolean allowNegative, Double maxValue, int maxPrecision) {
        jText.setDocument(TextFieldUtils.buildDecimalDocument(allowNegative, maxValue, maxPrecision));
        jText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                char c = evt.getKeyChar();
                String str = jText.getText();
                if (c == '.' && str.indexOf(46) > -1) {
                    evt.consume();
                    jText.setCaretPosition(str.indexOf(46) + 1);
                } else if (c == '-') {
                    evt.consume();
                    if (allowNegative) {
                        if (str.startsWith("-")) {
                            jText.setText(jText.getText().substring(1));
                        } else {
                            jText.setText("-" + jText.getText().trim());
                        }
                    }
                } else if (c == '+') {
                    evt.consume();
                    if (str.startsWith("-")) {
                        jText.setText(jText.getText().substring(1));
                    }
                }
            }
        });
    }

    public static JTextField buildDecimalOnlyTextField(boolean allowNegative, Double maxValue, int maxPrecision) {
        JTextField jText = new JTextField();
        TextFieldUtils.updateTextFieldToDecimalOnly(jText, allowNegative, maxValue, maxPrecision);
        return jText;
    }

    public static void trySetText(JTextField tf, Double value, DecimalFormat df) {
        if (value != null) {
            tf.setText(df.format(value));
        }
    }

    public static JTextField buildIntegerOnlyTextField(boolean allowNegative, long maxValue) {
        JTextField jText = new JTextField();
        TextFieldUtils.updateTextFieldToIntegerOnly(jText, allowNegative, maxValue);
        return jText;
    }

    public static void updateTextFieldToIntegerOnly(final JTextField jText, final boolean allowNegative, long maxValue) {
        jText.setDocument(TextFieldUtils.buildIntegerDocument(allowNegative, maxValue));
        jText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                char c = evt.getKeyChar();
                String str = jText.getText();
                if (c == '-') {
                    evt.consume();
                    if (allowNegative) {
                        if (str.startsWith("-")) {
                            jText.setText(jText.getText().substring(1));
                        } else {
                            jText.setText("-" + jText.getText().trim());
                        }
                    }
                } else if (c == '+') {
                    evt.consume();
                    if (str.startsWith("-")) {
                        jText.setText(jText.getText().substring(1));
                    }
                }
            }
        });
    }

    public static IntegerNumberOnlyDocument buildIntegerDocument(boolean allowNegative, long maxValue) {
        IntegerNumberOnlyDocument doc = new IntegerNumberOnlyDocument(new BeepInsertErrorListener());
        doc.setMaxValue(maxValue);
        doc.setAllowNegative(allowNegative);
        return doc;
    }

    public static void addChangeListener(final JTextComponent text, final ChangeListener changeListener) {
        Objects.requireNonNull(text);
        Objects.requireNonNull(changeListener);
        final DocumentListener dl = new DocumentListener(){
            private int lastChange = 0;
            private int lastNotifiedChange = 0;

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ++this.lastChange;
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ 3 this$0;
                    {
                        3 v0 = this$0;
                        Objects.requireNonNull(v0);
                        this.this$0 = v0;
                    }

                    @Override
                    public void run() {
                        if (this.this$0.lastNotifiedChange != this.this$0.lastChange) {
                            this.this$0.lastNotifiedChange = this.this$0.lastChange;
                            changeListener.stateChanged(new ChangeEvent(text));
                        }
                    }
                });
            }
        };
        text.addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Document d1 = (Document)e.getOldValue();
                Document d2 = (Document)e.getNewValue();
                if (d1 != null) {
                    d1.removeDocumentListener(dl);
                }
                if (d2 != null) {
                    d2.addDocumentListener(dl);
                }
                dl.changedUpdate(null);
            }
        });
        Document d = text.getDocument();
        if (d != null) {
            d.addDocumentListener(dl);
        }
    }

    public static void initSBDateFormatter(final JFormattedTextField field, String dateFormat) {
        if (dateFormat == null) {
            dateFormat = "dd-MMM-yy";
        }
        final String dateFormatString = dateFormat;
        DateFormatter dateFormatter = new DateFormatter(new SimpleDateFormat(dateFormat)){

            @Override
            public String valueToString(Object value) throws ParseException {
                if (value == null) {
                    field.setForeground(Color.LIGHT_GRAY);
                    return dateFormatString;
                }
                field.setForeground(Color.BLACK);
                return super.valueToString(value);
            }
        };
        DateFormatter editFormat = new DateFormatter(new SimpleDateFormat(dateFormat)){

            @Override
            public Object stringToValue(String userInput) throws ParseException {
                Object result = null;
                if (userInput != null && !userInput.trim().isEmpty()) {
                    result = super.stringToValue(userInput);
                }
                return result;
            }

            @Override
            public String valueToString(Object value) throws ParseException {
                field.setForeground(Color.BLACK);
                return super.valueToString(value);
            }
        };
        DefaultFormatterFactory fact = new DefaultFormatterFactory(dateFormatter, dateFormatter, editFormat);
        field.setFormatterFactory(fact);
    }
}

