/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.userconnect;

import com.stratadata.model3.user.Userdef;
import com.stratadata.sbconnect.ConnectionParameters;
import com.stratadata.util.preferences.RegistryPreferencesHelper;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.prefs.BackingStoreException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import jsbugs.userconnect.DialogSelectAnalyst;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBdb;
import util.SBException;

public class DialogSBLogin
extends SBDialog {
    private final SBdb sbdb;
    private final ConnectionParameters parms;
    private boolean inInitCombo;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonUsers;
    private JCheckBox jCheckBoxRemember;
    private JCheckBox jCheckBoxSilentSBLogin;
    private JComboBox jComboBoxLoginName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPasswordField jPasswordField;
    private JSeparator jSeparator1;

    public DialogSBLogin(Frame parent, boolean modal, ConnectionParameters parms, SBdb sbdb) throws SQLException {
        super(parent, modal);
        this.initComponents();
        this.sbdb = sbdb;
        this.parms = parms;
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("StrataBugs Login");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.initCombo();
    }

    private void initCombo() throws SQLException {
        this.inInitCombo = true;
        this.jComboBoxLoginName.removeAllItems();
        ArrayList<Userdef> userList = new ArrayList<Userdef>(this.sbdb.getUsers());
        Collections.sort(userList);
        for (Userdef user : userList) {
            if (user.getPriv() <= 0) continue;
            this.jComboBoxLoginName.addItem(user);
            if (this.parms.getSbUID() == null || this.parms.getSbUID().length() <= 0 || !user.getAbr().equals(this.parms.getSbUID())) continue;
            this.jComboBoxLoginName.setSelectedItem(user);
            this.jPasswordField.setText(this.parms.getSbPwd());
        }
        if (this.parms.getSbUID() != null && this.parms.getSbUID().length() > 0 && this.parms.getSbPwd() != null && this.parms.getSbPwd().length() > 0) {
            this.jCheckBoxRemember.setSelected(true);
        }
        this.inInitCombo = false;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jComboBoxLoginName = new JComboBox();
        this.jButtonUsers = new JButton();
        this.jPasswordField = new JPasswordField();
        this.jCheckBoxRemember = new JCheckBox();
        this.jCheckBoxSilentSBLogin = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        ResourceBundle bundle = ResourceBundle.getBundle("locale/UiText");
        this.jLabel1.setText(bundle.getString("label.loginname"));
        this.jLabel2.setText(bundle.getString("label.password"));
        this.jComboBoxLoginName.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSBLogin this$0;
            {
                DialogSBLogin dialogSBLogin = this$0;
                Objects.requireNonNull(dialogSBLogin);
                this.this$0 = dialogSBLogin;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxLoginNameActionPerformed(evt);
            }
        });
        this.jButtonUsers.setText("...");
        this.jButtonUsers.setToolTipText("Select analyst (you must enter the correct password to do this)");
        this.jButtonUsers.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonUsers.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSBLogin this$0;
            {
                DialogSBLogin dialogSBLogin = this$0;
                Objects.requireNonNull(dialogSBLogin);
                this.this$0 = dialogSBLogin;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonUsersActionPerformed(evt);
            }
        });
        this.jCheckBoxRemember.setText(bundle.getString("DialogSBLogin.checkbox.rememberlogin"));
        this.jCheckBoxRemember.setToolTipText("Not recommended for shared computers");
        this.jCheckBoxSilentSBLogin.setText(bundle.getString("checkbox.hidedialog"));
        this.jButtonCancel.setText(bundle.getString("button.cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSBLogin this$0;
            {
                DialogSBLogin dialogSBLogin = this$0;
                Objects.requireNonNull(dialogSBLogin);
                this.this$0 = dialogSBLogin;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText(bundle.getString("button.help"));
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSBLogin this$0;
            {
                DialogSBLogin dialogSBLogin = this$0;
                Objects.requireNonNull(dialogSBLogin);
                this.this$0 = dialogSBLogin;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText(bundle.getString("button.ok"));
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSBLogin this$0;
            {
                DialogSBLogin dialogSBLogin = this$0;
                Objects.requireNonNull(dialogSBLogin);
                this.this$0 = dialogSBLogin;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxSilentSBLogin).addComponent(this.jCheckBoxRemember).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPasswordField).addComponent(this.jComboBoxLoginName, 0, 226, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonUsers, -2, 34, -2)))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBoxLoginName, -2, -1, -2).addComponent(this.jButtonUsers)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jPasswordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxRemember).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxSilentSBLogin).addGap(15, 15, 15).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonUsersActionPerformed(ActionEvent evt) {
        if (this.login()) {
            if ((this.sbdb.getUser().getPriv() & 0x40) <= 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "You need to be a super user to do this.");
                return;
            }
            try {
                DialogSelectAnalyst dialog = new DialogSelectAnalyst((JDialog)((Object)this), true, this.sbdb, true);
                dialog.setLocationRelativeTo((Component)((Object)this));
                dialog.setVisible(true);
                this.initCombo();
                this.jComboBoxLoginNameActionPerformed(null);
            }
            catch (SQLException sql) {
                SbugsExceptionHandler.showStackError("Error loading personnel dialog", sql);
            }
        }
    }

    boolean login() {
        if (this.jComboBoxLoginName.getSelectedItem() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No login name selected", this.getTitle(), 2);
            return false;
        }
        Userdef user = (Userdef)this.jComboBoxLoginName.getSelectedItem();
        this.parms.setSbUID(user.getAbr());
        char[] passwordChars = this.jPasswordField.getPassword();
        if (passwordChars.length == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You must enter a password", this.getTitle(), 1);
            return false;
        }
        Object password = "";
        for (int i = 0; i < passwordChars.length && i < 9; ++i) {
            password = (String)password + passwordChars[i];
        }
        this.parms.setSbPwd((String)password);
        try {
            this.sbdb.login(user.getAbr(), (String)password);
            RegistryPreferencesHelper.putSilentSBLogin(this.jCheckBoxSilentSBLogin.isSelected());
            if (!this.jCheckBoxRemember.isSelected()) {
                this.parms.setSbPwd(null);
            }
            this.parms.putSBLogin();
            return true;
        }
        catch (SBException sbe) {
            JOptionPane.showMessageDialog((Component)((Object)this), sbe.getMessage(), "Login Error", 0);
            return false;
        }
        catch (RuntimeException | SQLException | BackingStoreException ex) {
            SbugsExceptionHandler.showStackError("Error logging in", ex, (Component)((Object)this));
            return false;
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.login()) {
            this.setOK();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"howtologin.html");
    }

    private void jComboBoxLoginNameActionPerformed(ActionEvent evt) {
        if (this.inInitCombo) {
            return;
        }
        Userdef user = (Userdef)this.jComboBoxLoginName.getSelectedItem();
        if (this.parms.getSbUID() != null && this.parms.getSbUID().length() > 0) {
            if (user.getAbr().equals(this.parms.getSbUID())) {
                this.jPasswordField.setText(this.parms.getSbPwd());
            } else {
                this.jPasswordField.setText("");
            }
        }
    }
}

