/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.userconnect;

import com.stratadata.model3.db.ModelVersion;
import com.stratadata.sbconnect.ConnectionParameters;
import com.stratadata.sblicense.SbugsLicense;
import com.stratadata.sblicense.SbugsLicenseHandler;
import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.SbugsLookAndFeelSetup;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import jsbugs.FrameJsbugs;
import jsbugs.uiutil.icon.IconFactory;
import jsbugs.userconnect.DialogRLMRoamExec;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.userconnect.SbugsLicenseHandlerImpl;
import jsbugs.userconnect.SbugsSession;
import model3.SBdb;
import util.SB;
import util.exception.SqlCache;

public class Jsbugs {
    private static final Logger LOGGER = Logger.getLogger(Jsbugs.class.getName());
    public static boolean DEBUG = false;
    public static String APP_VERSION = "v3.0";

    private static void startFrame() {
        int days;
        LOGGER.log(Level.INFO, "Running against Java version: {0} on {1} {2}", new Object[]{System.getProperty("java.version"), System.getProperty("os.name"), System.getProperty("os.arch")});
        LOGGER.log(Level.INFO, "Running in path: {0}", new File(".").getAbsolutePath());
        if (System.getenv("RLM_ROAM") != null && (days = Integer.parseInt(System.getenv("RLM_ROAM"))) != 0) {
            DialogRLMRoamExec dialog = new DialogRLMRoamExec(null, true);
            SB.centreDialog((Dialog)dialog);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            dialog.setVisible(true);
        }
        SbugsLicense.initLicense((SbugsLicenseHandler)new SbugsLicenseHandlerImpl());
        SwingWorker controlPanelImageLoader = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                IconFactory.getIcon("/resources/icon/", "FrameJsbugs_jButtonWells.svg");
                IconFactory.getIcon("/resources/icon/", "FrameJsbugs_jButtonSamples.svg");
                IconFactory.getIcon("/resources/icon/", "FrameJsbugs_jButtonInt.svg");
                IconFactory.getIcon("/resources/icon/", "FrameJsbugs_jButtonTaxaDB.svg");
                IconFactory.getIcon("/resources/icon/", "FrameJsbugs_jButtonOrganiser.svg");
                IconFactory.getIcon("/resources/icon/", "FrameJsbugs_jButtonCharts.svg");
                return null;
            }
        };
        controlPanelImageLoader.execute();
        List sbConns = ConnectionParameters.getConnections((ModelVersion)SBdb.MODEL_VERSION);
        if (sbConns.isEmpty()) {
            Object[] buttons = new String[]{"<html>Open Database Utility to download demo<br/>or convert from previous version</html>", "Create new connection", "Exit"};
            int opt = JOptionPane.showOptionDialog(null, "No " + APP_VERSION + " database connections found.\n", "StrataBugs " + APP_VERSION, 1, 3, null, buttons, null);
            switch (opt) {
                case 0: {
                    try {
                        Jsbugs.runSBconvert(true, true);
                    }
                    catch (IOException e) {
                        System.out.println("Error: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
                case 2: {
                    System.exit(0);
                }
            }
        }
        SbugsSession.startSession(false);
        Thread.setDefaultUncaughtExceptionHandler(new SbugsExceptionHandler());
        FrameJsbugs frame = new FrameJsbugs();
        SBDialog.centreWindow((Window)frame);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            boolean redirectErr = true;
            for (String arg : args) {
                if (arg.equalsIgnoreCase("-showSql")) {
                    SqlCache.setShowSql((boolean)true);
                    continue;
                }
                if (arg.equalsIgnoreCase("-useSystemErr")) {
                    redirectErr = false;
                    continue;
                }
                if (!arg.equalsIgnoreCase("-Debug")) continue;
                DEBUG = true;
            }
            if (redirectErr) {
                System.out.println("Redirecting error stream to out");
                System.setErr(System.out);
            }
            System.setProperty("apple.awt.application.name", "StrataBugs");
            System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tc] [%3$s] %4$s: %5$s%6$s%n");
            System.setProperty("com.sun.security.enableAIAcaIssuers", "true");
            SbugsLookAndFeelSetup.setupLookAndFeel();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Jsbugs.startFrame();
                }
            });
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void runSBconvert(boolean exit, boolean allowUnrestrictedQueries) throws IOException {
        String exePath = null;
        String defaultDir = ".";
        if (System.getProperty("os.name").startsWith("Mac")) {
            String cmd = "/Applications/StrataBugs.app/Contents/MacOS/StrataBugsDatabaseUtility";
            System.out.println("Running " + cmd);
            Runtime.getRuntime().exec(cmd);
        } else {
            File javaHome = new File("./jre");
            if (!javaHome.exists()) {
                javaHome = new File(System.getProperty("java.home"));
            }
            exePath = String.valueOf(javaHome) + File.separator + "bin" + File.separator + (System.console() == null ? "javaw.exe" : "java.exe");
            System.out.println("Running SBconvert using this path ...");
            System.out.println(exePath);
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File f, String name) {
                    return name.startsWith("sbconvert-3.0.") && name.endsWith(".jar");
                }
            };
            String[] files = new File(defaultDir).list(filter);
            if (files.length == 0) {
                JOptionPane.showMessageDialog(null, "Database Utility application not found\n(You may have a separate shortcut to launch this)", "StrataBugs", 2);
            } else {
                String cmd = " -jar " + defaultDir + File.separator + files[files.length - 1] + (allowUnrestrictedQueries ? " -allowUnrestrictedQueries" : "");
                Runtime.getRuntime().exec(exePath + cmd, null, new File("."));
            }
        }
        if (exit) {
            System.exit(0);
        }
    }
}

