/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.userconnect;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import jsbugs.userconnect.SbugsSession;
import model3.exception.SuppressedSQLException;
import util.InvalidFieldException;
import util.SBPermissionException;
import util.exception.StackError;

public class SbugsExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOGGER = Logger.getLogger(SbugsExceptionHandler.class.getName());
    private static final String DIALOG_ERROR_MESSAGE = "Error opening dialog";

    public static void showStackError(String msg, Throwable ex, Component componentForMessages) {
        if (ex instanceof SBPermissionException || ex instanceof RuntimeException && ex.getCause() instanceof SBPermissionException) {
            JOptionPane.showMessageDialog(componentForMessages, ex.getMessage(), "StrataBugs Permissions", 2);
            return;
        }
        if (ex instanceof InvalidFieldException) {
            JOptionPane.showMessageDialog(componentForMessages, ex.getMessage(), "StrataBugs Warning", 0);
            return;
        }
        if (ex instanceof IOException) {
            JOptionPane.showMessageDialog(componentForMessages, "File error: " + ex.getMessage(), "File Error", 0);
            return;
        }
        SQLException sqlEx = null;
        if (ex instanceof SQLException) {
            sqlEx = (SQLException)ex;
        } else if (ex.getCause() instanceof SQLException) {
            sqlEx = (SQLException)ex.getCause();
        }
        if (sqlEx != null && SbugsSession.isNetworkError(sqlEx)) {
            SbugsExceptionHandler.handleNetworkError(sqlEx);
            return;
        }
        boolean doRollback = true;
        if (ex instanceof SuppressedSQLException) {
            boolean bl = doRollback = !((SuppressedSQLException)ex).hasRolledBack();
        }
        if (doRollback && SbugsSession.getDb() != null) {
            SbugsSession.getDb().doRollback();
        }
        StackError.showStackError((String)msg, (Throwable)ex);
    }

    public static void showStackError(String msg, Throwable ex) {
        SbugsExceptionHandler.showStackError(msg, ex, null);
    }

    public static void showStackError(Throwable ex) {
        SbugsExceptionHandler.showStackError(null, ex, null);
    }

    public static void showStackError(Throwable ex, Component component) {
        SbugsExceptionHandler.showStackError(null, ex, component);
    }

    public static void showDialogStackError(Throwable ex, Component component) {
        SbugsExceptionHandler.showStackError(DIALOG_ERROR_MESSAGE, ex, component);
    }

    private static void handleNetworkError(Exception e) {
        e.printStackTrace();
        int option = JOptionPane.showConfirmDialog(null, e.getMessage() + "\nPlease check your network connection before continuing.\n\nPress 'OK' to attempt StrataBugs reconnection, or 'Cancel' to exit from StrataBugs.", "Database Connection Error", 2, 0);
        if (option == 0) {
            System.out.println("Attempting to reconnect database...");
            try {
                if (SbugsSession.attemptReconnection()) {
                    JOptionPane.showMessageDialog(null, "Connection re-established.", "Connection", 2);
                }
            }
            catch (Exception ex) {
                SbugsExceptionHandler.showStackError("Error reconnecting database\nAfter error: " + e.getMessage(), ex);
            }
        } else {
            LOGGER.severe("Failed to handle network error - exiting");
            System.exit(0);
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (SwingUtilities.isEventDispatchThread()) {
            SbugsExceptionHandler.showStackError(e);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    String message = "Exception occurred in thread: " + t.getName();
                    SbugsExceptionHandler.showStackError(message, e);
                });
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException ite) {
                ite.getCause().printStackTrace();
            }
        }
    }
}

