/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.userconnect;

import com.stratadata.model3.db.BasicConnectionFactory;
import com.stratadata.model3.db.ConnectionDetails;
import com.stratadata.model3.db.ConnectionDetailsHelper;
import com.stratadata.model3.db.DBType;
import com.stratadata.model3.db.HikariConnectionFactory;
import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.model3.well.sample.SampleTypePrecisionException;
import com.stratadata.model3.ws.LicenseCustomer;
import com.stratadata.sbconnect.ConnectionParameters;
import com.stratadata.sbconnect.DialogConnect;
import com.stratadata.sblicense.SbugsLicense;
import com.stratadata.util.preferences.RegistryPreferencesHelper;
import com.stratadata.util.ui.HelpUtils;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import jsbchart.core.ChartManager;
import jsbugs.DialogPasswordChange;
import jsbugs.refresh.RefreshHelper;
import jsbugs.tools.SBLogger;
import jsbugs.userconnect.DialogProxySettings;
import jsbugs.userconnect.DialogSBLogin;
import jsbugs.userconnect.ISBSession;
import jsbugs.userconnect.UserServiceNotAvailableException;
import jsbugs.userconnect.WebUserUtils;
import jsbugs.util.UserPrefsHelper;
import model3.Lastval;
import model3.SBdb;
import org.h2.jdbc.JdbcSQLException;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.exception.SqlCache;

public class SbugsSession
implements ISBSession {
    private static final Logger LOGGER = Logger.getLogger(SbugsSession.class.getName());
    private static final String MESSAGE_TITLE = "StrataBugs";
    private static final String WJSBUGS_PREF = "WJSBUGS";
    private static final int DAYS_TO_PASSWORD_EXPIRY = 3;
    private static SbugsSession session;
    private SBdb sbdb;
    private ChartManager chartManager;
    private ConnectionParameters parms;
    private static Process proxyConnectorGCP;
    private Boolean wjsbugs;
    private boolean useHiResIcons = true;

    public static void setTestSession(SbugsSession session) {
        SbugsSession.session = session;
    }

    private SbugsSession() {
    }

    public static SbugsSession getSession() {
        return session;
    }

    public static SBdb getDb() {
        return session.getDB();
    }

    public ChartManager getChartManager() {
        return this.chartManager;
    }

    public ConnectionParameters getParameters() {
        return this.parms;
    }

    public static void startSession(boolean alwaysShowLoginDialog) {
        if (session != null) {
            throw new IllegalStateException("Session has already started!");
        }
        session = new SbugsSession();
        session.connect(alwaysShowLoginDialog);
    }

    public static void endSession() throws SQLException {
        SbugsSession.session.sbdb.commit();
        SbugsSession.session.sbdb.close();
        session = null;
        if (proxyConnectorGCP != null) {
            proxyConnectorGCP.destroy();
        }
    }

    private void connect(boolean alwaysShowLoginDialog) {
        int attempts = 0;
        boolean silent = false;
        Object tablePrefix = null;
        String UID = null;
        String pwd = null;
        boolean saveUID = false;
        Preferences prefRoot = RegistryPreferencesHelper.getPreferences();
        if (!alwaysShowLoginDialog && (silent = RegistryPreferencesHelper.getSilentLogin())) {
            String DSN = prefRoot.get("sbdsn", null);
            if (DSN != null) {
                Preferences pref = prefRoot.node(DSN);
                UID = pref.get("uid", null);
                pwd = pref.get("pwd", null);
            } else {
                silent = false;
            }
        }
        while (true) {
            DialogConnect dialog = new DialogConnect(null, true);
            if (!silent) {
                SB.centreDialog((Dialog)dialog);
                dialog.setVisible(true);
                if (dialog.getParms() == null) {
                    System.exit(0);
                }
            }
            this.parms = dialog.getParms();
            if (this.parms.getGCPProxy() != null) {
                proxyConnectorGCP = this.startCloudProxy(this.parms);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            try {
                this.sbdb = new SBdb();
                ConnectionDetails connectionDetails = ConnectionDetailsHelper.getConnectionDetails(this.parms.getDriverType(), this.parms.getHostServerName(), false, this.parms.getInstanceNameWithSec(), this.parms.getUID(), this.parms.getPWD(), null, this.parms.isEncrypt());
                if (this.parms.isConnectionPoolDisabled()) {
                    this.sbdb.connect(new BasicConnectionFactory(connectionDetails));
                } else {
                    this.sbdb.connect(new HikariConnectionFactory(connectionDetails, this.parms.getMaxConnectionPoolSize()));
                }
                if (!this.sbdb.validSchema()) {
                    throw new SBException("Connection successful but schema invalid. (Cannot access PREF_SYSTEM table)");
                }
                this.chartManager = new ChartManager(this.sbdb);
                if (this.sbdb.getDBType() != DBType.ORACLE || this.sbdb.getDaysToPwExpiry() >= 3) break;
                DialogPasswordChange pwdialog = new DialogPasswordChange(null, true, this.sbdb);
                pwdialog.setLocationRelativeTo(null);
                pwdialog.setVisible(true);
            }
            catch (Exception e) {
                if (attempts < 3) {
                    silent = false;
                    e.printStackTrace();
                    if (e instanceof JdbcSQLException && this.parms.getUID() != null && !this.parms.getUID().isEmpty()) {
                        JOptionPane.showMessageDialog(null, "Can't connect. A connection login name & password is not usually required for H2\n(Connection error message is:  " + e.getMessage() + ")", MESSAGE_TITLE, 0);
                    } else {
                        JOptionPane.showMessageDialog(null, "Error getting database connection: " + e.getMessage(), MESSAGE_TITLE, 0);
                    }
                    ++attempts;
                    continue;
                }
                JOptionPane.showMessageDialog(null, "Error getting database connection: " + e.getMessage() + "\nStrataBugs will exit", MESSAGE_TITLE, 1);
                if (proxyConnectorGCP != null) {
                    proxyConnectorGCP.destroy();
                }
                System.exit(1);
                continue;
            }
            break;
        }
        try {
            String abr = this.sbdb.getDefaultUser(this.parms.getUID());
            boolean silentsblogon = false;
            if (abr != null) {
                alwaysShowLoginDialog = false;
                silentsblogon = true;
                this.parms.setSbUID(abr);
                prefRoot.remove("silentsblogin");
            }
            if (!silentsblogon) {
                silentsblogon = RegistryPreferencesHelper.getSilentSBLogin();
            }
            boolean loggedIn = false;
            if (!alwaysShowLoginDialog && silentsblogon) {
                try {
                    loggedIn = this.sbdb.login(this.parms.getSbUID(), this.parms.getSbPwd());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    loggedIn = false;
                }
            }
            if (!loggedIn) {
                DialogSBLogin dialog = new DialogSBLogin(null, true, this.parms, this.sbdb);
                SB.centreDialog((Dialog)((Object)dialog));
                dialog.setVisible(true);
                if (!dialog.isOK()) {
                    if (proxyConnectorGCP != null) {
                        proxyConnectorGCP.destroy();
                    }
                    System.exit(0);
                }
            }
            this.sbdb.setLicenceCustomer(new LicenseCustomer(SbugsLicense.getCustomer()));
            SBLogger.setup();
            this.initSystemProperties();
            if (this.useWjsbugs(true)) {
                try {
                    WebUserUtils.queryUser(this.sbdb.getUser().getUserCopy(), null);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Error while getting connection: " + e.getMessage() + "\nWeb services are disabled for now. Check proxy settings and re-enable from the control panel Config menu.", "Error", 0);
                    e.printStackTrace();
                    this.setWjsbugs(false);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error getting database connection: " + e.getMessage() + "\nSQL: " + SqlCache.getSql(), MESSAGE_TITLE, 0);
            if (proxyConnectorGCP != null) {
                proxyConnectorGCP.destroy();
            }
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error getting database connection: " + e.getMessage(), MESSAGE_TITLE, 0);
            if (proxyConnectorGCP != null) {
                proxyConnectorGCP.destroy();
            }
            System.exit(1);
        }
    }

    public static String getConnectionName() {
        return SbugsSession.session.parms.getName();
    }

    public static void startSBChart(Frame parentForMessages) throws IOException, SQLException {
        if (!System.getProperty("os.name").toUpperCase().startsWith("WINDOWS")) {
            JOptionPane.showMessageDialog(parentForMessages, "This option is only available on Windows x86 + odbc.", parentForMessages.getTitle(), 1);
            return;
        }
        if (!new File("./sbchart/sbchart.exe").exists()) {
            JOptionPane.showMessageDialog(parentForMessages, "SBChart module not found in StrataBugs/sbchart folder: " + System.getProperty("user.dir"), parentForMessages.getTitle(), 0);
            return;
        }
        session.openSBChart(parentForMessages);
    }

    private void openSBChart(Frame parentForMessages) throws IOException, SQLException {
        String chartHostName;
        if (this.parms.getSbchartODBC() == null && this.parms.getDriverName().equals("odbc")) {
            chartHostName = this.parms.getHostName();
        } else if (this.parms.getSbchartODBC() != null && this.parms.getSbchartODBC().length() > 0) {
            chartHostName = this.parms.getSbchartODBC();
        } else {
            JOptionPane.showMessageDialog(parentForMessages, "SBChart driver name not specified in connection settings", parentForMessages.getTitle(), 0);
            return;
        }
        String cmd = "./sbchart/sbchart.exe " + SBdb.getHostName(chartHostName);
        cmd = cmd + " UID=";
        if (this.parms.getUID() != null) {
            cmd = cmd + this.parms.getUID();
        }
        cmd = cmd + " PWD=";
        if (this.parms.getPWD() != null) {
            cmd = cmd + this.parms.getPWD();
        }
        cmd = cmd + " PFX=";
        if (this.parms.getInstanceName() != null && this.parms.getInstanceName().length() > 0) {
            if (this.parms.getInstanceName().contains(".")) {
                cmd = cmd + this.parms.getInstanceName().substring(this.parms.getInstanceName().lastIndexOf(46) + 1);
            } else if (!this.parms.getDriverName().equalsIgnoreCase("sqlserver")) {
                cmd = cmd + this.parms.getInstanceName();
            }
        }
        cmd = cmd + " SID=" + this.parms.getSbUID();
        cmd = cmd + " SPD=" + this.parms.getSbPwd();
        Runtime.getRuntime().exec(cmd, this.getLicenceEnv(), new File("./sbchart"));
    }

    private String[] getLicenceEnv() {
        String[] env = null;
        if (System.getenv("RLM_LICENSE") == null) {
            Object rlmLicEnv = null;
            File dir = new File(".");
            for (File f : dir.listFiles()) {
                if (!f.isFile() || !f.getName().endsWith(".lic")) continue;
                rlmLicEnv = rlmLicEnv == null ? "RLM_LICENSE=" : (String)rlmLicEnv + File.pathSeparator;
                rlmLicEnv = (String)rlmLicEnv + ".." + File.separator + f.getName();
            }
            if (rlmLicEnv != null) {
                Map<String, String> envmap = System.getenv();
                env = new String[envmap.size() + 1];
                int nEnv = 0;
                env[nEnv++] = rlmLicEnv;
                for (String envName : envmap.keySet()) {
                    env[nEnv++] = envName + "=" + envmap.get(envName);
                }
            }
        }
        return env;
    }

    public static boolean attemptReconnection() {
        try {
            return SbugsSession.session.sbdb.reconnect();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean isNetworkError(SQLException ex) {
        return SbugsSession.session.sbdb.isNetworkError(ex);
    }

    private void initSystemProperties() throws SQLException {
        try {
            String wjsbugsPref = Lastval.getString(this.sbdb, WJSBUGS_PREF);
            if (!wjsbugsPref.isEmpty()) {
                this.wjsbugs = Boolean.valueOf(wjsbugsPref);
            }
            RefreshHelper.setRefreshInterval(Lastval.getInt(this.sbdb, "DMONITOR") * 1000);
            try {
                int logPrec = Lastval.getInt(this.sbdb, "LOGPREC");
                if (logPrec > 0) {
                    SampleType.setLogSamplePrecision((int)logPrec);
                }
            }
            catch (SampleTypePrecisionException e) {
                LOGGER.log(Level.WARNING, "Could not set log sample precision: {0}", e.getMessage());
            }
            UserPrefsHelper helper = new UserPrefsHelper(this.sbdb);
            this.useHiResIcons = helper.getUseHiResIcons();
            this.sbdb.initSystemPreferences();
        }
        catch (SQLException sql) {
            LOGGER.log(Level.WARNING, "Error setting user or system preferences - using defaults", sql);
        }
    }

    public boolean useWjsbugs() {
        return this.useWjsbugs(false);
    }

    public boolean useWjsbugs(boolean showMessage) {
        if (this.wjsbugs == null) {
            Boolean useWjsbugs = false;
            while (useWjsbugs == null) {
                Object[] buttons = new String[]{"Allow", "Decline", "About...", "Proxy Settings..."};
                int opt = JOptionPane.showOptionDialog(null, "StrataBugs would like to access StrataData Web Services.", MESSAGE_TITLE, 1, 3, null, buttons, null);
                switch (opt) {
                    case 0: {
                        useWjsbugs = true;
                        break;
                    }
                    case 1: {
                        useWjsbugs = false;
                        break;
                    }
                    case 2: {
                        HelpUtils.openBlog((String)"2016/11/14/wjsbugs-user/");
                        break;
                    }
                    case 3: {
                        DialogProxySettings dialog = new DialogProxySettings(null, RegistryPreferencesHelper.getProxySettings());
                        SB.centreDialog((Dialog)((Object)dialog));
                        dialog.setVisible(true);
                        if (!dialog.isOK()) break;
                        RegistryPreferencesHelper.putProxySettings(dialog.getProxySettings());
                        useWjsbugs = true;
                        break;
                    }
                }
            }
            try {
                Lastval.putString(SbugsSession.getDb(), WJSBUGS_PREF, Boolean.toString(useWjsbugs));
                SbugsSession.getDb().commit();
            }
            catch (SQLException e) {
                this.wjsbugs = false;
            }
            this.wjsbugs = useWjsbugs;
        }
        return Boolean.TRUE.equals(this.wjsbugs);
    }

    public void setWjsbugs(boolean useWjsbugs) throws SQLException, UserServiceNotAvailableException {
        if (this.wjsbugs != useWjsbugs && useWjsbugs && !WebUserUtils.hasConnection()) {
            throw new UserServiceNotAvailableException();
        }
        this.wjsbugs = useWjsbugs;
        Lastval.putString(this.sbdb, WJSBUGS_PREF, Boolean.toString(useWjsbugs));
        this.sbdb.commit();
    }

    public void disableWjsbugs() {
        try {
            this.setWjsbugs(false);
        }
        catch (UserServiceNotAvailableException ex) {
            throw new IllegalStateException(ex);
        }
        catch (SQLException lastvalException) {
            lastvalException.printStackTrace();
        }
    }

    public boolean useHiResIcons() {
        return this.useHiResIcons;
    }

    public void setLogDp(int dp) throws SQLException, InvalidFieldException {
        try {
            SampleType.setLogSamplePrecision((int)dp);
        }
        catch (SampleTypePrecisionException ex) {
            throw new InvalidFieldException(ex.getMessage());
        }
        Lastval.putInt(this.sbdb, "LOGPREC", dp);
    }

    @Override
    public SBdb getDB() {
        return this.sbdb;
    }

    private Process startCloudProxy(ConnectionParameters parms) {
        try {
            String CLOUD_SQL_PROXY;
            String osArch;
            File tempFile = File.createTempFile("SBugs", ".tmp");
            switch (osArch = System.getProperty("os.arch")) {
                case "amd64": 
                case "ia64": {
                    CLOUD_SQL_PROXY = "cloud_sql_proxy_x64.exe";
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(null, "Cloud proxy binary for: " + osArch + " not found.\nStrataBugs will exit", MESSAGE_TITLE, 1);
                    System.exit(1);
                    return null;
                }
            }
            tempFile.deleteOnExit();
            BufferedWriter os = new BufferedWriter(new FileWriter(tempFile));
            String privateKeyID = "\"375d035f0387eec438ea1c047210a3e64f8f3795\"";
            String privateKey = "\"-----BEGIN PRIVATE KEY-----\\nMIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCgriaY902HmDQy\\nTHIn4RPmFd8z7rm6i6dGYKk7yJ1Ab2wDTC3IWJSkGmpUf6KNbfm0x2hf3/WWQFyj\\nm8n/jq0CzluIp1idAQz0NYzRVUtUjcYKKvfUuj4X45FufO0TBDccJyQE7ubojILH\\npcp0BomZykq+jc7OfnyZtfHP7JfkExFHqJYNVP8gRubrsPJqV/ip/a424eWZPWI9\\n3pNIH9BKTUghpD9iKf85iUaK6CWAZKgOE0YjzcIMXGKc9bV7NXbB5N35NAzxvuDy\\nvIvPWZDLNnZ2MHUTxEWbzsMNqXh/7KNhoBMI6cc5OWlt25EEDF6vY+og79+VIcJk\\nkYjiUMV5AgMBAAECggEACRrlPNMvgjWc25U0ymkfaT3bC8Se1kdpbEkE8TDRWS0X\\nLoN0fEv2T4UTRzeDI0chZV3/xNMNkrArlhyfw5edQTGNXH7svA53ryaSFLij6XL6\\nzzYXgucmc2pMIiBgVMZvEwbUX5bKeeoG04zKN9OFz5oReZ8Fu/JmwCHgLBtoxGrW\\nXjS81Ke/dmywdnNLKgQkKOETDLFdom12cv5RyZhjh6vCtfNEBxYPrW5danskrkyG\\n4doxu+3AWmk9ft5I5hE/9PDZePWFqzS/Mb7WtSkEZBC5Yxtq2urrpY3kl/j3TF68\\naSv/cMCAB9ybTI4vwmHE2lctNIBC1TIFCnRUXq+I0wKBgQDWNIgwyy4wSA1k6Cou\\njTuCMHoIwn7KinfGNe5V9R66DA0Pl4sBRzOeSawg4IQpRt8ypQSYfTB3mNdeqwn7\\n4FZVkdlJF6y13H3EVwiO10IVUaY1rdewqsyJhBjzrZmp9V6QLgWUATmqKW0joZQe\\nrNUz6y7C16waDkXOtDxv58N8vwKBgQDACBG0BBP7G+hFJHIFmTQ4FolaIDmAjnch\\nOmvBt772tWrptLHLgYXqWbWBwhfGRinMaA1yAfItZe7j/lgT4liKlNjPkFh0zi6v\\niNjtG4PiYzbM/fofnvqo9VK95V52YtGvziAP0MIyMxGhOkjtfkyRkuky6rliZVjG\\nZqalDu9zxwKBgQCqVFFrg1UyHUlRUO+h3rpQNt4DMy2BPwQo/9+KSITragPEvztQ\\ng96+4lRWPFG7RNjcu61g2EN/BnFTnOwudmAQYQ6H+aRjZHY5dv+eHfs1WpyxGJBn\\nshk8zGbO9d83754HRiE3ZJYHAjP/3k8a6VILm9quIrN+cJT/3gAk+AVRnwKBgCja\\nzqFk6LdY5Z6oNVX5lUGFke1Jw9IU/UVlf310UT19tWRJXDY2tT35ngMgPxyg2s2x\\nKYMi5NpBwIRjHWwFkN7S8hme1SLspsQTsksnunRUtVkBg9Bsa1m878CU5vb66S+l\\nA+85c8doVAzgMJnOcA3cmp6Jj61ecHetaTDer5ULAoGAKilWvYQ06ePi6zFkM/49\\naE/N0+D/3z5tTHsf4OFM+ldi4aUT98bntWACcPil+XGfk5GLgYLl2zgkA2Ee6JS8\\nrv+xF5Q43118g60YJX6rQ4qEYIpdXwYlWEGjYwkuU6awObTEPaEk8zBQdHyYtCW5\\nprVDPqzyv8aemd+DYGUudAk=\\n-----END PRIVATE KEY-----\\n\"";
            os.write("{\"type\": \"service_account\",  \"project_id\": \"calcium-anagram-274811\",  \"private_key_id\": " + privateKeyID + ",  \"private_key\": " + privateKey + ",  \"client_email\": \"stratabugs-user@calcium-anagram-274811.iam.gserviceaccount.com\",  \"client_id\": \"115072443501522778378\",  \"auth_uri\": \"https://accounts.google.com/o/oauth2/auth\",  \"token_uri\": \"https://oauth2.googleapis.com/token\",  \"auth_provider_x509_cert_url\": \"https://www.googleapis.com/oauth2/v1/certs\",  \"client_x509_cert_url\": \"https://www.googleapis.com/robot/v1/metadata/x509/stratabugs-user%40calcium-anagram-274811.iam.gserviceaccount.com\"}");
            os.close();
            File proxyExeFile = new File("." + File.separator + CLOUD_SQL_PROXY);
            if (new File("." + File.separator + "app").exists()) {
                proxyExeFile = new File("." + File.separator + "app" + File.separator + CLOUD_SQL_PROXY);
            }
            if (!proxyExeFile.exists()) {
                JOptionPane.showMessageDialog(null, "Unable to find cloud proxy application: " + CLOUD_SQL_PROXY + "\nStrataBugs will exit", MESSAGE_TITLE, 1);
                System.exit(1);
                return null;
            }
            ProcessBuilder pb = new ProcessBuilder(proxyExeFile.getPath(), "-instances=" + parms.getGCPProxy().getInstance(), "-credential_file=" + tempFile.getPath());
            SBLogger.LogStoreDefault logFolder = SBLogger.LogStoreDefault.SBUGS_FOLDER;
            File logFile = new File(logFolder.getPath() + File.separator + "GCP.log");
            if (!new File(logFolder.getPath()).canWrite()) {
                logFolder = SBLogger.LogStoreDefault.USER_HOME;
                File logPath = new File(logFolder.getPath());
                if (!logPath.exists()) {
                    logPath.mkdir();
                }
                logFile = new File(logFolder.getPath() + File.separator + "GCP.log");
            }
            pb.redirectError(logFile);
            pb.redirectOutput(logFile);
            return pb.start();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "Unable to connect to cloud proxy: message: " + ioe.getMessage() + "\nStrataBugs will exit", MESSAGE_TITLE, 1);
            ioe.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    static {
        proxyConnectorGCP = null;
    }
}

