/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.util;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.AbstractMultiResolutionImage;
import java.util.LinkedList;
import javax.swing.JFrame;
import jsbugs.uiutil.icon.MultiResImageHelper;

public abstract class SBFrame
extends JFrame {
    protected void init(String title, String[] iconNames) {
        this.setTitle(title);
        this.initIcons(iconNames);
    }

    private void initIcons(String[] iconNames) {
        if (iconNames == null || iconNames.length < 1) {
            return;
        }
        LinkedList<Image> imageList = new LinkedList<Image>();
        for (String png : iconNames) {
            imageList.add(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("/resources/frameicon/" + png)));
        }
        this.setIconImages(imageList);
    }

    protected void setMultiResIconImage(String src) {
        src = "/resources/frameicon/" + (String)src;
        AbstractMultiResolutionImage img = MultiResImageHelper.buildMultiResIcon((String)src, 16);
        this.setIconImage(img);
    }

    public void centreOnScreen() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }
}

