/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.util;

import java.awt.Component;
import java.sql.SQLException;
import javax.swing.JOptionPane;
import jsbugs.userconnect.SbugsExceptionHandler;
import util.InvalidFieldException;
import util.SBException;
import util.process.ProcessMessage;
import util.process.SbugsProcess;

public class SbugsProcessHandler {
    private final SbugsProcess process;
    private final Component messageParent;

    public SbugsProcessHandler(SbugsProcess process, Component messageParent) {
        this.process = process;
        this.messageParent = messageParent;
    }

    public void handleProcess() {
        try {
            do {
                this.process.go();
                if (!this.process.isValidated()) {
                    return;
                }
                ProcessMessage m = this.process.getCurrentMessage();
                if (m == null) continue;
                int opt = JOptionPane.showConfirmDialog(this.messageParent, m.message, m.title, 0);
                switch (opt) {
                    case 0: {
                        this.process.setResponse(ProcessMessage.Response.YES);
                        break;
                    }
                    default: {
                        this.process.setResponse(ProcessMessage.Response.CANCEL);
                    }
                }
            } while (this.process.isReady());
        }
        catch (RuntimeException | SQLException | InvalidFieldException | SBException e) {
            SbugsExceptionHandler.showStackError(e, this.messageParent);
        }
    }
}

