/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.webservices;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import jsbugs.webservices.WebCitationService;
import model3.Lastval;
import model3.SBdb;

public class DialogConfigureWebCitationServices
extends JDialog {
    private final SBdb db;
    private final List<Integer> selectedServices = new LinkedList<Integer>();
    private final WebCitationServicesTableModel model = new WebCitationServicesTableModel();
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTable jTableServices;

    public DialogConfigureWebCitationServices(Frame parent, boolean modal, SBdb db) {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init();
    }

    public DialogConfigureWebCitationServices(Dialog parent, boolean modal, SBdb db) {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Web Services");
        this.jTableServices.setTableHeader(null);
        this.jScrollPane1.setColumnHeaderView(null);
        Object[] b = new Boolean[WebCitationService.SERVICE_NAMES.length];
        Arrays.fill(b, (Object)true);
        this.model.selection = Arrays.asList(b);
        String srv = Lastval.tryGetString(this.db, "TXWEBSRV");
        if (srv == null) {
            srv = "";
        }
        String[] srvs = srv.split(",");
        for (int i = 0; i < srvs.length && i < WebCitationService.SERVICE_NAMES.length; ++i) {
            try {
                int selected = Integer.parseInt(srvs[i]);
                this.model.selection.set(i, selected > 0);
                continue;
            }
            catch (NumberFormatException pe) {
                Logger.getLogger(DialogConfigureWebCitationServices.class.getName()).warning("Error parsing boolean from '" + srvs[i] + "'");
            }
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableServices = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(328, 192));
        this.jLabel1.setText("The following service(s) will be used for reference searching:");
        this.jTableServices.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableServices);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogConfigureWebCitationServices this$0;
            {
                DialogConfigureWebCitationServices dialogConfigureWebCitationServices = this$0;
                Objects.requireNonNull(dialogConfigureWebCitationServices);
                this.this$0 = dialogConfigureWebCitationServices;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogConfigureWebCitationServices this$0;
            {
                DialogConfigureWebCitationServices dialogConfigureWebCitationServices = this$0;
                Objects.requireNonNull(dialogConfigureWebCitationServices);
                this.this$0 = dialogConfigureWebCitationServices;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 117, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.selectedServices.clear();
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.selectedServices.clear();
        Object prefString = "";
        for (int i = 0; i < this.model.selection.size(); ++i) {
            boolean selected = this.model.selection.get(i);
            if (selected) {
                this.selectedServices.add(i);
                prefString = (String)prefString + "1,";
                continue;
            }
            prefString = (String)prefString + "0,";
        }
        if (this.selectedServices.size() == 0) {
            JOptionPane.showMessageDialog(this, "No service(s) selected");
            return;
        }
        Lastval.tryPutString(this.db, "TXWEBSRV", (String)prefString);
        this.dispose();
    }

    public List<Integer> getSelectedServices() {
        return this.selectedServices;
    }

    private static class WebCitationServicesTableModel
    extends DefaultTableModel {
        List<Boolean> selection;

        private WebCitationServicesTableModel() {
        }

        @Override
        public int getRowCount() {
            return WebCitationService.SERVICE_NAMES.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return switch (column) {
                case 0 -> WebCitationService.SERVICE_NAMES[row];
                case 1 -> this.selection.get(row);
                default -> throw new IllegalStateException("Unrecognized column " + column);
            };
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return switch (columnIndex) {
                case 0 -> String.class;
                case 1 -> Boolean.class;
                default -> throw new IllegalStateException("Unrecognized column " + columnIndex);
            };
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            this.selection.set(row, (Boolean)aValue);
        }
    }
}

