/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.webservices;

import com.stratadata.model3.external.WebServiceDescription;
import com.stratadata.model3.external.WebServiceType;
import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.uiutil.TextFieldUtils;

public class DialogWebService
extends SBDialog {
    private static final int NAME_LEN = 30;
    private static final int URL_LEN = 256;
    private final DefaultComboBoxModel model = new DefaultComboBoxModel();
    private final WebServiceType type;
    private WebServiceDescription webServiceDescription;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxCredentials;
    private JCheckBox jCheckBoxProxy;
    private JComboBox<String> jComboBoxType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JTextField jTextFieldName;
    private JTextField jTextFieldURL;

    public DialogWebService(JDialog parent, boolean modal, WebServiceType type, WebServiceDescription webServiceDescription) {
        super((Window)parent, modal);
        this.initComponents();
        this.type = type;
        this.init(webServiceDescription);
    }

    private void init(WebServiceDescription orig) {
        for (WebServiceType t : WebServiceType.values()) {
            this.model.addElement(t);
        }
        this.jComboBoxType.setEnabled(false);
        if (orig != null) {
            this.setTitle("Web Service : Edit");
            this.jTextFieldName.setText(orig.name());
            this.jTextFieldURL.setText(orig.URL());
            this.jCheckBoxCredentials.setSelected(orig.requiresCredentials());
            this.jCheckBoxProxy.setSelected(orig.proxy());
        } else {
            this.setTitle("Web Service : Add");
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBoxType = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jTextFieldName = TextFieldUtils.buildLimitedLengthTextField(30);
        this.jCheckBoxCredentials = new JCheckBox();
        this.jCheckBoxProxy = new JCheckBox();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jTextFieldURL = TextFieldUtils.buildLimitedLengthTextField(256);
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(450, 240));
        this.jLabel1.setText("Type of service: ");
        this.jComboBoxType.setModel(this.model);
        this.jLabel2.setText("Name (used in StrataBugs):");
        this.jCheckBoxCredentials.setSelected(true);
        this.jCheckBoxCredentials.setText("Requires username and password");
        this.jCheckBoxProxy.setText("Connects through proxy");
        this.jCheckBoxProxy.setEnabled(false);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWebService this$0;
            {
                DialogWebService dialogWebService = this$0;
                Objects.requireNonNull(dialogWebService);
                this.this$0 = dialogWebService;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogWebService this$0;
            {
                DialogWebService dialogWebService = this$0;
                Objects.requireNonNull(dialogWebService);
                this.this$0 = dialogWebService;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("URL / Address of server"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jTextFieldURL).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jTextFieldURL, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldName)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxProxy, -2, 204, -2).addComponent(this.jCheckBoxCredentials).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxType, -2, 130, -2))).addGap(0, 384, Short.MAX_VALUE)).addComponent(this.jSeparator1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldName, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBoxType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxCredentials).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxProxy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.jButtonCancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String name = this.jTextFieldName.getText();
        String URL2 = this.jTextFieldURL.getText();
        boolean credentials = this.jCheckBoxCredentials.isSelected();
        boolean proxy = this.jCheckBoxProxy.isSelected();
        if (name.isBlank()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You must enter a name", this.getTitle(), 2);
            return;
        }
        if (URL2.isBlank()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You must enter a URL", this.getTitle(), 2);
            return;
        }
        this.webServiceDescription = new WebServiceDescription(0, this.type, name, URL2, credentials, proxy);
        this.setOK();
        this.dispose();
    }

    public WebServiceDescription getWebServiceDetails() {
        return this.webServiceDescription;
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

