/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.webservices;

import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.taxon.CategoryService;
import com.stratadata.model3.taxon.Genus;
import com.stratadata.model3.taxon.GenusService;
import com.stratadata.model3.taxon.SearchMode;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import jsbugs.FrameJsbugs;
import jsbugs.webservices.WebCitationService;

public abstract class WebCitationQuery {
    public static final String NO_CITATION = "(no citation)";
    private static final Logger LOGGER = Logger.getLogger(WebCitationQuery.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebCitationService.WebCitation queryTaxon(Taxon taxon) throws IOException {
        HttpURLConnection conn = WebCitationQuery.doQuery(this.getCitationQueryUrl(taxon));
        if (conn != null) {
            try {
                WebCitationService.WebCitation webCitation = this.parseCitation(conn.getInputStream());
                return webCitation;
            }
            catch (MismatchedInputException mismatchedInputException) {
            }
            catch (IOException e) {
                LOGGER.warning("Error parsing JSON: " + e.getMessage());
            }
            finally {
                conn.disconnect();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebCitationService.CitedTaxon> findTaxa(String queryTerm, WebCitationService.ServiceStatus statusMonitor, CategoryService categoryService, GenusService genusService) throws IOException {
        HttpURLConnection conn;
        Taxon taxon = TaxonFactory.parse((String)queryTerm, (int)0, (TaxonFactory.ParseMode)TaxonFactory.ParseMode.LENIENT, (CategoryService)categoryService);
        if (taxon == null) {
            return Collections.EMPTY_LIST;
        }
        String queryUrl = this.getSearchQueryUrl(taxon);
        if (queryUrl != null && (conn = WebCitationQuery.doQuery(queryUrl)) != null) {
            try {
                List<WebCitationService.CitedTaxon> taxa = this.parseTaxa(conn.getInputStream());
                Category nullCategory = new Category("");
                for (WebCitationService.CitedTaxon citedTaxon : taxa) {
                    Taxon t = citedTaxon.taxon();
                    if (t.getGenus().getCategory() == null) {
                        List matchingGenera = genusService.findMatchingGenera(t.getGenus(), SearchMode.LOOKUP);
                        if (matchingGenera.size() == 1 || matchingGenera.stream().map(genus -> genus.getCategory().getMnemonic()).distinct().toList().size() == 1) {
                            t.getGenus().setCategory(((Genus)matchingGenera.get(0)).getCategory());
                        } else {
                            t.getGenus().setCategory(nullCategory);
                        }
                    }
                    t.setUrl(citedTaxon.ciation().url());
                }
                List<WebCitationService.CitedTaxon> list = taxa;
                return list;
            }
            catch (MismatchedInputException taxa) {
            }
            catch (IOException e) {
                LOGGER.warning("Error parsing JSON: " + e.getMessage());
            }
            finally {
                conn.disconnect();
            }
        }
        return Collections.EMPTY_LIST;
    }

    public String getSearchQueryUrl(Taxon taxon) {
        return null;
    }

    public static HttpURLConnection doQuery(String urlString) throws IOException {
        try {
            URL url = new URI(urlString).toURL();
            HttpsURLConnection conn = (HttpsURLConnection)FrameJsbugs.getSecureUrlConnection(url);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                if (conn.getResponseCode() == 204 || conn.getResponseCode() == 206 || conn.getResponseCode() == 400 || conn.getResponseCode() == 404) {
                    return null;
                }
                if (conn.getResponseCode() > 300 && conn.getResponseCode() < 310) {
                    String redirect = conn.getHeaderField("Location");
                    url = new URI(redirect).toURL();
                    conn = (HttpsURLConnection)FrameJsbugs.getSecureUrlConnection(url);
                    conn.setRequestMethod("GET");
                    conn.setRequestProperty("Accept", "application/json");
                    if (conn.getResponseCode() != 200) {
                        LOGGER.warning("Redirect failed: " + conn.getResponseCode() + " " + conn.getResponseMessage() + " " + String.valueOf(url));
                        return null;
                    }
                }
                LOGGER.warning("Query failed: HTTP error code " + conn.getResponseCode() + " : query URL: " + String.valueOf(url));
                return null;
            }
            return conn;
        }
        catch (URISyntaxException e) {
            LOGGER.warning("Error in query URI: " + e.getMessage());
            return null;
        }
    }

    public abstract String getCitationQueryUrl(Taxon var1);

    public abstract WebCitationService.WebCitation parseCitation(InputStream var1) throws IOException;

    public static String getUrlTaxonName(Taxon taxon) {
        String tString = taxon.toString(false, false);
        return URLEncoder.encode(tString, Charset.defaultCharset());
    }

    public List<WebCitationService.CitedTaxon> parseTaxa(InputStream inputStream) throws IOException {
        return Collections.emptyList();
    }
}

