/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.wellheader;

import com.stratadata.model3.well.SectionType;
import com.stratadata.model3.well.WellSearchService;
import com.stratadata.util.ui.DialogBase;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import jsbugs.DialogList;
import jsbugs.table.PermissionRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.UserPrefsHelper;
import jsbugs.wellheader.TableModelWells;
import model3.Lastval;
import model3.SBdb;
import model3.Well;
import model3.WellHeader;
import net.miginfocom.swing.MigLayout;
import util.SBException;

public class DialogSelectWell
extends DialogBase {
    private final boolean multiSelect;
    private final TableModelWells model = new TableModelWells(true);
    private final SBdb sbdb;
    List<Well> selection = null;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JTextField jTextFieldWellName;
    private JTextField jTextFieldWellCode;
    private JTextField jTextFieldCountry;
    private JTextField jTextFieldField;
    private JTextField jTextFieldOperator;
    private JTextField jTextFieldCounty;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JTable jTableWells;
    private JButton jButtonSelectCountry;
    private JLabel jLabel7;
    private JTextField jTextFieldBasin;
    private JLabel jLabel8;
    private JTextField jTextFieldArea;
    private JLabel jLabel9;
    private JTextField jTextFieldState;
    private JLabel jLabel10;
    private JTextField jTextFieldClient;
    private JPanel panel1;
    private JButton jButtonSearch;
    private JButton jButtonClear;
    private JRadioButton jRadioButtonAllSections;
    private JRadioButton jRadioButtonWellsOnly;
    private JRadioButton jRadioButtonOutcropsOnly;
    private ButtonGroup buttonGroup1;

    public DialogSelectWell(Frame parent, boolean modal, SBdb sbdb, boolean multiSelect) {
        super((Window)parent);
        this.sbdb = sbdb;
        this.multiSelect = multiSelect;
        this.initComponents();
        this.init(null);
    }

    public DialogSelectWell(JDialog parent, boolean modal, SBdb sbdb, boolean multiSelect, String wellName) {
        super((Window)parent);
        this.sbdb = sbdb;
        this.multiSelect = multiSelect;
        this.initComponents();
        this.setLocation(parent.getLocation().x + 25, parent.getLocation().y + 25);
        this.init(wellName);
    }

    private void init(String wellName) {
        this.setTitle("Well : Select");
        this.getRootPane().setDefaultButton(this.jButtonSearch);
        super.addOkButtonActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectWell this$0;
            {
                DialogSelectWell dialogSelectWell = this$0;
                Objects.requireNonNull(dialogSelectWell);
                this.this$0 = dialogSelectWell;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.jButtonOKActionPerformed(e);
            }
        });
        this.jTableWells.getColumnModel().getColumn(12).setCellRenderer(new PermissionRenderer());
        this.model.setupTable(this.jTableWells, false, this.sbdb);
        this.jRadioButtonAllSections.setSelected(true);
        if (!this.multiSelect) {
            this.jTableWells.setSelectionMode(0);
        }
        if (wellName != null) {
            this.jTextFieldWellName.setText(wellName + "%");
            this.jTextFieldWellName.setCaretPosition(wellName.length() > 0 ? wellName.length() : 0);
        } else {
            String defaults = Lastval.tryGetString(this.sbdb, "JWSEARCH");
            if (defaults == null || defaults.length() == 0) {
                defaults = "%|%|%|%|";
            }
            try {
                StringTokenizer tok = new StringTokenizer(defaults, "|");
                this.jTextFieldWellName.setText((String)tok.nextElement());
                this.jTextFieldWellName.setCaretPosition(this.jTextFieldWellName.getText().length() - 1);
                this.jTextFieldWellCode.setText((String)tok.nextElement());
                this.jTextFieldWellCode.setCaretPosition(this.jTextFieldWellCode.getText().length() - 1);
                this.jTextFieldField.setText((String)tok.nextElement());
                this.jTextFieldField.setCaretPosition(this.jTextFieldField.getText().length() - 1);
                this.jTextFieldCountry.setText((String)tok.nextElement());
                this.jTextFieldCountry.setCaretPosition(this.jTextFieldCountry.getText().length() - 1);
                if (!tok.hasMoreElements()) {
                    return;
                }
                this.jTextFieldCounty.setText((String)tok.nextElement());
                this.jTextFieldCounty.setCaretPosition(this.jTextFieldCounty.getText().length() - 1);
                if (!tok.hasMoreElements()) {
                    return;
                }
                tok.nextElement();
                if (!tok.hasMoreElements()) {
                    return;
                }
                tok.nextElement();
                if (!tok.hasMoreElements()) {
                    return;
                }
                tok.nextElement();
                if (!tok.hasMoreElements()) {
                    return;
                }
                this.jTextFieldOperator.setText((String)tok.nextElement());
                this.jTextFieldOperator.setCaretPosition(this.jTextFieldOperator.getText().length() - 1);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    private void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("locale.UiText");
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jTextFieldWellName = new JTextField();
        this.jTextFieldWellCode = new JTextField();
        this.jTextFieldCountry = new JTextField();
        this.jTextFieldField = new JTextField();
        this.jTextFieldOperator = new JTextField();
        this.jTextFieldCounty = new JTextField();
        this.jLabel6 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableWells = new JTable();
        this.jButtonSelectCountry = new JButton();
        this.jButtonSelectCountry.putClientProperty("JComponent.sizeVariant", "small");
        this.jLabel7 = new JLabel();
        this.jTextFieldBasin = new JTextField();
        this.jLabel8 = new JLabel();
        this.jTextFieldArea = new JTextField();
        this.jLabel9 = new JLabel();
        this.jTextFieldState = new JTextField();
        this.jLabel10 = new JLabel();
        this.jTextFieldClient = new JTextField();
        this.panel1 = new JPanel();
        this.jButtonSearch = new JButton();
        this.jButtonClear = new JButton();
        this.jRadioButtonAllSections = new JRadioButton();
        this.jRadioButtonWellsOnly = new JRadioButton();
        this.jRadioButtonOutcropsOnly = new JRadioButton();
        this.buttonGroup1 = new ButtonGroup();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(600, 400));
        this.setHelpLocation("dialogselectwell.html");
        JPanel contentPanel = this.getContentPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("fill,insets panel,hidemode 3", "[shrink 0,right][120,grow,fill]unrel[shrink 0,right][120,grow,fill]unrel[right][120,grow,fill]", "[][][]para[]unrel[grow]"));
        this.jLabel1.setText(bundle.getString("DialogSelectWell.name.label"));
        contentPanel.add((Component)this.jLabel1, "cell 0 0");
        this.jLabel2.setText(bundle.getString("DialogSelectWell.code.label"));
        contentPanel.add((Component)this.jLabel2, "cell 0 1");
        this.jLabel3.setText(bundle.getString("DialogWell.location.country.label"));
        contentPanel.add((Component)this.jLabel3, "cell 0 2");
        this.jLabel4.setText(bundle.getString("DialogWell.location.field"));
        contentPanel.add((Component)this.jLabel4, "cell 2 0");
        this.jLabel5.setText(bundle.getString("DialogWell.details.operator"));
        contentPanel.add((Component)this.jLabel5, "cell 2 1");
        this.jTextFieldWellName.setText("%");
        contentPanel.add((Component)this.jTextFieldWellName, "cell 1 0");
        this.jTextFieldWellCode.setText("%");
        contentPanel.add((Component)this.jTextFieldWellCode, "cell 1 1");
        this.jTextFieldCountry.setText("%");
        contentPanel.add((Component)this.jTextFieldCountry, "cell 1 2,growx");
        this.jTextFieldField.setText("%");
        contentPanel.add((Component)this.jTextFieldField, "cell 3 0");
        this.jTextFieldOperator.setText("%");
        contentPanel.add((Component)this.jTextFieldOperator, "cell 3 1,growx");
        this.jTextFieldCounty.setText("%");
        contentPanel.add((Component)this.jTextFieldCounty, "cell 3 2");
        this.jLabel6.setText(bundle.getString("DialogWell.location.county"));
        contentPanel.add((Component)this.jLabel6, "cell 2 2");
        this.jTableWells.setModel(this.model);
        this.jTableWells.setAutoResizeMode(4);
        this.jTableWells.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSelectWell this$0;
            {
                DialogSelectWell dialogSelectWell = this$0;
                Objects.requireNonNull(dialogSelectWell);
                this.this$0 = dialogSelectWell;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.this$0.jTableWellsMouseClicked(e);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableWells);
        contentPanel.add((Component)this.jScrollPane1, "cell 0 4 6 1,grow");
        this.jButtonSelectCountry.setText(bundle.getString("ellipsis"));
        this.jButtonSelectCountry.setPreferredSize(new Dimension(30, 22));
        this.jButtonSelectCountry.setToolTipText(bundle.getString("DialogWell.location.country.toolTipText"));
        this.jButtonSelectCountry.addActionListener(e -> this.jButtonSelectCountryActionPerformed(e));
        contentPanel.add((Component)this.jButtonSelectCountry, "cell 1 2");
        this.jLabel7.setText(bundle.getString("DialogWell.location.basin"));
        contentPanel.add((Component)this.jLabel7, "cell 4 0");
        this.jTextFieldBasin.setText("%");
        contentPanel.add((Component)this.jTextFieldBasin, "cell 5 0");
        this.jLabel8.setText(bundle.getString("DialogWell.location.area"));
        contentPanel.add((Component)this.jLabel8, "cell 4 1");
        this.jTextFieldArea.setText("%");
        contentPanel.add((Component)this.jTextFieldArea, "cell 5 1");
        this.jLabel9.setText(bundle.getString("DialogWell.location.state"));
        contentPanel.add((Component)this.jLabel9, "cell 4 2");
        this.jTextFieldState.setText("%");
        contentPanel.add((Component)this.jTextFieldState, "cell 5 2");
        this.jLabel10.setText(bundle.getString("DialogWell.details.client"));
        contentPanel.add((Component)this.jLabel10, "cell 3 1");
        this.jTextFieldClient.setText("%");
        contentPanel.add((Component)this.jTextFieldClient, "cell 3 1,growx");
        this.panel1.setLayout((LayoutManager)new MigLayout("fillx,insets 0,hidemode 3", "[left][right]", "[]"));
        this.jButtonSearch.setText(bundle.getString("button.search"));
        this.jButtonSearch.addActionListener(e -> this.jButtonSearchActionPerformed(e));
        this.panel1.add((Component)this.jButtonSearch, "cell 0 0");
        this.jButtonClear.setText(bundle.getString("button.clear"));
        this.jButtonClear.setToolTipText(bundle.getString("DialogSelectWell.clear.button.toolTip"));
        this.jButtonClear.addActionListener(e -> this.jButtonClearActionPerformed(e));
        this.panel1.add((Component)this.jButtonClear, "cell 0 0");
        this.jRadioButtonAllSections.setText(bundle.getString("DialogSelectWell.sectiontype.all"));
        this.panel1.add((Component)this.jRadioButtonAllSections, "cell 1 0");
        this.jRadioButtonWellsOnly.setText(bundle.getString("DialogSelectWell.sectiontype.well"));
        this.panel1.add((Component)this.jRadioButtonWellsOnly, "cell 1 0");
        this.jRadioButtonOutcropsOnly.setText(bundle.getString("DialogSelectWell.sectiontype.outcrop"));
        this.panel1.add((Component)this.jRadioButtonOutcropsOnly, "cell 1 0");
        contentPanel.add((Component)this.panel1, "cell 0 3 6 1,growx");
        this.setSize(870, 645);
        this.setLocationRelativeTo(this.getOwner());
        this.buttonGroup1.add(this.jRadioButtonAllSections);
        this.buttonGroup1.add(this.jRadioButtonWellsOnly);
        this.buttonGroup1.add(this.jRadioButtonOutcropsOnly);
    }

    private void jTableWellsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonClearActionPerformed(ActionEvent evt) {
        this.jTextFieldWellName.setText("%");
        this.jTextFieldWellName.setCaretPosition(this.jTextFieldWellName.getText().length() - 1);
        this.jTextFieldWellCode.setText("%");
        this.jTextFieldWellCode.setCaretPosition(this.jTextFieldWellCode.getText().length() - 1);
        this.jTextFieldField.setText("%");
        this.jTextFieldField.setCaretPosition(this.jTextFieldField.getText().length() - 1);
        this.jTextFieldCountry.setText("%");
        this.jTextFieldCountry.setCaretPosition(this.jTextFieldCountry.getText().length() - 1);
        this.jTextFieldCounty.setText("%");
        this.jTextFieldCounty.setCaretPosition(this.jTextFieldCounty.getText().length() - 1);
        this.jTextFieldOperator.setText("%");
        this.jTextFieldOperator.setCaretPosition(this.jTextFieldOperator.getText().length() - 1);
        this.jTextFieldClient.setText("%");
        this.jTextFieldClient.setCaretPosition(this.jTextFieldClient.getText().length() - 1);
        this.jTextFieldState.setText("%");
        this.jTextFieldState.setCaretPosition(this.jTextFieldState.getText().length() - 1);
        this.jTextFieldArea.setText("%");
        this.jTextFieldArea.setCaretPosition(this.jTextFieldArea.getText().length() - 1);
        this.jTextFieldBasin.setText("%");
        this.jTextFieldBasin.setCaretPosition(this.jTextFieldBasin.getText().length() - 1);
        this.jTextFieldWellName.requestFocusInWindow();
    }

    private void jButtonSearchActionPerformed(ActionEvent evt) {
        com.stratadata.model3.well.WellHeader params = new com.stratadata.model3.well.WellHeader();
        params.setWellName(this.jTextFieldWellName.getText());
        params.setWellCode(this.jTextFieldWellCode.getText());
        params.setCountry(this.jTextFieldCountry.getText());
        params.setCounty(this.jTextFieldCounty.getText());
        params.setField(this.jTextFieldField.getText());
        params.setBasin(this.jTextFieldBasin.getText());
        params.setArea(this.jTextFieldArea.getText());
        params.setLocState(this.jTextFieldState.getText());
        params.setOperator(this.jTextFieldOperator.getText());
        params.setClient(this.jTextFieldClient.getText());
        params.setSectionType(this.jRadioButtonAllSections.isSelected() ? null : (this.jRadioButtonWellsOnly.isSelected() ? SectionType.WELL : SectionType.OUTCROP));
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.model.results = new WellSearchService(this.sbdb).search(params);
            if (this.model.results.isEmpty()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "No wells/outcrops found", this.getTitle(), 1);
            }
            this.model.fireTableDataChanged();
        }
        catch (SQLException sqle) {
            SbugsExceptionHandler.showStackError(sqle, (Component)((Object)this));
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableWells.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No well" + (this.multiSelect ? "s" : "") + " selected", this.getTitle(), 2);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.selection = new LinkedList<Well>();
        int wellID = 0;
        try {
            int[] selected = this.jTableWells.getSelectedRows();
            for (int i = 0; i < selected.length; ++i) {
                wellID = this.model.results.get(this.jTableWells.convertRowIndexToModel(selected[i])).getWellID();
                Well well = this.sbdb.getWell(wellID);
                this.selection.add(well);
            }
            this.sbdb.commit();
            this.saveDefaults();
            super.returnWithCode(DialogBase.ReturnCode.SUCCESS);
        }
        catch (RuntimeException | SQLException | SBException e) {
            this.sbdb.doRollback();
            if (e.getMessage().contains("permission to access")) {
                try {
                    Object msg = "You cannot select a restricted well. ";
                    String holders = Well.getKeyHolders(this.sbdb, wellID);
                    msg = (String)msg + (holders.contains(",") ? "Keyholders are: " : "Keyholder is: ");
                    msg = (String)msg + holders;
                    JOptionPane.showMessageDialog((Component)((Object)this), msg, this.getTitle(), 2);
                }
                catch (SQLException ex) {
                    SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
                }
            } else {
                SbugsExceptionHandler.showStackError(e, (Component)((Object)this));
            }
            this.selection = null;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonSelectCountryActionPerformed(ActionEvent evt) {
        try {
            List<String> list = WellHeader.getCountries(this.sbdb);
            DialogList<String> dialog = new DialogList<String>((JDialog)((Object)this), true, "Select Country", new UserPrefsHelper(this.sbdb), list, true, false);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                this.jTextFieldCountry.setText(dialog.getSelection());
            }
        }
        catch (SQLException ex) {
            SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
        }
    }

    void saveDefaults() {
        String defaults = this.jTextFieldWellName.getText().trim() + "|" + this.jTextFieldWellCode.getText().trim() + "|" + this.jTextFieldField.getText().trim() + "|" + this.jTextFieldCountry.getText().trim() + "|";
        defaults = defaults + this.jTextFieldCounty.getText().trim() + "| | | |" + this.jTextFieldOperator.getText().trim() + "|";
        try {
            Lastval.putString(this.sbdb, "JWSEARCH", defaults);
            this.model.putTableColumnWidths(this.sbdb, this.jTableWells);
            this.sbdb.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public List<Well> getSelection() {
        return this.selection;
    }

    public Well getSelected() {
        if (this.selection != null && !this.selection.isEmpty()) {
            return this.selection.get(0);
        }
        return null;
    }
}

