/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.wellheader;

import com.stratadata.model3.well.WellSearchService;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableRowSorter;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.wellheader.TableModelWells;
import model3.Lastval;
import model3.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;

public class DialogSelectWellMaster
extends JDialog {
    SBdb sbdb;
    String selectedWellCode = null;
    TableModelWells model = new TableModelWells(false);
    static final String TABLE_COLUMN_LASTVAL = "TABLESW";
    private JButton jButtonCancel;
    private JButton jButtonClear;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSearch;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTable jTableWells;
    private JTextField jTextFieldCountry;
    private JTextField jTextFieldWellCode;
    private JTextField jTextFieldWellName;

    public DialogSelectWellMaster(JDialog parent, boolean modal, SBdb SB2, String wellName) {
        super((Dialog)parent, modal);
        this.sbdb = SB2;
        this.setTitle("Well Master : Select");
        this.initComponents();
        this.setLocation(parent.getLocation().x + 25, parent.getLocation().y + 25);
        this.init(wellName);
    }

    private void init(String wellName) {
        this.getRootPane().setDefaultButton(this.jButtonSearch);
        for (int i = 0; i < this.model.maxColumn; ++i) {
            this.jTableWells.getColumnModel().getColumn(i).setHeaderValue(TableModelWells.columnHeaders[i]);
            this.jTableWells.getColumnModel().getColumn(i).setWidth(TableModelWells.columnWidths[i]);
        }
        TableUtils.setTableHeaderBold((JTable)this.jTableWells);
        this.jTableWells.setSelectionMode(0);
        this.jTableWells.setRowSorter(new TableRowSorter<TableModelWells>(this.model));
        new ColumnSortResetHandler(this.jTableWells).attach();
        try {
            this.sbdb.setTableColumnWidths(TABLE_COLUMN_LASTVAL, this.jTableWells);
            if (wellName != null && wellName.length() > 0) {
                this.jTextFieldWellName.setText(wellName + "%");
                this.jTextFieldWellName.setCaretPosition(wellName.length() - 1);
            } else {
                String defaults = Lastval.getString(this.sbdb, "JWSEARCH");
                if (defaults == null || defaults.length() == 0) {
                    defaults = "%|%|%|%|";
                }
                StringTokenizer tok = new StringTokenizer(defaults, "|");
                this.jTextFieldWellName.setText((String)tok.nextElement());
                this.jTextFieldWellName.setCaretPosition(this.jTextFieldWellName.getText().length() - 1);
                this.jTextFieldWellCode.setText((String)tok.nextElement());
                this.jTextFieldWellCode.setCaretPosition(this.jTextFieldWellCode.getText().length() - 1);
                this.jTextFieldCountry.setText((String)tok.nextElement());
                this.jTextFieldCountry.setCaretPosition(this.jTextFieldCountry.getText().length() - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldWellName = new JTextField();
        this.jTextFieldWellCode = new JTextField();
        this.jTextFieldCountry = new JTextField();
        this.jButtonSearch = new JButton();
        this.jButtonClear = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableWells = new JTable();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 400));
        this.jPanel2.setMinimumSize(new Dimension(400, 300));
        this.jLabel1.setText("Well name:");
        this.jLabel2.setText("Well code:");
        this.jLabel3.setText("Country:");
        this.jTextFieldWellName.setText("%");
        this.jTextFieldWellCode.setText("%");
        this.jTextFieldCountry.setText("%");
        this.jButtonSearch.setText("Search");
        this.jButtonSearch.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectWellMaster this$0;
            {
                DialogSelectWellMaster dialogSelectWellMaster = this$0;
                Objects.requireNonNull(dialogSelectWellMaster);
                this.this$0 = dialogSelectWellMaster;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSearchActionPerformed(evt);
            }
        });
        this.jButtonClear.setText("Clear");
        this.jButtonClear.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectWellMaster this$0;
            {
                DialogSelectWellMaster dialogSelectWellMaster = this$0;
                Objects.requireNonNull(dialogSelectWellMaster);
                this.this$0 = dialogSelectWellMaster;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonClearActionPerformed(evt);
            }
        });
        this.jTableWells.setModel(this.model);
        this.jTableWells.setAutoResizeMode(4);
        this.jTableWells.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogSelectWellMaster this$0;
            {
                DialogSelectWellMaster dialogSelectWellMaster = this$0;
                Objects.requireNonNull(dialogSelectWellMaster);
                this.this$0 = dialogSelectWellMaster;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableWellsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableWells);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectWellMaster this$0;
            {
                DialogSelectWellMaster dialogSelectWellMaster = this$0;
                Objects.requireNonNull(dialogSelectWellMaster);
                this.this$0 = dialogSelectWellMaster;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectWellMaster this$0;
            {
                DialogSelectWellMaster dialogSelectWellMaster = this$0;
                Objects.requireNonNull(dialogSelectWellMaster);
                this.this$0 = dialogSelectWellMaster;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSelectWellMaster this$0;
            {
                DialogSelectWellMaster dialogSelectWellMaster = this$0;
                Objects.requireNonNull(dialogSelectWellMaster);
                this.this$0 = dialogSelectWellMaster;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 456, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel3).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jTextFieldWellCode, -1, 171, Short.MAX_VALUE).add((Component)this.jTextFieldWellName, -1, 171, Short.MAX_VALUE).add((Component)this.jTextFieldCountry, -1, 171, Short.MAX_VALUE)).add(228, 228, 228)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).add(18, 18, 18)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jButtonSearch).addPreferredGap(0).add((Component)this.jButtonClear).addContainerGap(338, Short.MAX_VALUE)))));
        jPanel2Layout.linkSize(new Component[]{this.jButtonClear, this.jButtonSearch}, 1);
        jPanel2Layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jTextFieldWellName, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jTextFieldWellCode, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jTextFieldCountry, -2, -1, -2).add((Component)this.jLabel3)).add(12, 12, 12).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jButtonClear).add((Component)this.jButtonSearch)).addPreferredGap(1).add((Component)this.jScrollPane1, -1, 374, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jTableWellsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonOKActionPerformed(null);
        }
    }

    private void jButtonClearActionPerformed(ActionEvent evt) {
        this.jTextFieldWellName.setText("%");
        this.jTextFieldWellName.setCaretPosition(this.jTextFieldWellName.getText().length() - 1);
        this.jTextFieldWellCode.setText("%");
        this.jTextFieldWellCode.setCaretPosition(this.jTextFieldWellCode.getText().length() - 1);
        this.jTextFieldCountry.setText("%");
        this.jTextFieldCountry.setCaretPosition(this.jTextFieldCountry.getText().length() - 1);
        this.jTextFieldWellName.requestFocusInWindow();
    }

    private void jButtonSearchActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.model.results = new WellSearchService(this.sbdb).searchMaster(this.jTextFieldWellName.getText(), this.jTextFieldWellCode.getText(), this.jTextFieldCountry.getText());
            if (this.model.results.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No wells found", this.getTitle(), 1);
            }
            this.model.fireTableDataChanged();
        }
        catch (SQLException | InvalidFieldException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableWells.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No well selected", this.getTitle(), 2);
            return;
        }
        this.selectedWellCode = this.model.results.get(this.jTableWells.convertRowIndexToModel(this.jTableWells.getSelectedRow())).getWellCode();
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogselectwellmaster.html");
    }
}

