/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.wells;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogGrainSize;
import jsbugs.FrameJsbugs;
import jsbugs.LithologyCellRenderer;
import jsbugs.table.ComboRenderer;
import jsbugs.table.DepthRenderer;
import jsbugs.wells.ModelessWellInfoDialog;
import model3.LithBase;
import model3.LithInterval;
import model3.LithQualifier;
import model3.Lithdesc;
import model3.Lithology;
import model3.SBdb;
import model3.Well;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.exception.StackError;
import util.table.SbugsTable;

public class DialogIntLith
extends ModelessWellInfoDialog
implements Observer {
    private final TableModelIntLith model = new TableModelIntLith(this);
    private final Well well;
    private final SBdb db;
    private ButtonGroup buttonGroup1;
    private JButton jButtonAddInterval;
    private JButton jButtonAddQual;
    private JButton jButtonCancel;
    private JButton jButtonGrainSize;
    private JButton jButtonHelp;
    private JButton jButtonInsertInterval;
    private JButton jButtonInsertQual;
    private JButton jButtonOK;
    private JButton jButtonRemove;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonDepthDrilled;
    private JRadioButton jRadioButtonDepthLog;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTableLith;

    public DialogIntLith(Frame parent, boolean modal, SBdb db, Well well) throws SQLException, SBException {
        super(parent, modal);
        this.well = well;
        this.db = db;
        this.model.units = well.getWellUnits();
        this.model.type = well.getType();
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Interval Lithology : " + this.well.getWellName());
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.initList(false);
        this.model.lithdesc = this.db.getLithdesc();
        this.model.intervalComboBox = this.db.getLithologyCombo(true);
        this.model.alignmentComboBox = new JComboBox<String>(new String[]{"Left", "Right", "Centre"});
        this.model.setupTable(this.jTableLith);
        this.jTableLith.setRowSorter(new TableRowSorter<TableModelIntLith>(this.model));
        new ColumnSortResetHandler(this.jTableLith).attach();
        this.well.addObserver(this);
        this.jRadioButtonDepthDrilled.setSelected(this.well.getHeader().lithologyDepthsAreDrilled());
        if (!this.well.canWrite(this.db, null)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(this.well.getDeniedReason(this.db, "well", false));
        }
    }

    @Override
    public Well getWell() {
        return this.well;
    }

    void initList(boolean forceReload) throws SQLException, SBException {
        this.model.list = new LinkedList<LithBase>();
        if (forceReload) {
            this.well.loadLithology();
        }
        for (LithBase interval : this.well.getLithIntervals()) {
            if (interval instanceof LithInterval) {
                this.model.list.add(new LithInterval(null, (LithInterval)interval));
                continue;
            }
            this.model.list.add(new LithQualifier(null, (LithQualifier)interval));
        }
        this.model.fireTableDataChanged();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jTableLith = new SbugsTable();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonInsertInterval = new JButton();
        this.jButtonAddInterval = new JButton();
        this.jButtonRemove = new JButton();
        this.jButtonAddQual = new JButton();
        this.jButtonInsertQual = new JButton();
        this.jButtonGrainSize = new JButton();
        this.jPanel1 = new JPanel();
        this.jRadioButtonDepthLog = new JRadioButton();
        this.jRadioButtonDepthDrilled = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(500, 400));
        this.jTableLith.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableLith);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIntLith this$0;
            {
                DialogIntLith dialogIntLith = this$0;
                Objects.requireNonNull(dialogIntLith);
                this.this$0 = dialogIntLith;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIntLith this$0;
            {
                DialogIntLith dialogIntLith = this$0;
                Objects.requireNonNull(dialogIntLith);
                this.this$0 = dialogIntLith;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIntLith this$0;
            {
                DialogIntLith dialogIntLith = this$0;
                Objects.requireNonNull(dialogIntLith);
                this.this$0 = dialogIntLith;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonInsertInterval.setText("Insert interval");
        this.jButtonInsertInterval.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonInsertInterval.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIntLith this$0;
            {
                DialogIntLith dialogIntLith = this$0;
                Objects.requireNonNull(dialogIntLith);
                this.this$0 = dialogIntLith;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonInsertIntervalActionPerformed(evt);
            }
        });
        this.jButtonAddInterval.setText("Add Interval");
        this.jButtonAddInterval.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonAddInterval.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIntLith this$0;
            {
                DialogIntLith dialogIntLith = this$0;
                Objects.requireNonNull(dialogIntLith);
                this.this$0 = dialogIntLith;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddIntervalActionPerformed(evt);
            }
        });
        this.jButtonRemove.setText("Delete");
        this.jButtonRemove.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIntLith this$0;
            {
                DialogIntLith dialogIntLith = this$0;
                Objects.requireNonNull(dialogIntLith);
                this.this$0 = dialogIntLith;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonRemoveActionPerformed(evt);
            }
        });
        this.jButtonAddQual.setText("Add qualifier");
        this.jButtonAddQual.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonAddQual.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIntLith this$0;
            {
                DialogIntLith dialogIntLith = this$0;
                Objects.requireNonNull(dialogIntLith);
                this.this$0 = dialogIntLith;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddQualActionPerformed(evt);
            }
        });
        this.jButtonInsertQual.setText("Insert qualifier");
        this.jButtonInsertQual.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonInsertQual.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIntLith this$0;
            {
                DialogIntLith dialogIntLith = this$0;
                Objects.requireNonNull(dialogIntLith);
                this.this$0 = dialogIntLith;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonInsertQualActionPerformed(evt);
            }
        });
        this.jButtonGrainSize.setText("Grain size...");
        this.jButtonGrainSize.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIntLith this$0;
            {
                DialogIntLith dialogIntLith = this$0;
                Objects.requireNonNull(dialogIntLith);
                this.this$0 = dialogIntLith;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonGrainSizeActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Depths", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroup1.add(this.jRadioButtonDepthLog);
        this.jRadioButtonDepthLog.setSelected(true);
        this.jRadioButtonDepthLog.setText("Logged");
        this.buttonGroup1.add(this.jRadioButtonDepthDrilled);
        this.jRadioButtonDepthDrilled.setText("Drilled");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonDepthLog).addComponent(this.jRadioButtonDepthDrilled)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonDepthLog).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonDepthDrilled).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 661, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonCancel, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonOK, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAddInterval, -1, -1, Short.MAX_VALUE)).addComponent(this.jButtonInsertInterval, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addComponent(this.jButtonAddQual, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonInsertQual, -1, -1, Short.MAX_VALUE)).addComponent(this.jButtonRemove, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addComponent(this.jButtonGrainSize, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator1)).addContainerGap()));
        layout.linkSize(0, this.jButtonAddInterval, this.jButtonAddQual, this.jButtonCancel, this.jButtonHelp, this.jButtonInsertInterval, this.jButtonInsertQual, this.jButtonOK, this.jButtonRemove);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAddInterval).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonInsertInterval).addGap(18, 18, 18).addComponent(this.jButtonAddQual).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonInsertQual).addGap(18, 18, 18).addComponent(this.jButtonRemove).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonGrainSize).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 542, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonInsertIntervalActionPerformed(ActionEvent evt) {
        if (this.jTableLith.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No row selected", this.getTitle(), 2);
            return;
        }
        int row = this.jTableLith.getSelectedRow();
        this.model.list.add(row, new LithInterval(null));
        this.model.fireTableDataChanged();
        this.jTableLith.scrollRectToVisible(this.jTableLith.getCellRect(row, 0, true));
        this.jTableLith.setRowSelectionInterval(row, row);
    }

    private void jButtonAddIntervalActionPerformed(ActionEvent evt) {
        this.model.list.add(new LithInterval(null));
        this.model.fireTableDataChanged();
        int addedRow = this.model.list.size() - 1;
        this.jTableLith.scrollRectToVisible(this.jTableLith.getCellRect(addedRow, 0, true));
        this.jTableLith.setRowSelectionInterval(addedRow, addedRow);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        try {
            this.initList(false);
            this.model.fireTableDataChanged();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            Collections.sort(this.model.list);
            LithBase.check(this.model.list, this.model.units);
            this.well.storeLithology(this.model.list);
            this.well.notifyObservers(LithBase.class);
            this.well.getHeader().updateLithologyDepths(this.db, this.jRadioButtonDepthDrilled.isSelected());
            this.db.commit();
            this.initList(false);
            this.model.fireTableDataChanged();
            this.dispose();
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, "Check overlapping intervals: " + ex.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonAddQualActionPerformed(ActionEvent evt) {
        this.model.list.add(new LithQualifier(null));
        this.model.fireTableDataChanged();
        this.jTableLith.scrollRectToVisible(this.jTableLith.getCellRect(this.model.getRowCount(), 0, true));
    }

    private void jButtonInsertQualActionPerformed(ActionEvent evt) {
        if (this.jTableLith.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No row selected", this.getTitle(), 2);
            return;
        }
        int row = this.jTableLith.getSelectedRow();
        this.model.list.add(row, new LithQualifier(null));
        this.model.fireTableDataChanged();
        this.jTableLith.scrollRectToVisible(this.jTableLith.getCellRect(row, 0, true));
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        if (this.jTableLith.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 2);
            return;
        }
        int[] selection = this.jTableLith.getSelectedRows();
        String msg = "Really delete " + (String)(selection.length == 1 ? "this row?" : "these " + selection.length + " rows?");
        if (JOptionPane.showConfirmDialog(this, msg = msg + "\nData are not deleted from the database until you press OK.", this.getTitle(), 0, 3) != 0) {
            return;
        }
        LinkedList<LithBase> toRemove = new LinkedList<LithBase>();
        for (int i = 0; i < selection.length; ++i) {
            toRemove.add(this.model.list.get(this.jTableLith.convertRowIndexToModel(selection[i])));
        }
        for (LithBase lith : toRemove) {
            this.model.list.remove(lith);
        }
        this.jTableLith.clearSelection();
        this.model.fireTableDataChanged();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogintlith.html");
    }

    private void jButtonGrainSizeActionPerformed(ActionEvent evt) {
        try {
            DialogGrainSize dialog = new DialogGrainSize(this, true, this.db, this.well, this.model.units);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.toString(), (Throwable)ex);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Well && this.well.getWellID() == this.well.getWellID() && (arg instanceof LithBase || arg == LithBase.class)) {
            try {
                this.initList(false);
                this.model.fireTableDataChanged();
                this.jTableLith.repaint();
            }
            catch (SQLException | SBException sql) {
                sql.printStackTrace();
            }
        }
    }

    private class TableModelIntLith
    extends AbstractTableModel {
        static final int COL_TOP = 0;
        static final int COL_BASE = 1;
        static final int COL_LITH = 2;
        static final int COL_PATTERN = 3;
        static final int COL_ALIGNMENT = 4;
        static final int COL_POSITION = 5;
        final String[] colTitles;
        final int[] colWidths;
        char units;
        char type;
        List<LithBase> list;
        Lithdesc lithdesc;
        JComboBox intervalComboBox;
        JComboBox alignmentComboBox;
        final /* synthetic */ DialogIntLith this$0;

        private TableModelIntLith(DialogIntLith dialogIntLith) {
            DialogIntLith dialogIntLith2 = dialogIntLith;
            Objects.requireNonNull(dialogIntLith2);
            this.this$0 = dialogIntLith2;
            this.colTitles = new String[]{"Top", "Base", "Lithology", "Pattern", "Alignment", "Position/Size"};
            this.colWidths = new int[]{30, 30, 120, 40, 40, 40};
            this.units = (char)77;
            this.type = (char)87;
            this.list = null;
            this.intervalComboBox = null;
            this.alignmentComboBox = null;
        }

        @Override
        public int getRowCount() {
            if (this.list == null) {
                return 0;
            }
            return this.list.size();
        }

        @Override
        public int getColumnCount() {
            return this.colTitles.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            LithBase lith = this.list.get(rowIndex);
            if (lith == null) {
                return "";
            }
            try {
                switch (columnIndex) {
                    case 0: {
                        return DepthUtils.convFromM((double)lith.getTopDepth(), (char)this.units, (char)this.type);
                    }
                    case 1: {
                        if (lith instanceof LithQualifier) {
                            return null;
                        }
                        return DepthUtils.convFromM((double)((LithInterval)lith).getBaseDepth(), (char)this.units, (char)this.type);
                    }
                    case 2: {
                        if (lith.getLithology() == null) {
                            return "";
                        }
                        return this.lithdesc.getQualifiedLithdesc(lith.getLithology());
                    }
                    case 3: {
                        return lith.getLithology();
                    }
                    case 4: {
                        if (lith instanceof LithInterval) {
                            return "";
                        }
                        LithQualifier lithQualifier = (LithQualifier)lith;
                        if (lithQualifier.getType() == 'S') {
                            return lithQualifier.getAlignmentString();
                        }
                        return "";
                    }
                    case 5: {
                        if (lith instanceof LithInterval) {
                            return null;
                        }
                        LithQualifier lithQualifier = (LithQualifier)lith;
                        return Float.valueOf(lithQualifier.getXpos());
                    }
                }
                return "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void setValueAt(Object obj, int row, int col) {
            try {
                LithBase lith = this.list.get(row);
                if (lith == null) {
                    return;
                }
                switch (col) {
                    case 0: {
                        lith.setTopDepth(DepthUtils.convToM((double)Double.parseDouble(obj.toString()), (char)this.units, (char)this.type));
                        return;
                    }
                    case 1: {
                        LithBase nextLith;
                        if (!(lith instanceof LithInterval)) return;
                        double depth = DepthUtils.convToM((double)Double.parseDouble(obj.toString()), (char)this.units, (char)this.type);
                        ((LithInterval)lith).setBaseDepth(depth);
                        if (this.list.size() <= row + 1 || !((nextLith = this.list.get(row + 1)) instanceof LithInterval) || !(nextLith.getTopDepth() < (double)0.0029f)) return;
                        nextLith.setTopDepth(depth);
                        return;
                    }
                    case 2: {
                        Lithology descr = this.lithdesc.getLithologyFromDescription(obj.toString());
                        if (descr != null) {
                            if (lith instanceof LithQualifier && descr.isQual()) {
                                lith.setLithology(descr);
                                return;
                            }
                            if (lith instanceof LithInterval && !descr.isQual()) {
                                lith.setLithology(descr);
                                return;
                            }
                            lith.setLithology(null);
                            return;
                        }
                        lith.setLithology(null);
                        return;
                    }
                    default: {
                        return;
                    }
                    case 4: {
                        if (!(lith instanceof LithQualifier) || obj.toString().length() <= 0) return;
                        String strg = obj.toString();
                        ((LithQualifier)lith).setAlignment(strg.charAt(0));
                        return;
                    }
                    case 5: {
                        if (!(lith instanceof LithQualifier) || obj.toString().length() <= 0) return;
                        String strg = obj.toString();
                        if (Float.parseFloat(strg) > 100.0f) {
                            strg = "100.0";
                        }
                        ((LithQualifier)lith).setXpos(Float.parseFloat(strg));
                    }
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: 
                case 1: {
                    return Double.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return Lithology.class;
                }
                default: {
                    return String.class;
                }
                case 4: {
                    return String.class;
                }
                case 5: 
            }
            return Float.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            LithBase lith = this.list.get(row);
            switch (col) {
                case 0: 
                case 2: {
                    return true;
                }
                case 1: {
                    return !(lith instanceof LithQualifier);
                }
                case 4: 
                case 5: {
                    return lith instanceof LithQualifier;
                }
            }
            return false;
        }

        void setupTable(JTable jTable) {
            SB.setTableHeaderBold((JTable)jTable);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                jTable.getColumnModel().getColumn(i).setHeaderValue(this.colTitles[i]);
                jTable.getColumnModel().getColumn(i).setPreferredWidth(this.colWidths[i]);
            }
            TableColumnModel model = jTable.getColumnModel();
            model.getColumn(0).setCellRenderer(new DepthRenderer());
            model.getColumn(1).setCellRenderer(new DepthRenderer());
            model.getColumn(3).setCellRenderer(new LithologyCellRenderer());
            model.getColumn(2).setCellEditor(new DefaultCellEditor(this.intervalComboBox));
            model.getColumn(2).setCellRenderer(new ComboRenderer());
            model.getColumn(4).setCellEditor(new DefaultCellEditor(this.alignmentComboBox));
            model.getColumn(4).setCellRenderer(new ComboRenderer());
        }
    }
}

