/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.user.Userdef;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsbugs.abnsch.DialogAbnSchemes;
import jsbugs.userconnect.DialogSelectAnalyst;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.AnalystHeader;
import model3.EnvScheme;
import model3.Lastval;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.Well;
import org.jdesktop.layout.GroupLayout;
import util.DepthUtils;
import util.SB;
import util.SBException;

public class DialogAnalystHeader
extends SBDialog {
    private static final int COMMENTLEN = 255;
    private final DefaultComboBoxModel abnModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel envModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel modelAnalysts = new DefaultComboBoxModel();
    private final DefaultComboBoxModel comboModelDiscipline = new DefaultComboBoxModel<Discipline>(Discipline.values());
    private final SBdb db;
    private final Well well;
    private boolean colourSelected = false;
    AnalystHeader hdr;
    private JButton jButtonAbnSchemes;
    private JButton jButtonAnalysts;
    private JButton jButtonCancel;
    private JButton jButtonColour;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonenvSchemes;
    private JComboBox jComboBoxAbnScheme;
    private JComboBox jComboBoxAnalyst;
    private JComboBox jComboBoxDiscipline;
    private JComboBox jComboBoxEnvScheme;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelDepthUnits1;
    private JLabel jLabelDepthUnits2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerAnalysisNumber;
    private JTextArea jTextAreaComment;
    private JTextField jTextFieldColour;
    private JTextField jTextFieldDateFrom;
    private JTextField jTextFieldDateTo;
    private JTextField jTextFieldDepthFrom;
    private JTextField jTextFieldDepthTo;
    private JTextField jTextFieldWellName;

    public DialogAnalystHeader(JDialog parent, boolean modal, SBdb db, Well well, AnalystHeader hdr) throws SQLException, SBException {
        super((Window)parent, modal);
        this.db = db;
        this.well = well;
        this.hdr = hdr;
        this.initComponents();
        this.init();
    }

    private void initAbnCombo() {
        this.abnModel.removeAllElements();
        this.abnModel.addElement("");
        try {
            for (AbundanceScheme abundanceScheme : this.db.getAbundanceSchemeService().getAllAbundanceSchemes()) {
                this.abnModel.addElement(abundanceScheme);
            }
        }
        catch (RuntimeException ex) {
            SbugsExceptionHandler.showStackError("Error populating abundance schemes", ex, (Component)((Object)this));
        }
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Analysis Suite : ");
        this.initAbnCombo();
        this.initEnvCombo();
        if (this.well.getWellUnits() == 'F') {
            this.jLabelDepthUnits1.setText("ft");
            this.jLabelDepthUnits2.setText("ft");
        }
        this.jTextFieldWellName.setText(this.well.getWellName());
        this.jTextFieldDateFrom.setText("");
        this.jTextFieldDateTo.setText("");
        this.jTextFieldDepthFrom.setText("");
        this.jTextFieldDepthTo.setText("");
        this.jTextAreaComment.setText("");
        this.jComboBoxAbnScheme.setSelectedIndex(0);
        this.jComboBoxEnvScheme.setSelectedIndex(0);
        if (this.hdr != null) {
            this.setTitle(this.getTitle() + "Edit : " + this.hdr.getDiscipline().getNoun() + " " + this.hdr.getAnalyst() + "/" + this.hdr.getAnalyNumber());
            this.modelAnalysts.addElement(this.hdr.getAnalyst());
            this.jSpinnerAnalysisNumber.setValue(this.hdr.getAnalyNumber());
            this.jComboBoxDiscipline.setSelectedItem(this.hdr.getDiscipline());
            this.jComboBoxAnalyst.setSelectedItem(this.hdr.getAnalyst());
            this.jTextFieldColour.setBackground(this.hdr.getColour());
            if (this.hdr.getDateFrom() != null) {
                this.jTextFieldDateFrom.setText(SB.df.format(this.hdr.getDateFrom()));
            }
            if (this.hdr.getDateTo() != null) {
                this.jTextFieldDateTo.setText(SB.df.format(this.hdr.getDateTo()));
            }
            if (this.hdr.getDepthFrom() != null) {
                this.jTextFieldDepthFrom.setText(SB.floatString((double)DepthUtils.convFromM((double)this.hdr.getDepthFrom(), (char)this.well.getWellUnits(), (char)this.well.getType()), (int)2));
            }
            if (this.hdr.getDepthTo() != null) {
                this.jTextFieldDepthTo.setText(SB.floatString((double)DepthUtils.convFromM((double)this.hdr.getDepthTo(), (char)this.well.getWellUnits(), (char)this.well.getType()), (int)2));
            }
            if (this.hdr.getComments() != null) {
                this.jTextAreaComment.setText(this.hdr.getComments());
            }
            if (this.hdr.getEnvSchID() > 0) {
                this.jComboBoxEnvScheme.setSelectedItem(this.db.getEnvScheme(this.hdr.getEnvSchID()));
            }
            if (this.hdr.getAbnSchID() > 0) {
                for (int i = 1; i < this.abnModel.getSize(); ++i) {
                    if (((AbundanceScheme)this.abnModel.getElementAt(i)).getAbnSchID() != this.hdr.getAbnSchID()) continue;
                    this.jComboBoxAbnScheme.setSelectedIndex(i);
                    break;
                }
            }
        } else {
            this.setTitle(this.getTitle() + "Add");
            for (Discipline disc : Discipline.values()) {
                List<String> list = this.well.getAnalysts(disc);
                Collections.sort(list);
                list.add(0, this.db.getUser().getAbr());
                for (String s : list) {
                    if (this.modelAnalysts.getIndexOf(s) >= 0) continue;
                    this.modelAnalysts.addElement(s);
                }
            }
            this.jComboBoxAnalyst.repaint();
            String analyst = (String)this.modelAnalysts.getSelectedItem();
            Userdef def = this.db.getUser(analyst);
            this.jComboBoxDiscipline.setSelectedItem(def.getDiscipline());
        }
        if (!this.well.canWrite(this.db, null)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(this.well.getDeniedReason(this.db, "well", false));
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
    }

    private void initEnvCombo() throws SQLException {
        this.envModel.removeAllElements();
        this.envModel.addElement("");
        Iterator<EnvScheme> itE = this.db.getEnvSchemes().iterator();
        while (itE.hasNext()) {
            this.envModel.addElement(itE.next());
        }
    }

    private boolean saveData() throws ParseException, SBException, SQLException {
        boolean dataExists = false;
        double top = 0.0;
        String analyst = (String)this.jComboBoxAnalyst.getSelectedItem();
        if (analyst == null || analyst.length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No analyst selected", this.getTitle(), 2);
            return false;
        }
        try {
            top = DepthUtils.convToM((double)Double.parseDouble(this.jTextFieldDepthFrom.getText()), (char)this.well.getWellUnits(), (char)this.well.getType());
            if (top > 0.0) {
                dataExists = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        double base = 0.0;
        try {
            base = DepthUtils.convToM((double)Double.parseDouble(this.jTextFieldDepthTo.getText()), (char)this.well.getWellUnits(), (char)this.well.getType());
            if (base > 0.0) {
                dataExists = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Date from = null;
        Date to = null;
        if (this.jTextFieldDateFrom.getText().length() > 0) {
            from = SB.df.parse(this.jTextFieldDateFrom.getText());
            dataExists = true;
        }
        if (this.jTextFieldDateTo.getText().length() > 0) {
            to = SB.df.parse(this.jTextFieldDateTo.getText());
            dataExists = true;
        }
        String comments = null;
        if (this.jTextAreaComment.getText().length() > 0) {
            comments = this.jTextAreaComment.getText();
            dataExists = true;
        }
        int envSchID = 0;
        if (this.jComboBoxEnvScheme.getSelectedIndex() > 0) {
            envSchID = ((EnvScheme)this.jComboBoxEnvScheme.getSelectedItem()).getID();
            dataExists = true;
        }
        int abnSchID = 0;
        Object object = this.jComboBoxAbnScheme.getSelectedItem();
        if (object instanceof AbundanceScheme) {
            AbundanceScheme abundanceScheme = (AbundanceScheme)object;
            abnSchID = abundanceScheme.getAbnSchID();
            dataExists = true;
        }
        int analyNumber = (Integer)this.jSpinnerAnalysisNumber.getValue();
        Discipline discID = (Discipline)this.jComboBoxDiscipline.getSelectedItem();
        if (this.db.restrictedToDiscID(discID)) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You can only add/edit data within " + this.db.getUser().getDiscipline().getNoun() + ". See Config Personnel from the Control panel");
            return false;
        }
        if (this.hdr != null) {
            AnalystHeader existing = this.well.getAnalystHeader(analyst, discID.getChar(), analyNumber, false);
            if (existing != null && existing.getAnalyID() != this.hdr.getAnalyID()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Cannot edit unique identifiers - suite " + discID.getNoun() + "/" + analyst + "/" + analyNumber + " already exists.", this.getTitle(), 2);
                return false;
            }
            String semiQuant = this.well.hasSemiQuantData(this.hdr);
            if (abnSchID > 0) {
                AbundanceScheme abnScheme = (AbundanceScheme)this.jComboBoxAbnScheme.getSelectedItem();
                if (semiQuant != null) {
                    StringTokenizer tok = new StringTokenizer(semiQuant, ",");
                    while (tok.hasMoreTokens()) {
                        String token = tok.nextToken();
                        if (token.equals("+") || !abnScheme.findEntryBySubjAbund(token).isEmpty()) continue;
                        JOptionPane.showMessageDialog((Component)((Object)this), "Abundance Scheme specified is not compatible with existing Semi-Quantiative data. It must include classes: " + semiQuant, this.getTitle(), 1);
                        return false;
                    }
                }
                abnSchID = abnScheme.getAbnSchID();
                dataExists = true;
            } else if (semiQuant != null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "No Abundance Scheme specified for Semi-Quantitative data (" + semiQuant + ")", this.getTitle(), 1);
                return false;
            }
            if (this.well.hasSampleEnvData(this.hdr) && this.hdr.getEnvSchID() != envSchID) {
                EnvScheme newScheme = this.db.getEnvScheme(envSchID);
                if (newScheme == null) {
                    String msg = "This suite contains palaeoenvironment data: scheme must be set.";
                    JOptionPane.showMessageDialog((Component)((Object)this), msg, this.getTitle(), 2);
                    return false;
                }
                boolean allowed = true;
                block5: for (Sample sample : this.well.getSamples()) {
                    for (Smpdtl dtl : sample.getSmpdtls()) {
                        if (dtl.getHeader() != this.hdr) continue;
                        if (dtl.getProximal() > newScheme.getNClasses()) {
                            allowed = false;
                        }
                        if (dtl.getDistal() > newScheme.getNClasses()) {
                            allowed = false;
                        }
                        if (allowed) continue;
                        break block5;
                    }
                }
                if (allowed) {
                    EnvScheme oldScheme = this.db.getEnvScheme(this.hdr.getEnvSchID());
                    Object msg = "Palaeoenvironment data exist for analyses in this suite.\nIf you change the environment scheme, data will be changed as follows:\n\n";
                    for (int i = 1; i <= oldScheme.getNClasses(); ++i) {
                        msg = (String)msg + oldScheme.getTerm(i) + " --> " + newScheme.getTerm(i) + "\n";
                    }
                    if (JOptionPane.showConfirmDialog((Component)((Object)this), msg = (String)msg + "\nOK to continue?", this.getTitle(), 0) != 0) {
                        return false;
                    }
                } else {
                    String msg = "Palaeoenvironment scheme specified is insufficient for existing data.\nSelect another scheme or retain existing scheme.";
                    JOptionPane.showMessageDialog((Component)((Object)this), msg, this.getTitle(), 2);
                    return false;
                }
            }
        }
        Color colour = null;
        if (this.colourSelected) {
            Userdef analystUser;
            colour = this.jTextFieldColour.getBackground();
            if (!colour.equals((analystUser = this.db.getUser(analyst)).getColour())) {
                Lastval.putColour(this.db, "AHC:" + analyst + "/" + analyNumber, colour);
            }
        } else if (this.hdr.getColour() != null) {
            colour = this.hdr.getColour();
        }
        if (this.hdr != null) {
            this.well.setAnalystHeader(this.hdr, top, base, from, to, comments, envSchID, abnSchID, colour);
            if (!this.hdr.getAnalyst().equals(analyst) || this.hdr.getAnalyNumber() != analyNumber || this.hdr.getDiscipline() != discID) {
                this.well.setAnalystHeader(this.hdr, analyst, discID.getChar(), analyNumber);
            }
        } else {
            if (this.well.getAnalystHeader(analyst, discID.getChar(), analyNumber, false) != null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Data suite header already exists.", this.getTitle(), 1);
                return false;
            }
            this.hdr = this.well.addAnalystHeader(analyst, discID.getChar(), analyNumber, top, base, from, to, comments, envSchID, abnSchID, colour);
        }
        this.well.notifyObservers(this.hdr);
        return true;
    }

    private void initComponents() {
        this.jLabel10 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jComboBoxAnalyst = new JComboBox();
        this.jButtonAnalysts = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldWellName = new JTextField();
        this.jLabel4 = new JLabel();
        this.jSpinnerAnalysisNumber = new JSpinner();
        this.jPanel1 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTextFieldDepthFrom = new JTextField();
        this.jTextFieldDepthTo = new JTextField();
        this.jLabelDepthUnits1 = new JLabel();
        this.jLabelDepthUnits2 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jTextFieldDateFrom = new JTextField();
        this.jLabel8 = new JLabel();
        this.jTextFieldDateTo = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaComment = new JTextArea();
        this.jLabel9 = new JLabel();
        this.jComboBoxEnvScheme = new JComboBox();
        this.jLabel11 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel12 = new JLabel();
        this.jComboBoxAbnScheme = new JComboBox();
        this.jComboBoxDiscipline = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jButtonColour = new JButton();
        this.jLabel13 = new JLabel();
        this.jTextFieldColour = new JTextField();
        this.jButtonHelp = new JButton();
        this.jButtonAbnSchemes = new JButton();
        this.jButtonenvSchemes = new JButton();
        this.jLabel10.setText("jLabel10");
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel2.setText("Analyst:");
        this.jComboBoxAnalyst.setModel(this.modelAnalysts);
        this.jComboBoxAnalyst.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalystHeader this$0;
            {
                DialogAnalystHeader dialogAnalystHeader = this$0;
                Objects.requireNonNull(dialogAnalystHeader);
                this.this$0 = dialogAnalystHeader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxAnalystActionPerformed(evt);
            }
        });
        this.jButtonAnalysts.setText("...");
        this.jButtonAnalysts.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalystHeader this$0;
            {
                DialogAnalystHeader dialogAnalystHeader = this$0;
                Objects.requireNonNull(dialogAnalystHeader);
                this.this$0 = dialogAnalystHeader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAnalystsActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Well: ");
        this.jTextFieldWellName.setEditable(false);
        this.jTextFieldWellName.setText("jTextField1");
        this.jLabel4.setText("Suite number:");
        this.jSpinnerAnalysisNumber.setModel(new SpinnerNumberModel(1, 1, 10, 1));
        this.jSpinnerAnalysisNumber.setToolTipText("This is used to distinguish different sets of analyses by the same analyst");
        this.jSpinnerAnalysisNumber.addChangeListener(new ChangeListener(this){
            final /* synthetic */ DialogAnalystHeader this$0;
            {
                DialogAnalystHeader dialogAnalystHeader = this$0;
                Objects.requireNonNull(dialogAnalystHeader);
                this.this$0 = dialogAnalystHeader;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.jSpinnerAnalysisNumberStateChanged(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Depths", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabel5.setText("From: ");
        this.jLabel6.setText("To:");
        this.jTextFieldDepthFrom.setHorizontalAlignment(11);
        this.jTextFieldDepthFrom.setText("jTextField1");
        this.jTextFieldDepthFrom.setToolTipText("Not required for normal use - see help");
        this.jTextFieldDepthFrom.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogAnalystHeader this$0;
            {
                DialogAnalystHeader dialogAnalystHeader = this$0;
                Objects.requireNonNull(dialogAnalystHeader);
                this.this$0 = dialogAnalystHeader;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldDepthFromKeyTyped(evt);
            }
        });
        this.jTextFieldDepthTo.setHorizontalAlignment(11);
        this.jTextFieldDepthTo.setText("jTextField2");
        this.jTextFieldDepthTo.setToolTipText("Not required for normal use - see help");
        this.jTextFieldDepthTo.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogAnalystHeader this$0;
            {
                DialogAnalystHeader dialogAnalystHeader = this$0;
                Objects.requireNonNull(dialogAnalystHeader);
                this.this$0 = dialogAnalystHeader;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldDepthToKeyTyped(evt);
            }
        });
        this.jLabelDepthUnits1.setText("m");
        this.jLabelDepthUnits2.setText("m");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel5).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(10, 10, 10).add((Component)this.jLabel6))).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((Component)this.jTextFieldDepthTo, -1, 110, Short.MAX_VALUE).add((Component)this.jTextFieldDepthFrom)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabelDepthUnits2, -2, 14, -2).add((Component)this.jLabelDepthUnits1, -2, 14, -2)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.jTextFieldDepthFrom, -2, -1, -2).add((Component)this.jLabelDepthUnits1)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.jTextFieldDepthTo, -2, -1, -2).add((Component)this.jLabelDepthUnits2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Dates", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabel7.setText("From: ");
        this.jTextFieldDateFrom.setText("jTextField1");
        this.jTextFieldDateFrom.setToolTipText("Not required for normal use - see help");
        this.jLabel8.setText("To:");
        this.jTextFieldDateTo.setText("jTextField2");
        this.jTextFieldDateTo.setToolTipText("Not required for normal use - see help");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel7).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add(10, 10, 10).add((Component)this.jLabel8))).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jTextFieldDateTo, -1, 167, Short.MAX_VALUE).add((Component)this.jTextFieldDateFrom, -1, 140, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.jTextFieldDateFrom, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel8).add((Component)this.jTextFieldDateTo, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTextAreaComment.setColumns(20);
        this.jTextAreaComment.setFont(this.jTextAreaComment.getFont());
        this.jTextAreaComment.setLineWrap(true);
        this.jTextAreaComment.setRows(5);
        this.jTextAreaComment.setWrapStyleWord(true);
        this.jTextAreaComment.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogAnalystHeader this$0;
            {
                DialogAnalystHeader dialogAnalystHeader = this$0;
                Objects.requireNonNull(dialogAnalystHeader);
                this.this$0 = dialogAnalystHeader;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextAreaCommentKeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextAreaComment);
        this.jLabel9.setText("Comments:");
        this.jComboBoxEnvScheme.setModel(this.envModel);
        this.jLabel11.setText("Palaeoenvironment Scheme:");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalystHeader this$0;
            {
                DialogAnalystHeader dialogAnalystHeader = this$0;
                Objects.requireNonNull(dialogAnalystHeader);
                this.this$0 = dialogAnalystHeader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalystHeader this$0;
            {
                DialogAnalystHeader dialogAnalystHeader = this$0;
                Objects.requireNonNull(dialogAnalystHeader);
                this.this$0 = dialogAnalystHeader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel12.setText("Abundance Scheme:");
        this.jComboBoxAbnScheme.setModel(this.abnModel);
        this.jComboBoxDiscipline.setModel(this.comboModelDiscipline);
        this.jComboBoxDiscipline.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalystHeader this$0;
            {
                DialogAnalystHeader dialogAnalystHeader = this$0;
                Objects.requireNonNull(dialogAnalystHeader);
                this.this$0 = dialogAnalystHeader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxDisciplineActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Discipline:");
        this.jButtonColour.setText("...");
        this.jButtonColour.setToolTipText("Open colour chooser");
        this.jButtonColour.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalystHeader this$0;
            {
                DialogAnalystHeader dialogAnalystHeader = this$0;
                Objects.requireNonNull(dialogAnalystHeader);
                this.this$0 = dialogAnalystHeader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonColourActionPerformed(evt);
            }
        });
        this.jLabel13.setText("Colour:");
        this.jTextFieldColour.setEditable(false);
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalystHeader this$0;
            {
                DialogAnalystHeader dialogAnalystHeader = this$0;
                Objects.requireNonNull(dialogAnalystHeader);
                this.this$0 = dialogAnalystHeader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonAbnSchemes.setText("...");
        this.jButtonAbnSchemes.setToolTipText("Manage abundance schemes");
        this.jButtonAbnSchemes.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalystHeader this$0;
            {
                DialogAnalystHeader dialogAnalystHeader = this$0;
                Objects.requireNonNull(dialogAnalystHeader);
                this.this$0 = dialogAnalystHeader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAbnSchemesActionPerformed(evt);
            }
        });
        this.jButtonenvSchemes.setText("...");
        this.jButtonenvSchemes.setToolTipText("Select a palaeoenvironment scheme");
        this.jButtonenvSchemes.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAnalystHeader this$0;
            {
                DialogAnalystHeader dialogAnalystHeader = this$0;
                Objects.requireNonNull(dialogAnalystHeader);
                this.this$0 = dialogAnalystHeader;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonenvSchemesActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 410, Short.MAX_VALUE).add(1, (Component)this.jSeparator1, -1, 410, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel1).add((Component)this.jLabel3)).add((GroupLayout.Group)layout.createSequentialGroup().add(6, 6, 6).add((Component)this.jLabel2))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jComboBoxAnalyst, 0, -1, Short.MAX_VALUE).add((Component)this.jComboBoxDiscipline, 0, 169, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jButtonAnalysts, -2, 29, -2).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(33, 33, 33).add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.jSpinnerAnalysisNumber, -2, 44, -2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((Component)this.jLabel13).addPreferredGap(0).add((Component)this.jTextFieldColour, -2, 36, -2).addPreferredGap(0).add((Component)this.jButtonColour, -2, 30, -2)))).add((Component)this.jTextFieldWellName))).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(38, 38, 38).add((Component)this.jLabel12)).add((Component)this.jLabel11)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jComboBoxAbnScheme, 0, 229, Short.MAX_VALUE).add((Component)this.jComboBoxEnvScheme, 0, 229, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonAbnSchemes, -2, 35, -2).add((Component)this.jButtonenvSchemes, -2, 35, -2))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add(1, (Component)this.jLabel9)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldWellName, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jComboBoxDiscipline, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxAnalyst, -2, -1, -2).add((Component)this.jButtonAnalysts).add((Component)this.jLabel2))).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonColour).add((Component)this.jTextFieldColour, -2, -1, -2).add((Component)this.jLabel13)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jSpinnerAnalysisNumber, -2, -1, -2)))).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(1).add((Component)this.jLabel9).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 87, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(29, 29, 29).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonenvSchemes).add((Component)this.jLabel11).add((Component)this.jComboBoxEnvScheme, -2, -1, -2))).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxAbnScheme, -2, -1, -2).add((Component)this.jButtonAbnSchemes)).add((GroupLayout.Group)layout.createSequentialGroup().add(6, 6, 6).add((Component)this.jLabel12))).add(12, 12, 12).add((Component)this.jSeparator1, -2, 6, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((Component)this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonAnalystsActionPerformed(ActionEvent evt) {
        try {
            DialogSelectAnalyst dialog = new DialogSelectAnalyst((JDialog)((Object)this), true, this.db, true);
            dialog.setLocation(this.jButtonAnalysts.getLocationOnScreen());
            dialog.setVisible(true);
            if (dialog.selectedUser != null) {
                if (this.modelAnalysts.getIndexOf(dialog.selectedUser.getAbr()) < 0) {
                    this.jComboBoxAnalyst.addItem(dialog.selectedUser.getAbr());
                }
                this.jComboBoxAnalyst.setSelectedItem(dialog.selectedUser.getAbr());
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, (Component)((Object)this));
        }
    }

    private void jSpinnerAnalysisNumberStateChanged(ChangeEvent evt) {
        String number = this.jSpinnerAnalysisNumber.getValue().toString();
        String analyst = (String)this.jComboBoxAnalyst.getSelectedItem();
        if (analyst != null && analyst.length() > 0) {
            try {
                Color colour = Lastval.getColour(this.db, "AHC:" + analyst + "/" + number);
                if (colour != null) {
                    this.jTextFieldColour.setBackground(colour);
                    this.colourSelected = true;
                }
            }
            catch (SQLException sql) {
                sql.printStackTrace();
            }
        }
    }

    private void jComboBoxAnalystActionPerformed(ActionEvent evt) {
        if (this.hdr != null) {
            return;
        }
        try {
            Color colour;
            int maxAnalyno = 0;
            String analyst = (String)this.jComboBoxAnalyst.getSelectedItem();
            Iterator<AnalystHeader> it = this.well.getAnalystHeaderIterator();
            while (it.hasNext()) {
                AnalystHeader h = it.next();
                if (!h.getAnalyst().equals(analyst) || h.getAnalyNumber() <= maxAnalyno) continue;
                maxAnalyno = h.getAnalyNumber();
            }
            this.jSpinnerAnalysisNumber.setValue(maxAnalyno + 1);
            Userdef user = this.db.getUser(analyst);
            if (user != null && (colour = user.getColour()) != null) {
                this.jTextFieldColour.setBackground(colour);
                this.colourSelected = true;
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, (Component)((Object)this));
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            if (!this.saveData()) {
                return;
            }
            this.db.commit();
            this.setOK();
        }
        catch (ParseException p) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Error parsing date: " + p.getMessage(), this.getTitle(), 2);
        }
        catch (RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jTextFieldDepthFromKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldDepthFrom, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldDepthToKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldDepthTo, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jComboBoxDisciplineActionPerformed(ActionEvent evt) {
        if (this.hdr != null) {
            return;
        }
        try {
            int maxAnalyno = 0;
            String analyst = (String)this.jComboBoxAnalyst.getSelectedItem();
            Discipline discID = (Discipline)this.jComboBoxDiscipline.getSelectedItem();
            Iterator<AnalystHeader> it = this.well.getAnalystHeaderIterator();
            while (it.hasNext()) {
                AnalystHeader h = it.next();
                if (!h.getAnalyst().equals(analyst) || h.getDiscipline() != discID || h.getAnalyNumber() <= maxAnalyno) continue;
                maxAnalyno = h.getAnalyNumber();
            }
            this.jSpinnerAnalysisNumber.setValue(maxAnalyno + 1);
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql, (Component)((Object)this));
        }
    }

    private void jButtonColourActionPerformed(ActionEvent evt) {
        Color colour = this.jTextFieldColour.getBackground();
        if ((colour = JColorChooser.showDialog((Component)((Object)this), "Colour", colour)) != null) {
            this.jTextFieldColour.setBackground(colour);
            this.colourSelected = true;
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialoganalystheader.html");
    }

    private void jButtonAbnSchemesActionPerformed(ActionEvent evt) {
        try {
            Object o = this.jComboBoxAbnScheme.getSelectedItem();
            DialogAbnSchemes dialog = new DialogAbnSchemes((JDialog)((Object)this), this.db);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            this.initAbnCombo();
            this.jComboBoxAbnScheme.setSelectedItem(o);
        }
        catch (RuntimeException sql) {
            SbugsExceptionHandler.showDialogStackError(sql, (Component)((Object)this));
        }
    }

    private void jButtonenvSchemesActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog((Component)((Object)this), "To add/edit palaeoenvironment schemes, see the Schemes & Interpretations module.", this.getTitle(), 1);
    }

    private void jTextAreaCommentKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextArea)this.jTextAreaComment, (int)255, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }
}

