/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jsbugs.FrameJsbugs;
import jsbugs.uiutil.TextFieldUtils;
import model3.Lastval;
import model3.SBdb;
import util.SB;
import util.SBPermissionException;
import util.SbugsFileFilter;
import util.exception.StackError;

public class DialogAuditTrail
extends JDialog {
    private static final String[] colTitles = new String[]{"Date", "User", "Type", "Item"};
    private static final int[] colWidths = new int[]{30, 30, 60, 200};
    private final SBdb sbdb;
    private final ArrayList<AuditRecord> records = new ArrayList();
    private final AuditTableModel model = new AuditTableModel(this);
    private final DefaultComboBoxModel dTypeModel = new DefaultComboBoxModel<AuditDataType>(AuditDataType.values());
    private boolean inStartup = true;
    private ButtonGroup buttonGroup1;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonHelp;
    private JButton jButtonSave;
    private JButton jButtonSearch;
    private JComboBox jComboBoxDataTypes;
    private JFormattedTextField jFormattedTextFieldFrom;
    private JFormattedTextField jFormattedTextFieldTo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonOff;
    private JRadioButton jRadioButtonOn;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTable1;
    private JTextArea jTextArea1;
    private JTextField jTextFieldUser;

    public DialogAuditTrail(Frame parent, boolean modal, SBdb sbdb) {
        super(parent, modal);
        this.sbdb = sbdb;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Audit Records");
        this.dTypeModel.insertElementAt("<All>", 0);
        this.jComboBoxDataTypes.setSelectedIndex(0);
        SB.setTableHeaderBold((JTable)this.jTable1);
        TableColumnModel columnModel = this.jTable1.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
        }
        this.jTable1.setRowSorter(new TableRowSorter<AuditTableModel>(this.model));
        new ColumnSortResetHandler(this.jTable1).attach();
        TextFieldUtils.initSBDateFormatter(this.jFormattedTextFieldTo, null);
        TextFieldUtils.initSBDateFormatter(this.jFormattedTextFieldFrom, null);
        boolean audittrail = this.sbdb.getAuditTrail();
        this.jRadioButtonOn.setSelected(audittrail);
        this.jRadioButtonOff.setSelected(!audittrail);
        this.inStartup = false;
        if ((this.sbdb.getUser().getPriv() & 0x40) <= 0) {
            for (JRadioButton button : new JRadioButton[]{this.jRadioButtonOn, this.jRadioButtonOff}) {
                button.setEnabled(false);
                button.setToolTipText("You must be a super user to change this setting.");
            }
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonClose = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonSave = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBoxDataTypes = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jFormattedTextFieldFrom = new JFormattedTextField();
        this.jLabel3 = new JLabel();
        this.jFormattedTextFieldTo = new JFormattedTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldUser = new JTextField();
        this.jButtonSearch = new JButton();
        this.jLabel5 = new JLabel();
        this.jRadioButtonOn = new JRadioButton();
        this.jRadioButtonOff = new JRadioButton();
        this.jButtonDelete = new JButton();
        this.setDefaultCloseOperation(2);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAuditTrail this$0;
            {
                DialogAuditTrail dialogAuditTrail = this$0;
                Objects.requireNonNull(dialogAuditTrail);
                this.this$0 = dialogAuditTrail;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonSave.setText("Save As...");
        this.jButtonSave.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAuditTrail this$0;
            {
                DialogAuditTrail dialogAuditTrail = this$0;
                Objects.requireNonNull(dialogAuditTrail);
                this.this$0 = dialogAuditTrail;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveActionPerformed(evt);
            }
        });
        this.jTable1.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jScrollPane2.setBorder(null);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setBackground(SystemColor.window);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setFont(this.jTextArea1.getFont());
        this.jTextArea1.setForeground(new Color(51, 102, 204));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("An audit record is created when data are deleted. You cannot use it to restore the deleted data. You should periodically clear these records to reduce database size.");
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTextArea1.setFocusable(false);
        this.jTextArea1.setMargin(new Insets(4, 4, 4, 4));
        this.jScrollPane2.setViewportView(this.jTextArea1);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Search", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabel1.setText("Data type:");
        this.jComboBoxDataTypes.setModel(this.dTypeModel);
        this.jLabel2.setText("Between:");
        this.jFormattedTextFieldFrom.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogAuditTrail this$0;
            {
                DialogAuditTrail dialogAuditTrail = this$0;
                Objects.requireNonNull(dialogAuditTrail);
                this.this$0 = dialogAuditTrail;
            }

            @Override
            public void focusLost(FocusEvent evt) {
                this.this$0.jFormattedTextFieldFromFocusLost(evt);
            }
        });
        this.jLabel3.setText("and");
        this.jFormattedTextFieldTo.setPreferredSize(new Dimension(80, 20));
        this.jLabel4.setText("by user:");
        this.jButtonSearch.setText("Search");
        this.jButtonSearch.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAuditTrail this$0;
            {
                DialogAuditTrail dialogAuditTrail = this$0;
                Objects.requireNonNull(dialogAuditTrail);
                this.this$0 = dialogAuditTrail;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSearchActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jFormattedTextFieldFrom, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jFormattedTextFieldTo, -2, -1, -2)).addComponent(this.jTextFieldUser, -2, 80, -2).addComponent(this.jComboBoxDataTypes, 0, -1, Short.MAX_VALUE)).addContainerGap(20, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonSearch).addGap(0, 0, Short.MAX_VALUE)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBoxDataTypes, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jFormattedTextFieldFrom, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jFormattedTextFieldTo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextFieldUser, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonSearch).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel5.setText("Audit recording is:");
        this.buttonGroup1.add(this.jRadioButtonOn);
        this.jRadioButtonOn.setText("On");
        this.jRadioButtonOn.addItemListener(new ItemListener(this){
            final /* synthetic */ DialogAuditTrail this$0;
            {
                DialogAuditTrail dialogAuditTrail = this$0;
                Objects.requireNonNull(dialogAuditTrail);
                this.this$0 = dialogAuditTrail;
            }

            @Override
            public void itemStateChanged(ItemEvent evt) {
                this.this$0.jRadioButtonOnItemStateChanged(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonOff);
        this.jRadioButtonOff.setText("Off");
        this.jButtonDelete.setText("Clear Table");
        this.jButtonDelete.setToolTipText("Clear all entries from audit table");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogAuditTrail this$0;
            {
                DialogAuditTrail dialogAuditTrail = this$0;
                Objects.requireNonNull(dialogAuditTrail);
                this.this$0 = dialogAuditTrail;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(16, 16, 16).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonOn).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonOff).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2)))).addComponent(this.jScrollPane1)).addContainerGap()));
        layout.linkSize(0, this.jButtonClose, this.jButtonHelp);
        layout.linkSize(0, this.jButtonDelete, this.jButtonSave);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.jScrollPane2, -2, -1, -2).addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jRadioButtonOn).addComponent(this.jRadioButtonOff))).addComponent(this.jPanel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 242, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClose).addComponent(this.jButtonHelp).addComponent(this.jButtonSave).addComponent(this.jButtonDelete)).addContainerGap()));
        this.pack();
    }

    private void jButtonSearchActionPerformed(ActionEvent evt) {
        String user;
        this.records.clear();
        Object sql = "";
        Object dType = this.jComboBoxDataTypes.getSelectedItem();
        if (dType instanceof AuditDataType) {
            sql = (String)sql + " WHERE data_type=" + SB.DBString((String)((AuditDataType)((Object)dType)).name());
        }
        if (!(user = this.jTextFieldUser.getText().trim()).isEmpty()) {
            sql = (String)sql + (((String)sql).isEmpty() ? " WHERE " : " AND ") + "user_id=" + SB.DBString((String)user);
        }
        java.util.Date dateFrom = (java.util.Date)this.jFormattedTextFieldFrom.getValue();
        java.util.Date dateTo = (java.util.Date)this.jFormattedTextFieldTo.getValue();
        if (dateFrom != null) {
            sql = (String)sql + (((String)sql).isEmpty() ? " WHERE " : " AND ");
            sql = dateTo != null ? (String)sql + "track_date BETWEEN " + this.sbdb.DBDate(dateFrom) + " AND " + this.sbdb.DBDate(dateTo) : (String)sql + "track_date > " + this.sbdb.DBDate(dateFrom);
        }
        sql = "SELECT track_date,user_id,data_type,descrip FROM " + this.sbdb.DBTableName("AUDITTRAIL") + (String)sql;
        try {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery((String)sql));
                while (rs.next()) {
                    Date date = rs.getDate("track_date");
                    String user_id = rs.getString("user_id");
                    String d_type = rs.getString("data_type");
                    String descrip = rs.getString("descrip");
                    this.records.add(new AuditRecord(d_type, descrip, user_id, date));
                }
            }
            this.model.fireTableDataChanged();
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("SQL Error", e, this.sbdb);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jFormattedTextFieldFromFocusLost(FocusEvent evt) {
        if (this.jFormattedTextFieldFrom.getValue() != null && this.jFormattedTextFieldTo.getValue() == null) {
            this.jFormattedTextFieldTo.setValue(new java.util.Date());
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if ((this.sbdb.getUser().getPriv() & 0x40) <= 0) {
            JOptionPane.showMessageDialog(this, "You must be a super user to do this.", this.getTitle(), 2);
            return;
        }
        int opt = JOptionPane.showConfirmDialog(this, "This will clear all entries in the table.\nAre you sure you want to continue?", this.getTitle(), 0);
        if (opt != 0) {
            return;
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "DELETE FROM " + this.sbdb.DBTableName("AUDITTRAIL");
            stmt.executeUpdate(sql);
            this.records.clear();
            this.model.fireTableDataChanged();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void jRadioButtonOnItemStateChanged(ItemEvent evt) {
        this.updatePref();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSaveActionPerformed(ActionEvent evt) {
        block17: {
            if (this.records.isEmpty()) {
                JOptionPane.showMessageDialog(this, "Press search to see audit records.", this.getTitle(), 2);
                return;
            }
            File setDir = null;
            try {
                setDir = new File(Lastval.getString(this.sbdb, "JLISTFILE"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            JFileChooser jFileChooser1 = new JFileChooser();
            jFileChooser1.setCurrentDirectory(setDir);
            SbugsFileFilter filter = new SbugsFileFilter();
            filter.addExtension("csv");
            filter.setDescription("csv files");
            jFileChooser1.addChoosableFileFilter((FileFilter)filter);
            SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
            java.util.Date date = new java.util.Date();
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (0 != jFileChooser1.showSaveDialog(this)) break block17;
                try {
                    Object fileName = jFileChooser1.getSelectedFile().getPath();
                    if (!((String)fileName).toLowerCase().endsWith(".csv")) {
                        fileName = (String)fileName + ".csv";
                    }
                    try (FileWriter out = new FileWriter((String)fileName);){
                        String eol = "\r\n";
                        out.write("StrataBugs audit record: " + df.format(date) + eol);
                        for (AuditRecord record : this.records) {
                            String text = record.getTextString(',');
                            out.write(text + eol);
                        }
                    }
                    if (JOptionPane.showConfirmDialog(this, "File '" + (String)fileName + "' written", "File Saved", 2) == 0) {
                        Lastval.putString(this.sbdb, "JLISTFILE", (String)fileName);
                        this.sbdb.commit();
                    }
                }
                catch (SQLException sql) {
                    this.sbdb.doRollback();
                    FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, "File error: " + ex.getMessage());
                }
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void updatePref() {
        if (this.inStartup) {
            return;
        }
        try {
            this.sbdb.setAuditTrail(this.jRadioButtonOn.isSelected());
            this.sbdb.commit();
            return;
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog(this, pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            this.sbdb.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        this.dispose();
    }

    private class AuditTableModel
    extends AbstractTableModel {
        final /* synthetic */ DialogAuditTrail this$0;

        private AuditTableModel(DialogAuditTrail dialogAuditTrail) {
            DialogAuditTrail dialogAuditTrail2 = dialogAuditTrail;
            Objects.requireNonNull(dialogAuditTrail2);
            this.this$0 = dialogAuditTrail2;
        }

        @Override
        public int getRowCount() {
            return this.this$0.records.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int row, int col) {
            AuditRecord record = this.this$0.records.get(row);
            switch (col) {
                case 0: {
                    return record.date;
                }
                case 1: {
                    return record.user;
                }
                case 2: {
                    return record.dType;
                }
                case 3: {
                    return record.descr;
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return java.util.Date.class;
                }
            }
            return String.class;
        }
    }

    private static enum AuditDataType {
        AUDITTRAIL("Audit trail"),
        TAXON("Taxon"),
        GENUS("Genus"),
        CATEGORY("Category"),
        TXGROUP("Taxon Group"),
        TXGROUPSET("Taxon Group Set"),
        IGDSCH("Straigraphic Scheme"),
        ENVSCH("Environment Scheme"),
        CMPSTD("Composite Standard"),
        SBEVENT("Event"),
        AGECURVE("Age Curve"),
        ABNSCHEME("Abundance Scheme"),
        LOGDEF("Wireline Log Header"),
        OVERLAY("Overlay"),
        USERDEF("User"),
        PROJECT("Project"),
        WELL("Well"),
        SAMPLE("Sample"),
        LOG_CURVE("Wireline Log"),
        CORES("Cored Interval"),
        CASING("Casing Point"),
        MARKER("Seismic Marker"),
        IGDINTERVAL("Interval"),
        WELLEVENT("Well Event"),
        SQPICK("Sequence Pick"),
        BIOCOM("Biostratigraphic Comment"),
        ENV("Environment Interval"),
        INTCOM("Interval Comment"),
        FAULT("Fault"),
        ANALYSES("Analyses");

        final String descr;

        private AuditDataType(String descr) {
            this.descr = descr;
        }

        public String toString() {
            return this.descr;
        }
    }

    private static class AuditRecord {
        final String dType;
        final String descr;
        final String user;
        final java.util.Date date;

        AuditRecord(String dType, String descr, String user, java.util.Date date) {
            this.dType = dType;
            this.descr = descr;
            this.user = user;
            this.date = date;
        }

        String getTextString(char delim) {
            return String.valueOf(this.date) + delim + this.user + delim + this.dType + delim + this.descr;
        }
    }
}

