/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.Discipline;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import jsbugs.DialogSelectSample;
import jsbugs.FrameJsbugs;
import jsbugs.SbugsFocusTraversalPolicy;
import jsbugs.uiutil.TextFieldUtils;
import jsbugs.userconnect.DialogSelectAnalyst;
import model3.AnalystHeader;
import model3.Biocom;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import model3.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.exception.StackError;

public class DialogBiocom
extends SBDialog {
    private final Well well;
    private final WellInterp wellInterp;
    private final char units;
    private final SBdb db;
    private Biocom biocom;
    private Biocom previous = null;
    private Biocom next = null;
    private Sample topSample;
    private Sample baseSample;
    private final DefaultComboBoxModel comboModelDiscipline = new DefaultComboBoxModel<Discipline>(Discipline.values());
    private final DefaultComboBoxModel comboModelAnalyst = new DefaultComboBoxModel();
    private static String lastAnalystAbr = null;
    private static Discipline lastDisc = null;
    private static final int MAXLEN = 1200;
    private static final int DSLEN = 50;
    final UndoableEditSupport undoSupport = new UndoableEditSupport();
    WellInterp.BiocomEdit edit = null;
    private JButton jButtonAnalyst;
    private JButton jButtonBaseSample;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonNext;
    private JButton jButtonOK;
    private JButton jButtonPrevious;
    private JButton jButtonTopSample;
    private JComboBox jComboBoxAnalyst;
    private JComboBox jComboBoxDisc;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPaneComment;
    private JTextArea jTextAreaComment;
    private JTextField jTextFieldBaseSample;
    private JTextField jTextFieldDataSource;
    private JTextField jTextFieldTopSample;

    public DialogBiocom(Frame parent, boolean modal, SBdb db, Well well, WellInterp wellInterp, char units, Biocom biocom, Sample topSample, Sample baseSample) throws SQLException, SBException {
        super(parent, modal);
        this.initComponents();
        this.db = db;
        this.biocom = biocom;
        this.topSample = topSample;
        if (baseSample != topSample) {
            this.baseSample = baseSample;
        }
        this.well = well;
        this.wellInterp = wellInterp;
        this.units = units;
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.fillAnalystCombo();
        if (this.biocom == null) {
            this.setTitle("Biostratigraphic Comment : Add - " + this.wellInterp.getHeader().toString());
            if (lastAnalystAbr != null) {
                this.comboModelAnalyst.setSelectedItem(lastAnalystAbr);
            }
            if (lastDisc != null) {
                this.jComboBoxDisc.setSelectedItem(lastDisc);
            } else {
                this.jComboBoxDisc.setSelectedItem(this.db.getUser().getDiscipline());
            }
            this.jButtonPrevious.setVisible(false);
            this.jButtonNext.setVisible(false);
        } else {
            this.setTitle("Biostratigraphic Comment : Edit - " + this.wellInterp.getHeader().toString());
            this.topSample = this.biocom.getTopSample();
            this.baseSample = this.biocom.getBaseSample();
            if (this.comboModelAnalyst.getIndexOf(this.biocom.getAnalystString()) < 0) {
                this.comboModelAnalyst.addElement(this.biocom.getAnalystString());
            }
            this.jComboBoxAnalyst.setSelectedItem(this.biocom.getAnalystString());
            this.jComboBoxDisc.setSelectedItem(Discipline.getDisc((char)this.biocom.getDiscID()));
            this.jTextFieldDataSource.setText(this.biocom.getSource());
            this.jTextAreaComment.setText(this.biocom.getText());
            this.jTextAreaComment.setCaretPosition(this.biocom.getText().length());
            List<Biocom> list = this.wellInterp.getComments(this.biocom.getDiscID());
            Iterator<Biocom> it = list.iterator();
            Biocom current = null;
            this.previous = null;
            this.next = null;
            while (it.hasNext()) {
                this.previous = current;
                current = it.next();
                if (current != this.biocom || !it.hasNext()) continue;
                this.next = it.next();
                break;
            }
            this.jButtonPrevious.setEnabled(this.previous != null);
            this.jButtonNext.setEnabled(this.next != null);
        }
        if (this.topSample != null) {
            this.jTextFieldTopSample.setText(this.topSample.toString(this.units));
        }
        if (this.baseSample != null) {
            this.jTextFieldBaseSample.setText(this.baseSample.toString(this.units));
        }
        this.jTextAreaComment.requestFocusInWindow();
        this.initFocus();
        if (!this.well.canWrite(this.db, null)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(this.well.getDeniedReason(this.db, "well", false));
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
    }

    private void initFocus() {
        LinkedList<Component> focusOrder = new LinkedList<Component>();
        focusOrder.add(this.jTextAreaComment);
        focusOrder.add(this.jButtonOK);
        focusOrder.add(this.jButtonHelp);
        focusOrder.add(this.jButtonCancel);
        focusOrder.add(this.jComboBoxDisc);
        focusOrder.add(this.jComboBoxAnalyst);
        focusOrder.add(this.jButtonAnalyst);
        focusOrder.add(this.jButtonTopSample);
        focusOrder.add(this.jButtonBaseSample);
        focusOrder.add(this.jTextFieldDataSource);
        SbugsFocusTraversalPolicy focusPolicy = new SbugsFocusTraversalPolicy(focusOrder);
        this.setFocusTraversalPolicy(focusPolicy);
    }

    private void fillAnalystCombo() throws SQLException, SBException {
        Iterator<AnalystHeader> itr = this.well.getAnalystHeaderIterator();
        this.comboModelAnalyst.removeAllElements();
        this.comboModelAnalyst.addElement("");
        while (itr.hasNext()) {
            AnalystHeader hdr = itr.next();
            String abr = hdr.getAnalyst();
            if (this.comboModelAnalyst.getIndexOf(abr) >= 0) continue;
            this.comboModelAnalyst.addElement(abr);
        }
        if (lastAnalystAbr != null && this.comboModelAnalyst.getIndexOf(lastAnalystAbr) < 0) {
            this.comboModelAnalyst.addElement(lastAnalystAbr);
        }
        this.jComboBoxAnalyst.repaint();
        this.jComboBoxAnalyst.setSelectedIndex(0);
    }

    private void initComponents() {
        this.jScrollPaneComment = new JScrollPane();
        this.jTextAreaComment = TextFieldUtils.buildByteLimitedUTF8TextArea(1200);
        this.jComboBoxAnalyst = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBoxDisc = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldTopSample = new JTextField();
        this.jTextFieldBaseSample = new JTextField();
        this.jButtonBaseSample = new JButton();
        this.jButtonTopSample = new JButton();
        this.jButtonAnalyst = new JButton();
        this.jLabel5 = new JLabel();
        this.jTextFieldDataSource = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonPrevious = new JButton();
        this.jButtonNext = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(425, 350));
        this.jTextAreaComment.setColumns(20);
        this.jTextAreaComment.setFont(this.jTextAreaComment.getFont());
        this.jTextAreaComment.setLineWrap(true);
        this.jTextAreaComment.setRows(5);
        this.jTextAreaComment.setWrapStyleWord(true);
        this.jScrollPaneComment.setViewportView(this.jTextAreaComment);
        this.jComboBoxAnalyst.setModel(this.comboModelAnalyst);
        this.jComboBoxAnalyst.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jLabel2.setText("Analyst:");
        this.jComboBoxDisc.setModel(this.comboModelDiscipline);
        this.jComboBoxDisc.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jLabel3.setText("To sample:");
        this.jLabel4.setText("From sample:");
        this.jTextFieldTopSample.setEditable(false);
        this.jTextFieldTopSample.setBackground(new Color(255, 255, 204));
        this.jTextFieldBaseSample.setEditable(false);
        this.jTextFieldBaseSample.setBackground(new Color(255, 255, 204));
        this.jButtonBaseSample.setText("...");
        this.jButtonBaseSample.setToolTipText("Select base sample - to clear depth range, select the same sample as top");
        this.jButtonBaseSample.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonBaseSample.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBiocom this$0;
            {
                DialogBiocom dialogBiocom = this$0;
                Objects.requireNonNull(dialogBiocom);
                this.this$0 = dialogBiocom;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonBaseSampleActionPerformed(evt);
            }
        });
        this.jButtonTopSample.setText("...");
        this.jButtonTopSample.setToolTipText("Select top sample");
        this.jButtonTopSample.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonTopSample.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBiocom this$0;
            {
                DialogBiocom dialogBiocom = this$0;
                Objects.requireNonNull(dialogBiocom);
                this.this$0 = dialogBiocom;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonTopSampleActionPerformed(evt);
            }
        });
        this.jButtonAnalyst.setText("...");
        this.jButtonAnalyst.setToolTipText("Select analyst");
        this.jButtonAnalyst.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonAnalyst.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBiocom this$0;
            {
                DialogBiocom dialogBiocom = this$0;
                Objects.requireNonNull(dialogBiocom);
                this.this$0 = dialogBiocom;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAnalystActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Data source:");
        this.jTextFieldDataSource.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogBiocom this$0;
            {
                DialogBiocom dialogBiocom = this$0;
                Objects.requireNonNull(dialogBiocom);
                this.this$0 = dialogBiocom;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldDataSourceKeyTyped(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBiocom this$0;
            {
                DialogBiocom dialogBiocom = this$0;
                Objects.requireNonNull(dialogBiocom);
                this.this$0 = dialogBiocom;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.setToolTipText("Press using CTRL + ENTER keys");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBiocom this$0;
            {
                DialogBiocom dialogBiocom = this$0;
                Objects.requireNonNull(dialogBiocom);
                this.this$0 = dialogBiocom;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBiocom this$0;
            {
                DialogBiocom dialogBiocom = this$0;
                Objects.requireNonNull(dialogBiocom);
                this.this$0 = dialogBiocom;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonPrevious.setText("Previous");
        this.jButtonPrevious.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBiocom this$0;
            {
                DialogBiocom dialogBiocom = this$0;
                Objects.requireNonNull(dialogBiocom);
                this.this$0 = dialogBiocom;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonPreviousActionPerformed(evt);
            }
        });
        this.jButtonNext.setText("Next");
        this.jButtonNext.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogBiocom this$0;
            {
                DialogBiocom dialogBiocom = this$0;
                Objects.requireNonNull(dialogBiocom);
                this.this$0 = dialogBiocom;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonNextActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.jTextFieldDataSource, -2, 164, -2).add(0, 0, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPaneComment).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonPrevious).addPreferredGap(0).add((Component)this.jButtonNext).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel).add(11, 11, 11)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jComboBoxAnalyst, 0, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonAnalyst, -2, 30, -2)).add((Component)this.jComboBoxDisc, -2, 180, -2)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel4).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jTextFieldBaseSample).add((Component)this.jTextFieldTopSample, -2, 133, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonBaseSample, -2, 30, -2).add((Component)this.jButtonTopSample, -2, 30, -2)).addContainerGap(15, Short.MAX_VALUE)))));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldTopSample, -2, -1, -2).add((Component)this.jLabel4).add((Component)this.jButtonTopSample)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jTextFieldBaseSample, -2, -1, -2).add((Component)this.jButtonBaseSample))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jComboBoxDisc, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jComboBoxAnalyst, -2, -1, -2).add((Component)this.jButtonAnalyst)))).add(19, 19, 19).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.jTextFieldDataSource, -2, -1, -2)).addPreferredGap(1).add((Component)this.jScrollPaneComment, -1, 165, Short.MAX_VALUE).add(11, 11, 11).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((Component)this.jButtonHelp).add((Component)this.jButtonPrevious).add((Component)this.jButtonNext)).addContainerGap()));
        this.pack();
    }

    private void jButtonAnalystActionPerformed(ActionEvent evt) {
        DialogSelectAnalyst dialog;
        try {
            dialog = new DialogSelectAnalyst((JDialog)((Object)this), true, this.db, true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
            return;
        }
        dialog.setVisible(true);
        if (dialog.selectedUser != null) {
            if (this.comboModelAnalyst.getIndexOf(dialog.selectedUser.getAbr()) < 0) {
                int pos;
                for (pos = 0; pos < this.comboModelAnalyst.getSize(); ++pos) {
                    String abr = (String)this.comboModelAnalyst.getElementAt(pos);
                    if (dialog.selectedUser.getAbr().compareTo(abr) < 0) break;
                }
                this.comboModelAnalyst.insertElementAt(dialog.selectedUser.getAbr(), pos);
                this.jComboBoxAnalyst.repaint();
            }
            this.jComboBoxAnalyst.setSelectedItem(dialog.selectedUser.getAbr());
        }
    }

    private void jButtonBaseSampleActionPerformed(ActionEvent evt) {
        try {
            DialogSelectSample dialog = new DialogSelectSample((JDialog)((Object)this), true, this.db, this.well, this.baseSample != null ? this.baseSample : this.topSample, this.units, false);
            dialog.setLocation(this.jButtonBaseSample.getLocationOnScreen());
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.baseSample = dialog.selection;
                if (this.baseSample != null && this.baseSample == this.topSample) {
                    this.baseSample = null;
                    this.jTextFieldBaseSample.setText(null);
                } else {
                    this.jTextFieldBaseSample.setText(this.baseSample.toString(this.units));
                }
            }
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonTopSampleActionPerformed(ActionEvent evt) {
        try {
            DialogSelectSample dialog = new DialogSelectSample((JDialog)((Object)this), true, this.db, this.well, this.topSample != null ? this.topSample : this.baseSample, this.units, false);
            dialog.setLocation(this.jButtonTopSample.getLocationOnScreen());
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.topSample = dialog.selection;
                this.jTextFieldTopSample.setText(this.topSample.toString(this.units));
            }
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.saveComment()) {
            this.setOK();
        }
    }

    private boolean saveComment() {
        int analyst;
        String analy;
        if (this.topSample == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select a top sample", this.getTitle(), 2);
            return false;
        }
        if (this.baseSample == this.topSample) {
            this.baseSample = null;
        }
        if ((analy = (String)this.jComboBoxAnalyst.getSelectedItem()) == null || analy.length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select an analyst", this.getTitle(), 2);
            return false;
        }
        try {
            analyst = this.db.getUserID(analy);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error getting analyst", sql, this.db);
            return false;
        }
        String dataSource = this.jTextFieldDataSource.getText();
        String comment = this.jTextAreaComment.getText();
        if (comment.isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Enter a comment", this.getTitle(), 2);
            return false;
        }
        if (comment.length() > 1200) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Comment is too long to store in database. The total length must be 1200 characters or less.", this.getTitle(), 1);
            return false;
        }
        Discipline discID = (Discipline)this.jComboBoxDisc.getSelectedItem();
        try {
            if (this.biocom == null) {
                if (!comment.trim().isEmpty()) {
                    this.edit = this.wellInterp.addBiocom(new Biocom.Builder(this.db, discID, analyst, this.topSample, comment).source(dataSource).baseSample(this.baseSample), this.well.getWellID());
                }
            } else if (comment.trim().isEmpty() && JOptionPane.showConfirmDialog((Component)((Object)this), "Delete this comment?", this.getTitle(), 0) == 0) {
                this.edit = this.wellInterp.deleteBiocom(this.biocom, this.well.getWellID());
            } else {
                if (discID == this.biocom.getDiscipline() && comment.equals(this.biocom.getText()) && this.topSample == this.biocom.getTopSample() && this.baseSample == this.biocom.getBaseSample() && analyst == this.biocom.getAnalyst() && dataSource.equals(this.biocom.getSource())) {
                    return true;
                }
                this.edit = this.wellInterp.updateBiocom(this.biocom, new Biocom.Builder(this.db, discID, analyst, this.topSample, comment).source(dataSource).baseSample(this.baseSample), this.well.getWellID());
            }
        }
        catch (InvalidFieldException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage(), this.getTitle(), 2);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        if (this.edit != null) {
            this.undoSupport.postEdit((UndoableEdit)((Object)this.edit));
            lastAnalystAbr = this.jComboBoxAnalyst.getSelectedItem().toString();
            lastDisc = (Discipline)this.jComboBoxDisc.getSelectedItem();
            return true;
        }
        return false;
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogbiocom.html");
    }

    private void jTextFieldDataSourceKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldDataSource, (int)50, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonPreviousActionPerformed(ActionEvent evt) {
        if (this.saveComment()) {
            this.biocom = this.previous;
            try {
                this.init();
            }
            catch (SBException sbe) {
                StackError.showStackError((String)"Error", (Throwable)sbe);
            }
            catch (RuntimeException re) {
                StackError.showStackError((String)"", (Throwable)re);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
        }
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        if (this.saveComment()) {
            this.biocom = this.next;
            try {
                this.init();
            }
            catch (SBException sbe) {
                StackError.showStackError((String)"Error", (Throwable)sbe);
            }
            catch (RuntimeException re) {
                StackError.showStackError((String)"", (Throwable)re);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
        }
    }

    void addText(String text) {
        if (text.trim().length() == 0) {
            return;
        }
        Object existingText = this.jTextAreaComment.getText();
        if (((String)existingText).length() > 0) {
            existingText = (String)existingText + ", ";
        }
        if (((String)(existingText = (String)existingText + text)).length() > 1200) {
            existingText = ((String)existingText).substring(0, 1199);
        }
        this.jTextAreaComment.setText((String)existingText);
        this.jTextAreaComment.repaint();
    }

    void setAnalyst(String analyst) {
        this.jComboBoxAnalyst.setSelectedItem(analyst);
    }

    void setDiscipline(Discipline disc) {
        this.jComboBoxDisc.setSelectedItem(disc);
    }
}

