/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.util.io.FileChooserUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import jsbugs.FrameJsbugs;
import jsbugs.io.JPanelCSVOptions;
import jsbugs.io.analysis.GridBuilderAnalysis;
import jsbugs.io.analysis.OccurrenceCollator;
import jsbugs.io.analysis.OccurrenceCollection;
import jsbugs.list.CategoryListCellRenderer;
import jsbugs.uiutil.FileOverwriteCheck;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.UserPrefsHelper;
import model3.Lastval;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.SynonymScheme;
import model3.Taxon;
import model3.TxGroup;
import model3.TxGroupSet;
import model3.Well;
import org.jdesktop.layout.GroupLayout;
import util.FilePathUtils;
import util.SBException;
import util.gridwriter.CSVExportOptions;
import util.gridwriter.GridSheet;
import util.gridwriter.GridWriter;
import util.gridwriter.IGridBuilder;

public class DialogCSVExport
extends JDialog {
    private final SBdb db;
    private final Well well;
    private final char units;
    private final Discipline discID;
    private final int analystID;
    private final int analyNo;
    private final List<Smpdtl> selectedAnalyses;
    private static final String SORTFDO_STRING = "First Downhole Occurrence";
    private static final String SORTLDO_STRING = "Last Downhole Occurrence";
    private static final String SORTALPHA_STRING = "Alphabetic";
    private UserPrefsHelper prefs;
    private ListCellRenderer defaultComboRenderer;
    private final CategoryListCellRenderer categoryRenderer = new CategoryListCellRenderer();
    private ButtonGroup buttonGroupCols;
    private ButtonGroup buttonGroupData;
    private ButtonGroup buttonGroupFormat;
    private ButtonGroup buttonGroupQuant;
    private ButtonGroup buttonGroupRowPref;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonSave;
    private JButton jButtonSelectFile;
    private JCheckBox jCheckBoxAlphaCodes;
    private JCheckBox jCheckBoxAnalyStatus;
    private JCheckBox jCheckBoxAnalyst;
    private JCheckBox jCheckBoxCombineAnalyses;
    private JCheckBox jCheckBoxDepthRange;
    private JCheckBox jCheckBoxIncludeGroupInfo;
    private JCheckBox jCheckBoxPrepared;
    private JCheckBox jCheckBoxQual;
    private JCheckBox jCheckBoxQualifiersAsComments;
    private JCheckBox jCheckBoxSampleType;
    private JCheckBox jCheckBoxSeparateQuestionableTaxa;
    private JCheckBox jCheckBoxShowTotals;
    private JCheckBox jCheckBoxSubCategories;
    private JCheckBox jCheckBoxSynonymy;
    private JCheckBox jCheckBoxTextLabel;
    private JCheckBox jCheckBoxUseAuthor;
    private JCheckBox jCheckBoxUseCoreCorrections;
    private JCheckBox jCheckBoxUseCuttingCorrections;
    private JComboBox jComboBoxPercentWhich;
    private JComboBox jComboBoxSort;
    private JComboBox jComboBoxSynonymScheme;
    private JComboBox jComboBoxWhichData;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanelCSVOptions jPanelCSVOptions1;
    private JRadioButton jRadioButtonByGroup;
    private JRadioButton jRadioButtonCategory;
    private JRadioButton jRadioButtonDisc;
    private JRadioButton jRadioButtonGroup;
    private JRadioButton jRadioButtonIndividual;
    private JRadioButton jRadioButtonOccurrenceRows;
    private JRadioButton jRadioButtonPercent;
    private JRadioButton jRadioButtonPercentCategory;
    private JRadioButton jRadioButtonPercentDisc;
    private JRadioButton jRadioButtonPercentGroup;
    private JRadioButton jRadioButtonPercentRw;
    private JRadioButton jRadioButtonPercentSet;
    private JRadioButton jRadioButtonQuant;
    private JRadioButton jRadioButtonRichness;
    private JRadioButton jRadioButtonRowTaxa;
    private JRadioButton jRadioButtonSampleRows;
    private JRadioButton jRadioButtonSemiQuant;
    private JRadioButton jRadioButtonSet;
    private JRadioButton jRadioButtonTotal;
    private JTextField jTextFieldFileName;

    public DialogCSVExport(Frame parent, boolean modal, SBdb db, List<Smpdtl> selectedAnalyses, Well well, char units, Discipline discID, int analystID, int analyNo, String filename) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.well = well;
        this.units = units;
        this.discID = discID;
        this.analyNo = analyNo;
        this.analystID = analystID;
        this.selectedAnalyses = selectedAnalyses;
        this.prefs = new UserPrefsHelper(db);
        this.initComponents();
        this.init(filename);
    }

    private void init(String filename) throws SQLException {
        this.setTitle("Analyses File Export Options");
        this.jTextFieldFileName.setText(filename);
        this.getRootPane().setDefaultButton(this.jButtonSave);
        this.jComboBoxPercentWhich.removeAllItems();
        this.defaultComboRenderer = this.jComboBoxWhichData.getRenderer();
        this.jComboBoxWhichData.removeAllItems();
        this.jComboBoxSort.removeAllItems();
        this.jComboBoxSort.addItem(SORTALPHA_STRING);
        this.jComboBoxSort.addItem(SORTFDO_STRING);
        this.jComboBoxSort.addItem(SORTLDO_STRING);
        this.jComboBoxSynonymScheme.removeAllItems();
        try {
            for (SynonymScheme s : this.db.getSynSchemes()) {
                this.jComboBoxSynonymScheme.addItem(s);
            }
        }
        catch (Exception e) {
            this.jComboBoxSynonymScheme.setEnabled(false);
            e.printStackTrace();
        }
        this.loadDefaults();
        this.jPanelCSVOptions1.setDefaults();
        this.enableSampleCorrectionCheckboxes();
        this.setCorrectionCheckboxDefaults();
        this.outputFileChanged();
    }

    private void outputFileChanged() {
        boolean isCSVFile = FilePathUtils.getFileExtension((String)this.jTextFieldFileName.getText()).equalsIgnoreCase("csv");
        this.jPanelCSVOptions1.setEnabled(isCSVFile);
        this.jCheckBoxQualifiersAsComments.setEnabled(!isCSVFile);
        this.updateAddQualifiersAsCommentsCheckboxEnabled();
    }

    private void radioButtonDataToExportChanged() {
        this.jComboBoxWhichData.setEnabled(!this.jRadioButtonDisc.isSelected());
        this.jRadioButtonByGroup.setEnabled(this.jRadioButtonSet.isSelected());
        this.jComboBoxWhichData.removeAllItems();
        this.jComboBoxWhichData.setRenderer(this.jComboBoxWhichData.isEnabled() && this.jRadioButtonCategory.isSelected() ? this.categoryRenderer : this.defaultComboRenderer);
        if (this.jComboBoxWhichData.isEnabled()) {
            try {
                if (this.jRadioButtonGroup.isSelected()) {
                    LinkedList<TxGroup> groups = new LinkedList<TxGroup>(this.db.getTxGroups());
                    Collections.sort(groups);
                    for (TxGroup group : groups) {
                        this.jComboBoxWhichData.addItem(group);
                    }
                } else if (this.jRadioButtonSet.isSelected()) {
                    for (TxGroupSet set : this.db.getTxGroupSetsSorted()) {
                        this.jComboBoxWhichData.addItem(set);
                    }
                } else {
                    this.db.getCategoryService().getCategoryList().stream().forEach(cat -> this.jComboBoxWhichData.addItem(cat));
                }
            }
            catch (SQLException e) {
                SbugsExceptionHandler.showStackError(e);
            }
        }
        this.updateDataColumnsSelection();
    }

    private void radioButtonOutputDataFormatChanged() {
        boolean percentSelected = this.jRadioButtonPercent.isSelected();
        this.setPercentOptions(percentSelected);
        this.jCheckBoxShowTotals.setEnabled(percentSelected);
        if (this.jRadioButtonRichness.isSelected() || this.jRadioButtonPercentRw.isSelected()) {
            this.jRadioButtonIndividual.setEnabled(false);
        }
        this.jRadioButtonTotal.setEnabled(!this.jRadioButtonSemiQuant.isSelected());
        this.updateDataColumnsSelection();
    }

    private void updateDataColumnsSelection() {
        if (this.jRadioButtonByGroup.isSelected() && !this.jRadioButtonByGroup.isEnabled()) {
            this.jRadioButtonByGroup.setSelected(false);
            this.jRadioButtonIndividual.setSelected(true);
        }
        if (this.jRadioButtonIndividual.isSelected() && !this.jRadioButtonIndividual.isEnabled()) {
            this.jRadioButtonIndividual.setSelected(false);
            this.jRadioButtonTotal.setSelected(true);
        }
        if (this.jRadioButtonTotal.isSelected() && !this.jRadioButtonTotal.isEnabled() && this.jRadioButtonIndividual.isEnabled()) {
            this.jRadioButtonTotal.setSelected(false);
            this.jRadioButtonIndividual.setSelected(true);
        }
        this.radioButtonDataColumnsChanged();
    }

    private void radioButtonDataColumnsChanged() {
        boolean individualSelected = this.jRadioButtonIndividual.isSelected();
        this.jCheckBoxQual.setEnabled(individualSelected);
        this.jCheckBoxQualifiersAsComments.setEnabled(individualSelected);
        this.jCheckBoxUseAuthor.setEnabled(individualSelected);
        this.jCheckBoxSynonymy.setEnabled(individualSelected);
        this.jCheckBoxAlphaCodes.setEnabled(individualSelected);
        this.jCheckBoxSeparateQuestionableTaxa.setEnabled(individualSelected);
        if (individualSelected) {
            if (this.jRadioButtonSet.isSelected()) {
                this.jCheckBoxIncludeGroupInfo.setEnabled(true);
            } else {
                this.jCheckBoxIncludeGroupInfo.setEnabled(false);
            }
        } else {
            this.jCheckBoxIncludeGroupInfo.setEnabled(false);
        }
        this.uncheckDisabledIncludeOptions();
    }

    private void uncheckDisabledIncludeOptions() {
        for (Component c : this.jPanel5.getComponents()) {
            JCheckBox cb;
            if (!(c instanceof JCheckBox) || (cb = (JCheckBox)c).isEnabled() || !cb.isSelected()) continue;
            cb.setSelected(false);
        }
    }

    private void updateAddQualifiersAsCommentsCheckboxEnabled() {
        boolean enabled = this.jCheckBoxQual.isSelected();
        enabled = enabled && !FilePathUtils.getFileExtension((String)this.jTextFieldFileName.getText()).equalsIgnoreCase("csv");
        this.setCheckboxEnabled(this.jCheckBoxQualifiersAsComments, enabled);
    }

    private void initComponents() {
        this.buttonGroupData = new ButtonGroup();
        this.buttonGroupCols = new ButtonGroup();
        this.buttonGroupRowPref = new ButtonGroup();
        this.buttonGroupFormat = new ButtonGroup();
        this.buttonGroupQuant = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jTextFieldFileName = new JTextField();
        this.jButtonSelectFile = new JButton();
        this.jPanel1 = new JPanel();
        this.jRadioButtonDisc = new JRadioButton();
        this.jRadioButtonCategory = new JRadioButton();
        this.jComboBoxWhichData = new JComboBox();
        this.jRadioButtonGroup = new JRadioButton();
        this.jRadioButtonSet = new JRadioButton();
        this.jCheckBoxSubCategories = new JCheckBox();
        this.jCheckBoxPrepared = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jRadioButtonIndividual = new JRadioButton();
        this.jRadioButtonByGroup = new JRadioButton();
        this.jRadioButtonTotal = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.jRadioButtonSampleRows = new JRadioButton();
        this.jRadioButtonRowTaxa = new JRadioButton();
        this.jRadioButtonOccurrenceRows = new JRadioButton();
        this.jCheckBoxCombineAnalyses = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jRadioButtonQuant = new JRadioButton();
        this.jRadioButtonPercent = new JRadioButton();
        this.jRadioButtonSemiQuant = new JRadioButton();
        this.jRadioButtonRichness = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.jComboBoxSort = new JComboBox();
        this.jPanel6 = new JPanel();
        this.jRadioButtonPercentDisc = new JRadioButton();
        this.jRadioButtonPercentCategory = new JRadioButton();
        this.jRadioButtonPercentGroup = new JRadioButton();
        this.jRadioButtonPercentSet = new JRadioButton();
        this.jComboBoxPercentWhich = new JComboBox();
        this.jRadioButtonPercentRw = new JRadioButton();
        this.jButtonCancel = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonHelp = new JButton();
        this.jPanel5 = new JPanel();
        this.jCheckBoxUseAuthor = new JCheckBox();
        this.jCheckBoxShowTotals = new JCheckBox();
        this.jCheckBoxIncludeGroupInfo = new JCheckBox();
        this.jCheckBoxQual = new JCheckBox();
        this.jCheckBoxDepthRange = new JCheckBox();
        this.jCheckBoxTextLabel = new JCheckBox();
        this.jCheckBoxAnalyst = new JCheckBox();
        this.jCheckBoxSampleType = new JCheckBox();
        this.jCheckBoxAnalyStatus = new JCheckBox();
        this.jCheckBoxAlphaCodes = new JCheckBox();
        this.jCheckBoxSynonymy = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.jComboBoxSynonymScheme = new JComboBox();
        this.jCheckBoxQualifiersAsComments = new JCheckBox();
        this.jCheckBoxSeparateQuestionableTaxa = new JCheckBox();
        this.jPanel7 = new JPanel();
        this.jPanelCSVOptions1 = new JPanelCSVOptions();
        this.jPanel8 = new JPanel();
        this.jCheckBoxUseCoreCorrections = new JCheckBox();
        this.jCheckBoxUseCuttingCorrections = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("File:");
        this.jTextFieldFileName.setEditable(false);
        this.jTextFieldFileName.setBackground(new Color(255, 255, 204));
        this.jButtonSelectFile.setText("...");
        this.jButtonSelectFile.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectFileActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Data to export", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanel1.setFont(this.jPanel1.getFont());
        this.buttonGroupData.add(this.jRadioButtonDisc);
        this.jRadioButtonDisc.setText("Discipline");
        this.jRadioButtonDisc.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonDiscActionPerformed(evt);
            }
        });
        this.buttonGroupData.add(this.jRadioButtonCategory);
        this.jRadioButtonCategory.setText("Category:");
        this.jRadioButtonCategory.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonCategoryActionPerformed(evt);
            }
        });
        this.jComboBoxWhichData.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.buttonGroupData.add(this.jRadioButtonGroup);
        this.jRadioButtonGroup.setText("Group:");
        this.jRadioButtonGroup.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonGroupActionPerformed(evt);
            }
        });
        this.buttonGroupData.add(this.jRadioButtonSet);
        this.jRadioButtonSet.setText("Group set:");
        this.jRadioButtonSet.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonSetActionPerformed(evt);
            }
        });
        this.jCheckBoxSubCategories.setText("Include sub-category taxa");
        this.jCheckBoxPrepared.setText("Include 'Prepared' analyses");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonDisc).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jRadioButtonGroup).addPreferredGap(1).add((Component)this.jRadioButtonSet).addPreferredGap(1).add((Component)this.jRadioButtonCategory)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(21, 21, 21).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jCheckBoxSubCategories, -2, 184, -2).add((Component)this.jComboBoxWhichData, 0, -1, Short.MAX_VALUE))).add((Component)this.jCheckBoxPrepared)).add(29, 29, 29)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonDisc).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jRadioButtonGroup).add((Component)this.jRadioButtonSet).add((Component)this.jRadioButtonCategory)).addPreferredGap(1).add((Component)this.jComboBoxWhichData, -2, -1, -2).addPreferredGap(0).add((Component)this.jCheckBoxSubCategories, -2, 30, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jCheckBoxPrepared).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Data columns", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanel2.setFont(this.jPanel2.getFont());
        this.buttonGroupCols.add(this.jRadioButtonIndividual);
        this.jRadioButtonIndividual.setText("Individual taxa");
        this.jRadioButtonIndividual.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonIndividualActionPerformed(evt);
            }
        });
        this.buttonGroupCols.add(this.jRadioButtonByGroup);
        this.jRadioButtonByGroup.setText("Group");
        this.jRadioButtonByGroup.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonByGroupActionPerformed(evt);
            }
        });
        this.buttonGroupCols.add(this.jRadioButtonTotal);
        this.jRadioButtonTotal.setText("Total");
        this.jRadioButtonTotal.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonTotalActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jRadioButtonIndividual).add((Component)this.jRadioButtonByGroup).add((Component)this.jRadioButtonTotal)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jRadioButtonIndividual).addPreferredGap(0).add((Component)this.jRadioButtonByGroup).addPreferredGap(0).add((Component)this.jRadioButtonTotal).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Column and row preference", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanel3.setFont(this.jPanel3.getFont());
        this.buttonGroupRowPref.add(this.jRadioButtonSampleRows);
        this.jRadioButtonSampleRows.setText("Matrix - samples are columns");
        this.buttonGroupRowPref.add(this.jRadioButtonRowTaxa);
        this.jRadioButtonRowTaxa.setText("Matrix - taxa/titles are columns");
        this.jRadioButtonRowTaxa.addItemListener(new ItemListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void itemStateChanged(ItemEvent evt) {
                this.this$0.jRadioButtonRowTaxaItemStateChanged(evt);
            }
        });
        this.buttonGroupRowPref.add(this.jRadioButtonOccurrenceRows);
        this.jRadioButtonOccurrenceRows.setText("Occurrences on separate rows");
        this.jCheckBoxCombineAnalyses.setText("Combine sample analyses on same rows");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jRadioButtonOccurrenceRows).add((Component)this.jRadioButtonRowTaxa).add((Component)this.jRadioButtonSampleRows).add((Component)this.jCheckBoxCombineAnalyses)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jRadioButtonRowTaxa).addPreferredGap(0).add((Component)this.jCheckBoxCombineAnalyses).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jRadioButtonSampleRows).addPreferredGap(1).add((Component)this.jRadioButtonOccurrenceRows).addContainerGap()));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Output data format", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanel4.setFont(this.jPanel4.getFont());
        this.buttonGroupFormat.add(this.jRadioButtonQuant);
        this.jRadioButtonQuant.setText("Quantitative - absolute abundance");
        this.jRadioButtonQuant.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonQuantActionPerformed(evt);
            }
        });
        this.buttonGroupFormat.add(this.jRadioButtonPercent);
        this.jRadioButtonPercent.setText("Quantitative - % of:");
        this.jRadioButtonPercent.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonPercentActionPerformed(evt);
            }
        });
        this.buttonGroupFormat.add(this.jRadioButtonSemiQuant);
        this.jRadioButtonSemiQuant.setText("Semi-quantitative");
        this.jRadioButtonSemiQuant.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonSemiQuantActionPerformed(evt);
            }
        });
        this.buttonGroupFormat.add(this.jRadioButtonRichness);
        this.jRadioButtonRichness.setText("Richness");
        this.jRadioButtonRichness.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonRichnessActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Sort order:");
        this.jComboBoxSort.setModel(new DefaultComboBoxModel<String>(new String[]{"First DownHole Occurrence", SORTLDO_STRING}));
        this.jPanel6.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.buttonGroupQuant.add(this.jRadioButtonPercentDisc);
        this.jRadioButtonPercentDisc.setText("Discipline");
        this.jRadioButtonPercentDisc.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonPercentDiscActionPerformed(evt);
            }
        });
        this.buttonGroupQuant.add(this.jRadioButtonPercentCategory);
        this.jRadioButtonPercentCategory.setText("Category:");
        this.jRadioButtonPercentCategory.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonPercentCategoryActionPerformed(evt);
            }
        });
        this.buttonGroupQuant.add(this.jRadioButtonPercentGroup);
        this.jRadioButtonPercentGroup.setText("Group:");
        this.jRadioButtonPercentGroup.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonPercentGroupActionPerformed(evt);
            }
        });
        this.buttonGroupQuant.add(this.jRadioButtonPercentSet);
        this.jRadioButtonPercentSet.setText("Group set:");
        this.jRadioButtonPercentSet.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonPercentSetActionPerformed(evt);
            }
        });
        this.jComboBoxPercentWhich.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout jPanel6Layout = new GroupLayout((Container)this.jPanel6);
        this.jPanel6.setLayout((LayoutManager)jPanel6Layout);
        jPanel6Layout.setHorizontalGroup((GroupLayout.Group)jPanel6Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel6Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel6Layout.createParallelGroup(1).add((Component)this.jRadioButtonPercentDisc).add((GroupLayout.Group)jPanel6Layout.createSequentialGroup().add((Component)this.jRadioButtonPercentGroup).addPreferredGap(1).add((Component)this.jRadioButtonPercentSet).addPreferredGap(1).add((Component)this.jRadioButtonPercentCategory))).addContainerGap(-1, Short.MAX_VALUE)).add(2, (GroupLayout.Group)jPanel6Layout.createSequentialGroup().add(19, 19, 19).add((Component)this.jComboBoxPercentWhich, 0, -1, Short.MAX_VALUE).add(18, 18, 18)));
        jPanel6Layout.setVerticalGroup((GroupLayout.Group)jPanel6Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel6Layout.createSequentialGroup().add(4, 4, 4).add((Component)this.jRadioButtonPercentDisc).addPreferredGap(1).add((GroupLayout.Group)jPanel6Layout.createParallelGroup(3).add((Component)this.jRadioButtonPercentGroup).add((Component)this.jRadioButtonPercentCategory).add((Component)this.jRadioButtonPercentSet)).addPreferredGap(0).add((Component)this.jComboBoxPercentWhich, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.buttonGroupFormat.add(this.jRadioButtonPercentRw);
        this.jRadioButtonPercentRw.setText("% Reworking");
        this.jRadioButtonPercentRw.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonPercentRwActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.jRadioButtonQuant).add((Component)this.jRadioButtonPercent).add((Component)this.jRadioButtonSemiQuant).add((Component)this.jComboBoxSort, 0, -1, Short.MAX_VALUE).add((Component)this.jLabel2).add((Component)this.jRadioButtonRichness).add((Component)this.jRadioButtonPercentRw).add(2, (Component)this.jPanel6, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonQuant).addPreferredGap(1).add((Component)this.jRadioButtonPercent).addPreferredGap(1).add((Component)this.jPanel6, -2, -1, -2).add(18, 18, 18).add((Component)this.jRadioButtonSemiQuant).addPreferredGap(0).add((Component)this.jRadioButtonRichness).addPreferredGap(0).add((Component)this.jRadioButtonPercentRw).addPreferredGap(1).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jComboBoxSort, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonCancel.setText("Close");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(null, "Include", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanel5.setFont(this.jPanel5.getFont());
        this.jCheckBoxUseAuthor.setText("Author and year in taxon name");
        this.jCheckBoxShowTotals.setText("Total count column when outputting % data");
        this.jCheckBoxIncludeGroupInfo.setText("Group and set name in titles");
        this.jCheckBoxQual.setText("Qualifiers (Rw, Cv, ?)");
        this.jCheckBoxQual.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jCheckBoxQualActionPerformed(evt);
            }
        });
        this.jCheckBoxDepthRange.setText("Sample depth range");
        this.jCheckBoxTextLabel.setText("Sample label");
        this.jCheckBoxAnalyst.setText("Analyst");
        this.jCheckBoxSampleType.setText("Sample type");
        this.jCheckBoxAnalyStatus.setText("Sample status (Prepared/Barren/Analysed)");
        this.jCheckBoxAlphaCodes.setText("Species codes");
        this.jCheckBoxSynonymy.setText("Switch synonyms to preferred terms");
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText("Synonym Scheme:");
        this.jComboBoxSynonymScheme.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxSynonymScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCSVExport this$0;
            {
                DialogCSVExport dialogCSVExport = this$0;
                Objects.requireNonNull(dialogCSVExport);
                this.this$0 = dialogCSVExport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxSynonymSchemeActionPerformed(evt);
            }
        });
        this.jCheckBoxQualifiersAsComments.setText("Add qualifiers as comments");
        this.jCheckBoxSeparateQuestionableTaxa.setText("Separate Questionable Taxa");
        GroupLayout jPanel5Layout = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)jPanel5Layout);
        jPanel5Layout.setHorizontalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().add(21, 21, 21).add((Component)this.jCheckBoxQualifiersAsComments)).add((GroupLayout.Group)jPanel5Layout.createParallelGroup(1, false).add((Component)this.jCheckBoxShowTotals, -1, -1, Short.MAX_VALUE).add((Component)this.jCheckBoxUseAuthor, -1, -1, Short.MAX_VALUE).add((Component)this.jCheckBoxIncludeGroupInfo, -1, -1, Short.MAX_VALUE).add((Component)this.jCheckBoxAlphaCodes, -1, -1, Short.MAX_VALUE).add((Component)this.jCheckBoxQual, -1, -1, Short.MAX_VALUE).add((Component)this.jCheckBoxDepthRange, -1, -1, Short.MAX_VALUE).add((Component)this.jCheckBoxTextLabel, -1, -1, Short.MAX_VALUE).add((Component)this.jCheckBoxSampleType, -1, -1, Short.MAX_VALUE).add((Component)this.jCheckBoxAnalyst, -1, -1, Short.MAX_VALUE).add((Component)this.jCheckBoxAnalyStatus, -1, -1, Short.MAX_VALUE).add((Component)this.jCheckBoxSynonymy, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jCheckBoxSeparateQuestionableTaxa, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jComboBoxSynonymScheme, -2, 150, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().add((Component)this.jCheckBoxUseAuthor).addPreferredGap(0).add((Component)this.jCheckBoxSynonymy).addPreferredGap(1).add((GroupLayout.Group)jPanel5Layout.createParallelGroup(3).add((Component)this.jComboBoxSynonymScheme, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(0).add((Component)this.jCheckBoxAlphaCodes).addPreferredGap(0).add((Component)this.jCheckBoxShowTotals).addPreferredGap(0).add((Component)this.jCheckBoxIncludeGroupInfo).addPreferredGap(0).add((Component)this.jCheckBoxQual).addPreferredGap(0).add((Component)this.jCheckBoxQualifiersAsComments).addPreferredGap(0).add((Component)this.jCheckBoxDepthRange).addPreferredGap(0).add((Component)this.jCheckBoxTextLabel).addPreferredGap(0).add((Component)this.jCheckBoxSampleType).addPreferredGap(0).add((Component)this.jCheckBoxAnalyst).addPreferredGap(0).add((Component)this.jCheckBoxAnalyStatus).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jCheckBoxSeparateQuestionableTaxa)));
        this.jPanel7.setBorder(BorderFactory.createTitledBorder(null, "Delimiters", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanel7.setFont(this.jPanel7.getFont());
        GroupLayout jPanel7Layout = new GroupLayout((Container)this.jPanel7);
        this.jPanel7.setLayout((LayoutManager)jPanel7Layout);
        jPanel7Layout.setHorizontalGroup((GroupLayout.Group)jPanel7Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel7Layout.createSequentialGroup().add((Component)this.jPanelCSVOptions1, -2, -1, -2).add(0, 0, Short.MAX_VALUE)));
        jPanel7Layout.setVerticalGroup((GroupLayout.Group)jPanel7Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel7Layout.createSequentialGroup().add((Component)this.jPanelCSVOptions1, -2, -1, -2).add(0, 0, Short.MAX_VALUE)));
        this.jPanel8.setBorder(BorderFactory.createTitledBorder(null, "Core-corrected depth", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jCheckBoxUseCoreCorrections.setText("Output core-corrected depths for core samples");
        this.jCheckBoxUseCuttingCorrections.setText("Output core-corrected depths for cutting samples");
        GroupLayout jPanel8Layout = new GroupLayout((Container)this.jPanel8);
        this.jPanel8.setLayout((LayoutManager)jPanel8Layout);
        jPanel8Layout.setHorizontalGroup((GroupLayout.Group)jPanel8Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel8Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel8Layout.createParallelGroup(1).add((Component)this.jCheckBoxUseCoreCorrections).add((Component)this.jCheckBoxUseCuttingCorrections)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel8Layout.setVerticalGroup((GroupLayout.Group)jPanel8Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel8Layout.createSequentialGroup().add((Component)this.jCheckBoxUseCoreCorrections).addPreferredGap(0).add((Component)this.jCheckBoxUseCuttingCorrections).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldFileName, -2, 1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonSelectFile, -2, 30, -2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel4, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel8, -1, -1, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jPanel5, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonSave).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel7, -1, -1, Short.MAX_VALUE))))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonSave}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldFileName, -2, -1, -2).add((Component)this.jButtonSelectFile)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jPanel2, -2, 103, -2).add((Component)this.jPanel7, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel5, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel4, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel8, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonSave)).addContainerGap()));
        this.pack();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogcsvexportoptions.html");
    }

    private void jRadioButtonDiscActionPerformed(ActionEvent evt) {
        this.radioButtonDataToExportChanged();
    }

    private void jRadioButtonGroupActionPerformed(ActionEvent evt) {
        this.radioButtonDataToExportChanged();
    }

    private void jRadioButtonSetActionPerformed(ActionEvent evt) {
        this.radioButtonDataToExportChanged();
    }

    private void jRadioButtonCategoryActionPerformed(ActionEvent evt) {
        this.radioButtonDataToExportChanged();
    }

    private void jRadioButtonPercentDiscActionPerformed(ActionEvent evt) {
        this.jComboBoxPercentWhich.removeAllItems();
        this.jComboBoxPercentWhich.setEnabled(false);
    }

    private void jRadioButtonPercentCategoryActionPerformed(ActionEvent evt) {
        this.jComboBoxPercentWhich.removeAllItems();
        this.jComboBoxPercentWhich.setEnabled(true);
        this.jComboBoxPercentWhich.setRenderer(this.categoryRenderer);
        try {
            this.db.getCategoryService().getCategoryList().forEach(cat -> this.jComboBoxPercentWhich.addItem(cat));
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showStackError(e);
        }
    }

    private void jRadioButtonPercentGroupActionPerformed(ActionEvent evt) {
        try {
            this.jComboBoxPercentWhich.removeAllItems();
            this.jComboBoxPercentWhich.setEnabled(true);
            this.jComboBoxPercentWhich.setRenderer(this.defaultComboRenderer);
            LinkedList<TxGroup> groups = new LinkedList<TxGroup>(this.db.getTxGroups());
            Collections.sort(groups);
            for (TxGroup group : groups) {
                this.jComboBoxPercentWhich.addItem(group);
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql);
        }
    }

    private void jRadioButtonPercentSetActionPerformed(ActionEvent evt) {
        try {
            this.jComboBoxPercentWhich.removeAllItems();
            this.jComboBoxPercentWhich.setEnabled(true);
            this.jComboBoxPercentWhich.setRenderer(this.defaultComboRenderer);
            for (TxGroupSet set : this.db.getTxGroupSetsSorted()) {
                this.jComboBoxPercentWhich.addItem(set);
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql);
        }
    }

    private void jRadioButtonPercentActionPerformed(ActionEvent evt) {
        this.radioButtonOutputDataFormatChanged();
    }

    private void jRadioButtonRichnessActionPerformed(ActionEvent evt) {
        this.radioButtonOutputDataFormatChanged();
    }

    private void jRadioButtonByGroupActionPerformed(ActionEvent evt) {
        this.radioButtonDataColumnsChanged();
    }

    private void jRadioButtonIndividualActionPerformed(ActionEvent evt) {
        this.radioButtonDataColumnsChanged();
    }

    private void jRadioButtonSemiQuantActionPerformed(ActionEvent evt) {
        this.radioButtonOutputDataFormatChanged();
    }

    private void jRadioButtonQuantActionPerformed(ActionEvent evt) {
        this.radioButtonOutputDataFormatChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSaveActionPerformed(ActionEvent evt) {
        if (this.buttonGroupData.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select discipline/category/group/group set", "Warning", 2);
            return;
        }
        if (this.buttonGroupCols.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select individual/total", "Warning", 2);
            return;
        }
        if (this.buttonGroupRowPref.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select which order you prefer for the output file, row/columns/occurrences", "Warning", 2);
            return;
        }
        if (this.buttonGroupFormat.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select absolute/percentage/semi-quantitative/diversity option", "Warning", 2);
            return;
        }
        if (this.jRadioButtonPercent.isSelected() && this.buttonGroupQuant.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select option for basis for calculating percentage", "Warning", 2);
            return;
        }
        String filePath = this.jTextFieldFileName.getText();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String catMnem = null;
            TxGroup group = null;
            TxGroupSet set = null;
            if (this.jRadioButtonGroup.isSelected()) {
                group = (TxGroup)this.jComboBoxWhichData.getSelectedItem();
            } else if (this.jRadioButtonCategory.isSelected()) {
                Category category = (Category)this.jComboBoxWhichData.getSelectedItem();
                catMnem = category != null ? category.getMnemonic() : "";
            } else if (this.jRadioButtonSet.isSelected()) {
                set = (TxGroupSet)this.jComboBoxWhichData.getSelectedItem();
                set.getGroups();
            }
            HashMap<Integer, Taxon> taxaMap = new HashMap<Integer, Taxon>();
            this.well.fillTaxonList(taxaMap, Discipline.getChar((Discipline)this.discID), this.analystID, this.analyNo);
            LinkedList<Taxon> taxa = new LinkedList<Taxon>(taxaMap.values());
            if (!this.jRadioButtonDisc.isSelected()) {
                this.filterTaxa(taxa, group, catMnem, set, this.jCheckBoxSubCategories.isSelected());
            }
            this.filterTaxaFromSamples(taxa);
            List totalTaxa = this.getTaxaForPercentageTotal();
            this.sortTaxaList(taxa);
            CSVExportOptions csvOpts = this.jPanelCSVOptions1.getSelectedOptions();
            csvOpts.setMaxFractionalDigits(2);
            csvOpts.setMinFractionalDigits(2);
            GridWriter gw = new GridWriter();
            gw.setCSVOptions(csvOpts);
            File file = new File(filePath);
            gw.getXLSOptions().setSheetName(this.well.getWellName());
            gw.getXLSOptions().setAuthorName(this.db.getUser().getName());
            gw.getXLSOptions().setAutoSizeColumns(false);
            gw.getXLSOptions().setEnableBufferedOutput(true);
            if (FileOverwriteCheck.checkForGridFileOverwriting(this, (Component)this, file, gw)) {
                long buildstart = System.currentTimeMillis();
                GridSheet gb = new GridSheet();
                this.addHeaderRow((IGridBuilder)gb, this.well, catMnem, group, set);
                OccurrenceCollator collator = this.setupOccurrenceCollator();
                OccurrenceCollection data = this.jRadioButtonByGroup.isSelected() ? collator.collectAndGroupOccurrenceData(this.well, this.selectedAnalyses, this.db, set, totalTaxa, this.jCheckBoxSynonymy.isSelected() ? this.getSynSchID() : 0) : (this.jRadioButtonTotal.isSelected() ? collator.collectTotalOccurrenceData(this.well, this.selectedAnalyses, this.db, this.getAggregateTitle(), taxa, totalTaxa) : collator.collectOccurrenceData(this.well, this.selectedAnalyses, this.db, taxa, totalTaxa, set, this.jCheckBoxSynonymy.isSelected() ? this.getSynSchID() : 0));
                GridBuilderAnalysis gba = this.setupAnalysisGridBuilder(csvOpts);
                if (this.jRadioButtonSampleRows.isSelected()) {
                    gba.buildGridWithAnalysisColumns((IGridBuilder)gb, data);
                } else if (this.jRadioButtonOccurrenceRows.isSelected()) {
                    gba.buildGridWithIndividualRows((IGridBuilder)gb, data);
                } else {
                    gba.buildGridWithTaxaColumns((IGridBuilder)gb, data);
                }
                if (FilePathUtils.isFileExtension((String)filePath, (String[])FileChooserUtils.LEGACY_EXCEL_FILTER.getExtensions()) && gb.countColumns() > 255) {
                    JOptionPane.showMessageDialog(this, "The output you have selected has more than 255 columns, this number of columns is not supported by legacy Excel files (.xls files).\r\nPlease try selecting another file output format.", "Column limit warning", 2);
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                gw.write(file, gb.getObjectArray());
                long buildend = System.currentTimeMillis();
                Logger.getLogger(DialogCSVExport.class.getName()).log(Level.INFO, "{0} written in {1}ms.", new Object[]{file.getName(), buildend - buildstart});
                this.saveDefaults();
                this.db.commit();
                JOptionPane.showMessageDialog(this, "File '" + file.getName() + "' saved.", this.getTitle(), 1);
            }
        }
        catch (IOException | RuntimeException | SQLException | SBException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private List getTaxaForPercentageTotal() throws SBException, SQLException {
        LinkedList<Object> totalTaxa = new LinkedList();
        TxGroup percentGroup = null;
        String percentCatMnem = null;
        TxGroupSet percentSet = null;
        if (this.jRadioButtonPercent.isSelected()) {
            HashMap<Integer, Taxon> totalTaxaMap = new HashMap<Integer, Taxon>();
            this.well.fillTaxonList(totalTaxaMap, Discipline.getChar((Discipline)this.discID), this.analystID, this.analyNo);
            totalTaxa = new LinkedList<Taxon>(totalTaxaMap.values());
            if (this.jRadioButtonPercentGroup.isSelected()) {
                percentGroup = (TxGroup)this.jComboBoxPercentWhich.getSelectedItem();
            } else if (this.jRadioButtonPercentCategory.isSelected()) {
                percentCatMnem = ((Category)this.jComboBoxPercentWhich.getSelectedItem()).getMnemonic();
            } else if (this.jRadioButtonPercentSet.isSelected()) {
                percentSet = (TxGroupSet)this.jComboBoxPercentWhich.getSelectedItem();
            }
            if (!this.jRadioButtonPercentDisc.isSelected()) {
                this.filterTaxa(totalTaxa, percentGroup, percentCatMnem, percentSet, true);
            }
        }
        return totalTaxa;
    }

    private OccurrenceCollator setupOccurrenceCollator() throws SBException, SQLException {
        OccurrenceCollator collator = new OccurrenceCollator();
        collator.setUnits(this.units);
        collator.setUseAuthorInTaxaTiles(this.jCheckBoxUseAuthor.isSelected());
        collator.setUseCoreSampleCorrections(this.jCheckBoxUseCoreCorrections.isSelected());
        collator.setUseCuttingSampleCorrections(this.jCheckBoxUseCuttingCorrections.isSelected());
        collator.setCombineSampleAnalysis(this.jCheckBoxCombineAnalyses.isSelected());
        collator.setHasMultipleSuiteNos(this.hasMultipleSuiteNos());
        collator.setSeparateQuestionableTaxa(this.jCheckBoxSeparateQuestionableTaxa.isSelected());
        collator.setHidePreparedAnalysis(!this.jCheckBoxPrepared.isSelected());
        if (this.jCheckBoxSynonymy.isSelected()) {
            collator.setSynonymScheme((SynonymScheme)((Object)this.jComboBoxSynonymScheme.getSelectedItem()));
        } else {
            collator.setSynonymScheme(null);
        }
        return collator;
    }

    private GridBuilderAnalysis setupAnalysisGridBuilder(CSVExportOptions csvOpts) {
        GridBuilderAnalysis gba = new GridBuilderAnalysis();
        gba.setIncludeSampleType(this.jCheckBoxSampleType.isSelected());
        gba.setIncludeSampleLabel(this.jCheckBoxTextLabel.isSelected());
        gba.setIncludeAnalyst(this.jCheckBoxAnalyst.isSelected());
        gba.setIncludeSampleSatatus(this.jCheckBoxAnalyStatus.isSelected());
        gba.setIncludeDepthRange(this.jCheckBoxDepthRange.isSelected());
        gba.setIncludeTaxaSpeciesCodes(this.jCheckBoxAlphaCodes.isSelected());
        gba.setIncludeTotalsWithPercentage(this.jCheckBoxShowTotals.isSelected());
        gba.setIncludeGroupInfo(this.jCheckBoxIncludeGroupInfo.isSelected());
        gba.setShowQualifiers(this.jCheckBoxQual.isSelected());
        gba.setQualifiersAsComments(this.jCheckBoxQualifiersAsComments.isSelected());
        if (this.jRadioButtonQuant.isSelected()) {
            gba.setOutputData(GridBuilderAnalysis.OutputData.AbsoluteAbundance);
        } else if (this.jRadioButtonPercent.isSelected()) {
            gba.setOutputData(GridBuilderAnalysis.OutputData.Percentage);
        } else if (this.jRadioButtonSemiQuant.isSelected()) {
            gba.setOutputData(GridBuilderAnalysis.OutputData.SemiQuantative);
        } else if (this.jRadioButtonRichness.isSelected()) {
            gba.setOutputData(GridBuilderAnalysis.OutputData.Richness);
        } else if (this.jRadioButtonPercentRw.isSelected()) {
            gba.setOutputData(GridBuilderAnalysis.OutputData.PercentReworking);
        }
        boolean individualTaxaOutput = this.jRadioButtonIndividual.isSelected();
        gba.setIncludeZeroValuesInOutput(!individualTaxaOutput);
        gba.setIncludeCategory(!individualTaxaOutput);
        gba.setRotateHeaderText(individualTaxaOutput && this.jRadioButtonRowTaxa.isSelected());
        gba.setIncludeCategory(!this.jRadioButtonOccurrenceRows.isSelected());
        gba.setNumberFormat(csvOpts.buildNumberFormat());
        return gba;
    }

    private String getAggregateTitle() {
        String aggTitle = "Count";
        if (this.jRadioButtonPercent.isSelected()) {
            aggTitle = "Percent";
        } else if (this.jRadioButtonRichness.isSelected()) {
            aggTitle = "Diversity";
        } else if (this.jRadioButtonPercentRw.isSelected()) {
            aggTitle = "% Reworking";
        }
        return aggTitle;
    }

    private void sortTaxaList(List<Taxon> taxa) throws SQLException, SBException {
        Taxon.sort(taxa, Taxon.SortOrder.SORT_GENUS);
        System.out.println("Sorting: " + String.valueOf(this.jComboBoxSort.getSelectedItem()));
        if (this.jComboBoxSort.getSelectedItem().equals(SORTFDO_STRING)) {
            this.well.sortTaxonList(taxa, this.discID, 0);
        } else if (this.jComboBoxSort.getSelectedItem().equals(SORTLDO_STRING)) {
            this.well.sortTaxonList(taxa, this.discID, 1);
        }
    }

    private void jButtonSelectFileActionPerformed(ActionEvent evt) {
        String filePath = this.jTextFieldFileName.getText();
        File file = FileChooserUtils.saveAsGridDataDialog((Component)this, (String)filePath, (String)FilePathUtils.extractFileNameWithoutExtension((String)filePath));
        if (file != null) {
            this.jTextFieldFileName.setText(file.getPath());
            this.outputFileChanged();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jRadioButtonPercentRwActionPerformed(ActionEvent evt) {
        this.radioButtonOutputDataFormatChanged();
    }

    private void jRadioButtonRowTaxaItemStateChanged(ItemEvent evt) {
        this.jCheckBoxCombineAnalyses.setEnabled(this.jRadioButtonRowTaxa.isSelected());
    }

    private void jComboBoxSynonymSchemeActionPerformed(ActionEvent evt) {
        SynonymScheme scheme = (SynonymScheme)((Object)this.jComboBoxSynonymScheme.getSelectedItem());
    }

    private void jRadioButtonTotalActionPerformed(ActionEvent evt) {
        this.radioButtonDataColumnsChanged();
    }

    private void jCheckBoxQualActionPerformed(ActionEvent evt) {
        this.updateAddQualifiersAsCommentsCheckboxEnabled();
    }

    void saveDefaults() throws SQLException {
        Object defString = "";
        defString = this.jRadioButtonDisc.isSelected() ? (String)defString + "DIS" : (this.jRadioButtonCategory.isSelected() ? (String)defString + "CAT" : (this.jRadioButtonGroup.isSelected() ? (String)defString + "GRP" : (this.jRadioButtonSet.isSelected() ? (String)defString + "SET" : (String)defString + "---")));
        defString = (String)defString + "|";
        defString = this.jComboBoxWhichData.getSelectedItem() != null ? (String)defString + String.valueOf(this.jComboBoxWhichData.getSelectedItem()) : (String)defString + "---";
        defString = (String)defString + "|";
        defString = this.jRadioButtonIndividual.isSelected() ? (String)defString + "IND" : (this.jRadioButtonByGroup.isSelected() ? (String)defString + "GRP" : (this.jRadioButtonTotal.isSelected() ? (String)defString + "TOT" : (String)defString + "---"));
        defString = (String)defString + "|";
        defString = this.jRadioButtonQuant.isSelected() ? (String)defString + "QNT" : (this.jRadioButtonSemiQuant.isSelected() ? (String)defString + "SQT" : (this.jRadioButtonRichness.isSelected() ? (String)defString + "DIV" : (this.jRadioButtonPercentRw.isSelected() ? (String)defString + "PRW" : (this.jRadioButtonPercent.isSelected() ? (String)defString + "PCT" : (String)defString + "---"))));
        defString = (String)defString + "|";
        defString = this.jRadioButtonPercentDisc.isSelected() ? (String)defString + "PDS" : (this.jRadioButtonPercentCategory.isSelected() ? (String)defString + "PCA" : (this.jRadioButtonPercentGroup.isSelected() ? (String)defString + "PGP" : (this.jRadioButtonPercentSet.isSelected() ? (String)defString + "PST" : (String)defString + "---")));
        defString = (String)defString + "|";
        defString = this.jComboBoxPercentWhich.getSelectedItem() != null ? (String)defString + String.valueOf(this.jComboBoxPercentWhich.getSelectedItem()) : (String)defString + "---";
        defString = (String)defString + "|";
        defString = (String)defString + this.jCheckBoxUseAuthor.isSelected() + "|";
        defString = (String)defString + this.jCheckBoxShowTotals.isSelected() + "|";
        defString = (String)defString + this.jCheckBoxQual.isSelected() + "|";
        defString = (String)defString + this.jCheckBoxIncludeGroupInfo.isSelected() + "|";
        String sort = (String)this.jComboBoxSort.getSelectedItem();
        if (sort != null) {
            if (sort.equals(SORTALPHA_STRING)) {
                defString = (String)defString + "STA";
            } else if (sort.equals(SORTFDO_STRING)) {
                defString = (String)defString + "SFD";
            } else if (sort.equals(SORTLDO_STRING)) {
                defString = (String)defString + "SLD";
            }
        } else {
            defString = (String)defString + "|";
        }
        defString = (String)defString + "|";
        defString = (String)defString + this.jCheckBoxDepthRange.isSelected() + "|";
        defString = (String)defString + this.jCheckBoxTextLabel.isSelected() + "|";
        defString = (String)defString + this.jCheckBoxAnalyst.isSelected() + "|";
        defString = (String)defString + this.jCheckBoxSampleType.isSelected() + "|";
        defString = (String)defString + "|";
        defString = this.jRadioButtonSampleRows.isSelected() ? (String)defString + "RWS" : (this.jRadioButtonRowTaxa.isSelected() ? (String)defString + "RWT" : (this.jRadioButtonOccurrenceRows.isSelected() ? (String)defString + "RWO" : (String)defString + "---"));
        defString = (String)defString + "|";
        defString = (String)defString + this.jCheckBoxPrepared.isSelected() + "|";
        defString = (String)defString + this.jCheckBoxAnalyStatus.isSelected() + "|";
        defString = (String)defString + this.jCheckBoxAlphaCodes.isSelected() + "|";
        defString = (String)defString + this.jCheckBoxCombineAnalyses.isSelected() + "|";
        defString = (String)defString + this.jCheckBoxSynonymy.isSelected() + "|";
        defString = (String)defString + this.getSynSchID() + "|";
        defString = (String)defString + this.jCheckBoxSeparateQuestionableTaxa.isSelected() + "|";
        defString = (String)defString + this.jCheckBoxQualifiersAsComments.isSelected() + "|";
        Lastval.putString(this.db, "CSVOPT", (String)defString);
        Lastval.putString(this.db, "WINSMPDTL", "UNXSMPDTL", this.jTextFieldFileName.getText());
        this.prefs.setUseCoreSampleCorrections(this.jCheckBoxUseCoreCorrections.isSelected());
        this.prefs.setUseCuttingSampleCorrections(this.jCheckBoxUseCuttingCorrections.isSelected());
    }

    int getSynSchID() {
        SynonymScheme scheme;
        if (this.jComboBoxSynonymScheme.getSelectedItem() != null && (scheme = (SynonymScheme)((Object)this.jComboBoxSynonymScheme.getSelectedItem())) != null) {
            return scheme.getSchID();
        }
        return 0;
    }

    void loadDefaults() throws SQLException {
        String defString = Lastval.getString(this.db, "CSVOPT");
        if (defString != null && defString.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(defString, "|");
            try {
                int i;
                String tok;
                switch (tok = tokens.nextToken()) {
                    case "CAT": {
                        this.jRadioButtonCategory.setSelected(true);
                        break;
                    }
                    case "GRP": {
                        this.jRadioButtonGroup.setSelected(true);
                        break;
                    }
                    case "SET": {
                        this.jRadioButtonSet.setSelected(true);
                        break;
                    }
                    default: {
                        this.jRadioButtonDisc.setSelected(true);
                    }
                }
                this.radioButtonDataToExportChanged();
                tok = tokens.nextToken();
                if (!tok.equals("---")) {
                    int itemCount = this.jComboBoxWhichData.getItemCount();
                    for (i = 0; i < itemCount; ++i) {
                        if (!this.jComboBoxWhichData.getItemAt(i).toString().equals(tok)) continue;
                        this.jComboBoxWhichData.setSelectedIndex(i);
                        break;
                    }
                }
                if ((tok = tokens.nextToken()).equals("IND")) {
                    this.jRadioButtonIndividual.setSelected(true);
                } else if (tok.equals("GRP")) {
                    this.jRadioButtonByGroup.setSelected(true);
                } else if (tok.equals("TOT")) {
                    this.jRadioButtonTotal.setSelected(true);
                }
                tok = tokens.nextToken();
                if (tok.equals("QNT")) {
                    this.jRadioButtonQuant.setSelected(true);
                } else if (tok.equals("SQT")) {
                    this.jRadioButtonSemiQuant.setSelected(true);
                } else if (tok.equals("DIV")) {
                    this.jRadioButtonRichness.setSelected(true);
                } else if (tok.equals("PRW")) {
                    this.jRadioButtonPercentRw.setSelected(true);
                } else if (tok.equals("PCT")) {
                    this.jRadioButtonPercent.setSelected(true);
                } else if (tok.equals("SQT")) {
                    this.jRadioButtonSemiQuant.setSelected(true);
                }
                tok = tokens.nextToken();
                if (tok.equals("PDS")) {
                    this.jRadioButtonPercentDisc.setSelected(true);
                    this.jRadioButtonPercentDiscActionPerformed(null);
                } else if (tok.equals("PCA")) {
                    this.jRadioButtonPercentCategory.setSelected(true);
                    this.jRadioButtonPercentCategoryActionPerformed(null);
                } else if (tok.equals("PGP")) {
                    this.jRadioButtonPercentGroup.setSelected(true);
                    this.jRadioButtonPercentGroupActionPerformed(null);
                } else if (tok.equals("PST")) {
                    this.jRadioButtonPercentSet.setSelected(true);
                    this.jRadioButtonPercentSetActionPerformed(null);
                }
                tok = tokens.nextToken();
                if (!tok.equals("---")) {
                    int itemCount = this.jComboBoxPercentWhich.getItemCount();
                    for (i = 0; i < itemCount; ++i) {
                        if (!this.jComboBoxPercentWhich.getItemAt(i).toString().equals(tok)) continue;
                        this.jComboBoxPercentWhich.setSelectedIndex(i);
                        break;
                    }
                }
                tok = tokens.nextToken();
                this.jCheckBoxUseAuthor.setSelected(Boolean.valueOf(tok));
                tok = tokens.nextToken();
                this.jCheckBoxShowTotals.setSelected(Boolean.valueOf(tok));
                tok = tokens.nextToken();
                this.jCheckBoxQual.setSelected(Boolean.valueOf(tok));
                tok = tokens.nextToken();
                this.jCheckBoxIncludeGroupInfo.setSelected(Boolean.valueOf(tok));
                tok = tokens.nextToken();
                if (tok.equals("STA")) {
                    this.jComboBoxSort.setSelectedItem(SORTALPHA_STRING);
                } else if (tok.equals("SFD")) {
                    this.jComboBoxSort.setSelectedItem(SORTFDO_STRING);
                } else if (tok.equals("SLD")) {
                    this.jComboBoxSort.setSelectedItem(SORTLDO_STRING);
                }
                tok = tokens.nextToken();
                this.jCheckBoxDepthRange.setSelected(Boolean.valueOf(tok));
                tok = tokens.nextToken();
                this.jCheckBoxTextLabel.setSelected(Boolean.valueOf(tok));
                tok = tokens.nextToken();
                this.jCheckBoxAnalyst.setSelected(Boolean.valueOf(tok));
                tok = tokens.nextToken();
                this.jCheckBoxSampleType.setSelected(Boolean.valueOf(tok));
                if (tokens.hasMoreTokens()) {
                    tok = tokens.nextToken();
                    if (tok.equals("RWS")) {
                        this.jRadioButtonSampleRows.setSelected(true);
                    } else if (tok.equals("RWT")) {
                        this.jRadioButtonRowTaxa.setSelected(true);
                    } else if (tok.equals("RWO")) {
                        this.jRadioButtonOccurrenceRows.setSelected(true);
                    }
                }
                if (tokens.hasMoreTokens()) {
                    tok = tokens.nextToken();
                    this.jCheckBoxPrepared.setSelected(Boolean.valueOf(tok));
                }
                if (tokens.hasMoreTokens()) {
                    tok = tokens.nextToken();
                    this.jCheckBoxAnalyStatus.setSelected(Boolean.valueOf(tok));
                }
                if (tokens.hasMoreTokens()) {
                    tok = tokens.nextToken();
                    this.jCheckBoxAlphaCodes.setSelected(Boolean.valueOf(tok));
                }
                if (tokens.hasMoreTokens()) {
                    tok = tokens.nextToken();
                    this.jCheckBoxCombineAnalyses.setSelected(Boolean.valueOf(tok));
                }
                if (tokens.hasMoreTokens()) {
                    tok = tokens.nextToken();
                    this.jCheckBoxSynonymy.setSelected(Boolean.valueOf(tok));
                }
                if (tokens.hasMoreTokens()) {
                    tok = tokens.nextToken();
                    this.jComboBoxSynonymScheme.setSelectedItem((Object)this.db.getSynSch(Integer.valueOf(tok)));
                }
                if (tokens.hasMoreTokens()) {
                    tok = tokens.nextToken();
                    this.jCheckBoxSeparateQuestionableTaxa.setSelected(Boolean.valueOf(tok));
                }
                if (tokens.hasMoreTokens()) {
                    tok = tokens.nextToken();
                    this.jCheckBoxQualifiersAsComments.setSelected(Boolean.valueOf(tok));
                }
                this.radioButtonOutputDataFormatChanged();
            }
            catch (NumberFormatException | NoSuchElementException ex) {
                ex.printStackTrace();
            }
        }
    }

    void setPercentOptions(boolean enabled) {
        this.jRadioButtonPercentCategory.setEnabled(enabled);
        this.jRadioButtonPercentSet.setEnabled(enabled);
        this.jRadioButtonPercentDisc.setEnabled(enabled);
        this.jRadioButtonPercentGroup.setEnabled(enabled);
        this.jComboBoxPercentWhich.setEnabled(enabled);
        this.jRadioButtonIndividual.setEnabled(true);
        this.jRadioButtonGroup.setEnabled(true);
    }

    private boolean hasMultipleSuiteNos() throws SQLException, SBException {
        Iterator<Sample> en = this.well.getSamples().iterator();
        Integer analyNumber = null;
        while (en.hasNext()) {
            Sample sample = en.next();
            for (int i = 0; i < sample.getSmpdtls().size(); ++i) {
                Smpdtl smpdtl = sample.getSmpdtls().get(i);
                if (this.discID != null && smpdtl.getDiscID() != this.discID.getChar()) continue;
                if (analyNumber == null) {
                    analyNumber = smpdtl.getAnalyNo();
                    continue;
                }
                if (analyNumber.intValue() == smpdtl.getAnalyNo()) continue;
                return true;
            }
        }
        return false;
    }

    void filterTaxa(List taxa, TxGroup group, String catMnem, TxGroupSet set, boolean includeSubCat) throws SQLException, SBException {
        Iterator it = taxa.iterator();
        if (set != null) {
            set.getGroups();
        }
        while (it.hasNext()) {
            Taxon taxon = (Taxon)it.next();
            boolean keep = false;
            if (catMnem != null) {
                if (includeSubCat && taxon.getCatMnem().startsWith(catMnem)) {
                    keep = true;
                } else if (!includeSubCat && taxon.getCatMnem().equals(catMnem)) {
                    keep = true;
                }
            } else if (group != null && group.isMember(taxon.getSpecID(), this.jCheckBoxSynonymy.isSelected() ? this.getSynSchID() : 0)) {
                keep = true;
            } else if (set != null && set.isMember(taxon.getSpecID(), this.jCheckBoxSynonymy.isSelected() ? this.getSynSchID() : 0)) {
                keep = true;
            }
            if (keep) continue;
            it.remove();
        }
    }

    void filterTaxaFromSamples(List taxa) throws SQLException, SBException {
        if (this.selectedAnalyses == null) {
            return;
        }
        Iterator it = taxa.iterator();
        while (it.hasNext()) {
            Taxon taxon = (Taxon)it.next();
            boolean keep = false;
            block1: for (Sample sample : this.well.getSamples()) {
                for (Smpdtl smpdtl : sample.getSmpdtls()) {
                    if (!this.includeAnalysis(smpdtl) || !smpdtl.hasSpecies(taxon.getSpecID())) continue;
                    keep = true;
                    break block1;
                }
            }
            if (keep) continue;
            it.remove();
        }
    }

    private boolean includeAnalysis(Smpdtl smpdtl) {
        if (this.selectedAnalyses != null) {
            return this.selectedAnalyses.contains((Object)smpdtl);
        }
        if (!(this.discID != null && smpdtl.getDiscID() != this.discID.getChar() || this.analystID != 0 && smpdtl.getHeader().getAnalystUsrid() != this.analystID || this.analyNo != 0 && smpdtl.getAnalyNo() != this.analyNo)) {
            if (this.jCheckBoxPrepared.isSelected()) {
                return true;
            }
            if (smpdtl.getBarren()) {
                return true;
            }
            if (smpdtl.isAnalysed()) {
                return true;
            }
        }
        return false;
    }

    private void enableSampleCorrectionCheckboxes() {
        boolean coreSamplesFound = false;
        boolean cuttingSamplesFound = false;
        try {
            for (Sample sample : this.well.getSamples()) {
                if (sample.getType() == SampleType.CO) {
                    coreSamplesFound = true;
                } else if (sample.getType() == SampleType.CU) {
                    cuttingSamplesFound = true;
                }
                if (!coreSamplesFound || !cuttingSamplesFound) continue;
                break;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DialogCSVExport.class.getName()).log(Level.SEVERE, null, ex);
            coreSamplesFound = true;
            cuttingSamplesFound = true;
        }
        this.jCheckBoxUseCoreCorrections.setEnabled(coreSamplesFound);
        this.jCheckBoxUseCuttingCorrections.setEnabled(cuttingSamplesFound);
    }

    private void setCorrectionCheckboxDefaults() {
        if (this.jCheckBoxUseCoreCorrections.isEnabled()) {
            this.jCheckBoxUseCoreCorrections.setSelected(this.prefs.getUseCoreSampleCorrections());
        }
        if (this.jCheckBoxUseCuttingCorrections.isEnabled()) {
            this.jCheckBoxUseCuttingCorrections.setSelected(this.prefs.getUseCuttingSampleCorrections());
        }
    }

    private void setCheckboxEnabled(JCheckBox cbx, boolean enabled) {
        cbx.setEnabled(enabled);
        if (!enabled && cbx.isSelected()) {
            cbx.setSelected(false);
        }
    }

    private void addHeaderRow(IGridBuilder gb, Well well, String catMnem, TxGroup group, TxGroupSet set) {
        gb.append(new Object[]{"Sample data for well: " + well.getWellName()});
        if (catMnem != null) {
            gb.append(new Object[]{"Category " + catMnem});
        } else if (group != null) {
            gb.append(new Object[]{"Group: " + group.getName()});
        } else if (set != null) {
            gb.append(new Object[]{"Group Set: " + set.getName()});
        }
        if (this.jRadioButtonPercent.isSelected()) {
            Object percentHeading = "Percentage of taxa within/against ";
            if (this.jRadioButtonPercentDisc.isSelected()) {
                percentHeading = (String)percentHeading + (this.discID == null ? "All Disciplines" : this.discID.getNoun());
            } else if (this.jRadioButtonPercentGroup.isSelected()) {
                percentHeading = (String)percentHeading + String.valueOf((TxGroup)this.jComboBoxPercentWhich.getSelectedItem());
            } else if (this.jRadioButtonPercentCategory.isSelected()) {
                percentHeading = (String)percentHeading + ((Category)this.jComboBoxPercentWhich.getSelectedItem()).getMnemonic();
            } else if (this.jRadioButtonPercentSet.isSelected()) {
                percentHeading = (String)percentHeading + String.valueOf((TxGroupSet)this.jComboBoxPercentWhich.getSelectedItem());
            }
            gb.append(new Object[]{percentHeading});
        } else if (this.jRadioButtonRichness.isSelected()) {
            gb.append(new Object[]{"Diversity"});
        } else if (this.jRadioButtonPercentRw.isSelected()) {
            gb.append(new Object[]{"% Reworking"});
        }
        gb.addRow();
    }
}

