/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.event.EventType;
import com.stratadata.util.ui.SBDialog;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsbchart.block.ChartBlock;
import jsbchart.block.ChartBlockBase;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbugs.DialogList;
import jsbugs.FrameJsbugs;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.UserPrefsHelper;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnitBase;
import model3.InterpHdr;
import model3.SBEvent;
import model3.SBdb;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import util.InvalidFieldException;
import util.SBException;
import util.exception.StackError;

public class DialogChartBlockDepthRange
extends SBDialog {
    ChangeListener changeListener = new ChangeListener(this){
        final /* synthetic */ DialogChartBlockDepthRange this$0;
        {
            DialogChartBlockDepthRange dialogChartBlockDepthRange = this$0;
            Objects.requireNonNull(dialogChartBlockDepthRange);
            this.this$0 = dialogChartBlockDepthRange;
        }

        @Override
        public void stateChanged(ChangeEvent changEvent) {
            AbstractButton aButton = (AbstractButton)changEvent.getSource();
            ButtonModel aModel = aButton.getModel();
            if (aModel.isSelected()) {
                this.this$0.setCards();
            }
        }
    };
    private final SBdb sbdb;
    private final Chart chart;
    private final HashSet<Well> wells = new HashSet();
    private static IGDScheme scheme;
    private Object top;
    private Object base;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private JButton jButton1;
    private JButton jButtonCancel;
    private JButton jButtonEventBase;
    private JButton jButtonEventTop;
    private JButton jButtonOK;
    private JButton jButtonScheme;
    private JComboBox jComboBoxUnitBase;
    private JComboBox jComboBoxUnitTop;
    private JComboBox jComboBoxVersion;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabelVersion;
    private JPanel jPanelCard;
    private JPanel jPanelEvents;
    private JPanel jPanelIntervals;
    private JRadioButton jRadioButtonBaseEventBase;
    private JRadioButton jRadioButtonBaseEventSingle;
    private JRadioButton jRadioButtonBaseEventTop;
    private JRadioButton jRadioButtonEvent;
    private JRadioButton jRadioButtonInterval;
    private JRadioButton jRadioButtonTopEventBase;
    private JRadioButton jRadioButtonTopEventSingle;
    private JRadioButton jRadioButtonTopEventTop;
    private JSeparator jSeparator1;
    private JTextField jTextFieldEventBase;
    private JTextField jTextFieldEventTop;
    private JTextField jTextFieldScheme;

    public DialogChartBlockDepthRange(Frame parent, boolean modal, SBdb sbdb, Chart chart) {
        super(parent, modal);
        this.sbdb = sbdb;
        this.chart = chart;
        this.initComponents();
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    private void init() {
        void var2_7;
        this.jPanelCard.add("interval", this.jPanelIntervals);
        this.jPanelCard.add("event", this.jPanelEvents);
        this.jPanelCard.add("none", new JPanel());
        this.jRadioButtonInterval.addChangeListener(this.changeListener);
        this.jRadioButtonEvent.addChangeListener(this.changeListener);
        this.setCards();
        this.setTitle("Select Block Depth Ranges");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        for (ChartBlockBase chartBlockBase : this.chart.getBlocks()) {
            this.wells.addAll(chartBlockBase.getWells());
        }
        this.jComboBoxVersion.removeAllItems();
        HashSet<InterpHdr> hdrs = new HashSet<InterpHdr>();
        try {
            for (Well well : this.wells) {
                well.loadInterps();
                Iterator<WellInterp> it = well.getInterpIterator();
                while (it.hasNext()) {
                    hdrs.add(it.next().getHeader());
                }
            }
        }
        catch (SQLException | SBException throwable) {
            FrameJsbugs.showStackError("SQL Error", (Exception)throwable, this.sbdb);
        }
        Object var2_6 = null;
        for (InterpHdr hdr : hdrs) {
            this.jComboBoxVersion.addItem(hdr);
            if (hdr.getInterpID() != 0) continue;
            InterpHdr interpHdr = hdr;
        }
        this.jComboBoxVersion.setSelectedItem(var2_7);
        this.setVersionLabel();
        this.jComboBoxUnitTop.setRenderer(new UnitRenderer(this.jComboBoxUnitTop));
        this.jComboBoxUnitBase.setRenderer(new UnitRenderer(this.jComboBoxUnitBase));
        if (scheme != null) {
            this.setScheme();
        }
    }

    private void setScheme() {
        if (scheme == null) {
            return;
        }
        this.jTextFieldScheme.setText(scheme.toString());
        this.jComboBoxUnitTop.removeAllItems();
        this.jComboBoxUnitTop.addItem("");
        this.jComboBoxUnitBase.removeAllItems();
        this.jComboBoxUnitBase.addItem("");
        for (IGDUnitBase unit : scheme.getUnitBases()) {
            this.jComboBoxUnitTop.addItem(unit);
            this.jComboBoxUnitBase.addItem(unit);
        }
    }

    private void setCards() {
        String key = "none";
        if (this.jRadioButtonEvent.isSelected()) {
            key = "event";
        } else if (this.jRadioButtonInterval.isSelected()) {
            key = "interval";
        }
        ((CardLayout)this.jPanelCard.getLayout()).show(this.jPanelCard, key);
    }

    private EventType getEvType(boolean isRangeTop) {
        EventType evType = isRangeTop ? (this.jRadioButtonTopEventTop.isSelected() ? EventType.TOP : (this.jRadioButtonTopEventBase.isSelected() ? EventType.BASE : EventType.SINGLE)) : (this.jRadioButtonBaseEventTop.isSelected() ? EventType.TOP : (this.jRadioButtonBaseEventBase.isSelected() ? EventType.BASE : EventType.SINGLE));
        return evType;
    }

    private void setVersionLabel() {
        Object label = "";
        int interpID = ((InterpHdr)this.jComboBoxVersion.getSelectedItem()).getInterpID();
        try {
            for (int i = 0; i < 2; ++i) {
                Object object = i == 0 ? this.top : this.base;
                int nWells = 0;
                if (object == null) continue;
                if (object instanceof IGDUnitBase) {
                    IGDUnitBase topUnit = (IGDUnitBase)object;
                    int igdType = this.sbdb.getIGDScheme(topUnit.getSchID()).getIGDType();
                    block3: for (Well well : this.wells) {
                        for (IGDIntervalZone zone : well.getInterp(interpID).getIGDList(igdType)) {
                            if (zone.getUppZone() != topUnit.getUnitID()) continue;
                            ++nWells;
                            continue block3;
                        }
                    }
                } else if (object instanceof SBEvent) {
                    SBEvent event = (SBEvent)object;
                    EventType evType = this.getEvType(i == 0);
                    block5: for (Well well : this.wells) {
                        for (WellEvent wev : well.getInterp(interpID).getEvents()) {
                            if (wev.getEvent() != event || wev.getTypeObj() != evType) continue;
                            ++nWells;
                            continue block5;
                        }
                    }
                }
                if (!((String)label).isEmpty()) {
                    label = (String)label + ", ";
                }
                label = (String)label + (i == 0 ? "Top " : "Base ") + nWells + "/" + this.wells.size();
            }
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.sbdb);
            label = "";
        }
        this.jLabelVersion.setText((String)label);
    }

    private void initComponents() {
        this.jPanelIntervals = new JPanel();
        this.jLabel2 = new JLabel();
        this.jTextFieldScheme = new JTextField();
        this.jButtonScheme = new JButton();
        this.jComboBoxUnitTop = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jComboBoxUnitBase = new JComboBox();
        this.jPanelEvents = new JPanel();
        this.jLabel4 = new JLabel();
        this.jTextFieldEventTop = new JTextField();
        this.jButtonEventTop = new JButton();
        this.jLabel7 = new JLabel();
        this.jTextFieldEventBase = new JTextField();
        this.jButtonEventBase = new JButton();
        this.jRadioButtonTopEventTop = new JRadioButton();
        this.jRadioButtonTopEventBase = new JRadioButton();
        this.jRadioButtonBaseEventTop = new JRadioButton();
        this.jRadioButtonBaseEventBase = new JRadioButton();
        this.jRadioButtonTopEventSingle = new JRadioButton();
        this.jRadioButtonBaseEventSingle = new JRadioButton();
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabelVersion = new JLabel();
        this.jPanelCard = new JPanel();
        this.jRadioButtonEvent = new JRadioButton();
        this.jRadioButtonInterval = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jComboBoxVersion = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jButton1 = new JButton();
        this.jLabel2.setText("Scheme:");
        this.jTextFieldScheme.setEditable(false);
        this.jTextFieldScheme.setBackground(new Color(255, 255, 204));
        this.jButtonScheme.setText("...");
        this.jButtonScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartBlockDepthRange this$0;
            {
                DialogChartBlockDepthRange dialogChartBlockDepthRange = this$0;
                Objects.requireNonNull(dialogChartBlockDepthRange);
                this.this$0 = dialogChartBlockDepthRange;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSchemeActionPerformed(evt);
            }
        });
        this.jComboBoxUnitTop.setMaximumRowCount(15);
        this.jComboBoxUnitTop.addItemListener(new ItemListener(this){
            final /* synthetic */ DialogChartBlockDepthRange this$0;
            {
                DialogChartBlockDepthRange dialogChartBlockDepthRange = this$0;
                Objects.requireNonNull(dialogChartBlockDepthRange);
                this.this$0 = dialogChartBlockDepthRange;
            }

            @Override
            public void itemStateChanged(ItemEvent evt) {
                this.this$0.jComboBoxUnitTopItemStateChanged(evt);
            }
        });
        this.jLabel3.setText("Top boundary:");
        this.jLabel6.setText("Base boundary:");
        this.jComboBoxUnitBase.setMaximumRowCount(15);
        this.jComboBoxUnitBase.addItemListener(new ItemListener(this){
            final /* synthetic */ DialogChartBlockDepthRange this$0;
            {
                DialogChartBlockDepthRange dialogChartBlockDepthRange = this$0;
                Objects.requireNonNull(dialogChartBlockDepthRange);
                this.this$0 = dialogChartBlockDepthRange;
            }

            @Override
            public void itemStateChanged(ItemEvent evt) {
                this.this$0.jComboBoxUnitBaseItemStateChanged(evt);
            }
        });
        GroupLayout jPanelIntervalsLayout = new GroupLayout(this.jPanelIntervals);
        this.jPanelIntervals.setLayout(jPanelIntervalsLayout);
        jPanelIntervalsLayout.setHorizontalGroup(jPanelIntervalsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelIntervalsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelIntervalsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelIntervalsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldScheme).addComponent(this.jComboBoxUnitTop, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxUnitBase, 0, 240, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonScheme, -2, 30, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelIntervalsLayout.setVerticalGroup(jPanelIntervalsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelIntervalsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelIntervalsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldScheme, -2, -1, -2).addComponent(this.jButtonScheme)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelIntervalsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxUnitTop, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelIntervalsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jComboBoxUnitBase, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel4.setText("Top boundary:");
        this.jTextFieldEventTop.setEditable(false);
        this.jButtonEventTop.setText("...");
        this.jButtonEventTop.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartBlockDepthRange this$0;
            {
                DialogChartBlockDepthRange dialogChartBlockDepthRange = this$0;
                Objects.requireNonNull(dialogChartBlockDepthRange);
                this.this$0 = dialogChartBlockDepthRange;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEventTopActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Base boundary:");
        this.jTextFieldEventBase.setEditable(false);
        this.jButtonEventBase.setText("...");
        this.jButtonEventBase.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartBlockDepthRange this$0;
            {
                DialogChartBlockDepthRange dialogChartBlockDepthRange = this$0;
                Objects.requireNonNull(dialogChartBlockDepthRange);
                this.this$0 = dialogChartBlockDepthRange;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEventBaseActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.jRadioButtonTopEventTop);
        this.jRadioButtonTopEventTop.setText("Top");
        this.buttonGroup2.add(this.jRadioButtonTopEventBase);
        this.jRadioButtonTopEventBase.setText("Base");
        this.buttonGroup3.add(this.jRadioButtonBaseEventTop);
        this.jRadioButtonBaseEventTop.setText("Top");
        this.buttonGroup3.add(this.jRadioButtonBaseEventBase);
        this.jRadioButtonBaseEventBase.setText("Base");
        this.buttonGroup2.add(this.jRadioButtonTopEventSingle);
        this.jRadioButtonTopEventSingle.setText("Single");
        this.buttonGroup3.add(this.jRadioButtonBaseEventSingle);
        this.jRadioButtonBaseEventSingle.setText("Single");
        GroupLayout jPanelEventsLayout = new GroupLayout(this.jPanelEvents);
        this.jPanelEvents.setLayout(jPanelEventsLayout);
        jPanelEventsLayout.setHorizontalGroup(jPanelEventsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelEventsLayout.createSequentialGroup().addGroup(jPanelEventsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelEventsLayout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelEventsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelEventsLayout.createSequentialGroup().addComponent(this.jRadioButtonTopEventTop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonTopEventBase).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonTopEventSingle).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanelEventsLayout.createSequentialGroup().addComponent(this.jTextFieldEventTop, -1, 247, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEventTop, -2, 30, -2)))).addGroup(jPanelEventsLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelEventsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelEventsLayout.createSequentialGroup().addComponent(this.jTextFieldEventBase).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEventBase, -2, 30, -2)).addGroup(jPanelEventsLayout.createSequentialGroup().addComponent(this.jRadioButtonBaseEventTop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonBaseEventBase).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonBaseEventSingle).addGap(0, 0, Short.MAX_VALUE))))).addContainerGap()));
        jPanelEventsLayout.setVerticalGroup(jPanelEventsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelEventsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelEventsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextFieldEventTop, -2, -1, -2).addComponent(this.jButtonEventTop)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelEventsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonTopEventTop).addComponent(this.jRadioButtonTopEventBase).addComponent(this.jRadioButtonTopEventSingle)).addGap(30, 30, 30).addGroup(jPanelEventsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jTextFieldEventBase, -2, -1, -2).addComponent(this.jButtonEventBase)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelEventsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonBaseEventTop).addComponent(this.jRadioButtonBaseEventBase).addComponent(this.jRadioButtonBaseEventSingle)).addContainerGap(30, Short.MAX_VALUE)));
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartBlockDepthRange this$0;
            {
                DialogChartBlockDepthRange dialogChartBlockDepthRange = this$0;
                Objects.requireNonNull(dialogChartBlockDepthRange);
                this.this$0 = dialogChartBlockDepthRange;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartBlockDepthRange this$0;
            {
                DialogChartBlockDepthRange dialogChartBlockDepthRange = this$0;
                Objects.requireNonNull(dialogChartBlockDepthRange);
                this.this$0 = dialogChartBlockDepthRange;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabelVersion.setForeground(new Color(51, 102, 204));
        this.jLabelVersion.setText("info");
        this.jPanelCard.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelCard.setLayout(new CardLayout());
        this.buttonGroup1.add(this.jRadioButtonEvent);
        this.jRadioButtonEvent.setText("Event");
        this.jRadioButtonEvent.setFocusPainted(false);
        this.buttonGroup1.add(this.jRadioButtonInterval);
        this.jRadioButtonInterval.setText("Interval");
        this.jRadioButtonInterval.setFocusPainted(false);
        this.jLabel5.setText("Select range by:");
        this.jLabel12.setText("Version:");
        this.jComboBoxVersion.setMaximumRowCount(30);
        this.jComboBoxVersion.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jButton1.setText("Help");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addComponent(this.jPanelCard, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonInterval).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonEvent).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxVersion, -2, 222, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelVersion, -1, 150, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.jButton1, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonInterval).addComponent(this.jRadioButtonEvent).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelCard, -2, 132, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.jComboBoxVersion, -2, -1, -2).addComponent(this.jLabelVersion, -2, 15, -2)).addGap(13, 13, 13).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK).addComponent(this.jButton1)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonSchemeActionPerformed(ActionEvent evt) {
        HashSet<IGDScheme> schemes = new HashSet<IGDScheme>();
        InterpHdr hdr = (InterpHdr)this.jComboBoxVersion.getSelectedItem();
        int[] igdTypes = new int[]{3, 2, 4};
        try {
            for (Well well : this.wells) {
                for (int igdType : igdTypes) {
                    schemes.addAll(well.getInterp(hdr.getInterpID()).getIGDSchemes(igdType));
                }
            }
        }
        catch (SQLException | SBException sql) {
            SbugsExceptionHandler.showStackError(sql);
        }
        LinkedList list = new LinkedList(schemes);
        Collections.sort(list);
        DialogList dialog = new DialogList((JDialog)((Object)this), true, "Select Scheme", new UserPrefsHelper(this.sbdb), list, true, false);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.getSelection() != null && dialog.getSelection() != scheme) {
            scheme = (IGDScheme)dialog.getSelection();
            this.setScheme();
        }
    }

    private void jComboBoxUnitTopItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            if (this.jComboBoxUnitTop.getSelectedItem() instanceof IGDUnitBase) {
                this.top = this.jComboBoxUnitTop.getSelectedItem();
                if (this.base == null || !(this.base instanceof IGDUnitBase)) {
                    this.jComboBoxUnitBase.setSelectedItem(this.top);
                }
            } else {
                this.top = null;
            }
            this.setVersionLabel();
        }
    }

    private void jComboBoxUnitBaseItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            if (this.jComboBoxUnitBase.getSelectedItem() instanceof IGDUnitBase) {
                this.base = this.jComboBoxUnitBase.getSelectedItem();
                if (this.top == null || !(this.top instanceof IGDUnitBase)) {
                    this.jComboBoxUnitBase.setSelectedItem(this.base);
                }
            } else {
                this.base = null;
            }
            this.setVersionLabel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.top == null && this.base == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No selection!", this.getTitle(), 2);
            return;
        }
        if (this.top == null || this.base == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No " + (this.top == null ? "top" : "base") + " boundary seleced, " + (this.top == null ? "top" : "base") + " depths will not be reset.", this.getTitle(), 2);
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            int interpID = ((InterpHdr)this.jComboBoxVersion.getSelectedItem()).getInterpID();
            for (ChartBlockBase b : this.chart.getBlocks()) {
                if (!(b instanceof WellBlock) || b.getWells().isEmpty()) continue;
                ChartBlock block = (ChartBlock)b;
                try {
                    float topDepth = block.getMDLimit(true);
                    float baseDepth = block.getMDLimit(false);
                    block9: for (int i = 0; i < 2; ++i) {
                        Object object;
                        Object object2 = object = i == 0 ? this.top : this.base;
                        if (object == null) continue;
                        if (object instanceof IGDUnitBase) {
                            IGDUnitBase unit = (IGDUnitBase)object;
                            int igdType = this.sbdb.getIGDScheme(unit.getSchID()).getIGDType();
                            for (IGDIntervalZone zone : block.getWell().getInterp(interpID).getIGDList(igdType)) {
                                if (zone.getUppZone() != unit.getUnitID()) continue;
                                if (i == 0) {
                                    topDepth = (float)zone.getTopSample().getDepth();
                                    continue block9;
                                }
                                baseDepth = (float)zone.getBaseSample().getDepth();
                                continue block9;
                            }
                            continue;
                        }
                        if (!(object instanceof SBEvent)) continue;
                        SBEvent event = (SBEvent)object;
                        EventType evType = this.getEvType(i == 0);
                        for (WellEvent wev : block.getWell().getInterp(interpID).getEvents()) {
                            if (wev.getEvent() != event || wev.getTypeObj() != evType) continue;
                            if (i == 0) {
                                topDepth = (float)wev.getSample().getDepth();
                                continue block9;
                            }
                            baseDepth = (float)wev.getSample().getDepth();
                            continue block9;
                        }
                    }
                    if (topDepth > baseDepth) {
                        float temp = baseDepth;
                        baseDepth = topDepth;
                        topDepth = temp;
                    }
                    block.setScaleLimits(Float.valueOf(topDepth), Float.valueOf(baseDepth));
                }
                catch (InvalidFieldException ife) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Error setting limit on block " + String.valueOf(block) + ": " + ife.getMessage(), this.getTitle(), 2);
                }
                catch (SQLException | SBException sql) {
                    FrameJsbugs.showStackError("Error in block: " + String.valueOf(block), (Exception)sql, this.sbdb);
                }
            }
            this.setOK();
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonEventTopActionPerformed(ActionEvent evt) {
        this.selectEvent(true);
    }

    private void jButtonEventBaseActionPerformed(ActionEvent evt) {
        this.selectEvent(false);
    }

    private void selectEvent(boolean top) {
        int interpID = ((InterpHdr)this.jComboBoxVersion.getSelectedItem()).getInterpID();
        HashSet<SBEvent> events = new HashSet<SBEvent>();
        try {
            for (Well well : this.wells) {
                for (WellEvent event : well.getInterp(interpID).getEvents()) {
                    events.add(event.getEvent());
                }
            }
            LinkedList list = new LinkedList(events);
            Collections.sort(list);
            DialogList dialog = new DialogList((JDialog)((Object)this), true, "Select Event", new UserPrefsHelper(this.sbdb), list, true, false);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                JRadioButton[] jRadioButtonArray;
                SBEvent event = (SBEvent)dialog.getSelection();
                if (top) {
                    JRadioButton[] jRadioButtonArray2 = new JRadioButton[3];
                    jRadioButtonArray2[0] = this.jRadioButtonTopEventTop;
                    jRadioButtonArray2[1] = this.jRadioButtonTopEventBase;
                    jRadioButtonArray = jRadioButtonArray2;
                    jRadioButtonArray2[2] = this.jRadioButtonTopEventSingle;
                } else {
                    JRadioButton[] jRadioButtonArray3 = new JRadioButton[3];
                    jRadioButtonArray3[0] = this.jRadioButtonBaseEventTop;
                    jRadioButtonArray3[1] = this.jRadioButtonBaseEventBase;
                    jRadioButtonArray = jRadioButtonArray3;
                    jRadioButtonArray3[2] = this.jRadioButtonBaseEventSingle;
                }
                JRadioButton[] buttons = jRadioButtonArray;
                buttons[0].setEnabled(event.hasEvType(EventType.TOP));
                buttons[1].setEnabled(event.hasEvType(EventType.BASE));
                buttons[2].setEnabled(event.hasEvType(EventType.SINGLE));
                if (top) {
                    this.top = event;
                    if (!(this.base instanceof SBEvent)) {
                        this.base = null;
                    }
                } else {
                    this.base = event;
                    if (!(this.top instanceof SBEvent)) {
                        this.top = null;
                    }
                }
                this.jTextFieldEventTop.setText(this.top != null ? this.top.toString() : "");
                this.jTextFieldEventBase.setText(this.base != null ? this.base.toString() : "");
                this.setVersionLabel();
            }
        }
        catch (SBException sql) {
            FrameJsbugs.showStackError("Error", (Exception)((Object)sql), this.sbdb);
        }
    }

    private static class UnitRenderer
    extends JLabel
    implements ListCellRenderer {
        private final JComboBox combo;

        UnitRenderer(JComboBox combo) {
            this.combo = combo;
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, 17));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object text = "";
            if (value instanceof IGDUnitBase && this.combo.isPopupVisible()) {
                IGDUnitBase unit = (IGDUnitBase)value;
                for (int i = 1; i < unit.getHier(); ++i) {
                    text = (String)text + "  ";
                }
            }
            text = (String)text + (value != null ? value.toString() : "");
            this.setText((String)text);
            this.setOpaque(isSelected);
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            return this;
        }
    }
}

