/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import jsbchart.block.BlockType;
import jsbchart.block.BlockTypeHelper;
import jsbchart.core.WellBlockOrder;
import jsbugs.DialogList;
import jsbugs.DialogSelectProjectWellList;
import jsbugs.list.WellsListRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import jsbugs.util.UserPrefsHelper;
import jsbugs.wellheader.DialogSelectWell;
import model3.SBdb;
import model3.Well;
import model3.project.Project;
import model3.project.WellList;
import util.SBException;

public class DialogChartBlockImport
extends SBDialog {
    private final SBdb sbdb;
    private final Project chartProject;
    private final boolean multiWell;
    private List<Well> wells;
    private WellList wellList;
    private static WellBlockOrder lastOrder;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonWell;
    private JButton jButtonWellList;
    private JComboBox jComboBoxOrder;
    private JLabel jLabelOrder;
    private JRadioButton jRadioButtonUnassigned;
    private JRadioButton jRadioButtonWell;
    private JRadioButton jRadioButtonWellList;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTextField jTextFieldWell;
    private JTextField jTextFieldWellList;

    public DialogChartBlockImport(Frame parent, boolean modal, SBdb sbdb, BlockType type, Project chartProject, WellList defaultWellList, boolean multiWell) {
        super(parent, modal);
        this.sbdb = sbdb;
        this.chartProject = chartProject;
        this.multiWell = multiWell;
        this.initComponents();
        this.init(type, defaultWellList);
    }

    public DialogChartBlockImport(JDialog parent, boolean modal, SBdb sbdb, BlockType type) {
        super((Window)parent, modal);
        this.sbdb = sbdb;
        this.chartProject = null;
        this.multiWell = false;
        this.initComponents();
        this.init(type, null);
    }

    private void init(BlockType type, WellList defaultWellList) {
        this.setTitle("Select block import option");
        this.jRadioButtonWell.setText("Well" + (this.multiWell ? "(s):" : ":"));
        if (!BlockTypeHelper.canSetSingleWell(type)) {
            this.jRadioButtonWell.setVisible(false);
            this.jTextFieldWell.setVisible(false);
            this.jButtonWell.setVisible(false);
            this.jRadioButtonWellList.setSelected(true);
        }
        if (!BlockTypeHelper.canSetUnassignedWell(type)) {
            this.jRadioButtonUnassigned.setVisible(false);
        }
        if (type != BlockType.WELL) {
            this.jSeparator2.setVisible(false);
            this.jComboBoxOrder.setVisible(false);
            this.jLabelOrder.setVisible(false);
        }
        if (this.chartProject != null) {
            this.wellList = defaultWellList;
            if (this.wellList == null) {
                this.wellList = this.sbdb.getDefaultWellList(this.chartProject.getID());
            }
            if (this.wellList != null) {
                this.jTextFieldWellList.setText(this.wellList.toString());
            } else {
                this.jTextFieldWellList.setText(this.chartProject.toString() + " / <select well list>");
            }
        }
        for (WellBlockOrder order : WellBlockOrder.values()) {
            this.jComboBoxOrder.addItem(order);
        }
        if (lastOrder != null) {
            this.jComboBoxOrder.setSelectedItem((Object)lastOrder);
        } else {
            this.jComboBoxOrder.setSelectedItem((Object)WellBlockOrder.ALPHA);
        }
        this.pack();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jRadioButtonWell = new JRadioButton();
        this.jRadioButtonWellList = new JRadioButton();
        this.jTextFieldWellList = new JTextField();
        this.jButtonWellList = new JButton();
        this.jRadioButtonUnassigned = new JRadioButton();
        this.jTextFieldWell = new JTextField();
        this.jButtonWell = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jLabelOrder = new JLabel();
        this.jComboBoxOrder = new JComboBox();
        this.jSeparator2 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.buttonGroup1.add(this.jRadioButtonWell);
        this.jRadioButtonWell.setText("Well(s):");
        this.jRadioButtonWell.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartBlockImport this$0;
            {
                DialogChartBlockImport dialogChartBlockImport = this$0;
                Objects.requireNonNull(dialogChartBlockImport);
                this.this$0 = dialogChartBlockImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonWellActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonWellList);
        this.jRadioButtonWellList.setText("Well list:");
        this.jRadioButtonWellList.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartBlockImport this$0;
            {
                DialogChartBlockImport dialogChartBlockImport = this$0;
                Objects.requireNonNull(dialogChartBlockImport);
                this.this$0 = dialogChartBlockImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonWellListActionPerformed(evt);
            }
        });
        this.jTextFieldWellList.setEditable(false);
        this.jButtonWellList.setText("...");
        this.jButtonWellList.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonWellList.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartBlockImport this$0;
            {
                DialogChartBlockImport dialogChartBlockImport = this$0;
                Objects.requireNonNull(dialogChartBlockImport);
                this.this$0 = dialogChartBlockImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonWellListActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonUnassigned);
        this.jRadioButtonUnassigned.setText("Unassigned (template)");
        this.jTextFieldWell.setEditable(false);
        this.jButtonWell.setText("...");
        this.jButtonWell.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonWell.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartBlockImport this$0;
            {
                DialogChartBlockImport dialogChartBlockImport = this$0;
                Objects.requireNonNull(dialogChartBlockImport);
                this.this$0 = dialogChartBlockImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonWellActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartBlockImport this$0;
            {
                DialogChartBlockImport dialogChartBlockImport = this$0;
                Objects.requireNonNull(dialogChartBlockImport);
                this.this$0 = dialogChartBlockImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartBlockImport this$0;
            {
                DialogChartBlockImport dialogChartBlockImport = this$0;
                Objects.requireNonNull(dialogChartBlockImport);
                this.this$0 = dialogChartBlockImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartBlockImport this$0;
            {
                DialogChartBlockImport dialogChartBlockImport = this$0;
                Objects.requireNonNull(dialogChartBlockImport);
                this.this$0 = dialogChartBlockImport;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabelOrder.setText("Order:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator2).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 151, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addComponent(this.jLabelOrder).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxOrder, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButtonUnassigned).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonWell).addComponent(this.jRadioButtonWellList)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldWell).addComponent(this.jTextFieldWellList)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonWellList, -2, 30, -2).addComponent(this.jButtonWell, -2, 30, -2)))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(17, 17, 17).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldWell, -2, -1, -2).addComponent(this.jRadioButtonWell).addComponent(this.jButtonWell)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonWellList).addComponent(this.jTextFieldWellList, -2, -1, -2).addComponent(this.jButtonWellList)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonUnassigned, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelOrder).addComponent(this.jComboBoxOrder, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonWellActionPerformed(ActionEvent evt) {
        if (this.chartProject == null) {
            DialogSelectWell dialog = new DialogSelectWell((JDialog)((Object)this), true, this.sbdb, this.multiWell, null);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                this.wells = new ArrayList<Well>();
                this.wells.addAll(dialog.getSelection());
            }
        } else {
            LinkedList<Well> pWells = new LinkedList<Well>();
            try {
                Project project = this.sbdb.getProject(this.chartProject.getID());
                for (WellList wellList : this.sbdb.getWellListService().getWellLists(project.getID())) {
                    Iterator<Well> it = this.sbdb.getWellIterator(wellList.getID());
                    while (it.hasNext()) {
                        Well well = it.next();
                        if (pWells.contains(well)) continue;
                        pWells.add(well);
                    }
                }
            }
            catch (SQLException | SBException sql) {
                SbugsExceptionHandler.showStackError(sql, (Component)((Object)this));
            }
            if (pWells.isEmpty()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Project '" + this.chartProject.getName() + "' has no wells", this.getTitle(), 2);
                this.wells = null;
                return;
            }
            Collections.sort(pWells);
            DialogList dialog = new DialogList((JDialog)((Object)this), true, "Select Well From " + this.chartProject.getName(), new UserPrefsHelper(this.sbdb), pWells, true, this.multiWell, (ListCellRenderer)new WellsListRenderer());
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            this.wells = new ArrayList<Well>();
            if (dialog.getSelected() != null) {
                this.wells.addAll(dialog.getSelected());
            } else if (dialog.getSelection() != null) {
                this.wells.add((Well)dialog.getSelection());
            }
        }
        if (this.wells != null && !this.wells.isEmpty()) {
            this.jRadioButtonWell.setSelected(true);
            this.jTextFieldWell.setText(this.wells.toString());
        } else {
            this.wells = null;
        }
    }

    private void jButtonWellListActionPerformed(ActionEvent evt) {
        try {
            DialogSelectProjectWellList dialog = new DialogSelectProjectWellList((Window)((Object)this), this.sbdb, this.chartProject, null);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                this.wellList = dialog.getSelection();
                this.jRadioButtonWellList.setSelected(true);
                this.jTextFieldWellList.setText(this.wellList.toString());
            }
        }
        catch (RuntimeException sSql) {
            SbugsExceptionHandler.showDialogStackError(sSql, (Component)((Object)this));
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.buttonGroup1.getSelection() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Make a selection", this.getTitle(), 2);
            return;
        }
        if (this.jRadioButtonWell.isSelected()) {
            if (this.wells == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Select a well", this.getTitle(), 2);
                return;
            }
            this.wellList = null;
        } else if (this.jRadioButtonWellList.isSelected()) {
            if (this.wellList == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Select a well list", this.getTitle(), 2);
                return;
            }
            this.wells = null;
        } else {
            this.wellList = null;
            this.wells = null;
        }
        this.setOK();
    }

    private void jRadioButtonWellListActionPerformed(ActionEvent evt) {
        if (this.chartProject == null && this.wellList == null && this.jRadioButtonWellList.isSelected()) {
            this.jButtonWellListActionPerformed(null);
        }
    }

    private void jRadioButtonWellActionPerformed(ActionEvent evt) {
        if (this.wells == null && this.jRadioButtonWell.isSelected()) {
            this.jButtonWellActionPerformed(null);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"charts_charts.html#blockimport");
    }

    public Object getObject() {
        try {
            return this.getObject(null);
        }
        catch (SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e);
            return null;
        }
    }

    public Object getObject(BlockType type) throws SQLException, SBException {
        if (this.wells != null) {
            return this.wells;
        }
        if (this.wellList != null) {
            if (type == BlockType.WELL) {
                ArrayList<Well> projectWells = new ArrayList<Well>();
                Iterator<Well> it = this.sbdb.getWellIterator(this.wellList.getID());
                while (it.hasNext()) {
                    projectWells.add(it.next());
                }
                return projectWells;
            }
            return this.wellList;
        }
        return null;
    }

    WellBlockOrder getOrder() {
        return (WellBlockOrder)((Object)this.jComboBoxOrder.getSelectedItem());
    }
}

