/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbchart.core.TemplateDescr;
import jsbugs.FrameChart;
import jsbugs.FrameJsbugs;
import jsbugs.uiutil.audit.JPanelAuditColumn;
import jsbugs.userconnect.SbugsSession;
import model3.SBdb;
import model3.Well;
import model3.project.Project;
import model3.project.WellList;
import util.SB;

public class DialogChartDesc
extends SBDialog {
    private static final int NAME_LENGTH = 150;
    private static final int COMMENT_LENGTH = 255;
    private static final String GLOBAL_STRING = "Global";
    private final DefaultComboBoxModel model = new DefaultComboBoxModel();
    private final DefaultComboBoxModel modelWellList = new DefaultComboBoxModel();
    private boolean projectsInitialised;
    String name;
    String comments;
    int projID;
    int wellListID = 0;
    boolean canUseWellList = false;
    private Box.Filler filler1;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JComboBox jComboBoxProject;
    private JComboBox jComboBoxWellist;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelWellList;
    private JPanelAuditColumn jPanelAudit;
    private JScrollPane jScrollPane1;
    private JTextArea jTextAreaDescription;
    private JTextField jTextFieldName;

    public DialogChartDesc(JDialog parent, SBdb sbdb, TemplateDescr descr, boolean canWrite, boolean canUseWelllist) {
        super((Window)parent, true);
        this.initComponents();
        this.init("Edit Template : " + descr.getName(), descr.getName(), descr.getComments(), canWrite, true, canUseWelllist);
    }

    public DialogChartDesc(Frame parent, String dialogTitle, String title, String comments, boolean canWrite, boolean canUseWelllist) {
        super(parent, true);
        this.initComponents();
        this.init(dialogTitle, title, comments, canWrite, true, canUseWelllist);
    }

    public DialogChartDesc(FrameChart parent, String dialogTitle, TemplateDescr descr, boolean canWrite, boolean canUseWellList) {
        super((Frame)parent, true);
        this.initComponents();
        this.init(dialogTitle, descr.getName(), descr.getComments(), canWrite, false, canUseWellList);
        if (descr.hasWellList()) {
            this.canUseWellList = true;
        }
        this.jPanelAudit.setAuditText(descr.getCreator(), descr.getCreated(), descr.getModifier(), descr.getModified());
    }

    private void init(String dialogTitle, String title, String comments, boolean canWrite, boolean hideAudit, boolean canUseWellList) {
        this.canUseWellList = canUseWellList;
        if (title != null) {
            this.jTextFieldName.setText(title);
        }
        if (comments != null) {
            this.jTextAreaDescription.setText(comments);
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.setTitle(dialogTitle);
        if (!canUseWellList) {
            this.jLabelWellList.setEnabled(false);
            this.jComboBoxWellist.setEnabled(false);
        }
        if (!canWrite) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText("This template is read-only. Use Permissions... menu option to change status.");
        }
        if (hideAudit) {
            this.jPanelAudit.setVisible(false);
            this.pack();
        }
    }

    void restrictProjectToAny(int preferredProject) throws SQLException {
        this.jComboBoxProject.removeAllItems();
        this.model.addElement(GLOBAL_STRING);
        SbugsSession.getDb().loadProjectCombo(this.model, false);
        if (preferredProject > 0) {
            this.jComboBoxProject.setSelectedItem((Object)SbugsSession.getDb().getProject(preferredProject));
        }
        this.projectsInitialised = true;
    }

    void restrictProjectToGlobal() throws SQLException {
        this.restrictProjectToProject(0, true);
    }

    void setWellList(int wellListID) {
        if (this.canUseWellList) {
            this.refreshWellList();
            for (int i = 0; i < this.modelWellList.getSize(); ++i) {
                WellList wl;
                Object o = this.modelWellList.getElementAt(i);
                if (!(o instanceof WellList) || (wl = (WellList)((Object)o)).getID() != wellListID) continue;
                this.jComboBoxWellist.setSelectedItem((Object)wl);
                break;
            }
        }
    }

    void refreshWellList() {
        if (this.canUseWellList) {
            Object origWellList = this.jComboBoxWellist.getSelectedItem();
            this.jComboBoxWellist.removeAllItems();
            this.modelWellList.removeAllElements();
            this.jComboBoxWellist.repaint();
            Object object = this.jComboBoxProject.getSelectedItem();
            if (object instanceof Project) {
                Project p = (Project)((Object)object);
                this.jLabelWellList.setEnabled(true);
                this.jComboBoxWellist.setEnabled(true);
                List wellLists = SbugsSession.getDb().getWellListService().getWellLists(p.getID());
                this.modelWellList.addAll(wellLists);
                this.jComboBoxWellist.setSelectedItem(origWellList);
            } else {
                this.jLabelWellList.setEnabled(false);
                this.jComboBoxWellist.setEnabled(false);
            }
        }
    }

    void restrictProjectToProject(int projID, boolean includeGlobal) throws SQLException {
        this.jComboBoxProject.removeAllItems();
        if (includeGlobal || projID == 0) {
            this.model.addElement(GLOBAL_STRING);
        }
        if (projID > 0) {
            Project p = SbugsSession.getDb().getProject(projID);
            this.jComboBoxProject.addItem(p);
            this.jComboBoxProject.setSelectedItem((Object)p);
        }
        this.projectsInitialised = true;
    }

    void restrictProjectToWell(Well well, boolean includeGlobal) throws SQLException {
        this.restrictProjectToWell(well, includeGlobal, 0);
    }

    void restrictProjectToWell(Well well, boolean includeGlobal, int preferredProject) throws SQLException {
        this.jComboBoxProject.removeAllItems();
        if (includeGlobal) {
            this.model.addElement(GLOBAL_STRING);
        }
        for (int id : well.getDataModel().getProjIDs(well)) {
            Project project = SbugsSession.getDb().getProject(id);
            this.jComboBoxProject.addItem(project);
        }
        if (well.getDataModel().getProjIDs(well).size() > 0) {
            this.jComboBoxProject.setSelectedIndex(1);
        } else if (preferredProject > 0) {
            this.jComboBoxProject.setSelectedItem((Object)SbugsSession.getDb().getProject(preferredProject));
        }
        this.projectsInitialised = true;
    }

    public void setVisible(boolean b) {
        if (b && !this.projectsInitialised) {
            throw new IllegalStateException("Projects not initialised in DialogChartDesc");
        }
        super.setVisible(b);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaDescription = new JTextArea();
        this.jTextFieldName = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel3 = new JLabel();
        this.jComboBoxProject = new JComboBox();
        this.filler1 = new Box.Filler(new Dimension(0, 7), new Dimension(0, 7), new Dimension(Short.MAX_VALUE, 7));
        this.jButtonHelp = new JButton();
        this.jLabelWellList = new JLabel();
        this.jComboBoxWellist = new JComboBox();
        this.jPanelAudit = new JPanelAuditColumn();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(412, 250));
        this.jLabel1.setText("Name:");
        this.jLabel2.setText("Description:");
        this.jTextAreaDescription.setColumns(20);
        this.jTextAreaDescription.setFont(this.jTextAreaDescription.getFont());
        this.jTextAreaDescription.setLineWrap(true);
        this.jTextAreaDescription.setRows(5);
        this.jTextAreaDescription.setWrapStyleWord(true);
        this.jTextAreaDescription.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogChartDesc this$0;
            {
                DialogChartDesc dialogChartDesc = this$0;
                Objects.requireNonNull(dialogChartDesc);
                this.this$0 = dialogChartDesc;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextAreaDescriptionKeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextAreaDescription);
        this.jTextFieldName.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogChartDesc this$0;
            {
                DialogChartDesc dialogChartDesc = this$0;
                Objects.requireNonNull(dialogChartDesc);
                this.this$0 = dialogChartDesc;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldNameKeyTyped(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartDesc this$0;
            {
                DialogChartDesc dialogChartDesc = this$0;
                Objects.requireNonNull(dialogChartDesc);
                this.this$0 = dialogChartDesc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartDesc this$0;
            {
                DialogChartDesc dialogChartDesc = this$0;
                Objects.requireNonNull(dialogChartDesc);
                this.this$0 = dialogChartDesc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Project:");
        this.jComboBoxProject.setMaximumRowCount(30);
        this.jComboBoxProject.setModel(this.model);
        this.jComboBoxProject.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jComboBoxProject.addItemListener(new ItemListener(this){
            final /* synthetic */ DialogChartDesc this$0;
            {
                DialogChartDesc dialogChartDesc = this$0;
                Objects.requireNonNull(dialogChartDesc);
                this.this$0 = dialogChartDesc;
            }

            @Override
            public void itemStateChanged(ItemEvent evt) {
                this.this$0.jComboBoxProjectItemStateChanged(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogChartDesc this$0;
            {
                DialogChartDesc dialogChartDesc = this$0;
                Objects.requireNonNull(dialogChartDesc);
                this.this$0 = dialogChartDesc;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabelWellList.setText("Default well list:");
        this.jComboBoxWellist.setMaximumRowCount(30);
        this.jComboBoxWellist.setModel(this.modelWellList);
        this.jComboBoxWellist.setToolTipText("Default for selection and searching (optional)");
        this.jComboBoxProject.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jPanelAudit.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(78, 78, 78).addComponent(this.filler1, -1, 56, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelWellList).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxWellist, 0, -1, Short.MAX_VALUE)).addComponent(this.jTextFieldName).addComponent(this.jPanelAudit, -2, 0, Short.MAX_VALUE).addComponent(this.jScrollPane1).addComponent(this.jComboBoxProject, 0, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jComboBoxProject, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelWellList).addComponent(this.jComboBoxWellist, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 137, Short.MAX_VALUE).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelAudit, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filler1, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK).addComponent(this.jButtonHelp))).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        Object object;
        this.name = this.jTextFieldName.getText().trim();
        if (this.name.isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Enter a name", this.getTitle(), 2);
            return;
        }
        if (this.name.length() > 150) {
            this.name = this.name.substring(0, 149);
        }
        this.comments = this.jTextAreaDescription.getText();
        if (this.comments.length() > 255) {
            this.comments = this.comments.substring(0, 254);
        }
        if ((object = this.jComboBoxProject.getSelectedItem()) instanceof Project) {
            Project project = (Project)((Object)object);
            this.projID = project.getID();
        } else {
            this.projID = 0;
        }
        object = this.jComboBoxWellist.getSelectedItem();
        if (object instanceof WellList) {
            WellList wellList = (WellList)((Object)object);
            this.wellListID = wellList.getID();
        } else {
            this.wellListID = 0;
        }
        this.setOK();
    }

    private void jTextAreaDescriptionKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextArea)this.jTextAreaDescription, (int)255, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldName, (int)150, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("charts_overview.html#templates");
    }

    private void jComboBoxProjectItemStateChanged(ItemEvent evt) {
        this.refreshWellList();
    }
}

