/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.image.EditableImageSet;
import com.stratadata.model3.image.ImageLoader;
import com.stratadata.model3.image.ImageRecordService;
import com.stratadata.model3.well.SectionType;
import com.stratadata.util.depth.DepthUnits;
import com.stratadata.util.depth.DepthUtils;
import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.table.TableUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jsbugs.DialogCoreImage;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.CoreImage;
import model3.Well;
import org.jdesktop.layout.GroupLayout;
import util.SBException;

public class DialogCoreImages
extends JDialog {
    private final TableModelCoreImages model;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JScrollPane jScrollPane1;
    private JTable jTableCoreImages;

    public DialogCoreImages(Frame parent, boolean modal, Well well) throws SQLException, SBException {
        super(parent, modal);
        this.model = new TableModelCoreImages(well);
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        TableUtils.setTableHeaderBold((JTable)this.jTableCoreImages);
        TableColumnModel columnModel = this.jTableCoreImages.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelCoreImages.COL_TITLES[i]);
            columnModel.getColumn(i).setWidth(TableModelCoreImages.COL_WIDTHS[i]);
        }
        this.jTableCoreImages.setRowHeight(TableModelCoreImages.IMAGE_ROW_HEIGHT.height);
        this.setTitle("Core Images: " + this.model.well.getWellName());
        this.model.setTableData();
        this.jTableCoreImages.updateUI();
        this.getRootPane().setDefaultButton(this.jButtonClose);
        if (!this.model.well.canWrite(this.model.well.getDataModel(), null)) {
            this.jButtonDelete.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jButtonAdd = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableCoreImages = new JTable();
        this.jButtonEdit = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(350, 400));
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCoreImages this$0;
            {
                DialogCoreImages dialogCoreImages = this$0;
                Objects.requireNonNull(dialogCoreImages);
                this.this$0 = dialogCoreImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCoreImages this$0;
            {
                DialogCoreImages dialogCoreImages = this$0;
                Objects.requireNonNull(dialogCoreImages);
                this.this$0 = dialogCoreImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCoreImages this$0;
            {
                DialogCoreImages dialogCoreImages = this$0;
                Objects.requireNonNull(dialogCoreImages);
                this.this$0 = dialogCoreImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jTableCoreImages.setModel(this.model);
        this.jTableCoreImages.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogCoreImages this$0;
            {
                DialogCoreImages dialogCoreImages = this$0;
                Objects.requireNonNull(dialogCoreImages);
                this.this$0 = dialogCoreImages;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableCoreImagesMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableCoreImages);
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCoreImages this$0;
            {
                DialogCoreImages dialogCoreImages = this$0;
                Objects.requireNonNull(dialogCoreImages);
                this.this$0 = dialogCoreImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCoreImages this$0;
            {
                DialogCoreImages dialogCoreImages = this$0;
                Objects.requireNonNull(dialogCoreImages);
                this.this$0 = dialogCoreImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 277, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jButtonAdd).add((Component)this.jButtonDelete).add((Component)this.jButtonEdit)).add((Component)this.jButtonHelp).add((Component)this.jButtonClose, -2, 63, -2)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonAdd, this.jButtonDelete}, 1);
        layout.linkSize(new Component[]{this.jButtonClose, this.jButtonHelp}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp).add(8, 8, 8).add((Component)this.jButtonClose)).add((Component)this.jScrollPane1, -1, 492, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jTableCoreImagesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            double defaultTop = this.model.coreImages.isEmpty() ? 0.0 : this.model.coreImages.get(this.model.coreImages.size() - 1).getBaseDepth();
            DialogCoreImage dialog = new DialogCoreImage(this, true, this.model.well.getDataModel(), this.model.well, null, this.model.well.getHeader().getDepthUnits(), defaultTop);
            if (GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().width - this.getX() - this.getWidth() > dialog.getWidth()) {
                dialog.setLocation(this.getX() + this.getWidth(), this.getY());
            } else {
                dialog.setLocationRelativeTo(this);
            }
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.model.setTableData();
                this.model.fireTableDataChanged();
                int index = this.model.coreImages.indexOf(dialog.added);
                this.jTableCoreImages.getSelectionModel().setSelectionInterval(index, index);
                this.jTableCoreImages.scrollRectToVisible(this.jTableCoreImages.getCellRect(index, 0, false));
            }
        }
        catch (RuntimeException | SQLException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableCoreImages.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 1);
            return;
        }
        try {
            LinkedList<CoreImage> toDelete = new LinkedList<CoreImage>();
            for (int row : this.jTableCoreImages.getSelectedRows()) {
                CoreImage coreImage = this.model.coreImages.get(row);
                DepthUnits units = this.model.well.getHeader().getDepthUnits();
                int option = JOptionPane.showConfirmDialog(this, "Really delete: " + DepthUtils.depthString((double)coreImage.getTopDepth(), (DepthUnits)units, (int)2, (SectionType)this.model.well.getSectionType()) + " - " + DepthUtils.depthString((double)coreImage.getBaseDepth(), (DepthUnits)units, (int)2, (SectionType)this.model.well.getSectionType()) + "?", this.getTitle(), 0, 3);
                if (option != 0) continue;
                toDelete.add(coreImage);
            }
            Object object = toDelete.iterator();
            while (object.hasNext()) {
                CoreImage coreImage = (CoreImage)object.next();
                this.model.well.deleteCoreImage(coreImage);
                this.model.well.getDataModel().commit();
            }
            this.jTableCoreImages.clearSelection();
            this.model.fireTableDataChanged();
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        int row = this.jTableCoreImages.getSelectedRow();
        if (row < 0) {
            JOptionPane.showMessageDialog(this, "No images selected", this.getTitle(), 1);
            return;
        }
        CoreImage core = this.model.coreImages.get(row);
        try {
            DialogCoreImage dialog = new DialogCoreImage(this, true, this.model.well.getDataModel(), this.model.well, core, this.model.well.getHeader().getDepthUnits(), 0.0);
            dialog.setLocation(this.getLocation().x + 25, this.getLocation().y + 25);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.model.setTableData();
                this.model.fireTableDataChanged();
                int index = this.model.coreImages.indexOf(dialog.added);
                this.jTableCoreImages.getSelectionModel().setSelectionInterval(index, index);
                this.jTableCoreImages.scrollRectToVisible(this.jTableCoreImages.getCellRect(index, 0, false));
            }
        }
        catch (RuntimeException | SQLException e) {
            SbugsExceptionHandler.showStackError(e, this);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogcoreimages.html");
    }

    private static class TableModelCoreImages
    extends AbstractTableModel {
        private static final String[] COL_TITLES = new String[]{"Top", "Base", "Number", "Image"};
        private static final int[] COL_WIDTHS = new int[]{30, 30, 30, 40};
        private static final Dimension IMAGE_ROW_HEIGHT = new Dimension(150, 150);
        private final Well well;
        private List<CoreImage> coreImages;
        private EditableImageSet imageSet;
        private ImageRecordService imageRecordService;
        private ImageLoader imageLoader;

        public TableModelCoreImages(Well well) {
            this.well = well;
        }

        void setTableData() throws SQLException {
            this.imageRecordService = this.well.getDataModel().getImageRecordService();
            this.coreImages = this.well.getCoreImages();
            this.imageLoader = this.well.getDataModel().getImageLoader();
            this.imageSet = new EditableImageSet(this.imageLoader);
            for (CoreImage coreImage : this.coreImages) {
                this.imageSet.addImageRecord(this.imageRecordService.getImageRecord(coreImage.getImageID()));
            }
        }

        @Override
        public int getColumnCount() {
            return COL_TITLES.length;
        }

        @Override
        public int getRowCount() {
            if (this.coreImages == null) {
                return 0;
            }
            return this.coreImages.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            CoreImage core = this.coreImages.get(row);
            switch (col) {
                case 0: {
                    return DepthUtils.depthString((double)core.getTopDepth(), (DepthUnits)this.well.getHeader().getDepthUnits(), (int)2, (SectionType)this.well.getSectionType());
                }
                case 1: {
                    return DepthUtils.depthString((double)core.getBaseDepth(), (DepthUnits)this.well.getHeader().getDepthUnits(), (int)2, (SectionType)this.well.getSectionType());
                }
                case 2: {
                    String coreNumTop = this.well.getCoreNumber(core.getTopDepth());
                    String coreNumBase = this.well.getCoreNumber(core.getBaseDepth());
                    if (coreNumTop.equals(coreNumBase)) {
                        return coreNumTop;
                    }
                    return coreNumTop + " - " + coreNumBase;
                }
                case 3: {
                    try {
                        return this.imageSet.getImage(this.imageRecordService, this.imageLoader, core.getImageID(), IMAGE_ROW_HEIGHT);
                    }
                    catch (Exception e) {
                        return e.getMessage();
                    }
                }
            }
            return "";
        }

        public Class getColumnClass(int c) {
            return switch (c) {
                case 0, 1, 2 -> String.class;
                case 3 -> ImageIcon.class;
                default -> Object.class;
            };
        }
    }
}

