/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.user.Userdef;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import jsbugs.JTableCountryRoles;
import jsbugs.TableModelSampleLithology;
import model3.SBdb;
import model3.WellHeader;
import util.SB;

public class DialogCountryRoles
extends JDialog {
    private static final int COL_COUNTRY = 0;
    private static final int COL_ASSIGNED = 1;
    private static String[] columnHeaders = new String[]{"Country", "Assigned"};
    private static int[] columnWidths = new int[]{120, 30, 50, 10, 20};
    private final DefaultListModel userModel = new DefaultListModel();
    private final TableModelCountry model = new TableModelCountry(this);
    private String SQLDatabaseUsername = null;
    SBdb db;
    private ButtonGroup buttonGroup1;
    private JButton jButtonApply;
    private JButton jButtonApplyHiddenSchemes;
    private JButton jButtonClose;
    private JCheckBox jCheckBoxHiddenSchemes;
    private JLabel jLabel1;
    private JList<String> jListUsers;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRadioButton jRadioButtonAll;
    private JRadioButton jRadioButtonRestricted;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTableCountryRoles jTableCountryRoles;

    public DialogCountryRoles(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public DialogCountryRoles(JDialog parent, boolean modal, SBdb db, Userdef user) throws SQLException {
        super((Dialog)parent, modal);
        this.db = db;
        this.initComponents();
        this.init(user);
    }

    private void init(Userdef user) throws SQLException {
        this.setTitle("User Country Restrictions");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        Collection<Userdef> users = this.db.getUsers();
        LinkedList<String> userList = new LinkedList<String>();
        for (Userdef u : users) {
            if (u.getPriv() <= 0) continue;
            userList.add(this.getListStringFromUserdef(u));
        }
        Collections.sort(userList);
        for (String s : userList) {
            this.userModel.addElement(s);
        }
        this.jListUsers.repaint();
        SB.setTableHeaderBold((JTable)this.jTableCountryRoles);
        for (int i = 0; i < TableModelSampleLithology.colTitles.length; ++i) {
            this.jTableCountryRoles.getColumnModel().getColumn(i).setHeaderValue(columnHeaders[i]);
            this.jTableCountryRoles.getColumnModel().getColumn(i).setPreferredWidth(columnWidths[i]);
        }
        this.jTableCountryRoles.setRowSorter(new TableRowSorter<TableModelCountry>(this.model));
        List<String> list = WellHeader.getCountries(this.db);
        for (String country : list) {
            this.model.roles.add(new CountryRole(this, country.replaceAll(" ", "_")));
        }
        if (user != null) {
            this.jListUsers.setSelectedValue(this.getListStringFromUserdef(user), true);
        }
    }

    private String getListStringFromUserdef(Userdef u) {
        return u.getName() + " [" + u.getAbr() + "]";
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListUsers = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.jTableCountryRoles = new JTableCountryRoles();
        this.jButtonApply = new JButton();
        this.jButtonClose = new JButton();
        this.jPanel1 = new JPanel();
        this.jRadioButtonAll = new JRadioButton();
        this.jRadioButtonRestricted = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jCheckBoxHiddenSchemes = new JCheckBox();
        this.jButtonApplyHiddenSchemes = new JButton();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("User");
        this.jListUsers.setModel(this.userModel);
        this.jListUsers.setSelectionMode(0);
        this.jListUsers.addListSelectionListener(new ListSelectionListener(this){
            final /* synthetic */ DialogCountryRoles this$0;
            {
                DialogCountryRoles dialogCountryRoles = this$0;
                Objects.requireNonNull(dialogCountryRoles);
                this.this$0 = dialogCountryRoles;
            }

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                this.this$0.jListUsersValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListUsers);
        this.jTableCountryRoles.setModel(this.model);
        this.jScrollPane2.setViewportView(this.jTableCountryRoles);
        this.jButtonApply.setText("Apply");
        this.jButtonApply.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCountryRoles this$0;
            {
                DialogCountryRoles dialogCountryRoles = this$0;
                Objects.requireNonNull(dialogCountryRoles);
                this.this$0 = dialogCountryRoles;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonApplyActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCountryRoles this$0;
            {
                DialogCountryRoles dialogCountryRoles = this$0;
                Objects.requireNonNull(dialogCountryRoles);
                this.this$0 = dialogCountryRoles;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "User country restriction", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroup1.add(this.jRadioButtonAll);
        this.jRadioButtonAll.setText("All countries (no restriction)");
        this.jRadioButtonAll.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCountryRoles this$0;
            {
                DialogCountryRoles dialogCountryRoles = this$0;
                Objects.requireNonNull(dialogCountryRoles);
                this.this$0 = dialogCountryRoles;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonAllActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonRestricted);
        this.jRadioButtonRestricted.setText("Restricted as below");
        this.jRadioButtonRestricted.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCountryRoles this$0;
            {
                DialogCountryRoles dialogCountryRoles = this$0;
                Objects.requireNonNull(dialogCountryRoles);
                this.this$0 = dialogCountryRoles;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonRestrictedActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonAll).addGap(18, 18, 18).addComponent(this.jRadioButtonRestricted).addContainerGap(9, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonAll).addComponent(this.jRadioButtonRestricted))));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("User scheme restriction"));
        this.jCheckBoxHiddenSchemes.setText("Don't show hidden schemes & composite standards");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(32, Short.MAX_VALUE).addComponent(this.jCheckBoxHiddenSchemes, -2, 289, -2).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jCheckBoxHiddenSchemes).addGap(0, 10, Short.MAX_VALUE)));
        this.jButtonApplyHiddenSchemes.setText("Apply");
        this.jButtonApplyHiddenSchemes.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCountryRoles this$0;
            {
                DialogCountryRoles dialogCountryRoles = this$0;
                Objects.requireNonNull(dialogCountryRoles);
                this.this$0 = dialogCountryRoles;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonApplyHiddenSchemesActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonApply).addComponent(this.jButtonClose, GroupLayout.Alignment.TRAILING))).addComponent(this.jLabel1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonApplyHiddenSchemes)).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1).addGap(78, 78, 78))).addContainerGap()));
        layout.linkSize(0, this.jPanel1, this.jPanel2);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jScrollPane1, -2, 167, -2).addGap(14, 14, 14).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(206, 206, 206).addComponent(this.jButtonApplyHiddenSchemes).addGap(42, 42, 42).addComponent(this.jButtonApply))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane2, -1, 424, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jListUsersValueChanged(ListSelectionEvent evt) {
        this.buttonGroup1.clearSelection();
        this.jCheckBoxHiddenSchemes.setSelected(false);
        this.SQLDatabaseUsername = null;
        for (CountryRole r : this.model.roles) {
            r.assigned = false;
            r.originallyAssigned = false;
        }
        Object sql = "";
        try (Statement stmt = this.db.getDatabase().createStatement();){
            Userdef user = this.getUserFromListSelection();
            if (user == null) {
                return;
            }
            sql = "SELECT rpr.name, rpu.name as username FROM sys.database_principals rpr, sys.database_principals rpu, sys.database_role_members drm WHERE drm.role_principal_id=rpr.principal_id AND drm.member_principal_id=rpu.principal_id AND rpu.sid=SUSER_SID('" + user.getSysName() + "')";
            ResultSet rs = stmt.executeQuery((String)sql);
            boolean roleFound = false;
            while (rs.next()) {
                roleFound = true;
                String role = rs.getString("name");
                this.SQLDatabaseUsername = rs.getString("username");
                if (role.equalsIgnoreCase("COUNTRY_ALL")) {
                    this.jRadioButtonAll.setSelected(true);
                    this.jTableCountryRoles.setEnabled(false);
                    for (CountryRole r : this.model.roles) {
                        r.assigned = false;
                    }
                    continue;
                }
                if (role.equalsIgnoreCase("HIDE_SCHEMES")) {
                    this.jCheckBoxHiddenSchemes.setSelected(true);
                    continue;
                }
                if (!role.startsWith("COUNTRY_")) continue;
                this.jRadioButtonRestricted.setSelected(true);
                for (CountryRole r : this.model.roles) {
                    if (!role.equalsIgnoreCase("COUNTRY_" + r.country)) continue;
                    r.assigned = true;
                    r.originallyAssigned = true;
                }
                this.jTableCountryRoles.setEnabled(true);
            }
            this.model.fireTableDataChanged();
            if (!roleFound) {
                JOptionPane.showMessageDialog(this, "Warning: no database roles found for user: " + user.getSysName(), this.getTitle(), 2);
                System.out.println((String)sql);
            }
        }
        catch (SQLException sqle) {
            JOptionPane.showMessageDialog(this, sqle.getMessage(), "SQL Error", 0);
            System.out.println((String)sql);
            sqle.printStackTrace();
        }
    }

    private void jButtonApplyActionPerformed(ActionEvent evt) {
        Object sql = "";
        if (this.SQLDatabaseUsername == null) {
            JOptionPane.showMessageDialog(this, "Database username is null or not assigned!", this.getTitle(), 2);
            return;
        }
        if (this.SQLDatabaseUsername.equalsIgnoreCase("dbo")) {
            JOptionPane.showMessageDialog(this, "Cannot assign roles to dbo user", this.getTitle(), 2);
            return;
        }
        if (!this.jRadioButtonAll.isSelected()) {
            boolean atLeastOne = false;
            for (CountryRole r : this.model.roles) {
                if (!r.assigned.booleanValue()) continue;
                atLeastOne = true;
            }
            if (!atLeastOne) {
                JOptionPane.showMessageDialog(this, "No countries assigned!", this.getTitle(), 2);
                return;
            }
        }
        try (Statement stmt = this.db.getDatabase().createStatement();){
            Userdef user = this.getUserFromListSelection();
            boolean changed = false;
            if (user == null) {
                return;
            }
            if (this.jRadioButtonAll.isSelected()) {
                this.grantRole(stmt, user, "ALL");
                changed = true;
            } else {
                sql = "ALTER ROLE [COUNTRY_ALL] DROP MEMBER [" + this.SQLDatabaseUsername + "]";
                System.out.println((String)sql);
                stmt.executeUpdate((String)sql);
            }
            for (CountryRole r : this.model.roles) {
                if (this.jRadioButtonAll.isSelected()) {
                    r.assigned = false;
                }
                if (r.originallyAssigned.equals(r.assigned)) continue;
                if (!r.assigned.booleanValue()) {
                    sql = "ALTER ROLE [COUNTRY_" + r.country + "] DROP MEMBER [" + this.SQLDatabaseUsername + "]";
                    System.out.println((String)sql);
                    stmt.executeUpdate((String)sql);
                } else {
                    this.grantRole(stmt, user, r.country);
                }
                r.originallyAssigned = r.assigned;
                changed = true;
            }
            this.model.fireTableDataChanged();
            this.db.commit();
            if (changed) {
                JOptionPane.showMessageDialog(this, "Changes successfully applied", this.getTitle(), 1);
            }
        }
        catch (SQLException sqle) {
            this.db.doRollback();
            JOptionPane.showMessageDialog(this, sqle.getMessage(), "SQL Error", 0);
            System.out.println((String)sql);
            sqle.printStackTrace();
        }
    }

    private void jRadioButtonAllActionPerformed(ActionEvent evt) {
        boolean asked = false;
        for (CountryRole r : this.model.roles) {
            if (!r.assigned.booleanValue()) continue;
            if (!asked) {
                if (JOptionPane.showConfirmDialog(this, "Clear country assignments?", this.getTitle(), 0) == 1) {
                    return;
                }
                asked = true;
            }
            r.assigned = false;
        }
        this.jTableCountryRoles.setEnabled(false);
        this.model.fireTableDataChanged();
    }

    private void jRadioButtonRestrictedActionPerformed(ActionEvent evt) {
        this.jTableCountryRoles.setEnabled(true);
    }

    private void jButtonApplyHiddenSchemesActionPerformed(ActionEvent evt) {
        if (this.SQLDatabaseUsername == null) {
            JOptionPane.showMessageDialog(this, "Database username is null or not assigned!", this.getTitle(), 2);
            return;
        }
        if (this.SQLDatabaseUsername.equalsIgnoreCase("dbo")) {
            JOptionPane.showMessageDialog(this, "Cannot assign roles to dbo user", this.getTitle(), 2);
            return;
        }
        try (Statement stmt = this.db.getDatabase().createStatement();){
            Userdef user = this.getUserFromListSelection();
            if (user == null) {
                return;
            }
            if (this.jCheckBoxHiddenSchemes.isSelected()) {
                this.grantHideSchemeRole(stmt, user);
            } else {
                this.revokeHideSchemeRole(stmt, user);
            }
            JOptionPane.showMessageDialog(this, "Changes successfully applied", this.getTitle(), 1);
        }
        catch (SQLException sqle) {
            this.db.doRollback();
            JOptionPane.showMessageDialog(this, sqle.getMessage(), "SQL Error", 0);
            sqle.printStackTrace();
        }
    }

    private void grantRole(Statement stmt, Userdef user, String country) throws SQLException {
        String sql = "Select name FROM sysusers WHERE issqlrole = 1 AND name ='COUNTRY_" + country + "'";
        ResultSet rs = stmt.executeQuery(sql);
        if (!rs.next()) {
            sql = "CREATE ROLE [COUNTRY_" + country + "]";
            if (!country.equals("ALL")) {
                sql = sql + "AUTHORIZATION COUNTRY_ALL";
            }
            System.out.println(sql);
            stmt.executeUpdate(sql);
        }
        sql = "ALTER ROLE [COUNTRY_" + country + "] ADD MEMBER [" + this.SQLDatabaseUsername + "]";
        System.out.println(sql);
        stmt.executeUpdate(sql);
    }

    private void grantHideSchemeRole(Statement stmt, Userdef user) throws SQLException {
        Object sql = "Select name FROM sysusers WHERE issqlrole = 1 AND name ='HIDE_SCHEMES'";
        ResultSet rs = stmt.executeQuery((String)sql);
        if (!rs.next()) {
            sql = "CREATE ROLE [HIDE_SCHEMES] AUTHORIZATION COUNTRY_ALL";
            System.out.println((String)sql);
            stmt.executeUpdate((String)sql);
        }
        sql = "ALTER ROLE [HIDE_SCHEMES] ADD MEMBER [" + this.SQLDatabaseUsername + "]";
        System.out.println((String)sql);
        stmt.executeUpdate((String)sql);
    }

    private void revokeHideSchemeRole(Statement stmt, Userdef user) throws SQLException {
        Object sql = "Select name FROM sysusers WHERE issqlrole = 1 AND name ='HIDE_SCHEMES'";
        ResultSet rs = stmt.executeQuery((String)sql);
        if (!rs.next()) {
            return;
        }
        sql = "ALTER ROLE [HIDE_SCHEMES] DROP MEMBER [" + this.SQLDatabaseUsername + "]";
        System.out.println((String)sql);
        stmt.executeUpdate((String)sql);
    }

    public static boolean checkSecurityFunctionExists(SBdb db) throws SQLException {
        try (Statement stmt = db.getDatabase().createStatement();){
            String sql = "SELECT 1 FROM sys.objects WHERE  object_id = OBJECT_ID(N'[rls].[SBsecurityCountry]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT')";
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private Userdef getUserFromListSelection() throws SQLException {
        String userString = (String)this.userModel.getElementAt(this.jListUsers.getSelectedIndex());
        Userdef user = null;
        Collection<Userdef> users = this.db.getUsers();
        for (Userdef u : users) {
            if (!userString.equals(u.getName() + " [" + u.getAbr() + "]")) continue;
            user = u;
            break;
        }
        return user;
    }

    public static boolean checkDatabasePriv(SBdb db) throws SQLException {
        try (Statement stmt = db.getDatabase().createStatement();){
            String sql2;
            ResultSet rs2;
            String sql = "select 1 from sys.database_permissions where (type='ALUS' and grantee_principal_id=user_id()) OR USER_NAME()='dbo'";
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next() && (rs2 = stmt.executeQuery(sql2 = "select 1 from sys.database_permissions where (type='ALRL' and grantee_principal_id=user_id()) OR USER_NAME()='dbo'")).next()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    class TableModelCountry
    extends AbstractTableModel {
        List<CountryRole> roles;
        int maxColumn;
        final /* synthetic */ DialogCountryRoles this$0;

        TableModelCountry(DialogCountryRoles this$0) {
            DialogCountryRoles dialogCountryRoles = this$0;
            Objects.requireNonNull(dialogCountryRoles);
            this.this$0 = dialogCountryRoles;
            this.roles = new LinkedList<CountryRole>();
            this.maxColumn = 2;
        }

        @Override
        public int getColumnCount() {
            return this.maxColumn;
        }

        @Override
        public int getRowCount() {
            if (this.roles == null) {
                return 0;
            }
            return this.roles.size();
        }

        public void setSize(int i) {
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            switch (c) {
                default: {
                    return false;
                }
                case 1: 
            }
            return true;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.roles == null) {
                return "";
            }
            switch (col) {
                default: {
                    return "";
                }
                case 0: {
                    return this.roles.get((int)row).country;
                }
                case 1: 
            }
            return this.roles.get((int)row).assigned;
        }

        @Override
        public void setValueAt(Object o, int row, int col) {
            if (this.roles == null) {
                return;
            }
            switch (col) {
                case 0: {
                    return;
                }
                case 1: {
                    this.roles.get((int)row).assigned = (Boolean)o;
                }
            }
        }

        public Class getColumnClass(int col) {
            switch (col) {
                default: {
                    return String.class;
                }
                case 1: 
            }
            return Boolean.class;
        }
    }

    class CountryRole {
        String country;
        Boolean originallyAssigned;
        Boolean assigned;

        CountryRole(DialogCountryRoles this$0, String c) {
            Objects.requireNonNull(this$0);
            this.originallyAssigned = false;
            this.assigned = false;
            this.country = c;
        }
    }
}

