/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.db.DBType;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import jsbchart.core.ChartManager;
import jsbugs.DialogSelectGlobals;
import jsbugs.FrameJsbugs;
import model3.Lastval;
import model3.SBChart;
import model3.SBRestrictable;
import model3.SBdb;
import model3.TxGroup;
import model3.TxGroupSet;
import model3.Well;
import model3.project.Project;
import model3.project.WellList;
import org.h2.jdbc.JdbcSQLIntegrityConstraintViolationException;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;
import util.exception.SqlCache;
import util.exception.StackError;

public class DialogCreateDatabase
extends JDialog {
    private final SBdb db;
    private final ChartManager chartManager;
    private final Project project;
    private final WellList wellList;
    private Connection newDB = null;
    private SwingWorker task = null;
    private PrintWriter log = null;
    private boolean allGlobalTemplates;
    private String selectedBlockTemplates = null;
    private HashSet<Integer> selectedSets = null;
    private HashSet<Integer> selectedGroups = null;
    private JButton jButtonClose;
    private JButton jButtonFile;
    private JButton jButtonHelp;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldDataFile;
    private JTextField jTextFieldProject;
    private JTextField jTextFieldWellList;
    private JTextPane jTextPaneProgress;

    public DialogCreateDatabase(Frame parent, boolean modal, SBdb db, ChartManager chartManager, Project project, WellList wellList) {
        super(parent, modal);
        this.db = db;
        this.chartManager = chartManager;
        this.project = project;
        this.wellList = wellList;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Create Database");
        this.jTextFieldProject.setText(this.project.getName());
        this.jTextFieldWellList.setText(this.wellList.getName());
        this.jTextFieldDataFile.setText(null);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldProject = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldDataFile = new JTextField();
        this.jButtonFile = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextPaneProgress = new JTextPane();
        this.jButtonClose = new JButton();
        this.jButtonHelp = new JButton();
        this.jLabel3 = new JLabel();
        this.jTextFieldWellList = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(350, 300));
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ DialogCreateDatabase this$0;
            {
                DialogCreateDatabase dialogCreateDatabase = this$0;
                Objects.requireNonNull(dialogCreateDatabase);
                this.this$0 = dialogCreateDatabase;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                this.this$0.formWindowClosing(evt);
            }
        });
        this.jLabel1.setText("Create a new database from project: ");
        this.jTextFieldProject.setEditable(false);
        this.jTextFieldProject.setBackground(new Color(255, 255, 204));
        this.jLabel2.setText("Database file:");
        this.jTextFieldDataFile.setEditable(false);
        this.jButtonFile.setText("File...");
        this.jButtonFile.setToolTipText("Select an empty StrataBugs database");
        this.jButtonFile.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCreateDatabase this$0;
            {
                DialogCreateDatabase dialogCreateDatabase = this$0;
                Objects.requireNonNull(dialogCreateDatabase);
                this.this$0 = dialogCreateDatabase;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonFileActionPerformed(evt);
            }
        });
        this.jTextPaneProgress.setEditable(false);
        this.jScrollPane1.setViewportView(this.jTextPaneProgress);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCreateDatabase this$0;
            {
                DialogCreateDatabase dialogCreateDatabase = this$0;
                Objects.requireNonNull(dialogCreateDatabase);
                this.this$0 = dialogCreateDatabase;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCreateDatabase this$0;
            {
                DialogCreateDatabase dialogCreateDatabase = this$0;
                Objects.requireNonNull(dialogCreateDatabase);
                this.this$0 = dialogCreateDatabase;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Well list:");
        this.jTextFieldWellList.setEditable(false);
        this.jTextFieldWellList.setBackground(new Color(255, 255, 204));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldProject)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jTextFieldDataFile, -2, 245, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonFile)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldWellList, -2, 329, -2))))).addContainerGap()));
        layout.linkSize(0, this.jButtonClose, this.jButtonHelp);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldProject, -2, -1, -2)).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldWellList, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldDataFile, -2, -1, -2).addComponent(this.jButtonFile)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 210, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClose).addComponent(this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        try {
            if (this.task != null) {
                this.task.cancel(true);
            }
            if (this.newDB != null) {
                this.newDB.close();
                this.newDB = null;
            }
            this.dispose();
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
        }
    }

    private void copy(File src, File dst) throws IOException {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dst);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
    }

    private void jButtonFileActionPerformed(ActionEvent evt) {
        JFileChooser jFileChooser = new JFileChooser();
        if (this.jTextFieldDataFile.getText().length() > 0) {
            jFileChooser.setSelectedFile(new File(this.jTextFieldDataFile.getText()));
        } else {
            try {
                jFileChooser.setSelectedFile(new File(Lastval.getString(this.db, "CREATEDB")));
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        SbugsFileFilter filter = new SbugsFileFilter("db", "H2 Files (*.h2.db)");
        jFileChooser.setFileFilter((FileFilter)filter);
        jFileChooser.setDialogTitle("Select database file");
        try {
            if (jFileChooser.showOpenDialog(this) == 0 && jFileChooser.getSelectedFile() != null) {
                if (this.newDB != null) {
                    this.newDB.close();
                    this.newDB = null;
                }
                File file = jFileChooser.getSelectedFile();
                Lastval.putString(this.db, "CREATEDB", file.getPath());
                this.db.commit();
                if (file.getName().contains("2-1")) {
                    JOptionPane.showMessageDialog(this, "ERROR: selected database appears to be a 2.1 database.", this.getTitle(), 2);
                    return;
                }
                if (file.getName().equals("sbugs3-0.mv.db")) {
                    file = this.masterFileCopy(file);
                }
                String DSN = "jdbc:h2:" + file.getPath().substring(0, file.getPath().length() - 6);
                System.out.println("Connecting with: " + DSN);
                this.newDB = DriverManager.getConnection(DSN);
                this.jTextFieldDataFile.setText(file.getPath());
                this.jTextPaneProgress.setText("Connected");
                if (!this.checkExistingData()) {
                    return;
                }
                Object[] buttons = new String[]{"Include all", "Include selection", "Exclude all", "Cancel"};
                int opt = JOptionPane.showOptionDialog(this, "Do you want to include 'Global' groups, sets, panel and block templates?\n(this might make the export take longer).", this.getTitle(), 1, 3, null, buttons, null);
                if (opt == 3) {
                    return;
                }
                switch (opt) {
                    case 0: {
                        this.allGlobalTemplates = true;
                        break;
                    }
                    case 2: {
                        this.allGlobalTemplates = false;
                        break;
                    }
                    default: {
                        this.jTextPaneProgress.setText("Loading global templates and groups...");
                        this.jTextPaneProgress.setCursor(Cursor.getPredefinedCursor(3));
                        DialogSelectGlobals dialog = new DialogSelectGlobals(this, this.db, this.chartManager, true);
                        dialog.setLocationRelativeTo(this);
                        dialog.setVisible(true);
                        this.setCursor(Cursor.getDefaultCursor());
                        if (dialog.isOK) {
                            this.selectedBlockTemplates = dialog.getSelectedBlockTemplateIDs();
                            this.selectedSets = dialog.getSelectedSetHashSet();
                            this.selectedGroups = dialog.getSelectedGroupHashSet();
                            System.out.println("Dialog selection well blocks: " + dialog.getSelectedWellBlockIDs());
                            System.out.println("Dialog selection scheme blocks: " + dialog.getSelectedSchemeBlockIDs());
                            break;
                        }
                        return;
                    }
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.task = new SwingWorker(this){
                    boolean state;
                    final /* synthetic */ DialogCreateDatabase this$0;
                    {
                        DialogCreateDatabase dialogCreateDatabase = this$0;
                        Objects.requireNonNull(dialogCreateDatabase);
                        this.this$0 = dialogCreateDatabase;
                        this.state = false;
                    }

                    public Object doInBackground() throws InterruptedException {
                        this.state = this.this$0.processWells();
                        return "ok";
                    }

                    @Override
                    protected void done() {
                        try {
                            if (this.state) {
                                this.this$0.outputProgress(false, "\r\n...done");
                                this.this$0.outputProgress(false, "\r\n\r\nTest new database by changing database from control panel File menu.");
                                this.this$0.outputProgress(false, "\r\nNote: All passwords have been reset to the word 'SYSTEM' in the new database.");
                                this.this$0.jButtonClose.setText("Finish");
                            } else {
                                this.this$0.outputProgress(false, "\r\n...did not finish due to error");
                            }
                            this.this$0.setCursor(Cursor.getDefaultCursor());
                            this.this$0.jTextPaneProgress.setCursor(Cursor.getDefaultCursor());
                        }
                        catch (InterruptedException ex) {
                            this.this$0.jTextPaneProgress.setText("Task interrupted");
                            this.this$0.setCursor(Cursor.getDefaultCursor());
                            this.this$0.jTextPaneProgress.setCursor(Cursor.getDefaultCursor());
                        }
                    }
                };
                this.task.execute();
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        catch (Exception ex) {
            StackError.showStackError((String)ex.getMessage(), (Throwable)ex);
        }
    }

    File masterFileCopy(File file) throws IOException {
        String projName = this.project.getName();
        projName = Well.makeCode(projName);
        String newFileName = file.getParentFile().getPath() + File.separator + file.getName().substring(0, file.getName().length() - 6) + "_" + projName + ".mv.db";
        File newFile = new File(newFileName);
        boolean toCopy = true;
        if (newFile.exists()) {
            int opt = JOptionPane.showConfirmDialog(this, "File: " + newFile.getAbsolutePath() + " exists.\nDelete and recreate?", this.getTitle(), 0, 3);
            if (opt == 0) {
                newFile.delete();
            } else {
                toCopy = false;
            }
        }
        if (toCopy) {
            this.copy(file, newFile);
        }
        return newFile;
    }

    private boolean processWells() throws InterruptedException {
        try {
            Statement nStmt;
            Object sql;
            ResultSet rs;
            block29: {
                int wellID;
                Well well;
                boolean hasSplitIDtable = false;
                DatabaseMetaData meta = this.db.getDatabase().getMetaData();
                String schema = this.db.getSchema();
                try {
                    String tableName = "SPLITID";
                    if (this.db.getDBType() == DBType.POSTGRESQL) {
                        tableName = tableName.toLowerCase();
                    }
                    rs = meta.getTables(null, schema, tableName, null);
                }
                catch (SQLException sqle) {
                    rs = meta.getColumns(null, null, "SPLITID", "%");
                }
                if (rs.next()) {
                    hasSplitIDtable = true;
                }
                rs.close();
                Statement stmt = this.db.getDatabase().createStatement();
                if (hasSplitIDtable) {
                    sql = "DELETE FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID();
                    try {
                        stmt.executeUpdate(this.db.modQuery((String)sql));
                        this.db.commit();
                    }
                    catch (SQLException se) {
                        this.printLog("Message from delete from table SPLITID: " + se.getMessage());
                    }
                } else {
                    sql = "CREATE TABLE " + this.db.DBTableName("SPLITID") + " (usrid int not null, label " + this.db.getDBCharType() + "(30) not null, id int not null, constraint splitid_pk primary key (usrid,label,id))";
                    stmt.executeUpdate(this.db.modQuery((String)sql));
                }
                this.copyTable("USERDEF", null, false, false);
                this.copyTable("ABNSCHME", " WHERE scheme_id IN (SELECT abnsch_id FROM " + this.db.DBTableName("WELLIST_MBR") + " s, " + this.db.DBTableName("ANALY_HDR") + " w where s.wellist_id=" + this.wellList.getID() + " AND s.well_id=w.well_id)", false, false);
                this.copyTable("ABNSCHMBR", " WHERE scheme_id IN (SELECT abnsch_id FROM " + this.db.DBTableName("WELLIST_MBR") + " s, " + this.db.DBTableName("ANALY_HDR") + " w where s.wellist_id=" + this.wellList.getID() + " AND s.well_id=w.well_id)", false, false);
                this.copyTable("ENV_SCH", " WHERE envsch_id IN (SELECT envsch_id FROM " + this.db.DBTableName("WELLIST_MBR") + " s, " + this.db.DBTableName("ANALY_HDR") + " w where s.wellist_id=" + this.wellList.getID() + " AND s.well_id=w.well_id)", false, false);
                this.copyTable("ENVSCHMBR", " WHERE envsch_id IN (SELECT envsch_id FROM " + this.db.DBTableName("WELLIST_MBR") + " s, " + this.db.DBTableName("ANALY_HDR") + " w where s.wellist_id=" + this.wellList.getID() + " AND s.well_id=w.well_id)", false, false);
                this.copyTable("SPECIESTYPE", null, true, false);
                this.copyTable("DISCS", null, true, false);
                this.copyTable("CATEGORY", null, true, false);
                this.copyTable("IGD_DEF", null, true, false);
                this.copyTable("LITHDESC", null, true, false);
                this.copyTable("SBLTHPAT", null, true, false);
                this.copyTable("DBVERSION", null, true, false);
                this.copyTable("LOGDEF", null, true, false);
                this.copyTable("INTERP", " WHERE interp_id = 0", false, false);
                Iterator<Well> it = this.db.getWellIterator(this.wellList.getID());
                int total = this.db.getnWells(this.wellList.getID());
                int n = 0;
                while (it.hasNext()) {
                    well = it.next();
                    wellID = well.getWellID();
                    this.outputProgress(false, "\r\nProcessing (" + ++n + "/" + total + ") well: " + well.getWellName());
                    this.copyTable("ENV_SCH", " WHERE envsch_id IN (SELECT envsch_id FROM " + this.db.DBTableName("IGD_ENV") + " i WHERE i.well_id=" + wellID + ")", false, false);
                    this.copyTable("ENVSCHMBR", " WHERE envsch_id IN (SELECT envsch_id FROM " + this.db.DBTableName("IGD_ENV") + " i WHERE i.well_id=" + wellID + ")", false, false);
                    this.copyTable("INTERP", " WHERE interp_id IN (SELECT interp_id FROM " + this.db.DBTableName("IGD") + " i WHERE i.well_id=" + wellID + ")", false, false);
                    this.copyTable("INTERP", " WHERE interp_id IN (SELECT interp_id FROM " + this.db.DBTableName("IGD_LSTRAT") + " i WHERE i.well_id=" + wellID + ")", false, false);
                    this.copyTable("INTERP", " WHERE interp_id IN (SELECT interp_id FROM " + this.db.DBTableName("BCMMNTS") + " i WHERE i.well_id=" + wellID + ")", false, false);
                    this.copyTable("INTERP", " WHERE interp_id IN (SELECT interp_id FROM " + this.db.DBTableName("IGD_ENV") + " i WHERE i.well_id=" + wellID + ")", false, false);
                    this.copyTable("INTERP", " WHERE interp_id IN (SELECT interp_id FROM " + this.db.DBTableName("SQPICK") + " i WHERE i.well_id=" + wellID + ")", false, false);
                    this.copyTable("INTERP", " WHERE interp_id IN (SELECT interp_id FROM " + this.db.DBTableName("INTCMMNTS") + " i WHERE i.well_id=" + wellID + ")", false, false);
                    this.copyTable("INTERP", " WHERE interp_id IN (SELECT interp_id FROM " + this.db.DBTableName("EVENTS") + " i WHERE i.well_id=" + wellID + ")", false, false);
                    this.copyTable("INTERP", " WHERE interp_id IN (SELECT interp_id FROM " + this.db.DBTableName("LOC") + " i WHERE i.well_id=" + wellID + ")", false, false);
                    this.copyTable("INTERP", " WHERE interp_id IN (SELECT interp_id FROM " + this.db.DBTableName("FAULTS") + " i WHERE i.well_id=" + wellID + ")", false, false);
                    this.copyTable("WELLS", " WHERE well_id=" + wellID, false, false);
                    this.copyTable("PROJECT", " WHERE proj_id=" + this.project.getID(), false, false);
                    this.copyTable("WELLIST", " WHERE wellist_id=" + this.wellList.getID(), false, false);
                    this.createSplitIDs(stmt, "SCH_ID", "IGD", wellID);
                    this.insertSplitID(stmt, "PARENT", "parent FROM " + this.db.DBTableName("IGD_SCH") + " d," + this.db.DBTableName("IGD") + " i WHERE parent is not null and i.sch_id=d.sch_id AND i.well_id=" + wellID + " AND parent NOT IN (SELECT id from " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='PARENT') GROUP BY parent");
                    this.createSplitIDs(stmt, "SCH_ID", "IGD_LSTRAT", wellID);
                    this.insertSplitID(stmt, "PARENT", "parent FROM " + this.db.DBTableName("IGD_SCH") + " d," + this.db.DBTableName("IGD_LSTRAT") + " i WHERE parent is not null and i.sch_id=d.sch_id AND i.well_id=" + wellID + " AND parent NOT IN (SELECT id from " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='PARENT') GROUP BY parent");
                    this.insertSplitID(stmt, "sch_id", "sch_id FROM " + this.db.DBTableName("SURFACE") + " s," + this.db.DBTableName("SQPICK") + " p WHERE p.surface_id=s.surface_id AND p.well_id=" + wellID + " AND sch_id NOT IN (SELECT id from " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='SCH_ID') GROUP BY sch_id");
                    this.insertSplitID(stmt, "PARENT", "parent FROM " + this.db.DBTableName("IGD_SCH") + " d," + this.db.DBTableName("SURFACE") + " s," + this.db.DBTableName("SQPICK") + " p WHERE d.sch_id=s.sch_id AND p.surface_id=s.surface_id AND p.well_id=" + wellID + " AND parent NOT IN (SELECT id from " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='PARENT') GROUP BY PARENT");
                    this.insertSplitID(stmt, "std_id", "std_id FROM " + this.db.DBTableName("LOC") + " WHERE well_id=" + wellID + " AND std_id > 0 AND std_id NOT IN (SELECT id from " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='STD_ID') GROUP BY std_id");
                    this.insertSplitID(stmt, "sch_id", "sch_id FROM " + this.db.DBTableName("IGD_HDR") + " WHERE well_id=" + wellID + " AND sch_id NOT IN (SELECT id from " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='SCH_ID') GROUP BY sch_id");
                    this.createSplitIDs(stmt, "SPEC_ID", "TAXONOCC", wellID);
                    this.createSplitIDs(stmt, "EV_ID", "EVENTS", wellID);
                    this.db.commit();
                    Runtime.getRuntime().gc();
                }
                this.processTxGroups();
                this.processCharts1();
                this.processSchParent();
                this.copyTable("INTERP", " WHERE interp_id IN (SELECT distinct INTERP_ID FROM " + this.db.DBTableName("CHTBLOCKMBR") + " WHERE block_id IN(SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='BLOCK_ID') and interp_id > 0)", false, false);
                SqlCache.setSql((String)"");
                this.copyTable("PROJECT", " WHERE proj_id IN (SELECT proj_id FROM " + this.db.DBTableName("CHTBLOCK") + " WHERE block_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='BLOCK_ID'))", false, false);
                this.outputProgress(false, "\r\nProcessing genera...");
                this.copyTable("GENUS", " WHERE gen_id IN (SELECT g.gen_id FROM " + this.db.DBTableName("genus") + " g, " + this.db.DBTableName("species") + " s, " + this.db.DBTableName("splitid") + " x WHERE  usrid=" + this.db.getUserID() + " AND x.label='SPEC_ID' AND x.id=s.spec_id AND s.gen_id=g.gen_id)", false, false);
                this.outputProgress(false, "\r\nProcessing species...");
                this.copyTable("SPECIES", " WHERE spec_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='SPEC_ID')", false, false);
                this.copyTable("SYNSCH", null, true, false);
                this.outputProgress(false, "\r\nProcessing genera of synonyms...");
                this.copyTable("GENUS", " WHERE gen_id IN (SELECT s.gen_id FROM " + this.db.DBTableName("species") + " s, " + this.db.DBTableName("synonymy") + " sy, " + this.db.DBTableName("splitid") + " x WHERE  x.usrid=" + this.db.getUserID() + " AND x.label='SPEC_ID' AND x.id=sy.spec_id AND sy.pref=s.spec_id)", false, false);
                this.copyTable("GENUS", " WHERE gen_id IN (SELECT s.gen_id FROM " + this.db.DBTableName("species") + " s, " + this.db.DBTableName("synonymy") + " sy, " + this.db.DBTableName("splitid") + " x WHERE  x.usrid=" + this.db.getUserID() + " AND x.label='SPEC_ID' AND x.id=sy.pref AND sy.spec_id=s.spec_id)", false, false);
                this.outputProgress(false, "\r\nProcessing species of synonyms...");
                this.copyTable("SPECIES", " WHERE spec_id IN (SELECT pref FROM " + this.db.DBTableName("synonymy") + " s, " + this.db.DBTableName("splitid") + " x WHERE x.usrid=" + this.db.getUserID() + " AND x.label='SPEC_ID' AND x.id=s.spec_id)", false, false);
                this.copyTable("SPECIES", " WHERE spec_id IN (SELECT spec_id FROM " + this.db.DBTableName("synonymy") + " s, " + this.db.DBTableName("splitid") + " x WHERE x.usrid=" + this.db.getUserID() + " AND x.label='SPEC_ID' AND x.id=s.pref)", false, false);
                this.copyTable("SYNONYMY", " WHERE spec_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='SPEC_ID')", true, false);
                this.copyTable("SYNONYMY", " WHERE pref IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='SPEC_ID')", false, false);
                this.copyTable("GENUS", " WHERE gen_id IN (SELECT s.gen_id FROM " + this.db.DBTableName("species") + " s, " + this.db.DBTableName("eventdic") + " e," + this.db.DBTableName("cmpstdev") + " c WHERE e.spec_id=s.spec_id AND e.ev_id=c.ev_id AND c.std_id IN  (SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='STD_ID'))", false, false);
                this.copyTable("SPECIES", " WHERE spec_id IN (SELECT spec_id FROM " + this.db.DBTableName("eventdic") + " e," + this.db.DBTableName("cmpstdev") + " c WHERE c.ev_id=e.ev_id AND c.std_id IN (SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='STD_ID'))", false, false);
                this.outputProgress(false, "\r\nProcessing events...");
                this.insertSplitID(stmt, "ev_id", "ev_id FROM " + this.db.DBTableName("CMPSTDEV") + " WHERE std_id IN(SELECT id from " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='STD_ID')");
                this.copyTable("GENUS", " WHERE gen_id IN (SELECT s.gen_id FROM " + this.db.DBTableName("species") + " s, " + this.db.DBTableName("eventdic") + " d, " + this.db.DBTableName("splitid") + " x WHERE x.usrid=" + this.db.getUserID() + " AND x.label='EV_ID' AND x.id=d.ev_id AND d.spec_id=s.spec_id)", false, false);
                this.copyTable("SPECIES", " WHERE spec_id IN (SELECT spec_id FROM " + this.db.DBTableName("eventdic") + " d, " + this.db.DBTableName("splitid") + " x WHERE x.usrid=" + this.db.getUserID() + " AND x.label='EV_ID' AND x.id=d.ev_id)", false, false);
                this.copyTable("EVENTDIC", " WHERE ev_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='EV_ID')", false, false);
                this.copyTable("EVENTDIC", " WHERE ev_id IN (SELECT ev_id from " + this.db.DBTableName("cmpstdev") + " WHERE std_id in (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='STD_ID'))", false, false);
                this.copyTable("EVENTDIC", " WHERE spec_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='SPEC_ID')", false, false);
                this.copyTable("EVENTDIC", " WHERE spec_id IN (SELECT pref FROM " + this.db.DBTableName("synonymy") + " s, " + this.db.DBTableName("splitid") + " x WHERE x.usrid=" + this.db.getUserID() + " AND x.label='SPEC_ID' AND x.id=s.spec_id)", false, false);
                this.copyTable("EVENTDIC", " WHERE spec_id IN (SELECT spec_id FROM " + this.db.DBTableName("synonymy") + " s, " + this.db.DBTableName("splitid") + " x WHERE x.usrid=" + this.db.getUserID() + " AND x.label='SPEC_ID' AND x.id=s.pref)", false, false);
                this.outputProgress(false, "\r\nProcessing images...");
                this.copyTable("SBIMAGE", " WHERE image_id IN (SELECT image_id FROM " + this.db.DBTableName("coreimage") + " WHERE well_id IN (select well_id from " + this.db.DBTableName("WELLIST_MBR") + " WHERE wellist_id=" + this.wellList.getID() + "))", true, false);
                this.copyTable("IMAGE_SET", " WHERE image_set_id IN (SELECT image_set_id FROM " + this.db.DBTableName("taxonocc") + " WHERE well_id IN (select well_id from " + this.db.DBTableName("WELLIST_MBR") + " WHERE wellist_id=" + this.wellList.getID() + "))", true, false);
                this.copyTable("SBIMAGE", " WHERE image_id IN (SELECT image_id FROM " + this.db.DBTableName("image_setmbr") + " WHERE image_set_id IN (SELECT image_set_id FROM " + this.db.DBTableName("taxonocc") + " WHERE well_id IN (SELECT well_id FROM " + this.db.DBTableName("WELLIST_MBR") + " WHERE wellist_id=" + this.wellList.getID() + ")))", true, false);
                this.copyTable("IMAGE_SETMBR", " WHERE image_set_id IN (SELECT image_set_id FROM " + this.db.DBTableName("taxonocc") + " WHERE well_id IN (select well_id from " + this.db.DBTableName("WELLIST_MBR") + " WHERE wellist_id=" + this.wellList.getID() + "))", true, false);
                this.outputProgress(false, "\r\nProcessing cmpstd scheme parent...");
                this.insertSplitID(stmt, "parent", "parent FROM " + this.db.DBTableName("CMPSTD") + " WHERE std_id IN (SELECT id from " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='STD_ID') AND  parent not in (select id from " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " and label='SCH_ID') AND parent is not null GROUP BY parent");
                this.outputProgress(false, "\r\nProcessing schemes...");
                this.copyTable("IGD_SCH", " WHERE sch_id IN (SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='PARENT')", false, false);
                this.copyTable("IGD_SCH", " WHERE sch_id IN (SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='SCH_ID')", false, false);
                this.copyTable("IGD_DICT", " WHERE sch_id IN (SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='PARENT')", false, false);
                this.copyTable("IGD_DICT", " WHERE sch_id IN (SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='SCH_ID')", false, false);
                this.copyTable("IGD_DICT_LSTRAT", " WHERE sch_id IN (SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='PARENT')", false, false);
                this.copyTable("IGD_DICT_LSTRAT", " WHERE sch_id IN (SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='SCH_ID')", false, false);
                this.copyTable("SURFACE", " WHERE sch_id IN (SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='PARENT')", false, false);
                this.copyTable("SURFACE", " WHERE sch_id IN (SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='SCH_ID')", false, false);
                this.outputProgress(false, "\r\nProcessing composite standards...");
                this.copyTable("CMPSTD", " WHERE std_id IN (SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='STD_ID')", false, false);
                this.copyTable("CMPSTDEV", " WHERE std_id IN (SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='STD_ID')", false, false);
                this.outputProgress(false, "\r\nProcessing groups...");
                this.copyTable("TXGROUP", " WHERE grp_id IN (SELECT grp_id FROM " + this.db.DBTableName("setmbr") + " s, " + this.db.DBTableName("splitid") + " i WHERE i.usrid=" + this.db.getUserID() + " AND i.label='GRPSET_ID' AND i.id=s.grpset_id)", false, false);
                this.copyTable("GENUS", " WHERE gen_id in (SELECT gen_id FROM " + this.db.DBTableName("species") + " WHERE spec_id in (SELECT spec_id from " + this.db.DBTableName("groupmbr") + " WHERE grp_id IN (SELECT grp_id FROM " + this.db.DBTableName("setmbr") + " s, " + this.db.DBTableName("splitid") + " i WHERE i.usrid=" + this.db.getUserID() + " AND i.label='GRPSET_ID' AND i.id=s.grpset_id)))", false, false);
                this.copyTable("GENUS", " WHERE gen_id in (SELECT gen_id FROM " + this.db.DBTableName("groupmbr_genus") + " WHERE grp_id in (SELECT grp_id FROM " + this.db.DBTableName("setmbr") + " s, " + this.db.DBTableName("splitid") + " i WHERE i.usrid=" + this.db.getUserID() + " AND i.label='GRPSET_ID' AND i.id=s.grpset_id))", false, false);
                this.copyTable("SPECIES", " WHERE spec_id in (SELECT spec_id from " + this.db.DBTableName("groupmbr") + " WHERE grp_id IN (SELECT grp_id FROM " + this.db.DBTableName("setmbr") + " s, " + this.db.DBTableName("splitid") + " i WHERE i.usrid=" + this.db.getUserID() + " AND i.label='GRPSET_ID' AND i.id=s.grpset_id))", false, false);
                this.copyTable("SPECIES", " WHERE gen_id in (SELECT gen_id from " + this.db.DBTableName("groupmbr_genus") + " WHERE grp_id IN (SELECT grp_id FROM " + this.db.DBTableName("setmbr") + " s, " + this.db.DBTableName("splitid") + " i WHERE i.usrid=" + this.db.getUserID() + " AND i.label='GRPSET_ID' AND i.id=s.grpset_id))", false, false);
                this.copyTable("SPECIES", "  WHERE gen_id in (SELECT gen_id FROM " + this.db.DBTableName("groupmbr_genus") + " WHERE grp_id in (SELECT grp_id FROM " + this.db.DBTableName("setmbr") + " s, " + this.db.DBTableName("splitid") + " i WHERE i.usrid=" + this.db.getUserID() + " AND i.label='GRPSET_ID' AND i.id=s.grpset_id))", false, false);
                this.copyTable("GROUPMBR", " WHERE grp_id IN (SELECT grp_id FROM " + this.db.DBTableName("setmbr") + " s, " + this.db.DBTableName("splitid") + " i WHERE i.usrid=" + this.db.getUserID() + " AND i.label='GRPSET_ID' AND i.id=s.grpset_id)", false, false);
                this.copyTable("GROUPMBR_GENUS", " WHERE grp_id IN (SELECT grp_id FROM " + this.db.DBTableName("setmbr") + " s, " + this.db.DBTableName("splitid") + " i WHERE i.usrid=" + this.db.getUserID() + " AND i.label='GRPSET_ID' AND i.id=s.grpset_id)", false, false);
                this.copyTable("GROUPSET", " WHERE grpset_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='GRPSET_ID')", false, false);
                this.copyTable("SETMBR", " WHERE grpset_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='GRPSET_ID')", true, false);
                this.copyTable("TXGROUP", " WHERE grp_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='GRP_ID')", false, false);
                this.copyTable("GENUS", " WHERE gen_id in (SELECT gen_id FROM " + this.db.DBTableName("species") + " WHERE spec_id in (SELECT spec_id from " + this.db.DBTableName("groupmbr") + " WHERE grp_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='GRP_ID')))", false, false);
                this.copyTable("SPECIES", " WHERE spec_id in (SELECT spec_id from " + this.db.DBTableName("groupmbr") + " WHERE grp_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='GRP_ID'))", false, false);
                this.copyTable("GENUS", " WHERE gen_id IN (SELECT gen_id from " + this.db.DBTableName("groupmbr_genus") + " WHERE grp_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='GRP_ID'))", false, false);
                this.copyTable("GROUPMBR", " WHERE grp_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='GRP_ID')", false, false);
                this.copyTable("GROUPMBR_GENUS", " WHERE grp_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='GRP_ID')", false, false);
                this.outputProgress(false, "\r\nProcessing shapestores...");
                this.copyTable("SHAPESTORE", " WHERE id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='SHAPE_ID')", false, false);
                this.copyTable("SHAPESTORE_DATA", " WHERE shapestore_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='SHAPE_ID')", true, false);
                this.outputProgress(false, "\r\nProcessing charts...");
                it = this.db.getWellIterator(this.wellList.getID());
                n = 0;
                SqlCache.setSql((String)"");
                while (it.hasNext()) {
                    well = it.next();
                    wellID = well.getWellID();
                    ++n;
                    try {
                        this.outputProgress(false, "\r\nSecond round wells... Processing (" + n + "/" + total + ") well: " + well.getWellName());
                        this.outputProgress(false, "\r\nCasing, cores, interval comments, lithology...");
                        this.copyTable("CASING", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("CORES", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("CORESHIFT", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("INTCMMNTS", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("SBGS", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("SBILITH", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("SBQLITH", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("TVDHDR", " WHERE well_id=" + wellID, false, false);
                        this.outputProgress(false, "\r\nLogs...");
                        this.copyTable("LOG_CURVE", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("LOG_TRACE", " WHERE curve_id IN (SELECT curve_id FROM " + this.db.DBTableName("LOG_CURVE") + " WHERE well_id=" + wellID + ")", false, false);
                        this.copyTable("WELLSMARK", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("WELLTVD", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("WELLTWT", " WHERE well_id=" + wellID, false, false);
                        this.outputProgress(false, "\r\nSamples...");
                        this.copyTable("SAMPLES", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("SBSLITH", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("SBSSR", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("BCMMNTS", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("EVENTS", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("FAULTS", " WHERE well_id=" + wellID, false, false);
                        this.outputProgress(false, "\r\nAnalyses...");
                        this.copyTable("ANALY_HDR", " WHERE well_id=" + wellID, false, false);
                        this.outputProgress(false, "\r\nSample details...");
                        this.copyTable("SMPDTL", " WHERE well_id=" + wellID, false, false);
                        this.outputProgress(false, "\r\nOccurrences...");
                        this.copyTable("TAXONOCC", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("IGD_HDR", " WHERE well_id=" + wellID, false, false);
                        this.outputProgress(false, "\r\nIntervals...");
                        this.copyTable("IGD", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("IGD_COLMAP", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("IGD_ENV", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("IGD_LSTRAT", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("LOC", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("LOCNODE", " WHERE well_id=" + wellID, false, false);
                        this.outputProgress(false, "\r\nPicks...");
                        this.copyTable("SQPICK", " WHERE well_id=" + wellID, false, false);
                        this.outputProgress(false, "\r\nCore images...");
                        this.copyTable("SBIMAGE", " WHERE image_id IN (SELECT image_id FROM " + this.db.DBTableName("coreimage") + " WHERE well_id=" + wellID + ")", false, false);
                        this.copyTable("COREIMAGE", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("LOC", " WHERE well_id=" + wellID, false, false);
                        this.copyTable("LOCNODE", " WHERE well_id=" + wellID, false, false);
                        this.db.commit();
                        Runtime.getRuntime().gc();
                    }
                    catch (RuntimeException | SQLException e) {
                        if (this.log != null) {
                            e.printStackTrace(this.log);
                        }
                        e.printStackTrace();
                        if (JOptionPane.showConfirmDialog(this, "An error occurred processing well: " + well.getWellName() + "\n" + e.getMessage() + "\nContinue to process?", this.getTitle(), 0, 3) != 1) continue;
                        throw e;
                    }
                }
                try {
                    this.processCharts2();
                }
                catch (SQLException sqle) {
                    sqle.printStackTrace();
                    if (JOptionPane.showConfirmDialog(this, "An error occurred processing charts: " + sqle.getMessage() + "\nContinue without completing chart templates?", this.getTitle(), 0, 3) != 1) break block29;
                    throw sqle;
                }
            }
            this.copyTable("WELLIST_MBR", " WHERE wellist_id=" + this.wellList.getID(), false, false);
            try {
                sql = "SELECT user_id, abr FROM userdef";
                nStmt = this.newDB.createStatement();
                rs = nStmt.executeQuery(this.db.modQuery((String)sql));
                HashSet<Integer> users = new HashSet<Integer>();
                while (rs.next()) {
                    int userID = rs.getInt("user_id");
                    String abr = rs.getString("abr");
                    if (abr.equalsIgnoreCase("SYS")) continue;
                    users.add(userID);
                }
                rs.close();
                for (Integer userID : users) {
                    sql = "DELETE FROM userdef WHERE user_id=" + userID;
                    try {
                        nStmt.executeUpdate((String)sql);
                    }
                    catch (SQLException sqle) {
                        System.out.println("Can't delete userdef: " + userID);
                    }
                }
            }
            catch (SQLException sqle) {
                this.printLog("Error fetching USERDEF table in new database: " + sqle.getMessage());
            }
            try {
                sql = "UPDATE USERDEF SET PASSWORD=" + SB.DBString((String)"7A9EB559FA1322");
                nStmt = this.newDB.createStatement();
                int nItems = nStmt.executeUpdate((String)sql);
                this.printLog("Number of users with password reset to SYSTEM: " + nItems);
                nStmt.close();
                this.newDB.commit();
            }
            catch (SQLException sqle) {
                this.printLog("Error from updating passwords in USERDEF table in new database: " + sqle.getMessage());
            }
            this.outputProgress(false, "\r\nCompacting...");
            this.newDB.createStatement().execute("shutdown compact");
            return true;
        }
        catch (SQLException ex) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error: " + ex.getMessage(), ex, this.db);
            if (this.log != null) {
                ex.printStackTrace(this.log);
            }
            ex.printStackTrace();
        }
        catch (SBException ex) {
            this.db.doRollback();
            FrameJsbugs.showStackError("Well Error: " + ex.getMessage(), (Exception)((Object)ex), this.db);
            if (this.log != null) {
                ex.printStackTrace(this.log);
            }
            ex.printStackTrace();
        }
        catch (RuntimeException rex) {
            FrameJsbugs.showStackError("Runtime exception " + rex.getMessage(), rex, this.db);
            rex.printStackTrace();
        }
        return false;
    }

    private void processSchParent() throws SQLException, SBException, InterruptedException {
        this.outputProgress(false, "\r\nProcessing chart scheme parents...");
        try (Statement stmt = this.db.getDatabase().createStatement();
             PreparedStatement pStmt = this.db.getDatabase().prepareStatement("INSERT INTO " + this.db.DBTableName("splitid") + " (usrid,label,ID) VALUES (?,?,?)");){
            String sql = "SELECT DISTINCT PARENT FROM " + this.db.DBTableName("IGD_SCH") + " s," + this.db.DBTableName("SPLITID") + " p WHERE p.usrid=" + this.db.getUserID() + " AND p.label='SCH_ID' AND p.id=s.sch_id AND s.parent is not null";
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            while (rs.next()) {
                this.insertSplitID(pStmt, "PARENT", rs.getInt("PARENT"));
                this.outputProgress(false, "\r\nInserted ...");
            }
        }
    }

    private void processCharts1() throws SQLException, SBException, InterruptedException {
        this.outputProgress(false, "\r\nProcessing chart templates (1)...");
        try (Statement stmt = this.db.getDatabase().createStatement();
             PreparedStatement pStmt = this.db.getDatabase().prepareStatement("INSERT INTO " + this.db.DBTableName("splitid") + " (usrid,label,ID) VALUES (?,?,?)");){
            String[] fields2;
            String[] fields;
            String sql = "SELECT block_id from " + this.db.DBTableName("CHTBLOCK") + " WHERE ";
            if (this.allGlobalTemplates) {
                sql = sql + "(proj_id is null AND well_id is null) OR ";
            } else if (this.selectedBlockTemplates != null) {
                sql = sql + " (block_id IN " + this.selectedBlockTemplates + " AND well_id is null) OR ";
            }
            sql = sql + "(proj_id=" + this.project.getID() + " AND (well_id is null OR well_id IN (SELECT WELL_ID FROM " + this.db.DBTableName("WELLIST_MBR") + " WHERE wellist_id=" + this.wellList.getID() + ")))";
            sql = sql + " OR BLOCK_ID IN(SELECT BLOCK_ID FROM " + this.db.DBTableName("CHTMBR") + " WHERE CHART_ID IN(SELECT CHART_ID FROM " + this.db.DBTableName("CHART") + " WHERE PROJ_ID=" + this.project.getID() + "))";
            sql = sql + " OR BLOCK_ID IN (SELECT BLOCK_ID FROM " + this.db.DBTableName("CHTBLOCK") + " WHERE WELL_ID IN (SELECT WELL_ID FROM " + this.db.DBTableName("WELLIST_MBR") + " WHERE wellist_id=" + this.wellList.getID() + "))";
            sql = sql + " OR BLOCK_ID IN (SELECT PARENT_ID FROM " + this.db.DBTableName("CHTBLOCK") + " WHERE WELL_ID IN (SELECT WELL_ID FROM " + this.db.DBTableName("WELLIST_MBR") + " WHERE wellist_id=" + this.wellList.getID() + "))";
            sql = sql + " GROUP BY BLOCK_ID";
            System.out.println("Executing: " + sql);
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            while (rs.next()) {
                this.insertSplitID(true, pStmt, "BLOCK_ID", rs.getInt("block_id"));
            }
            this.executeBatch(pStmt);
            sql = "SELECT panel_id FROM " + this.db.DBTableName("CHTPANL") + " WHERE panel_id IN(SELECT DISTINCT panel_id FROM " + this.db.DBTableName("CHTBLOCKMBR") + " WHERE BLOCK_ID IN(SELECT id FROM  " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='BLOCK_ID')" + (String)(this.selectedBlockTemplates == null ? "" : " OR block_id IN " + this.selectedBlockTemplates) + " ) OR panel_id IN (SELECT panel_id FROM " + this.db.DBTableName("CHTBLOCKMBR") + " WHERE block_id IN( SELECT block_id FROM " + this.db.DBTableName("CHTBLOCK") + " WHERE " + (this.allGlobalTemplates ? "(proj_id is null AND well_id is null) OR" : "") + " proj_id=" + this.project.getID() + "))OR PANEL_ID IN (SELECT PANEL_ID FROM " + this.db.DBTableName("CHTPANL") + " WHERE proj_id=" + this.project.getID() + ")";
            rs = stmt.executeQuery(this.db.modQuery(sql));
            while (rs.next()) {
                this.insertSplitID(true, pStmt, "PANEL_ID", rs.getInt("panel_id"));
            }
            this.executeBatch(pStmt);
            this.insertSplitID(stmt, "block_id", "block_id FROM " + this.db.DBTableName("CHTPANL_BLKMBR") + " WHERE panel_id IN(SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='PANEL_ID')");
            sql = "SELECT panel_id FROM " + this.db.DBTableName("CHTPANL") + " WHERE panel_id IN(SELECT DISTINCT panel_id FROM " + this.db.DBTableName("CHTBLOCKMBR") + " WHERE BLOCK_ID IN(SELECT id FROM  " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='BLOCK_ID'))";
            rs = stmt.executeQuery(this.db.modQuery(sql));
            while (rs.next()) {
                this.insertSplitID(pStmt, "PANEL_ID", rs.getInt("panel_id"));
            }
            String splitWhere = " WHERE panel_id IN (SELECT id from " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='PANEL_ID')";
            for (String field : fields = new String[]{"sch_id", "std_id", "envsch_id", "synsch_id", "grpset_id", "shape_id"}) {
                sql = "SELECT distinct " + field + " FROM " + this.db.DBTableName("CHTPANL") + splitWhere + " AND " + field + " > 0";
                rs = stmt.executeQuery(this.db.modQuery(sql));
                while (rs.next()) {
                    this.insertSplitID(false, pStmt, field.toUpperCase(), rs.getInt(field));
                }
            }
            for (String field : fields2 = new String[]{"sch_id", "std_id", "grpset_id", "grp_id", "highlight_grp_id", "exclude_grp_id", "spec_id"}) {
                sql = "SELECT distinct " + field + " FROM " + this.db.DBTableName("CHTPANLMBR") + splitWhere + " AND " + field + " > 0";
                rs = stmt.executeQuery(this.db.modQuery(sql));
                String splitIDfield = field.toUpperCase();
                if (splitIDfield.endsWith("_GRP_ID")) {
                    splitIDfield = "GRP_ID";
                }
                while (rs.next()) {
                    this.insertSplitID(pStmt, splitIDfield, rs.getInt(field));
                }
            }
            sql = "SELECT distinct sch_id FROM " + this.db.DBTableName("CHTBLOCKMBR") + " WHERE BLOCK_ID IN(SELECT id FROM  " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='BLOCK_ID') AND sch_id > 0";
            rs = stmt.executeQuery(this.db.modQuery(sql));
            while (rs.next()) {
                this.insertSplitID(pStmt, "SCH_ID", rs.getInt("sch_id"));
            }
            String ageCurveWhere = " WHERE curve_id IN(SELECT agecurve_id FROM " + this.db.DBTableName("CHTPANL") + splitWhere + ")";
            if (this.allGlobalTemplates || this.selectedBlockTemplates != null) {
                sql = "SELECT distinct sch_id FROM " + this.db.DBTableName("AGE_CURVE") + ageCurveWhere + " AND sch_id > 0";
                rs = stmt.executeQuery(this.db.modQuery(sql));
                while (rs.next()) {
                    this.insertSplitID(pStmt, "SCH_ID", rs.getInt("sch_id"));
                }
            }
            sql = "SELECT curve_id FROM " + this.db.DBTableName("AGE_CURVE") + ageCurveWhere;
            rs = stmt.executeQuery(this.db.modQuery(sql));
            while (rs.next()) {
                this.insertSplitID(pStmt, "AGE_CURVE_ID", rs.getInt("curve_id"));
            }
            this.db.commit();
            this.copyTable("SYNSCH", " WHERE sch_id IN(SELECT synsch_id FROM " + this.db.DBTableName("CHTPANL") + splitWhere + ")", false, false);
        }
    }

    private void processCharts2() throws SQLException, InterruptedException {
        this.outputProgress(false, "\r\nProcessing chart templates (2)...");
        this.copyTable("AGE_CURVE", " WHERE curve_id IN (SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='AGE_CURVE_ID')", false, false);
        this.copyTable("AGE_TRACE", " WHERE curve_id IN (SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='AGE_CURVE_ID')", false, false);
        this.copyTable("ENV_SCH", " WHERE envsch_id IN (SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='ENVSCH_ID')", false, false);
        this.copyTable("ENVSCHMBR", " WHERE envsch_id IN (SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='ENVSCH_ID')", false, false);
        this.copyTable("CHTPANL", " WHERE panel_id IN(SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='PANEL_ID')", false, false);
        this.copyTable("CHTPANLMBR", " WHERE panel_id IN(SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='PANEL_ID')", false, false);
        this.copyTable("CHTANALYST", " WHERE panel_id IN(SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='PANEL_ID')", false, false);
        this.copyTable("CHTLOG", " WHERE panel_id IN(SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='PANEL_ID')", false, false);
        this.copyTable("CHTSPECTYPE", " WHERE panel_id IN(SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='PANEL_ID')", false, false);
        this.copyTable("CHTBLOCK", " WHERE block_id IN(SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='BLOCK_ID')", false, true);
        this.copyTable("CHTBLOCK", " WHERE block_id IN(SELECT block_id FROM " + this.db.DBTableName("CHTPANL_BLKMBR") + " WHERE panel_id IN (SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='PANEL_ID'))", false, true);
        this.copyTable("CHTPANL_BLKMBR", " WHERE panel_id IN(SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='PANEL_ID')", false, true);
        this.copyTable("CHTBLOCKMBR", " WHERE block_id IN(SELECT id FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID() + " AND label='BLOCK_ID')", false, true);
        this.copyTable("CHART", " WHERE chart_id IN (SELECT CHART_ID FROM " + this.db.DBTableName("CHART") + " WHERE PROJ_ID=" + this.project.getID() + " AND (WELLIST_ID is null OR WELLIST_ID=" + this.wellList.getID() + "))", false, true);
        this.copyTable("CHTMBR", " WHERE chart_id IN (SELECT CHART_ID FROM " + this.db.DBTableName("CHART") + " WHERE PROJ_ID=" + this.project.getID() + " AND (WELLIST_ID is null OR WELLIST_ID=" + this.wellList.getID() + ")) AND (wellist_id=" + this.wellList.getID() + " OR well_id IN (SELECT well_id FROM " + this.db.DBTableName("WELLIST_MBR") + " WHERE wellist_id=" + this.wellList.getID() + ")) ", false, true);
    }

    private void processLegacyCharts() throws SQLException, SBException {
        PreparedStatement pStmt = this.db.getDatabase().prepareStatement("INSERT INTO " + this.db.DBTableName("splitid") + " (usrid,label,ID) VALUES (?,?,?)");
        LinkedList charts = new LinkedList();
        SBChart.load(this.db, charts, "%");
        for (SBChart chart : charts) {
            chart.loadData();
            Iterator itP = chart.getPanels().iterator();
            boolean chartRequired = false;
            while (itP.hasNext()) {
                SBChart.Panel chPanel = (SBChart.Panel)itP.next();
                Iterator<Well> itW = this.db.getWellIterator(this.wellList.getID());
                while (itW.hasNext()) {
                    Well well = itW.next();
                    int wellID = well.getWellID();
                    if (wellID != chPanel.wellID) continue;
                    chartRequired = true;
                    break;
                }
                if (!chartRequired) continue;
                if (chPanel.groupID > 0) {
                    this.insertSplitID(true, pStmt, "GRP_ID", chPanel.groupID);
                }
                if (chPanel.filterGroup > 0) {
                    this.insertSplitID(true, pStmt, "GRP_ID", chPanel.filterGroup);
                }
                if (chPanel.highlightGroup > 0) {
                    this.insertSplitID(true, pStmt, "GRP_ID", chPanel.highlightGroup);
                }
                if (chPanel.setID > 0) {
                    this.insertSplitID(true, pStmt, "GRPSET_ID", chPanel.setID);
                }
                if (chPanel.cmpStdID <= 0) continue;
                this.insertSplitID(true, pStmt, "STD_ID", chPanel.cmpStdID);
            }
            if (!chartRequired) continue;
            this.insertSplitID(true, pStmt, "CHART_ID", chart.getChartID());
        }
        this.executeBatch(pStmt);
        this.db.commit();
        this.copyTable("SBCHARTS", " WHERE chart_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='CHART_ID')", false, true);
        this.copyTable("SBCHCLIN", " WHERE chart_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='CHART_ID')", false, true);
        this.copyTable("SBCHPANL", " WHERE chart_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='CHART_ID')", false, true);
        this.copyTable("SBLOGTRC", " WHERE chart_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='CHART_ID')", false, true);
    }

    private void processTxGroups() throws SQLException, InterruptedException {
        try (PreparedStatement pStmt = this.db.getDatabase().prepareStatement("INSERT INTO " + this.db.DBTableName("splitid") + " (usrid,label,ID) VALUES (?,?,?)");){
            HashSet<TxGroup> txGroups = new HashSet<TxGroup>(this.db.getTxGroups(this.project.getID(), this.allGlobalTemplates || this.selectedGroups != null));
            if (this.selectedGroups != null) {
                Iterator<SBRestrictable> it = txGroups.iterator();
                while (it.hasNext()) {
                    TxGroup gp = it.next();
                    if (gp.getProjID() != 0 || this.selectedGroups.contains(gp.getID())) continue;
                    it.remove();
                }
            }
            for (TxGroupSet grpSet : this.db.getTxGroupSets(this.project.getID(), this.allGlobalTemplates || this.selectedSets != null)) {
                if (grpSet.getProjID() != this.project.getID() && !this.allGlobalTemplates && !this.selectedSets.contains(grpSet.getID())) continue;
                for (TxGroup g : grpSet.getGroups()) {
                    txGroups.add(g);
                }
                this.insertSplitID(true, pStmt, "GRPSET_ID", grpSet.getID());
            }
            this.outputProgress(false, "\r\nPre-processing groups: there are: " + txGroups.size() + " to process ");
            int n = 0;
            for (TxGroup grp : txGroups) {
                System.out.println("Pre-processing group: " + grp.getName() + " (" + ++n + "/" + txGroups.size() + " members: " + (grp.getSize() + grp.getGenSize()));
                this.insertSplitID(true, pStmt, "GRP_ID", grp.getID());
                for (int genID : grp.getGenIDs()) {
                    this.insertSplitID(true, pStmt, "GEN_ID", genID);
                }
                for (int specID : grp.getSpecIDs()) {
                    this.insertSplitID(true, pStmt, "SPEC_ID", specID);
                }
            }
            this.executeBatch(pStmt);
        }
        this.db.commit();
    }

    private void insertSplitID(PreparedStatement pStmt, String name, int ID) throws SQLException {
        this.insertSplitID(false, pStmt, name, ID);
    }

    private void insertSplitID(boolean asBatch, PreparedStatement pStmt, String name, int ID) throws SQLException {
        block4: {
            pStmt.setInt(1, this.db.getUserID());
            pStmt.setString(2, name);
            pStmt.setInt(3, ID);
            if (asBatch) {
                pStmt.addBatch();
            } else {
                try {
                    pStmt.executeUpdate();
                }
                catch (SQLException se) {
                    if (this.isDuplicateException(se)) break block4;
                    throw se;
                }
            }
        }
    }

    private void executeBatch(PreparedStatement pStmt) {
        int[] affectedRows = null;
        try {
            affectedRows = pStmt.executeBatch();
        }
        catch (SQLException sqle) {
            System.out.println("SQL Exception in executeBatch: " + sqle.getMessage());
            sqle.printStackTrace();
        }
        if (affectedRows != null) {
            int nInserted = 0;
            int nError = 0;
            int nNoInfo = 0;
            for (int row : affectedRows) {
                if (row > 0) {
                    ++nInserted;
                    continue;
                }
                if (row == -3) {
                    ++nError;
                    continue;
                }
                ++nNoInfo;
            }
            System.out.println("Batch update: Number of rows affected: " + affectedRows.length + ", Inserted: " + nInserted + ", Error: " + nError + ", No Info: " + nNoInfo);
        }
    }

    private void insertSplitID(Statement stmt, String field, String select) throws SQLException {
        block2: {
            try {
                String sql = "INSERT INTO " + this.db.DBTableName("splitid") + " (usrid, label, ID) SELECT " + this.db.getUserID() + "," + SB.DBString((String)field.toUpperCase()) + "," + select;
                stmt.executeUpdate(this.db.modQuery(sql));
            }
            catch (SQLException se) {
                if (this.isDuplicateException(se)) break block2;
                throw se;
            }
        }
        this.db.commit();
    }

    private void createSplitIDs(Statement stmt, String columnName, String tableName, int wellID) throws SQLException {
        block10: {
            String sql = "SELECT " + columnName + " FROM " + this.db.DBTableName(tableName) + " WHERE well_id=" + wellID;
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            try (PreparedStatement pStmt = this.db.getDatabase().prepareStatement("INSERT INTO " + this.db.DBTableName("splitid") + " (usrid,label,ID) VALUES (" + this.db.getUserID() + ",'" + columnName + "',?)");){
                while (rs.next()) {
                    pStmt.setInt(1, rs.getInt(columnName));
                    pStmt.addBatch();
                }
                try {
                    pStmt.executeBatch();
                }
                catch (SQLException se) {
                    if (this.isDuplicateException(se)) {
                        break block10;
                    }
                    System.out.println(se.getMessage());
                    throw se;
                }
            }
        }
        this.db.commit();
    }

    private void outputProgress(boolean clear, String text) throws InterruptedException {
        if (this.task.isCancelled()) {
            throw new InterruptedException();
        }
        if (clear) {
            this.jTextPaneProgress.setText("");
        }
        this.jTextPaneProgress.setText(this.jTextPaneProgress.getText() + text);
        try {
            this.jTextPaneProgress.scrollRectToVisible(new Rectangle(0, this.jTextPaneProgress.getHeight(), this.jTextPaneProgress.getWidth(), 10));
        }
        catch (NullPointerException e) {
            System.out.println("Null pointer exception in scrollRectToVisible ... continuing.");
        }
        this.jTextPaneProgress.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void printLog(String entry) {
        if (this.log != null) {
            this.log.println(entry);
        } else {
            System.out.println(entry);
        }
    }

    private void copyTable(String tableName, String whereClause, boolean clearValues, boolean ignoreFKexceptions) throws SQLException {
        try (Statement newStmt = this.newDB.createStatement();){
            int i;
            ResultSet rs;
            if (clearValues) {
                newStmt.executeUpdate("DELETE FROM " + tableName);
            }
            Object selectQuery = "SELECT * FROM " + tableName;
            ResultSet rsNew = newStmt.executeQuery((String)selectQuery);
            ResultSetMetaData meta = rsNew.getMetaData();
            int nCols = meta.getColumnCount();
            selectQuery = "SELECT ";
            for (int i2 = 1; i2 <= nCols; ++i2) {
                selectQuery = (String)selectQuery + meta.getColumnName(i2);
                if (i2 >= nCols) continue;
                selectQuery = (String)selectQuery + ",";
            }
            selectQuery = (String)selectQuery + " FROM " + this.db.DBTableName(tableName);
            Statement stmt = this.db.getDatabase().createStatement();
            if (whereClause != null) {
                selectQuery = (String)selectQuery + whereClause;
            }
            try {
                this.printLog("Executing query in copyTable: " + (String)selectQuery);
                rs = stmt.executeQuery((String)selectQuery);
            }
            catch (SQLException se) {
                selectQuery = "SELECT * FROM " + this.db.DBTableName(tableName);
                if (whereClause != null) {
                    selectQuery = (String)selectQuery + whereClause;
                }
                this.printLog("Re-trying: Select query: " + (String)selectQuery);
                rs = stmt.executeQuery((String)selectQuery);
                meta = rs.getMetaData();
                nCols = meta.getColumnCount();
            }
            ResultSetMetaData sourceMeta = rs.getMetaData();
            Object sql = "INSERT INTO " + tableName + "(";
            boolean foundUpsize = false;
            for (i = 1; i <= nCols; ++i) {
                String colName = meta.getColumnName(i);
                if (colName.equals("upsize_ts")) {
                    foundUpsize = true;
                    continue;
                }
                sql = (String)sql + colName;
                if (i >= nCols) continue;
                sql = (String)sql + ",";
            }
            if (foundUpsize) {
                if (((String)sql).charAt(((String)sql).length() - 1) == ',') {
                    sql = ((String)sql).substring(0, ((String)sql).length() - 1);
                }
                --nCols;
            }
            sql = (String)sql + " ) VALUES (";
            for (i = 1; i <= nCols; ++i) {
                sql = (String)sql + "?";
                if (i >= nCols) continue;
                sql = (String)sql + ",";
            }
            sql = (String)sql + ")";
            PreparedStatement pStmt = this.newDB.prepareStatement((String)sql);
            while (rs.next()) {
                Object paramString = "";
                for (int col = 1; col <= nCols; ++col) {
                    if (sourceMeta.getColumnType(col) == 2004) {
                        pStmt.setBytes(col, rs.getBytes(col));
                        paramString = (String)paramString + "BLOB,";
                        continue;
                    }
                    if (sourceMeta.getColumnType(col) == 2005) {
                        if (this.db.getDBType() == DBType.ORACLE) {
                            Clob clob = rs.getClob(col);
                            pStmt.setClob(col, clob);
                        } else {
                            pStmt.setBytes(col, rs.getBytes(col));
                        }
                        paramString = (String)paramString + "CLOB,";
                        continue;
                    }
                    if (sourceMeta.getColumnType(col) == 93 && sourceMeta.getColumnName(col).equalsIgnoreCase("UPDATED")) {
                        pStmt.setNull(col, 93);
                        continue;
                    }
                    if (sourceMeta.getColumnType(col) == 12 && sourceMeta.getPrecision(col) > meta.getPrecision(col)) {
                        String s = rs.getString(col);
                        if (s != null) {
                            if (s.length() > meta.getPrecision(col)) {
                                this.printLog("Truncating string: " + s);
                                s = s.substring(0, meta.getPrecision(col));
                            }
                            pStmt.setString(col, s);
                            continue;
                        }
                        pStmt.setNull(col, meta.getColumnType(col));
                        continue;
                    }
                    Object obj = rs.getObject(col);
                    if (obj != null) {
                        if ((meta.getColumnName(col).equalsIgnoreCase("CREATOR") || meta.getColumnName(col).equalsIgnoreCase("MODIFIER") || meta.getColumnName(col).equalsIgnoreCase("UPDATER")) && Integer.parseInt(obj.toString()) == 0) {
                            pStmt.setNull(col, meta.getColumnType(col));
                        } else {
                            pStmt.setObject(col, obj);
                        }
                    } else {
                        int type = meta.getColumnType(col);
                        if (type == 3) {
                            type = 8;
                        }
                        pStmt.setNull(col, type);
                    }
                    paramString = (String)paramString + String.valueOf(obj) + ",";
                }
                try {
                    pStmt.executeUpdate();
                }
                catch (SQLException se) {
                    if (this.isDuplicateException(se)) continue;
                    if (ignoreFKexceptions && this.isFKexception(se)) {
                        this.printLog("Foreign key exception when inserting into " + tableName + ": " + (String)paramString);
                        continue;
                    }
                    if (JOptionPane.showConfirmDialog(this, "Error inserting record: " + se.getMessage() + "\nParameters: " + (String)paramString + "\n\nContinue export?:", this.getTitle(), 0, 3) != 0) {
                        this.printLog("Parameters:" + (String)paramString);
                        throw se;
                    }
                    se.printStackTrace();
                }
            }
            pStmt.close();
            stmt.close();
            this.newDB.commit();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.jButtonCloseActionPerformed(null);
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogcreatedatabase.html");
    }

    private boolean checkExistingData() throws SQLException {
        try (Statement stmt = this.newDB.createStatement();){
            String sql = "SELECT count(*) AS nWells FROM WELLS";
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            int nWells = 0;
            if (rs.next()) {
                nWells = rs.getInt("nWells");
            }
            if (nWells > 0 && JOptionPane.showConfirmDialog(this, "WARNING: selected database contains existing data. Continue (at your own risk)?", this.getTitle(), 0, 2) != 0) {
                stmt.close();
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private boolean isDuplicateException(SQLException se) {
        return se.getMessage().equalsIgnoreCase("GENERAL ERROR") || se.getMessage().contains("ORA-00001") || se.getMessage().contains("Violation of PRIMARY KEY") || se.getMessage().contains("duplicate key value violates unique constraint") || se.getMessage().startsWith("Unique index or primary key violation");
    }

    private boolean isFKexception(SQLException se) {
        return se instanceof JdbcSQLIntegrityConstraintViolationException;
    }
}

