/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.Discipline;
import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import jsbugs.FrameJsbugs;
import jsbugs.userconnect.DialogSelectAnalyst;
import model3.AnalystHeader;
import model3.Biocom;
import model3.SBdb;
import model3.Well;
import model3.WellInterp;
import util.SBException;
import util.exception.StackError;

public class DialogEditBiocoms
extends SBDialog {
    private final DefaultComboBoxModel comboModelDiscipline = new DefaultComboBoxModel<Discipline>(Discipline.values());
    private final DefaultComboBoxModel comboModelAnalyst = new DefaultComboBoxModel();
    private static final int MAXLEN = 240;
    Well well;
    SBdb db;
    WellInterp wellInterp;
    List<Biocom> biocoms;
    private ButtonGroup buttonGroup1;
    private JButton jButtonAnalyst;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxAnalyst;
    private JComboBox jComboBoxDisc;
    private JRadioButton jRadioButtonAnalyst;
    private JRadioButton jRadioButtonDisc;
    private JRadioButton jRadioButtonText;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea1;
    private JTextArea jTextAreaBiocom;

    public DialogEditBiocoms(Frame parent, boolean modal, Well well, WellInterp wellInterp, List<Biocom> biocoms) throws SQLException, SBException {
        super(parent, modal);
        this.well = well;
        this.wellInterp = wellInterp;
        this.biocoms = biocoms;
        this.db = well.getDataModel();
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Biostratigraphic comments");
        this.fillAnalystCombo();
        Discipline disc = null;
        String analyst = null;
        boolean first = true;
        for (Biocom biocom : this.biocoms) {
            if (disc == null && first) {
                disc = biocom.getDiscipline();
            } else if (disc != biocom.getDiscipline()) {
                disc = null;
            }
            if (analyst == null && first) {
                analyst = biocom.getAnalystString();
            } else if (!analyst.equals(biocom.getAnalystString())) {
                analyst = null;
            }
            first = false;
        }
        this.jComboBoxAnalyst.setSelectedItem(analyst);
        this.jComboBoxDisc.setSelectedItem(disc);
    }

    private void fillAnalystCombo() throws SQLException, SBException {
        Iterator<AnalystHeader> itr = this.well.getAnalystHeaderIterator();
        this.comboModelAnalyst.removeAllElements();
        this.comboModelAnalyst.addElement("");
        while (itr.hasNext()) {
            AnalystHeader hdr = itr.next();
            String abr = hdr.getAnalyst();
            if (this.comboModelAnalyst.getIndexOf(abr) >= 0) continue;
            this.comboModelAnalyst.addElement(abr);
        }
        this.jComboBoxAnalyst.repaint();
        this.jComboBoxAnalyst.setSelectedIndex(0);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jRadioButtonAnalyst = new JRadioButton();
        this.jComboBoxAnalyst = new JComboBox();
        this.jButtonAnalyst = new JButton();
        this.jRadioButtonText = new JRadioButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTextAreaBiocom = new JTextArea();
        this.jComboBoxDisc = new JComboBox();
        this.jRadioButtonDisc = new JRadioButton();
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.setDefaultCloseOperation(2);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEditBiocoms this$0;
            {
                DialogEditBiocoms dialogEditBiocoms = this$0;
                Objects.requireNonNull(dialogEditBiocoms);
                this.this$0 = dialogEditBiocoms;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEditBiocoms this$0;
            {
                DialogEditBiocoms dialogEditBiocoms = this$0;
                Objects.requireNonNull(dialogEditBiocoms);
                this.this$0 = dialogEditBiocoms;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonAnalyst);
        this.jRadioButtonAnalyst.setText("Change analyst to:");
        this.jComboBoxAnalyst.setModel(this.comboModelAnalyst);
        this.jComboBoxAnalyst.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jComboBoxAnalyst.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEditBiocoms this$0;
            {
                DialogEditBiocoms dialogEditBiocoms = this$0;
                Objects.requireNonNull(dialogEditBiocoms);
                this.this$0 = dialogEditBiocoms;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxAnalystActionPerformed(evt);
            }
        });
        this.jButtonAnalyst.setText("...");
        this.jButtonAnalyst.setToolTipText("Select analyst");
        this.jButtonAnalyst.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonAnalyst.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEditBiocoms this$0;
            {
                DialogEditBiocoms dialogEditBiocoms = this$0;
                Objects.requireNonNull(dialogEditBiocoms);
                this.this$0 = dialogEditBiocoms;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAnalystActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonText);
        this.jRadioButtonText.setText("Add text:");
        this.jTextAreaBiocom.setColumns(20);
        this.jTextAreaBiocom.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextAreaBiocom);
        this.jComboBoxDisc.setModel(this.comboModelDiscipline);
        this.jComboBoxDisc.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.buttonGroup1.add(this.jRadioButtonDisc);
        this.jRadioButtonDisc.setText("change discipline to:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonCancel)).addComponent(this.jScrollPane2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jRadioButtonText, -1, -1, Short.MAX_VALUE).addComponent(this.jRadioButtonAnalyst, -1, -1, Short.MAX_VALUE)).addComponent(this.jRadioButtonDisc)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxDisc, -2, 180, -2).addGroup(layout.createSequentialGroup().addComponent(this.jComboBoxAnalyst, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAnalyst, -2, 30, -2))).addGap(0, 71, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxDisc, -2, -1, -2).addComponent(this.jRadioButtonDisc)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonAnalyst).addComponent(this.jComboBoxAnalyst, -2, -1, -2).addComponent(this.jButtonAnalyst)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonText).addGap(7, 7, 7).addComponent(this.jScrollPane2, -1, 158, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.jButtonCancel)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.buttonGroup1.getSelection() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No option selected", this.getTitle(), 1);
            return;
        }
        try {
            Biocom last = null;
            if (this.jRadioButtonDisc.isSelected()) {
                Discipline disc = (Discipline)this.jComboBoxDisc.getSelectedItem();
                if (disc == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "No discipline selected", this.getTitle(), 1);
                    return;
                }
                for (Biocom biocom : this.biocoms) {
                    if (biocom.getDiscipline() == disc) continue;
                    List<Biocom> existing = this.wellInterp.getComments(disc.getChar());
                    for (Biocom b : existing) {
                        if (b.getSample() != biocom.getSample()) continue;
                        JOptionPane.showMessageDialog((Component)((Object)this), "Cannot edit: already an existing comment for: " + disc.getNoun() + " for sample: " + b.getSample().toString(), this.getTitle(), 1);
                        return;
                    }
                }
                for (Biocom biocom : this.biocoms) {
                    Biocom.Builder builder = new Biocom.Builder(this.well.getDataModel(), disc, biocom.getAnalyst(), biocom.getTopSample(), biocom.getText()).baseSample(biocom.getBaseSample()).source(biocom.getSource());
                    this.wellInterp.updateBiocom(biocom, builder, this.well.getWellID());
                    last = biocom;
                }
            } else if (this.jRadioButtonAnalyst.isSelected()) {
                String analyst = (String)this.jComboBoxAnalyst.getSelectedItem();
                if (analyst == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "No analyst selected", this.getTitle(), 1);
                    return;
                }
                for (Biocom biocom : this.biocoms) {
                    if (analyst.equals(biocom.getAnalystString())) continue;
                    List<Biocom> existing = this.wellInterp.getComments(biocom.getDiscID());
                    for (Biocom b : existing) {
                        if (b.getSample() != biocom.getSample() || !b.getAnalystString().equals(analyst)) continue;
                        JOptionPane.showMessageDialog((Component)((Object)this), "Cannot edit: already an existing comment for: " + analyst + " for sample: " + b.getSample().toString(), this.getTitle(), 1);
                        return;
                    }
                }
                for (Biocom biocom : this.biocoms) {
                    Biocom.Builder builder = new Biocom.Builder(this.well.getDataModel(), biocom.getDiscipline(), this.well.getDataModel().getUserID(analyst), biocom.getTopSample(), biocom.getText()).baseSample(biocom.getBaseSample()).source(biocom.getSource());
                    this.wellInterp.updateBiocom(biocom, builder, this.well.getWellID());
                    last = biocom;
                }
            } else if (this.jRadioButtonText.isSelected()) {
                Object text = this.jTextAreaBiocom.getText();
                if (text == null || ((String)text).isEmpty()) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "No text entered", this.getTitle(), 1);
                    return;
                }
                if (((String)text).charAt(0) != ' ' && ((String)text).charAt(0) != ',') {
                    text = ", " + (String)text;
                }
                if (((String)text).length() > 240) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Length of text exceeds 240", this.getTitle(), 1);
                    return;
                }
                for (Biocom biocom : this.biocoms) {
                    if ((biocom.getText() + (String)text).length() <= 240) continue;
                    JOptionPane.showMessageDialog((Component)((Object)this), "Length of new text for comment: " + String.valueOf(biocom) + " exceeds 240", this.getTitle(), 1);
                    return;
                }
                for (Biocom biocom : this.biocoms) {
                    Biocom.Builder builder = new Biocom.Builder(this.well.getDataModel(), biocom.getDiscipline(), biocom.getAnalyst(), biocom.getTopSample(), biocom.getText() + " " + (String)text).baseSample(biocom.getBaseSample()).source(biocom.getSource());
                    this.wellInterp.updateBiocom(biocom, builder, this.well.getWellID());
                    last = biocom;
                }
            }
            if (last != null) {
                this.wellInterp.notifyObservers(last);
                this.db.commit();
            }
            this.setOK();
        }
        catch (SQLException | SBException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("Error adding sample", (Exception)sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonAnalystActionPerformed(ActionEvent evt) {
        DialogSelectAnalyst dialog;
        try {
            dialog = new DialogSelectAnalyst((JDialog)((Object)this), true, this.db, true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
            return;
        }
        dialog.setVisible(true);
        if (dialog.selectedUser != null) {
            if (this.comboModelAnalyst.getIndexOf(dialog.selectedUser.getAbr()) < 0) {
                int pos;
                for (pos = 0; pos < this.comboModelAnalyst.getSize(); ++pos) {
                    String abr = (String)this.comboModelAnalyst.getElementAt(pos);
                    if (dialog.selectedUser.getAbr().compareTo(abr) < 0) break;
                }
                this.comboModelAnalyst.insertElementAt(dialog.selectedUser.getAbr(), pos);
                this.jComboBoxAnalyst.repaint();
            }
            this.jComboBoxAnalyst.setSelectedItem(dialog.selectedUser.getAbr());
        }
    }

    private void jComboBoxAnalystActionPerformed(ActionEvent evt) {
    }
}

