/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.DialogMergeSamples;
import jsbugs.FrameJsbugs;
import jsbugs.uiutil.TextFieldUtils;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import org.jdesktop.layout.GroupLayout;
import util.DepthUnits;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.exception.StackError;

public class DialogEditSamples
extends SBDialog {
    private static final int LABELEN = 30;
    private final DefaultComboBoxModel typeModel = new DefaultComboBoxModel<SampleType>(SampleType.values());
    private final Well well;
    private final SBdb db;
    private final char units;
    List<Sample> samples;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JComboBox jComboBoxType;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabelBaseDepthOffsetUnits;
    private JLabel jLabelShiftUnits;
    private JLabel jLabelStatus;
    private JLabel jLabelTopDepthOffsetUnits;
    private JRadioButton jRadioButtonBaseToTop;
    private JRadioButton jRadioButtonLabel;
    private JRadioButton jRadioButtonSetBaseByOffset;
    private JRadioButton jRadioButtonSetTopByOffset;
    private JRadioButton jRadioButtonShift;
    private JRadioButton jRadioButtonTopToBase;
    private JRadioButton jRadioButtonType;
    private JSeparator jSeparator1;
    private JTextField jTextFieldBaseDepthOffset;
    private JTextField jTextFieldLabel;
    private JTextField jTextFieldShift;
    private JTextField jTextFieldTopDepthOffset;

    public DialogEditSamples(Frame parent, boolean modal, SBdb db, Well well, char units, List<Sample> samples) {
        super(parent, modal);
        this.well = well;
        this.db = db;
        this.units = units;
        this.samples = samples;
        this.setLocation(parent.getLocation().x + 25, parent.getLocation().y + 25);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.setTitle("Samples : Edit");
        if (this.well.getType() == 'O') {
            this.jComboBoxType.setSelectedItem(SampleType.OC);
        }
        this.jLabelStatus.setText(this.samples.size() + " sample to update");
        try {
            if (!this.well.canWrite(this.db, null)) {
                this.jButtonOK.setEnabled(false);
                this.jButtonOK.setToolTipText(this.well.getDeniedReason(this.db, "well", false));
                this.jLabelStatus.setText("Well is read-only");
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        this.jLabelTopDepthOffsetUnits.setText(DepthUnits.getUnits((char)this.units).getAbr());
        this.jLabelBaseDepthOffsetUnits.setText(DepthUnits.getUnits((char)this.units).getAbr());
        this.jLabelShiftUnits.setText(DepthUnits.getUnits((char)this.units).getAbr());
        this.jTextFieldTopDepthOffset.setDocument(TextFieldUtils.buildIntegerDocument(false, 99L));
        this.jTextFieldBaseDepthOffset.setDocument(TextFieldUtils.buildIntegerDocument(false, 99L));
        this.jTextFieldShift.setDocument(TextFieldUtils.buildDecimalDocument(true, 99999.9, 3));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jComboBoxType = new JComboBox();
        this.jComboBoxType.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jTextFieldLabel = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jButtonHelp = new JButton();
        this.jRadioButtonBaseToTop = new JRadioButton();
        this.jRadioButtonTopToBase = new JRadioButton();
        this.jLabelStatus = new JLabel();
        this.jRadioButtonType = new JRadioButton();
        this.jRadioButtonLabel = new JRadioButton();
        this.jRadioButtonSetTopByOffset = new JRadioButton();
        this.jRadioButtonSetBaseByOffset = new JRadioButton();
        this.jTextFieldTopDepthOffset = new JTextField();
        this.jLabelTopDepthOffsetUnits = new JLabel();
        this.jLabelBaseDepthOffsetUnits = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jTextFieldBaseDepthOffset = new JTextField();
        this.jRadioButtonShift = new JRadioButton();
        this.jTextFieldShift = new JTextField();
        this.jLabelShiftUnits = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel1.setText("jLabel1");
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(false);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEditSamples this$0;
            {
                DialogEditSamples dialogEditSamples = this$0;
                Objects.requireNonNull(dialogEditSamples);
                this.this$0 = dialogEditSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEditSamples this$0;
            {
                DialogEditSamples dialogEditSamples = this$0;
                Objects.requireNonNull(dialogEditSamples);
                this.this$0 = dialogEditSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jComboBoxType.setModel(this.typeModel);
        this.jComboBoxType.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEditSamples this$0;
            {
                DialogEditSamples dialogEditSamples = this$0;
                Objects.requireNonNull(dialogEditSamples);
                this.this$0 = dialogEditSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxTypeActionPerformed(evt);
            }
        });
        this.jTextFieldLabel.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogEditSamples this$0;
            {
                DialogEditSamples dialogEditSamples = this$0;
                Objects.requireNonNull(dialogEditSamples);
                this.this$0 = dialogEditSamples;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldLabelKeyTyped(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEditSamples this$0;
            {
                DialogEditSamples dialogEditSamples = this$0;
                Objects.requireNonNull(dialogEditSamples);
                this.this$0 = dialogEditSamples;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonBaseToTop);
        this.jRadioButtonBaseToTop.setText("Move base depths to top");
        this.jRadioButtonBaseToTop.setToolTipText("");
        this.buttonGroup1.add(this.jRadioButtonTopToBase);
        this.jRadioButtonTopToBase.setText("Move top depths to base");
        this.jLabelStatus.setText("jLabel2");
        this.buttonGroup1.add(this.jRadioButtonType);
        this.jRadioButtonType.setText("Change sample type to:");
        this.buttonGroup1.add(this.jRadioButtonLabel);
        this.jRadioButtonLabel.setText("Change label to:");
        this.buttonGroup1.add(this.jRadioButtonSetTopByOffset);
        this.jRadioButtonSetTopByOffset.setText("Set selected top depths to");
        this.buttonGroup1.add(this.jRadioButtonSetBaseByOffset);
        this.jRadioButtonSetBaseByOffset.setText("Set selected base depths to");
        this.jLabelTopDepthOffsetUnits.setText("m");
        this.jLabelBaseDepthOffsetUnits.setText("m");
        this.jLabel4.setText("above base depths.");
        this.jLabel5.setText("below top depths.");
        this.buttonGroup1.add(this.jRadioButtonShift);
        this.jRadioButtonShift.setText("Change top and base depths by this amount:");
        this.jRadioButtonShift.setToolTipText("Use a negative value to decrease the depths");
        this.jLabelShiftUnits.setText("m");
        this.jLabel6.setToolTipText("Use \"-\" to shift upwards in wells, shifts top and base depths is specified");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelStatus, -1, -1, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jRadioButtonType).add((Component)this.jRadioButtonLabel).add((Component)this.jRadioButtonBaseToTop)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jComboBoxType, 0, -1, Short.MAX_VALUE).add((Component)this.jTextFieldLabel))).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jRadioButtonTopToBase).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jRadioButtonSetTopByOffset, -2, 186, -2).add((Component)this.jRadioButtonSetBaseByOffset)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldBaseDepthOffset, -2, 33, -2).addPreferredGap(0).add((Component)this.jLabelBaseDepthOffsetUnits).addPreferredGap(0).add((Component)this.jLabel5)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldTopDepthOffset, -2, 33, -2).addPreferredGap(0).add((Component)this.jLabelTopDepthOffsetUnits).addPreferredGap(0).add((Component)this.jLabel4)))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jRadioButtonShift).addPreferredGap(0).add((Component)this.jTextFieldShift, -2, 33, -2).addPreferredGap(0).add((Component)this.jLabelShiftUnits).addPreferredGap(0).add((Component)this.jLabel6))).add(0, 51, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxType, -2, -1, -2).add((Component)this.jRadioButtonType)).add(5, 5, 5).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldLabel, -2, -1, -2).add((Component)this.jRadioButtonLabel)).add(5, 5, 5).add((Component)this.jRadioButtonBaseToTop).add(5, 5, 5).add((Component)this.jRadioButtonTopToBase).add(5, 5, 5).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jRadioButtonSetTopByOffset).add((Component)this.jTextFieldTopDepthOffset, -2, -1, -2).add((Component)this.jLabelTopDepthOffsetUnits).add((Component)this.jLabel4)).add(5, 5, 5).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jRadioButtonSetBaseByOffset).add((Component)this.jTextFieldBaseDepthOffset, -2, -1, -2).add((Component)this.jLabelBaseDepthOffsetUnits).add((Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jRadioButtonShift).add((Component)this.jTextFieldShift, -2, -1, -2).add((Component)this.jLabelShiftUnits).add((Component)this.jLabel6)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonOK).add((Component)this.jButtonHelp).add((Component)this.jButtonCancel).add((Component)this.jLabelStatus)).addContainerGap()));
        this.pack();
    }

    private void jTextFieldLabelKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldLabel, (int)30, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.buttonGroup1.getSelection() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No option selected", this.getTitle(), 1);
            return;
        }
        try {
            Sample last = null;
            if (this.jRadioButtonLabel.isSelected()) {
                int opt;
                String newLabel = this.jTextFieldLabel.getText().trim();
                if (newLabel.isEmpty() && (opt = JOptionPane.showConfirmDialog((Component)((Object)this), "No label entered - clear label?", this.getTitle(), 0, 3)) == 1) {
                    return;
                }
                for (Sample sample : this.samples) {
                    if (sample.getLabel() == null || sample.getLabel().isEmpty()) continue;
                    int opt2 = JOptionPane.showConfirmDialog((Component)((Object)this), "Existing sample label(s) are not blank, overwrite?", this.getTitle(), 0, 3);
                    if (opt2 != 1) break;
                    return;
                }
                for (Sample sample : this.samples) {
                    Sample.Builder builder = new Sample.Builder().topDepth(sample.getTopDepth()).baseDepth(sample.getBaseDepth()).type(sample.getType()).label(newLabel);
                    this.well.updateSample(sample, builder);
                    last = sample;
                }
            } else if (this.jRadioButtonType.isSelected()) {
                SampleType type = (SampleType)this.jComboBoxType.getSelectedItem();
                for (Sample sample : this.samples) {
                    if (sample.getType() == type || this.well.getSample(sample.getTopDepth(), sample.getBaseDepth(), type) == null) continue;
                    JOptionPane.showMessageDialog((Component)((Object)this), "Cannot change sample type: " + String.valueOf(sample) + ": sample already exists", this.getTitle(), 1);
                    return;
                }
                for (Sample sample : this.samples) {
                    Sample.Builder builder = new Sample.Builder().topDepth(sample.getTopDepth()).baseDepth(sample.getBaseDepth()).type(type).label(sample.getLabel());
                    this.well.updateSample(sample, builder);
                    last = sample;
                }
            } else if (this.jRadioButtonTopToBase.isSelected()) {
                for (Sample sample : this.samples) {
                    if (sample.getTopDepth() == null || sample.getBaseDepth() == null) continue;
                    JOptionPane.showMessageDialog((Component)((Object)this), "Cannot change sample: " + String.valueOf(sample) + " : base depth already exists", this.getTitle(), 1);
                    return;
                }
                for (Sample sample : this.samples) {
                    if (sample.getTopDepth() == null) continue;
                    Sample.Builder builder = new Sample.Builder().topDepth(null).baseDepth(sample.getTopDepth()).type(sample.getType()).label(sample.getLabel());
                    this.well.updateSample(sample, builder);
                    last = sample;
                }
            } else if (this.jRadioButtonBaseToTop.isSelected()) {
                for (Sample sample : this.samples) {
                    if (sample.getBaseDepth() == null || sample.getTopDepth() == null) continue;
                    JOptionPane.showMessageDialog((Component)((Object)this), "Cannot change sample: " + String.valueOf(sample) + " : top depth already exists", this.getTitle(), 1);
                    return;
                }
                for (Sample sample : this.samples) {
                    if (sample.getBaseDepth() == null) continue;
                    Sample.Builder builder = new Sample.Builder().topDepth(sample.getBaseDepth()).baseDepth(null).type(sample.getType()).label(sample.getLabel());
                    this.well.updateSample(sample, builder);
                    last = sample;
                }
            } else if (this.jRadioButtonSetBaseByOffset.isSelected()) {
                if (this.jTextFieldBaseDepthOffset.getText().length() == 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "No offset specified, please enter an offset value.", this.getTitle(), 1);
                    return;
                }
                if (this.countSamplesWithTopDepth() < this.samples.size()) {
                    int missing = this.samples.size() - this.countSamplesWithTopDepth();
                    String message = String.format("%s of the selected samples doesn't have a top depth, please make sure all selected samples have a top depth specified.", missing);
                    JOptionPane.showMessageDialog((Component)((Object)this), message, this.getTitle(), 1);
                    return;
                }
                float offset = DepthUtils.convToM((float)Float.parseFloat(this.jTextFieldBaseDepthOffset.getText()), (char)this.units);
                boolean overwriteValues = false;
                if (this.countSamplesWithBaseDepth() > 0) {
                    String message = String.format("%s of the selected samples already have a base depths specified, overwrite these values?", this.countSamplesWithBaseDepth());
                    int result = JOptionPane.showConfirmDialog((Component)((Object)this), message, this.getTitle(), 1, 2);
                    if (result == 2) {
                        return;
                    }
                    overwriteValues = result == 0;
                }
                int skipCount = 0;
                for (Sample sample : this.samples) {
                    if (sample.getBaseDepth() != null && !overwriteValues) continue;
                    Sample.Builder builder = new Sample.Builder().topDepth(sample.getTopDepth()).baseDepth(sample.getTopDepth() + (double)offset).type(sample.getType()).label(sample.getLabel());
                    if (this.doesSampleExist(builder)) {
                        ++skipCount;
                        continue;
                    }
                    this.well.updateSample(sample, builder);
                    last = sample;
                }
                if (skipCount > 0) {
                    String message = String.format("%s samples were not updated because samples at the target depth already existed.", skipCount);
                    if (skipCount == 1) {
                        message = "One sample was not updated because a sample at the target depth already existed.";
                    }
                    JOptionPane.showMessageDialog((Component)((Object)this), message, this.getTitle(), 1);
                }
            } else if (this.jRadioButtonSetTopByOffset.isSelected()) {
                if (this.jTextFieldTopDepthOffset.getText().length() == 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "No offset specified, please enter an offset value.", this.getTitle(), 1);
                    return;
                }
                if (this.countSamplesWithBaseDepth() < this.samples.size()) {
                    int missing = this.samples.size() - this.countSamplesWithBaseDepth();
                    String message = String.format("%s of the selected samples doesn't have a base depth, please make sure all selected samples have a base depth specified.", missing);
                    JOptionPane.showMessageDialog((Component)((Object)this), message, this.getTitle(), 1);
                    return;
                }
                float offset = DepthUtils.convToM((float)Float.parseFloat(this.jTextFieldTopDepthOffset.getText()), (char)this.units);
                boolean overwriteValues = false;
                if (this.countSamplesWithTopDepth() > 0) {
                    String message = String.format("%s of the selected samples already have a top depth specified, overwrite these values?", this.countSamplesWithTopDepth());
                    int result = JOptionPane.showConfirmDialog((Component)((Object)this), message, this.getTitle(), 1, 2);
                    if (result == 2) {
                        return;
                    }
                    overwriteValues = result == 0;
                }
                int skipCount = 0;
                for (Sample sample : this.samples) {
                    if (sample.getTopDepth() != null && !overwriteValues) continue;
                    Sample.Builder builder = new Sample.Builder().topDepth(sample.getBaseDepth() - (double)offset).baseDepth(sample.getBaseDepth()).type(sample.getType()).label(sample.getLabel());
                    if (this.doesSampleExist(builder)) {
                        ++skipCount;
                        continue;
                    }
                    this.well.updateSample(sample, builder);
                    last = sample;
                }
                if (skipCount > 0) {
                    String message = String.format("%s samples were not updated because samples at the target depth already existed.", skipCount);
                    if (skipCount == 1) {
                        message = "One sample was not updated because a sample at the target depth already existed.";
                    }
                    JOptionPane.showMessageDialog((Component)((Object)this), message, this.getTitle(), 1);
                }
            } else if (this.jRadioButtonShift.isSelected()) {
                ListIterator<Sample> it;
                if (this.jTextFieldShift.getText().length() == 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "No depth increment specified, please enter a value.", this.getTitle(), 1);
                    return;
                }
                double shift = DepthUtils.convToM((double)Double.parseDouble(this.jTextFieldShift.getText()), (char)this.units);
                if (Math.abs(shift) < (double)0.0029f) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "No significant depth increment specified, please enter a positive or negative value.", this.getTitle(), 1);
                    return;
                }
                Sample sample = null;
                if (shift > 0.0) {
                    it = this.samples.listIterator(this.samples.size());
                    if (it.hasPrevious()) {
                        sample = it.previous();
                    }
                } else {
                    it = this.samples.listIterator();
                    if (it.hasNext()) {
                        sample = it.next();
                    }
                }
                record SampleConflict(Sample sample, Sample.Builder builder) {
                }
                LinkedList<SampleConflict> existing = new LinkedList<SampleConflict>();
                while (sample != null) {
                    Sample.Builder builder = new Sample.Builder().type(sample.getType()).label(sample.getLabel());
                    if (sample.getTopDepth() != null) {
                        builder = builder.topDepth(sample.getTopDepth() + shift);
                    }
                    if (sample.getBaseDepth() != null) {
                        builder = builder.baseDepth(sample.getBaseDepth() + shift);
                    }
                    if (this.doesSampleExist(builder)) {
                        existing.add(new SampleConflict(sample, builder));
                    } else {
                        this.well.updateSample(sample, builder);
                        last = sample;
                    }
                    sample = shift > 0.0 ? (it.hasPrevious() ? it.previous() : null) : (it.hasNext() ? it.next() : null);
                }
                if (last != null) {
                    this.well.notifyObservers(last);
                    this.db.commit();
                }
                if (existing.size() > 0) {
                    Object message = String.format("%s samples were not updated because samples at the target depth already existed.", existing.size());
                    if (existing.size() == 1) {
                        message = "One sample was not updated because a sample at the target depth already existed.";
                    }
                    message = (String)message + "\nYou can now merge each pair of sample records, in turn.";
                    JOptionPane.showMessageDialog((Component)((Object)this), message, this.getTitle(), 1);
                    for (SampleConflict samplePair : existing) {
                        Sample mergeKeep = this.well.getSample(samplePair.builder());
                        String reason = this.well.mergeSampleCheckConflicts(samplePair.sample().getSampID(), mergeKeep.getSampID());
                        if (reason != null) {
                            JOptionPane.showMessageDialog((Component)((Object)this), "Cannot merge these samples without creating conflicting data: " + reason + "\nDelete data before proceeding", this.getTitle(), 2);
                            continue;
                        }
                        DialogMergeSamples dialog = new DialogMergeSamples((JDialog)((Object)this), true, this.db, this.units, this.well, mergeKeep, samplePair.sample());
                        dialog.setLocationRelativeTo((Component)((Object)this));
                        dialog.setVisible(true);
                        if (dialog.isOK()) continue;
                        break;
                    }
                }
            }
            this.setOK();
        }
        catch (SQLException | SBException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("Error adding sample", (Exception)sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jComboBoxTypeActionPerformed(ActionEvent evt) {
        switch ((SampleType)this.jComboBoxType.getSelectedItem()) {
            case SC: 
            case LOG: {
                break;
            }
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("howtoaddsamples.html#dialogeditsamples");
    }

    private int countSamplesWithTopDepth() {
        int topDepthCount = 0;
        for (Sample sample : this.samples) {
            if (sample.getTopDepth() == null) continue;
            ++topDepthCount;
        }
        return topDepthCount;
    }

    private int countSamplesWithBaseDepth() {
        int baseDepthCount = 0;
        for (Sample sample : this.samples) {
            if (sample.getBaseDepth() == null) continue;
            ++baseDepthCount;
        }
        return baseDepthCount;
    }

    private boolean doesSampleExist(Sample.Builder builder) {
        return this.well.getSample(builder) != null;
    }
}

