/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.event.EventType;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.FrameJsbugs;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import util.DepthUtils;

public class DialogEditWellEventError
extends JDialog {
    List<WellEvent> events;
    Well well;
    WellInterp wellInterp;
    boolean isOK = false;
    char units;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelUnits1;
    private JLabel jLabelUnits2;
    private JRadioButton jRadioButtonClear;
    private JRadioButton jRadioButtonNextSample;
    private JRadioButton jRadioButtonSet;
    private JTextField jTextFieldMinus;
    private JTextField jTextFieldPlus;

    public DialogEditWellEventError(Frame parent, boolean modal, Well well, WellInterp wellInterp, List<WellEvent> events, char units) {
        super(parent, modal);
        this.well = well;
        this.wellInterp = wellInterp;
        this.events = events;
        this.units = units;
        this.initComponents();
        if (units == 'M') {
            this.jLabelUnits1.setText("m");
            this.jLabelUnits2.setText("m");
        }
        this.setTitle("Set Event Error");
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jRadioButtonClear = new JRadioButton();
        this.jRadioButtonNextSample = new JRadioButton();
        this.jRadioButtonSet = new JRadioButton();
        this.jTextFieldMinus = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldPlus = new JTextField();
        this.jLabelUnits1 = new JLabel();
        this.jLabelUnits2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEditWellEventError this$0;
            {
                DialogEditWellEventError dialogEditWellEventError = this$0;
                Objects.requireNonNull(dialogEditWellEventError);
                this.this$0 = dialogEditWellEventError;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEditWellEventError this$0;
            {
                DialogEditWellEventError dialogEditWellEventError = this$0;
                Objects.requireNonNull(dialogEditWellEventError);
                this.this$0 = dialogEditWellEventError;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonClear);
        this.jRadioButtonClear.setText("Clear depth error values");
        this.jRadioButtonClear.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEditWellEventError this$0;
            {
                DialogEditWellEventError dialogEditWellEventError = this$0;
                Objects.requireNonNull(dialogEditWellEventError);
                this.this$0 = dialogEditWellEventError;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonClearActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonNextSample);
        this.jRadioButtonNextSample.setText("Set depth error to next or previous sample");
        this.jRadioButtonNextSample.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEditWellEventError this$0;
            {
                DialogEditWellEventError dialogEditWellEventError = this$0;
                Objects.requireNonNull(dialogEditWellEventError);
                this.this$0 = dialogEditWellEventError;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonNextSampleActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonSet);
        this.jRadioButtonSet.setText("Set all errors to:");
        this.jRadioButtonSet.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEditWellEventError this$0;
            {
                DialogEditWellEventError dialogEditWellEventError = this$0;
                Objects.requireNonNull(dialogEditWellEventError);
                this.this$0 = dialogEditWellEventError;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonSetActionPerformed(evt);
            }
        });
        this.jTextFieldMinus.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEditWellEventError this$0;
            {
                DialogEditWellEventError dialogEditWellEventError = this$0;
                Objects.requireNonNull(dialogEditWellEventError);
                this.this$0 = dialogEditWellEventError;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jTextFieldMinusActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Minus:");
        this.jLabel2.setText("Plus:");
        this.jLabelUnits1.setText("ft");
        this.jLabelUnits2.setText("ft");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonClear).addComponent(this.jRadioButtonNextSample).addComponent(this.jRadioButtonSet))).addGroup(layout.createSequentialGroup().addGap(41, 41, 41).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldMinus, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addComponent(this.jLabelUnits2).addGap(12, 12, 12).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPlus, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelUnits1).addGap(0, 2, Short.MAX_VALUE))))).addGap(21, 21, 21)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.jRadioButtonClear).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonNextSample).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonSet).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldMinus, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jTextFieldPlus, -2, -1, -2).addComponent(this.jLabelUnits1).addComponent(this.jLabelUnits2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.jButtonCancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jTextFieldMinusActionPerformed(ActionEvent evt) {
    }

    private void jRadioButtonClearActionPerformed(ActionEvent evt) {
        this.setTextFields();
    }

    private void jRadioButtonNextSampleActionPerformed(ActionEvent evt) {
        this.setTextFields();
    }

    private void jRadioButtonSetActionPerformed(ActionEvent evt) {
        this.setTextFields();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.buttonGroup1.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "No option selected", this.getTitle(), 1);
            return;
        }
        try {
            for (WellEvent event : this.events) {
                WellEvent.Builder builder = new WellEvent.Builder().event(event.getEvent()).sample(event.getSample()).type(event.getTypeObj()).confidence(event.getConfidence());
                builder.analyst(event.getAnalyst()).qualifier(event.getQualifier()).source(event.getSource()).comments(event.getComments()).company(event.getCompany()).audit(event.getAudit()).discID(event.getDiscipline());
                if (this.jRadioButtonSet.isSelected()) {
                    Double errMinus = this.jTextFieldMinus.getText().isEmpty() ? null : Double.valueOf(DepthUtils.convToM((double)Double.valueOf(this.jTextFieldMinus.getText()), (char)this.units));
                    Double errPlus = this.jTextFieldPlus.getText().isEmpty() ? null : Double.valueOf(DepthUtils.convToM((double)Double.valueOf(this.jTextFieldPlus.getText()), (char)this.units));
                    builder.errMinus(errMinus);
                    builder.errPlus(errPlus);
                } else if (this.jRadioButtonNextSample.isSelected()) {
                    if (event.getTypeObj() == EventType.TOP) {
                        builder.errMinus(WellEvent.getEventError(this.well, event.getSample(), event.getDiscipline(), event.getTypeObj()));
                    }
                    if (event.getTypeObj() == EventType.BASE) {
                        builder.errPlus(WellEvent.getEventError(this.well, event.getSample(), event.getDiscipline(), event.getTypeObj()));
                    }
                }
                WellEvent wellEvent = this.wellInterp.updateEvent(event, builder, this.well.getWellID());
            }
            this.well.getDataModel().commit();
            this.isOK = true;
            this.dispose();
        }
        catch (Exception ex) {
            this.well.getDataModel().doRollback();
            FrameJsbugs.showStackError(ex.getMessage(), ex, this.well.getDataModel());
        }
    }

    private void setTextFields() {
        this.jTextFieldMinus.setEnabled(this.jRadioButtonSet.isSelected());
        this.jTextFieldPlus.setEnabled(this.jRadioButtonSet.isSelected());
    }
}

