/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jsbugs.DialogSelectSample;
import jsbugs.uiutil.audit.JPanelAuditColumn;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.EnvScheme;
import model3.IGDIntervalEnv;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import model3.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SBException;

public class DialogEnv
extends SBDialog {
    private final SBdb db;
    private final char units;
    private final Well well;
    private final WellInterp wellInterp;
    private IGDIntervalEnv zone;
    private Sample topSample;
    private Sample baseSample;
    private final DefaultComboBoxModel schemes = new DefaultComboBoxModel();
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSampleBase;
    private JButton jButtonSampleTop;
    private JComboBox jComboBoxLD;
    private JComboBox jComboBoxLP;
    private JComboBox jComboBoxQual;
    private JComboBox jComboBoxScheme;
    private JComboBox jComboBoxUD;
    private JComboBox jComboBoxUP;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanelAuditColumn jPanelAudit;
    private JTextField jTextFieldSampleBase;
    private JTextField jTextFieldSampleTop;

    public DialogEnv(Frame parent, boolean modal, SBdb db, Well well, WellInterp wellInterp, char units, IGDIntervalEnv zone, Sample topSample, Sample baseSample) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        this.units = units;
        this.zone = zone;
        this.well = well;
        this.wellInterp = wellInterp;
        if (zone == null) {
            this.topSample = topSample;
            this.baseSample = baseSample;
        }
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.fillSchemeCombo();
        if (this.zone == null) {
            this.setTitle("Palaeoenvironment Interval : Add");
            if (this.wellInterp.getEnvs() != null && !this.wellInterp.getEnvs().isEmpty()) {
                this.setScheme(this.wellInterp.getEnvs().get(0).getSchID());
            }
            this.jPanelAudit.setVisible(false);
        } else {
            this.setTitle("Palaeoenvironment Interval : Edit");
            this.topSample = this.zone.getTopSample();
            this.baseSample = this.zone.getBaseSample();
            this.setScheme(this.zone.getSchID());
            this.jPanelAudit.setAuditText(this.zone.getCreator(), this.zone.getCreated(), this.zone.getModifier(), this.zone.getModified());
        }
        if (this.topSample != null) {
            this.jTextFieldSampleTop.setText(this.topSample.toString(this.units));
        }
        if (this.baseSample != null) {
            this.jTextFieldSampleBase.setText(this.baseSample.toString(this.units));
        }
        if (!this.well.canWrite(this.db, null)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(this.well.getDeniedReason(this.db, "well", false));
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
        this.pack();
    }

    private void setScheme(int schID) throws SBException, SQLException {
        EnvScheme scheme = this.db.getEnvScheme(schID);
        if (scheme == null) {
            throw new SBException("Cann't find scheme, ID=" + this.zone.getSchID());
        }
        this.jComboBoxScheme.setSelectedItem(scheme);
        scheme.fillCombo(this.jComboBoxUP, this.zone != null ? this.zone.getUp() : 0, true);
        scheme.fillCombo(this.jComboBoxUD, this.zone != null ? this.zone.getUd() : 0, true);
        scheme.fillCombo(this.jComboBoxLP, this.zone != null ? this.zone.getLp() : 0, true);
        scheme.fillCombo(this.jComboBoxLD, this.zone != null ? this.zone.getLd() : 0, true);
        scheme.fillCombo(this.jComboBoxQual, this.zone != null ? this.zone.getQual() : 0, true);
        if (this.wellInterp.getEnvs() != null && (this.wellInterp.getEnvs().size() > 1 || this.wellInterp.getEnvs().size() == 1 && this.zone == null) && this.wellInterp.getEnvSchemes().size() == 1 && !this.db.allowMultipleEnvSchemes()) {
            this.jComboBoxScheme.setEnabled(false);
        }
    }

    private void fillSchemeCombo() throws SQLException, SBException {
        List<EnvScheme> coll = this.db.getEnvSchemes();
        for (EnvScheme scheme : coll) {
            this.schemes.addElement(scheme);
        }
        this.jComboBoxScheme.repaint();
    }

    private void initComponents() {
        this.jComboBoxScheme = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jTextFieldSampleTop = new JTextField();
        this.jTextFieldSampleBase = new JTextField();
        this.jButtonSampleBase = new JButton();
        this.jButtonSampleTop = new JButton();
        this.jLabel4 = new JLabel();
        this.jComboBoxUP = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jComboBoxUD = new JComboBox();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jComboBoxLP = new JComboBox();
        this.jComboBoxLD = new JComboBox();
        this.jLabel10 = new JLabel();
        this.jComboBoxQual = new JComboBox();
        this.jPanelAudit = new JPanelAuditColumn();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(false);
        this.jComboBoxScheme.setModel(this.schemes);
        this.jComboBoxScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEnv this$0;
            {
                DialogEnv dialogEnv = this$0;
                Objects.requireNonNull(dialogEnv);
                this.this$0 = dialogEnv;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxSchemeActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Scheme:");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEnv this$0;
            {
                DialogEnv dialogEnv = this$0;
                Objects.requireNonNull(dialogEnv);
                this.this$0 = dialogEnv;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEnv this$0;
            {
                DialogEnv dialogEnv = this$0;
                Objects.requireNonNull(dialogEnv);
                this.this$0 = dialogEnv;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEnv this$0;
            {
                DialogEnv dialogEnv = this$0;
                Objects.requireNonNull(dialogEnv);
                this.this$0 = dialogEnv;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Sample/Depth", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jLabel2.setText("Base:");
        this.jLabel1.setText("Top:");
        this.jTextFieldSampleTop.setEditable(false);
        this.jTextFieldSampleTop.setBackground(new Color(255, 255, 204));
        this.jTextFieldSampleBase.setEditable(false);
        this.jTextFieldSampleBase.setBackground(new Color(255, 255, 204));
        this.jButtonSampleBase.setText("...");
        this.jButtonSampleBase.setToolTipText("Select base sample");
        this.jButtonSampleBase.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEnv this$0;
            {
                DialogEnv dialogEnv = this$0;
                Objects.requireNonNull(dialogEnv);
                this.this$0 = dialogEnv;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSampleBaseActionPerformed(evt);
            }
        });
        this.jButtonSampleTop.setText("...");
        this.jButtonSampleTop.setToolTipText("Select top sample");
        this.jButtonSampleTop.setMaximumSize(new Dimension(25, 23));
        this.jButtonSampleTop.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEnv this$0;
            {
                DialogEnv dialogEnv = this$0;
                Objects.requireNonNull(dialogEnv);
                this.this$0 = dialogEnv;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSampleTopActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((Component)this.jTextFieldSampleBase, -1, 171, Short.MAX_VALUE).add((Component)this.jTextFieldSampleTop)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jButtonSampleTop, -2, 30, -2).addContainerGap(-1, Short.MAX_VALUE)).add((Component)this.jButtonSampleBase, -2, 30, -2))));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jTextFieldSampleTop, -2, -1, -2).add((Component)this.jLabel1).add((Component)this.jButtonSampleTop, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jTextFieldSampleBase, -2, -1, -2).add((Component)this.jLabel2).add((Component)this.jButtonSampleBase)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel4.setText("Upper proximal:");
        this.jComboBoxUP.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxUP.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEnv this$0;
            {
                DialogEnv dialogEnv = this$0;
                Objects.requireNonNull(dialogEnv);
                this.this$0 = dialogEnv;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxUPActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Upper distal:");
        this.jComboBoxUD.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxUD.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEnv this$0;
            {
                DialogEnv dialogEnv = this$0;
                Objects.requireNonNull(dialogEnv);
                this.this$0 = dialogEnv;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxUDActionPerformed(evt);
            }
        });
        this.jLabel8.setText("Lower proximal:");
        this.jLabel9.setText("Lower distal:");
        this.jComboBoxLP.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxLP.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogEnv this$0;
            {
                DialogEnv dialogEnv = this$0;
                Objects.requireNonNull(dialogEnv);
                this.this$0 = dialogEnv;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxLPActionPerformed(evt);
            }
        });
        this.jComboBoxLD.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel10.setText("Qualifier:");
        this.jComboBoxQual.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jPanelAudit.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel6).addPreferredGap(0).add((Component)this.jComboBoxScheme, 0, -1, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.jComboBoxUP, 0, -1, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel8).add((Component)this.jLabel9)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jComboBoxLD, 0, -1, Short.MAX_VALUE).add((Component)this.jComboBoxLP, 0, -1, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add(19, 19, 19).add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.jComboBoxUD, 0, -1, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(37, 37, 37).add((Component)this.jLabel10).addPreferredGap(0).add((Component)this.jComboBoxQual, 0, -1, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanelAudit, -2, 263, -2).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.jComboBoxScheme, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jComboBoxUP, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.jComboBoxUD, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel8).add((Component)this.jComboBoxLP, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxLD, -2, -1, -2).add((Component)this.jLabel9)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel10).add((Component)this.jComboBoxQual, -2, -1, -2)).add(18, 18, 18).add((Component)this.jPanelAudit, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jComboBoxUDActionPerformed(ActionEvent evt) {
        if (this.zone == null) {
            this.jComboBoxLD.setSelectedItem(this.jComboBoxUD.getSelectedItem());
        }
    }

    private void jComboBoxLPActionPerformed(ActionEvent evt) {
        if (this.zone == null && this.jComboBoxLD.getSelectedIndex() < this.jComboBoxLP.getSelectedIndex()) {
            this.jComboBoxLD.setSelectedItem(this.jComboBoxLP.getSelectedItem());
        }
    }

    private void jComboBoxUPActionPerformed(ActionEvent evt) {
        if (this.zone == null) {
            this.jComboBoxUD.setSelectedItem(this.jComboBoxUP.getSelectedItem());
            this.jComboBoxLP.setSelectedItem(this.jComboBoxUP.getSelectedItem());
            this.jComboBoxLD.setSelectedItem(this.jComboBoxUP.getSelectedItem());
        }
    }

    private void jComboBoxSchemeActionPerformed(ActionEvent evt) {
        try {
            EnvScheme scheme = (EnvScheme)this.jComboBoxScheme.getSelectedItem();
            scheme.fillCombo(this.jComboBoxUP, 0, true);
            scheme.fillCombo(this.jComboBoxUD, 0, true);
            scheme.fillCombo(this.jComboBoxLP, 0, true);
            scheme.fillCombo(this.jComboBoxLD, 0, true);
            scheme.fillCombo(this.jComboBoxQual, 0, true);
        }
        catch (RuntimeException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Error selecting scheme: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void jButtonSampleBaseActionPerformed(ActionEvent evt) {
        try {
            DialogSelectSample dialog = new DialogSelectSample((JDialog)((Object)this), true, this.db, this.well, this.baseSample != null ? this.baseSample : this.topSample, this.units, false);
            dialog.setLocation(this.jButtonSampleBase.getLocationOnScreen());
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.baseSample = dialog.selection;
                this.jTextFieldSampleBase.setText(this.baseSample.toString(this.units));
                if (this.topSample == null || this.topSample.getDepth() > this.baseSample.getDepth()) {
                    this.topSample = this.baseSample;
                    this.jTextFieldSampleTop.setText(this.topSample.toString(this.units));
                }
            }
        }
        catch (SQLException | SBException ex) {
            SbugsExceptionHandler.showDialogStackError(ex, (Component)((Object)this));
        }
    }

    private void jButtonSampleTopActionPerformed(ActionEvent evt) {
        try {
            DialogSelectSample dialog = new DialogSelectSample((JDialog)((Object)this), true, this.db, this.well, this.topSample != null ? this.topSample : this.baseSample, this.units, false);
            dialog.setLocation(this.jButtonSampleTop.getLocationOnScreen());
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.topSample = dialog.selection;
                this.jTextFieldSampleTop.setText(this.topSample.toString(this.units));
                if (this.baseSample == null || this.baseSample.getDepth() < this.topSample.getDepth()) {
                    this.baseSample = this.topSample;
                    this.jTextFieldSampleBase.setText(this.baseSample.toString(this.units));
                }
            }
        }
        catch (SQLException | SBException ex) {
            SbugsExceptionHandler.showDialogStackError(ex, (Component)((Object)this));
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.topSample == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Top sample blank", this.getTitle(), 2);
            return;
        }
        if (this.baseSample == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Top sample blank", this.getTitle(), 2);
            return;
        }
        EnvScheme scheme = (EnvScheme)this.jComboBoxScheme.getSelectedItem();
        int up = this.jComboBoxUP.getSelectedIndex();
        if (up == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No environment selected", this.getTitle(), 2);
            return;
        }
        int ud = this.jComboBoxUD.getSelectedIndex();
        if (ud < up) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Upper distal nearer than proximal", this.getTitle(), 2);
            return;
        }
        int lp = this.jComboBoxLP.getSelectedIndex();
        int ld = this.jComboBoxLD.getSelectedIndex();
        if (ld < lp) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Lower distal nearer than proximal", this.getTitle(), 2);
            return;
        }
        int qual = this.jComboBoxQual.getSelectedIndex();
        IGDIntervalEnv.Builder builder = new IGDIntervalEnv.Builder(this.db, this.topSample, this.baseSample, scheme.getID());
        builder.up(up).ud(ud).lp(lp).ld(ld).qual(qual);
        try {
            if (this.zone == null) {
                this.zone = this.wellInterp.addEnvInterval(builder, this.well.getWellID());
            } else {
                this.wellInterp.updateEnvInterval(this.zone, builder, this.well.getWellID());
            }
            this.db.commit();
            this.setOK();
        }
        catch (SQLException | InvalidFieldException | SBException e) {
            SbugsExceptionHandler.showStackError(e, (Component)((Object)this));
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogenv.html");
    }
}

