/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.event.EventType;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.DialogList;
import jsbugs.DialogSelectProject;
import model3.InterpHdr;
import model3.Lastval;
import model3.SBEvent;
import model3.SBdb;
import model3.Taxon;
import model3.Well;
import model3.WellEvent;
import model3.WellHeader;
import model3.WellInterp;
import model3.project.Project;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.exception.StackError;

public class DialogExportProjectEvents
extends JDialog {
    SBdb db;
    Project project;
    InterpHdr interpHdr;
    File folder;
    Frame parent;
    public boolean initOK = false;
    JFileChooser jFileChooser;
    private JButton jButtonClose;
    private JButton jButtonWriteCONOP;
    private JButton jButtonWriteRASC;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField jTextFieldFolder;
    private JTextField jTextFieldProject;
    private JTextField jTextFieldVersion;

    public DialogExportProjectEvents(Frame parent, boolean modal, SBdb db) throws SQLException, SBException {
        super(parent, modal);
        this.parent = parent;
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Export Well Events");
        DialogSelectProject dialog = new DialogSelectProject(this.parent, true, this.db, false, null);
        dialog.setLocationRelativeTo(this.parent);
        dialog.setVisible(true);
        if (dialog.selection == null) {
            return;
        }
        this.project = dialog.selection;
        this.jTextFieldProject.setText(this.project.toString());
        Iterator<Well> it = this.db.getWellIterator(this.project.getID());
        LinkedList<InterpHdr> interps = new LinkedList<InterpHdr>();
        while (it.hasNext()) {
            Well well = it.next();
            well.loadInterps();
            Iterator<WellInterp> wit = well.getInterpIterator();
            while (wit.hasNext()) {
                WellInterp wellInterp = wit.next();
                well.loadInterp(wellInterp);
                List<WellEvent> events = wellInterp.getEvents();
                if (events == null || events.isEmpty() || interps.contains(wellInterp.getHeader())) continue;
                interps.add(wellInterp.getHeader());
            }
        }
        if (interps.isEmpty()) {
            JOptionPane.showMessageDialog(this.parent, "There are no well events in the selected project", this.getTitle(), 1);
            return;
        }
        if (interps.size() == 1) {
            this.interpHdr = (InterpHdr)interps.get(0);
        } else {
            DialogList dialogList = new DialogList(this.parent, true, "Select Version", null, interps, true, false);
            dialogList.setLocationRelativeTo(this.parent);
            dialogList.setVisible(true);
            if (dialogList.getSelection() == null) {
                return;
            }
            this.interpHdr = (InterpHdr)dialogList.getSelection();
        }
        this.jTextFieldVersion.setText(this.interpHdr.toString());
        if (this.jFileChooser == null) {
            this.jFileChooser = new JFileChooser();
            File setDir = null;
            try {
                setDir = new File(Lastval.getString(this.db, "CONOPDIR"));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (setDir == null || setDir.getParent() == null || !setDir.getParentFile().exists()) {
                setDir = new File(".");
            }
            try {
                this.jFileChooser.setSelectedFile(setDir);
                this.jFileChooser.setFileSelectionMode(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (0 == this.jFileChooser.showSaveDialog(this)) {
            this.folder = this.jFileChooser.getSelectedFile();
        }
        if (this.folder == null) {
            return;
        }
        String projectDir = SB.makeFileName((String)this.project.getName());
        if (!this.folder.toString().contains(projectDir)) {
            this.folder = new File(this.folder.toString() + File.separator + projectDir);
        }
        this.jTextFieldFolder.setText(this.folder.getPath());
        if (this.folder.exists()) {
            if (!this.folder.isDirectory()) {
                JOptionPane.showMessageDialog(this.parent, "Choose a folder name for the project files. You selected an existing file, not a folder.", this.getTitle(), 1);
                return;
            }
            if (this.folder.listFiles().length > 0 && JOptionPane.showConfirmDialog(this.parent, "Selected folder is not empty - continue (and overwrite any existing files)?", this.getTitle(), 0) == 1) {
                return;
            }
        }
        this.initOK = true;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldProject = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldVersion = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextFieldFolder = new JTextField();
        this.jButtonWriteCONOP = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonWriteRASC = new JButton();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Project:");
        this.jTextFieldProject.setEditable(false);
        this.jLabel2.setText("Version:");
        this.jTextFieldVersion.setEditable(false);
        this.jLabel3.setText("Folder:");
        this.jTextFieldFolder.setEditable(false);
        this.jButtonWriteCONOP.setText("Write CONOP files");
        this.jButtonWriteCONOP.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogExportProjectEvents this$0;
            {
                DialogExportProjectEvents dialogExportProjectEvents = this$0;
                Objects.requireNonNull(dialogExportProjectEvents);
                this.this$0 = dialogExportProjectEvents;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonWriteCONOPActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogExportProjectEvents this$0;
            {
                DialogExportProjectEvents dialogExportProjectEvents = this$0;
                Objects.requireNonNull(dialogExportProjectEvents);
                this.this$0 = dialogExportProjectEvents;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonWriteRASC.setText("Write RASC files");
        this.jButtonWriteRASC.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogExportProjectEvents this$0;
            {
                DialogExportProjectEvents dialogExportProjectEvents = this$0;
                Objects.requireNonNull(dialogExportProjectEvents);
                this.this$0 = dialogExportProjectEvents;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonWriteRASCActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGap(17, 17, 17)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel3).addGap(18, 18, 18))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.jButtonWriteRASC, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonWriteCONOP).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonClose)).addComponent(this.jTextFieldVersion).addComponent(this.jTextFieldFolder).addComponent(this.jTextFieldProject, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldProject, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldVersion, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldFolder, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonWriteCONOP).addComponent(this.jButtonClose).addComponent(this.jButtonWriteRASC)).addContainerGap()));
        this.pack();
    }

    private void jButtonWriteCONOPActionPerformed(ActionEvent evt) {
        if (!this.folder.exists() && !this.folder.mkdir()) {
            JOptionPane.showMessageDialog(this.parent, "Cannot create selected folder.", this.getTitle(), 1);
            return;
        }
        try (BufferedWriter sectionFile = new BufferedWriter(new FileWriter(new File(String.valueOf(this.folder.toPath()) + File.separator + "section.dic")));){
            Iterator<Well> it = this.db.getWellIterator(this.project.getID());
            int wellSequenceNumber = 100;
            HashMap<Integer, SBEvent> eventMap = new HashMap<Integer, SBEvent>();
            while (it.hasNext()) {
                Well well = it.next();
                try {
                    WellInterp wellInterp = well.getInterp(this.interpHdr.getInterpID());
                    String fileName = SB.makeFileName((String)well.getWellCode());
                    sectionFile.write("'" + well.getWellName() + "'\t'" + wellSequenceNumber++ + "'\t'" + fileName + "'\t'" + well.getHeader().getCountry() + "'\t'Phanerozoic'\t'*'\t'*'\t'*'\t'yes'\n");
                    List<WellEvent> events = wellInterp.getEvents();
                    if (events == null || events.isEmpty()) continue;
                    BufferedWriter wellFile = new BufferedWriter(new FileWriter(new File(String.valueOf(this.folder.toPath()) + File.separator + fileName + ".dat")));
                    for (WellEvent event : events) {
                        double topDepth;
                        if (eventMap.get(event.getEvent().getEvID()) == null) {
                            eventMap.put(event.getEvent().getEvID(), event.getEvent());
                        }
                        double baseDepth = topDepth = event.getSample().getDepth(well.getWellUnits());
                        if (event.getTypeObj() != EventType.SINGLE) {
                            for (WellEvent event2 : events) {
                                if (event == event2 || event.getEvent().getEvID() != event2.getEvent().getEvID()) continue;
                                if (event2.getTypeObj() == EventType.TOP) {
                                    topDepth = event2.getSample().getDepth(well.getWellUnits());
                                    continue;
                                }
                                baseDepth = event2.getSample().getDepth(well.getWellUnits());
                            }
                        }
                        topDepth = -topDepth;
                        baseDepth = -baseDepth;
                        wellFile.write(this.getEventCode(event.getEvent()) + "\t" + this.getEventAbr(event.getEvent()) + "\t" + topDepth + "\t" + baseDepth + "\t" + this.getEventCode(event.getEvent()) + "\t" + this.getEventAbr(event.getEvent()) + "\t'*'\t'*'\n");
                    }
                    wellFile.close();
                    System.out.println("Written events for well: " + String.valueOf(well));
                }
                catch (SBException sbe) {
                    System.out.println("Exception in well output: " + String.valueOf((Object)sbe));
                }
            }
            BufferedWriter taxonFile = new BufferedWriter(new FileWriter(new File(String.valueOf(this.folder.toPath()) + File.separator + "taxon.dic")));
            for (SBEvent event : eventMap.values()) {
                taxonFile.write(this.getEventCode(event) + "\t" + this.getEventAbr(event) + "\t" + this.getEventClass(event));
                Taxon taxon = event.getTaxon();
                if (taxon != null) {
                    taxonFile.write(this.getField(taxon.getGenusName(), false) + this.getField(taxon.getSpecies(), false) + this.getField(taxon.getSubSpecies()) + this.getField(null) + this.getField(taxon.getAuthor()));
                } else {
                    taxonFile.write(this.getField(null) + this.getField(null) + this.getField(null) + this.getField(null) + this.getField(null) + this.getField(null) + this.getField(null));
                }
                taxonFile.write("\n");
            }
            taxonFile.close();
            JOptionPane.showMessageDialog(this.parent, "Files written.", this.getTitle(), 1);
        }
        catch (IOException | SQLException | SBException ex) {
            StackError.showStackError((Exception)ex);
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonWriteRASCActionPerformed(ActionEvent evt) {
        if (!this.folder.exists() && !this.folder.mkdir()) {
            JOptionPane.showMessageDialog(this.parent, "Cannot create selected folder.", this.getTitle(), 1);
            return;
        }
        String projectFileName = SB.makeFileName((String)this.project.getName()).replace(" ", "").substring(0, 7);
        try (BufferedWriter datFile = new BufferedWriter(new FileWriter(new File(String.valueOf(this.folder.toPath()) + File.separator + projectFileName + ".dat")));
             BufferedWriter depFile = new BufferedWriter(new FileWriter(new File(String.valueOf(this.folder.toPath()) + File.separator + projectFileName + ".dep")));
             BufferedWriter dicFile = new BufferedWriter(new FileWriter(new File(String.valueOf(this.folder.toPath()) + File.separator + projectFileName + ".dic")));
             BufferedWriter inpFile = new BufferedWriter(new FileWriter(new File(String.valueOf(this.folder.toPath()) + File.separator + projectFileName + ".inp")));){
            Iterator<Well> it = this.db.getWellIterator(this.project.getID());
            HashSet<String> eventMap = new HashSet<String>();
            while (it.hasNext()) {
                Well well = it.next();
                try {
                    WellInterp wellInterp = well.getInterp(this.interpHdr.getInterpID());
                    List<WellEvent> events = wellInterp.getEvents();
                    if (events == null || events.isEmpty()) continue;
                    for (WellEvent event : events) {
                        String eventName = event.toString(true, false, false);
                        if (eventMap.contains(eventName)) continue;
                        eventMap.add(eventName);
                    }
                }
                catch (SBException sbe) {
                    System.out.println("Exception in well output: " + String.valueOf((Object)sbe));
                }
            }
            if (eventMap.size() >= 999) {
                throw new SBException("There are too many events in the project (> 999).");
            }
            for (String event : eventMap) {
                dicFile.write(event + "\n");
            }
            dicFile.write("LAST");
            depFile.write("DECIMAL DEPTH FILE\n");
            it = this.db.getWellIterator(this.project.getID());
            String[] eventMapArr = eventMap.toArray(new String[0]);
            int nWells = 0;
            while (it.hasNext()) {
                Well well = it.next();
                ++nWells;
                try {
                    WellInterp wellInterp = well.getInterp(this.interpHdr.getInterpID());
                    datFile.write(well.getWellName() + "\n");
                    depFile.write(well.getWellName() + "\n");
                    char units = well.getWellUnits();
                    WellHeader wh = well.getHeader();
                    depFile.write(units + String.format("%4.1f%5.1f\n", DepthUtils.convFromM((double)wh.getRTEValue(), (char)units, (char)wh.getType()), DepthUtils.convFromM((double)wh.getSBValue(), (char)units, (char)wh.getType())));
                    depFile.write("AUTHOR " + this.db.getUser().getName() + "\n");
                    List<WellEvent> events = wellInterp.getEventsByDepth();
                    Double lastDepth = null;
                    int lineEntriesInDat = 0;
                    int lineEntriesInDep = 0;
                    if (events != null && !events.isEmpty()) {
                        for (WellEvent event : events) {
                            double depth = event.getSample().getDepth(units);
                            for (int i = 0; i < eventMap.size(); ++i) {
                                if (!event.toString(true, false, false).equals(eventMapArr[i])) continue;
                                boolean equalDepth = true;
                                if (lastDepth == null || Math.abs(lastDepth - depth) > (double)0.0029f) {
                                    equalDepth = false;
                                    depFile.write((lineEntriesInDep > 0 ? "," : "") + SB.floatString((double)DepthUtils.convFromM((double)depth, (char)units), (int)2));
                                    if (++lineEntriesInDep > 8) {
                                        depFile.write("\n");
                                        lineEntriesInDep = 0;
                                    }
                                }
                                int eventNumber = i + 1;
                                if (equalDepth) {
                                    eventNumber = -eventNumber;
                                }
                                datFile.write(String.format("%4d", eventNumber));
                                if (++lineEntriesInDat <= 19) break;
                                datFile.write("\n");
                                lineEntriesInDat = 0;
                                break;
                            }
                            lastDepth = depth;
                        }
                        System.out.println("Written events for well: " + String.valueOf(well));
                    }
                    datFile.write("-999\n");
                    depFile.write("\n\n");
                }
                catch (SBException sbe) {
                    System.out.println("Exception in well output: " + String.valueOf((Object)sbe));
                }
            }
            inpFile.write(String.format("%2d%2d%2d%2d%2d%2d%2d", nWells, 6, 0, 0, 0, 3, 1) + "\n\n\n");
            JOptionPane.showMessageDialog(this.parent, "Files written.", this.getTitle(), 1);
        }
        catch (IOException | SQLException | SBException ex) {
            StackError.showStackError((Exception)ex);
        }
    }

    private String getEventCode(SBEvent event) {
        Object code;
        if (event.getTaxon() != null) {
            String catMnem;
            switch (catMnem = event.getTaxon().getCatMnem()) {
                case "NA": {
                    code = "N";
                    break;
                }
                case "FO": 
                case "FOP": 
                case "FOB": 
                case "FOBA": 
                case "FOBC": {
                    code = "F";
                    break;
                }
                case "OS": {
                    code = "O";
                    break;
                }
                case "RA": {
                    code = "R";
                    break;
                }
                case "DI": {
                    code = "D";
                    break;
                }
                case "DC": {
                    code = "X";
                    break;
                }
                case "AC": {
                    code = "A";
                    break;
                }
                case "SP": {
                    code = "P";
                    break;
                }
                case "SPS": {
                    code = "S";
                    break;
                }
                case "CO": {
                    code = "C";
                    break;
                }
                default: {
                    code = catMnem.substring(0, 1);
                    break;
                }
            }
        } else {
            code = "E";
        }
        code = (String)code + String.format("%010d", event.getEvID());
        return code;
    }

    private String getEventAbr(SBEvent event) {
        Object abr = "'";
        if (event.getTaxon() != null) {
            if (event.getTaxon().getAlphaCode() != null && !event.getTaxon().getAlphaCode().isEmpty()) {
                abr = (String)abr + event.getTaxon().getAlphaCode();
                abr = ((String)abr).replaceAll(" ", ".");
            } else {
                abr = (String)abr + event.getEvID();
            }
        } else {
            abr = (String)abr + event.getEvID();
        }
        abr = (String)abr + "'";
        return abr;
    }

    private String getField(String fieldString) {
        return this.getField(fieldString, true);
    }

    private String getField(String fieldString, boolean useQuotes) {
        Object field = "\t";
        if (useQuotes) {
            field = (String)field + "'";
        }
        field = fieldString == null || fieldString.isEmpty() ? (String)field + "*" : (String)field + fieldString;
        if (useQuotes) {
            field = (String)field + "'";
        }
        return field;
    }

    private String getEventClass(SBEvent event) {
        if (event.getTaxon() != null) {
            return "'" + event.getTaxon().getCatMnem() + "'";
        }
        return "'pseudotaxon'";
    }
}

