/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.scheme.Boundary;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.DialogSelectSample;
import jsbugs.FrameJsbugs;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.Fault;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import model3.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.DepthUnits;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class DialogFault
extends SBDialog {
    private Fault original;
    private final char units;
    private final Well well;
    private final SBdb db;
    private final WellInterp wellInterp;
    private Sample sample = null;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSelectSample;
    private JComboBox jComboBoxBnd;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabelThrow;
    private JLabel jLabelUnits;
    private JSeparator jSeparator1;
    private JTextField jTextFieldLabel;
    private JTextField jTextFieldSample;
    private JTextField jTextFieldThrow;

    public DialogFault(JDialog parent, boolean modal, Fault fault, Well well, char units, WellInterp wellInterp, SBdb db) throws SQLException {
        super((Window)parent, modal);
        this.original = fault;
        this.units = units;
        this.wellInterp = wellInterp;
        this.db = db;
        this.well = well;
        this.initComponents();
        this.init();
    }

    public DialogFault(JFrame parent, boolean modal, Fault fault, Well well, char units, WellInterp wellInterp, SBdb db, Sample sample) throws SQLException {
        super((Frame)parent, modal);
        this.original = fault;
        this.units = units;
        this.well = well;
        this.wellInterp = wellInterp;
        this.db = db;
        this.sample = sample;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.jComboBoxBnd.removeAllItems();
        for (Boundary bnd : Boundary.values()) {
            if (!bnd.isDisconformable()) continue;
            this.jComboBoxBnd.addItem(bnd);
        }
        if (this.original == null) {
            this.setTitle("Disconformity : Add");
            if (this.sample != null) {
                this.jTextFieldSample.setText(String.valueOf(this.sample));
            }
            this.jComboBoxBnd.setSelectedItem(Boundary.FAULT);
        } else {
            this.setTitle("Disconformity : Edit");
            this.jTextFieldSample.setText(String.valueOf(this.original.getSample()));
            this.sample = this.original.getSample();
            this.jTextFieldThrow.setText("" + DepthUtils.convFromM((double)this.original.getThrow(), (char)this.units));
            if (this.original.getLabel() != null) {
                this.jTextFieldLabel.setText(this.original.getLabel());
            }
            this.jComboBoxBnd.setSelectedItem(this.original.getBnd());
        }
        this.jLabelUnits.setText(DepthUnits.getUnits((char)this.units).getAbr());
        if (!this.well.canWrite(this.db, null)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(this.well.getDeniedReason(this.db, "well", false));
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
        this.enableThrow();
        this.pack();
    }

    private void enableThrow() {
        boolean b = false;
        Boundary bnd = (Boundary)this.jComboBoxBnd.getSelectedItem();
        if (bnd == null) {
            return;
        }
        switch (bnd) {
            case FAULT: 
            case RFAULT: 
            case QFAULT: {
                b = true;
            }
        }
        this.jLabelThrow.setEnabled(b);
        this.jLabelUnits.setEnabled(b);
        this.jTextFieldThrow.setEnabled(b);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldSample = new JTextField();
        this.jButtonSelectSample = new JButton();
        this.jButtonSelectSample.putClientProperty("JComponent.sizeVariant", "small");
        this.jLabelThrow = new JLabel();
        this.jTextFieldThrow = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextFieldLabel = new JTextField();
        this.jLabelUnits = new JLabel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonHelp = new JButton();
        this.jLabel4 = new JLabel();
        this.jComboBoxBnd = new JComboBox();
        this.jComboBoxBnd.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Sample:");
        this.jTextFieldSample.setEditable(false);
        this.jTextFieldSample.setBackground(new Color(255, 255, 204));
        this.jButtonSelectSample.setText("...");
        this.jButtonSelectSample.setToolTipText("Select sample");
        this.jButtonSelectSample.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogFault this$0;
            {
                DialogFault dialogFault = this$0;
                Objects.requireNonNull(dialogFault);
                this.this$0 = dialogFault;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectSampleActionPerformed(evt);
            }
        });
        this.jLabelThrow.setText("Throw:");
        this.jTextFieldThrow.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogFault this$0;
            {
                DialogFault dialogFault = this$0;
                Objects.requireNonNull(dialogFault);
                this.this$0 = dialogFault;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldThrowKeyTyped(evt);
            }
        });
        this.jLabel3.setText("Label:");
        this.jTextFieldLabel.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogFault this$0;
            {
                DialogFault dialogFault = this$0;
                Objects.requireNonNull(dialogFault);
                this.this$0 = dialogFault;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldLabelKeyTyped(evt);
            }
        });
        this.jLabelUnits.setText("m");
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogFault this$0;
            {
                DialogFault dialogFault = this$0;
                Objects.requireNonNull(dialogFault);
                this.this$0 = dialogFault;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogFault this$0;
            {
                DialogFault dialogFault = this$0;
                Objects.requireNonNull(dialogFault);
                this.this$0 = dialogFault;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogFault this$0;
            {
                DialogFault dialogFault = this$0;
                Objects.requireNonNull(dialogFault);
                this.this$0 = dialogFault;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Boundary:");
        this.jComboBoxBnd.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxBnd.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogFault this$0;
            {
                DialogFault dialogFault = this$0;
                Objects.requireNonNull(dialogFault);
                this.this$0 = dialogFault;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxBndActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jSeparator1).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel1).add((Component)this.jLabel4)).add(2, (Component)this.jLabelThrow)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldSample).addPreferredGap(0).add((Component)this.jButtonSelectSample, -2, 30, -2)).add((Component)this.jComboBoxBnd, 0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldThrow, -2, 98, -2).addPreferredGap(0).add((Component)this.jLabelUnits, -2, 17, -2).add(0, 0, Short.MAX_VALUE)))).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp, -2, 61, -2).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap(-1, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(31, 31, 31).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jTextFieldLabel).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldSample, -2, -1, -2).add((Component)this.jLabel1).add((Component)this.jButtonSelectSample)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jComboBoxBnd, -2, -1, -2)).add(5, 5, 5).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldThrow, -2, -1, -2).add((Component)this.jLabelUnits).add((Component)this.jLabelThrow)).add(7, 7, 7).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jTextFieldLabel, -2, -1, -2)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonOK).add((Component)this.jButtonHelp).add((Component)this.jButtonCancel)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonSelectSampleActionPerformed(ActionEvent evt) {
        DialogSelectSample dialog;
        try {
            dialog = new DialogSelectSample((JDialog)((Object)this), true, this.db, this.well, this.sample, this.units, true);
        }
        catch (SBException ex) {
            StackError.showStackError((String)"Error opening dialog", (Throwable)ex);
            return;
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error opening dialog", ex, this.db);
            return;
        }
        dialog.setLocation(this.jButtonSelectSample.getLocationOnScreen());
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.sample = dialog.selection;
            this.jTextFieldSample.setText(this.sample.toString(this.units));
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.sample == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select a sample", this.getTitle(), 2);
            return;
        }
        Boundary bnd = (Boundary)this.jComboBoxBnd.getSelectedItem();
        double faultThrow = 0.0;
        switch (bnd) {
            case FAULT: 
            case RFAULT: 
            case QFAULT: {
                if (this.jTextFieldThrow.getText().length() == 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Enter fault throw", this.getTitle(), 2);
                    this.jTextFieldThrow.requestFocusInWindow();
                    return;
                }
                faultThrow = DepthUtils.convToM((double)Double.parseDouble(this.jTextFieldThrow.getText()), (char)this.units);
            }
        }
        String label = this.jTextFieldLabel.getText();
        try {
            Fault newFault;
            if (this.original == null) {
                newFault = this.wellInterp.addFault(this.well, this.sample, bnd, faultThrow, label);
            } else {
                boolean updateIntervalBnds = false;
                if (bnd != this.original.getBnd() && this.wellInterp.checkUpdateDisconfBndType(this.original, bnd)) {
                    int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Do you want to update interval boundary types at this sample?", this.getTitle(), 1);
                    if (opt == 0) {
                        updateIntervalBnds = true;
                    } else if (opt != 1) {
                        return;
                    }
                }
                newFault = this.wellInterp.updateFault(this.well, this.original, this.sample, bnd, faultThrow, label, updateIntervalBnds);
            }
            this.db.commit();
            this.wellInterp.notifyObservers(newFault);
            this.setOK();
        }
        catch (RuntimeException | SQLException | InvalidFieldException | SBPermissionException e) {
            SbugsExceptionHandler.showStackError(e, (Component)((Object)this));
        }
    }

    private void jTextFieldThrowKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldThrow, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldLabelKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldLabel, (int)80, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogfault.html");
    }

    private void jComboBoxBndActionPerformed(ActionEvent evt) {
        this.enableThrow();
    }
}

