/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jsbugs.FrameJsbugs;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.IGDUnitBase;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import model3.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SBException;

public class DialogFillHierarchy
extends JDialog {
    WellInterp wellInterp;
    IGDScheme scheme;
    Well well;
    SBdb db;
    boolean isOK = false;
    List<IGDIntervalZone> list = null;
    List<IGDIntervalZone> toAdd = new LinkedList<IGDIntervalZone>();
    private ButtonGroup buttonGroupSamples;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JCheckBox jCheckBox5;
    private JCheckBox jCheckBox6;
    private JCheckBox jCheckBox7;
    private JCheckBox jCheckBox8;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonCreate;
    private JRadioButton jRadioButtonSpan;
    private JSeparator jSeparator1;
    private JTextField jTextFieldScheme;
    private JTextField jTextFieldVersion;

    public DialogFillHierarchy(Frame parent, boolean modal, Well well, WellInterp wellInterp, IGDScheme scheme, List<IGDIntervalZone> list) throws SBException {
        super(parent, modal);
        this.well = well;
        this.db = well.getDataModel();
        this.wellInterp = wellInterp;
        this.scheme = scheme;
        this.list = list;
        this.initComponents();
        this.init();
    }

    private void init() throws SBException {
        this.setTitle("Intervals : Fill Hierarchy");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jTextFieldVersion.setText(this.wellInterp.toString());
        if (this.scheme == null) {
            throw new SBException("Fill Hierarchy: no scheme specified");
        }
        this.jTextFieldScheme.setText(this.scheme.toString());
        this.setSchemeLevels(this.scheme);
    }

    private void setSchemeLevels(IGDScheme scheme) {
        if (scheme == null) {
            this.unsetCheck(this.jCheckBox1);
            this.unsetCheck(this.jCheckBox2);
            this.unsetCheck(this.jCheckBox3);
            this.unsetCheck(this.jCheckBox4);
            this.unsetCheck(this.jCheckBox5);
            this.unsetCheck(this.jCheckBox6);
            this.unsetCheck(this.jCheckBox7);
            this.unsetCheck(this.jCheckBox8);
        } else {
            this.setCheck(this.jCheckBox1, IGDIntervalZone.getHierName(scheme.getIGDType(), 1));
            if (IGDIntervalZone.getNHier(scheme.getIGDType(), true) > 1) {
                this.setCheck(this.jCheckBox2, IGDIntervalZone.getHierName(scheme.getIGDType(), 2));
            } else {
                this.unsetCheck(this.jCheckBox2);
            }
            if (IGDIntervalZone.getNHier(scheme.getIGDType(), true) > 2) {
                this.setCheck(this.jCheckBox3, IGDIntervalZone.getHierName(scheme.getIGDType(), 3));
            } else {
                this.unsetCheck(this.jCheckBox3);
            }
            if (IGDIntervalZone.getNHier(scheme.getIGDType(), true) > 3) {
                this.setCheck(this.jCheckBox4, IGDIntervalZone.getHierName(scheme.getIGDType(), 4));
            } else {
                this.unsetCheck(this.jCheckBox4);
            }
            if (IGDIntervalZone.getNHier(scheme.getIGDType(), true) > 4) {
                this.setCheck(this.jCheckBox5, IGDIntervalZone.getHierName(scheme.getIGDType(), 5));
            } else {
                this.unsetCheck(this.jCheckBox5);
            }
            if (IGDIntervalZone.getNHier(scheme.getIGDType(), true) > 5) {
                this.setCheck(this.jCheckBox6, IGDIntervalZone.getHierName(scheme.getIGDType(), 6));
            } else {
                this.unsetCheck(this.jCheckBox6);
            }
            if (IGDIntervalZone.getNHier(scheme.getIGDType(), true) > 6) {
                this.setCheck(this.jCheckBox7, IGDIntervalZone.getHierName(scheme.getIGDType(), 7));
            } else {
                this.unsetCheck(this.jCheckBox7);
            }
            if (IGDIntervalZone.getNHier(scheme.getIGDType(), true) > 7) {
                this.setCheck(this.jCheckBox8, IGDIntervalZone.getHierName(scheme.getIGDType(), 8));
            } else {
                this.unsetCheck(this.jCheckBox8);
            }
        }
    }

    private void unsetCheck(JCheckBox checkBox) {
        checkBox.setText(null);
        checkBox.setEnabled(false);
        checkBox.setSelected(false);
    }

    private void setCheck(JCheckBox checkBox, String label) {
        checkBox.setText(label);
        checkBox.setEnabled(true);
        checkBox.setSelected(true);
    }

    private void initComponents() {
        this.buttonGroupSamples = new ButtonGroup();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldVersion = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldScheme = new JTextField();
        this.jLabel3 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox3 = new JCheckBox();
        this.jCheckBox4 = new JCheckBox();
        this.jCheckBox5 = new JCheckBox();
        this.jCheckBox6 = new JCheckBox();
        this.jCheckBox7 = new JCheckBox();
        this.jCheckBox8 = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jRadioButtonSpan = new JRadioButton();
        this.jRadioButtonCreate = new JRadioButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(441, 315));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogFillHierarchy this$0;
            {
                DialogFillHierarchy dialogFillHierarchy = this$0;
                Objects.requireNonNull(dialogFillHierarchy);
                this.this$0 = dialogFillHierarchy;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogFillHierarchy this$0;
            {
                DialogFillHierarchy dialogFillHierarchy = this$0;
                Objects.requireNonNull(dialogFillHierarchy);
                this.this$0 = dialogFillHierarchy;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Version:");
        this.jTextFieldVersion.setEditable(false);
        this.jLabel2.setText("Scheme:");
        this.jTextFieldScheme.setEditable(false);
        this.jLabel3.setText("Levels:");
        this.jCheckBox1.setText("jCheckBox1");
        this.jCheckBox2.setText("jCheckBox2");
        this.jCheckBox3.setText("jCheckBox3");
        this.jCheckBox4.setText("jCheckBox4");
        this.jCheckBox5.setText("jCheckBox5");
        this.jCheckBox6.setText("jCheckBox6");
        this.jCheckBox7.setText("jCheckBox7");
        this.jCheckBox8.setText("jCheckBox8");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Sample gap options", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupSamples.add(this.jRadioButtonSpan);
        this.jRadioButtonSpan.setText("Higher levels span across sample gaps at lower levels");
        this.buttonGroupSamples.add(this.jRadioButtonCreate);
        this.jRadioButtonCreate.setText("Higher levels retain sample gaps ");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonSpan).add((Component)this.jRadioButtonCreate)).addContainerGap(122, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(new Component[]{this.jRadioButtonCreate, this.jRadioButtonSpan}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonSpan).addPreferredGap(1).add((Component)this.jRadioButtonCreate).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogFillHierarchy this$0;
            {
                DialogFillHierarchy dialogFillHierarchy = this$0;
                Objects.requireNonNull(dialogFillHierarchy);
                this.this$0 = dialogFillHierarchy;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 421, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).add(5, 5, 5).add((Component)this.jButtonCancel)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).add(4, 4, 4)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(1))).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jCheckBox1).addPreferredGap(0).add((Component)this.jCheckBox2).addPreferredGap(0).add((Component)this.jCheckBox3).addPreferredGap(1).add((Component)this.jCheckBox4)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jCheckBox5).addPreferredGap(0).add((Component)this.jCheckBox6).addPreferredGap(1).add((Component)this.jCheckBox7).addPreferredGap(0).add((Component)this.jCheckBox8)).add((Component)this.jTextFieldVersion, -1, 376, Short.MAX_VALUE).add((Component)this.jTextFieldScheme, -1, 376, Short.MAX_VALUE))).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldVersion, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldScheme, -2, -1, -2)).add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jCheckBox1).add((Component)this.jCheckBox2).add((Component)this.jCheckBox3).add((Component)this.jCheckBox4).add((Component)this.jLabel3)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jCheckBox5).add((Component)this.jCheckBox6).add((Component)this.jCheckBox7).add((Component)this.jCheckBox8)).add(13, 13, 13).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).add(4, 4, 4).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((Component)this.jButtonHelp)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.buttonGroupSamples.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select sample gap option", this.getTitle(), 1);
            return;
        }
        int igdType = this.scheme.getIGDType();
        try {
            this.scheme.loadUnits();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error loading scheme units", sql, this.db);
            return;
        }
        int hier = IGDIntervalZone.getNHier(igdType, true);
        while (true) {
            block42: {
                if (hier <= 1) break;
                LinkedList<IGDIntervalZone> hierZones = new LinkedList<IGDIntervalZone>();
                for (IGDIntervalZone iGDIntervalZone : this.list) {
                    if (iGDIntervalZone.getHier() != hier) continue;
                    hierZones.add(iGDIntervalZone);
                }
                if (hierZones.isEmpty()) break block42;
                block22: for (int genHier = hier - 1; genHier > 0; --genHier) {
                    switch (genHier) {
                        case 1: {
                            if (this.jCheckBox1.isSelected()) break;
                            continue block22;
                        }
                        case 2: {
                            if (this.jCheckBox2.isSelected()) break;
                            continue block22;
                        }
                        case 3: {
                            if (this.jCheckBox3.isSelected()) break;
                            continue block22;
                        }
                        case 4: {
                            if (this.jCheckBox4.isSelected()) break;
                            continue block22;
                        }
                        case 5: {
                            if (this.jCheckBox5.isSelected()) break;
                            continue block22;
                        }
                        case 6: {
                            if (this.jCheckBox6.isSelected()) break;
                            continue block22;
                        }
                        case 7: {
                            if (this.jCheckBox7.isSelected()) break;
                            continue block22;
                        }
                        case 8: {
                            if (!this.jCheckBox8.isSelected()) continue block22;
                        }
                    }
                    for (IGDIntervalZone zone : hierZones) {
                        if (zone.getUppZone() == 0) continue;
                        try {
                            IGDUnitBase unit = this.scheme.findUnitBase(zone.getUppZone());
                            IGDUnitBase higherUnit = this.scheme.getHigherUnit(unit, genHier);
                            if (higherUnit == null) continue;
                            boolean genZone = true;
                            if (zone.getLowZone() != 0) {
                                IGDUnit lowUnit = this.scheme.findUnit(zone.getLowZone());
                                IGDUnitBase highterLowUnit = this.scheme.getHigherUnit(lowUnit, genHier);
                                if (higherUnit.getUnitID() != highterLowUnit.getUnitID()) {
                                    genZone = false;
                                }
                            }
                            for (IGDIntervalZone checkZone : this.list) {
                                if (checkZone.getTopSample() != zone.getTopSample() || checkZone.getHier() != genHier) continue;
                                genZone = false;
                                break;
                            }
                            IGDIntervalZone toRemove = null;
                            Sample top = zone.getTopSample();
                            Sample base = zone.getBaseSample();
                            int topBnd = zone.getTopBndInt();
                            int baseBnd = zone.getBaseBndInt();
                            for (IGDIntervalZone checkZone : this.toAdd) {
                                if (checkZone.getHier() != genHier || checkZone.getUppZone() != higherUnit.getUnitID()) continue;
                                if (checkZone.getTopSample() == zone.getTopSample() && checkZone.getBaseSample() == zone.getBaseSample()) {
                                    genZone = false;
                                    break;
                                }
                                if (checkZone.getTopSample().getDepth() < zone.getTopSample().getDepth()) {
                                    top = checkZone.getTopSample();
                                    topBnd = checkZone.getTopBndInt();
                                }
                                if (checkZone.getBaseSample().getDepth() > zone.getBaseSample().getDepth()) {
                                    base = checkZone.getBaseSample();
                                    baseBnd = checkZone.getBaseBndInt();
                                }
                                toRemove = checkZone;
                                break;
                            }
                            if (toRemove != null) {
                                this.toAdd.remove(toRemove);
                            }
                            if (!genZone) continue;
                            IGDIntervalZone.Builder addZone = new IGDIntervalZone.Builder(this.db, igdType, top, base, higherUnit.getHier(), this.scheme.getID()).topBnd(topBnd).baseBnd(baseBnd);
                            addZone.uppZone(higherUnit.getUnitID()).uppInf(higherUnit.getName());
                            try {
                                IGDIntervalZone okZone = WellInterp.checkOverlap(this.toAdd, addZone, null, false);
                                this.wellInterp.checkOverlap(addZone, null, false);
                                this.toAdd.add(okZone);
                            }
                            catch (SQLException | InvalidFieldException | SBException throwable) {}
                        }
                        catch (SQLException sql) {
                            FrameJsbugs.showStackError("SQL Error", sql, this.db);
                            return;
                        }
                    }
                }
            }
            --hier;
        }
        boolean sorted = false;
        block26: while (true) {
            if (sorted) {
                System.out.println("\n\n" + this.toAdd.size() + " Intervals to be added before removal, after sort: ");
                for (IGDIntervalZone z : this.toAdd) {
                    System.out.println(String.valueOf(z.getTopSample()) + "\t" + String.valueOf(z.getBaseSample()) + "\t" + z.getUppInf() + "\t" + z.getHier());
                }
                try {
                    this.removeOverlappingIntervals();
                    System.out.println("\n\n" + this.toAdd.size() + " Intervals to be added AFTER removal: ");
                    for (IGDIntervalZone z : this.toAdd) {
                        System.out.println(String.valueOf(z.getTopSample()) + "\t" + String.valueOf(z.getBaseSample()) + "\t" + z.getUppInf() + "\t" + z.getHier());
                    }
                }
                catch (SQLException | InvalidFieldException | SBException e) {
                    FrameJsbugs.showStackError("Error removing overlapping intervals", (Exception)e, this.db);
                    return;
                }
                try {
                    IGDIntervalZone zone = null;
                    int zonesAdded = 0;
                    Iterator<IGDIntervalZone> iterator = this.toAdd.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            this.wellInterp.notifyObservers(zone);
                            JOptionPane.showMessageDialog(this, "Number of intervals added: " + zonesAdded, this.getTitle(), 1);
                            this.isOK = true;
                            this.dispose();
                            return;
                        }
                        IGDIntervalZone z = iterator.next();
                        zone = this.wellInterp.addZone(IGDIntervalZone.Builder.copyOf(z), this.well);
                        ++zonesAdded;
                        this.well.getDataModel().commit();
                    }
                }
                catch (SQLException | InvalidFieldException | SBException e) {
                    this.well.getDataModel().doRollback();
                    FrameJsbugs.showStackError("Error adding new intervals", (Exception)e, this.db);
                }
                return;
            }
            sorted = true;
            int i = 1;
            while (true) {
                if (i >= this.toAdd.size()) continue block26;
                IGDIntervalZone z1 = this.toAdd.get(i - 1);
                IGDIntervalZone iGDIntervalZone = this.toAdd.get(i);
                if (z1.getHier() > iGDIntervalZone.getHier()) {
                    sorted = false;
                    this.toAdd.remove(i);
                    this.toAdd.add(i - 1, iGDIntervalZone);
                    continue block26;
                }
                if (z1.getHier() == iGDIntervalZone.getHier() && z1.getTopSample().getDepth() > iGDIntervalZone.getTopSample().getDepth()) {
                    sorted = false;
                    this.toAdd.remove(i);
                    this.toAdd.add(i - 1, iGDIntervalZone);
                    continue block26;
                }
                ++i;
            }
            break;
        }
    }

    private void removeOverlappingIntervals() throws SBException, SQLException, InvalidFieldException {
        boolean intervalRemoved;
        block0: do {
            intervalRemoved = false;
            for (int i = 0; i < this.toAdd.size() - 1; ++i) {
                IGDIntervalZone zone = this.toAdd.get(i);
                IGDIntervalZone nextZone = this.toAdd.get(i + 1);
                if (zone.getHier() != nextZone.getHier() || zone.getUppZone() != nextZone.getUppZone() || !this.jRadioButtonSpan.isSelected() && !(zone.getBaseSample().getDepth() >= nextZone.getTopSample().getDepth())) continue;
                this.toAdd.remove(nextZone);
                if (nextZone.getBaseSample().getDepth() > zone.getBaseSample().getDepth()) {
                    int index = this.toAdd.indexOf(zone);
                    this.toAdd.remove(zone);
                    this.toAdd.add(index, WellInterp.checkOverlap(this.toAdd, IGDIntervalZone.Builder.copyOf(zone, zone.getTopSample(), nextZone.getBaseSample()).baseBnd(nextZone.getBaseBndInt()), zone, false));
                }
                intervalRemoved = true;
                continue block0;
            }
        } while (intervalRemoved);
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogfillhierarchy.html");
    }
}

