/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jsbugs.userconnect.Jsbugs;
import model3.SBdb;
import org.jdesktop.layout.GroupLayout;

public class DialogHelpAbout
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(DialogHelpAbout.class.getName());
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabelAppVersion;
    private JLabel jLabelDBVersion;
    private JLabel jLabelModified;
    private JLabel jLabelicense;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public DialogHelpAbout(Frame parent, boolean modal, SBdb db, String licenceExpiry) {
        super(parent, modal);
        this.initComponents();
        this.init(db, licenceExpiry);
        this.setLocationRelativeTo(parent);
    }

    private void init(SBdb db, String licenceExpiry) {
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.setTitle("About StrataBugs");
        try {
            File jarFile = new File(Jsbugs.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (jarFile.exists() && jarFile.getPath().endsWith(".jar")) {
                LOGGER.log(Level.CONFIG, "Jar file Path: " + jarFile.getPath());
                this.setInfoFromManifest(jarFile);
            } else {
                this.jLabelAppVersion.setText("JAR file not found. Running in IDE?");
                LOGGER.log(Level.CONFIG, "Running in IDE? Jar file doesn't exist in path: " + jarFile.getPath());
            }
        }
        catch (RuntimeException | URISyntaxException ex) {
            LOGGER.log(Level.WARNING, "Exception getting source info", ex);
        }
        this.jLabelicense.setText("Licence expiry: " + licenceExpiry);
        Object dbv = "Database version: ";
        dbv = db != null ? (String)dbv + db.getDataModelRevision() : "No database!";
        this.jLabelDBVersion.setText((String)dbv);
    }

    private void setInfoFromManifest(File jarFile) {
        block18: {
            try {
                Date verDate = new Date(jarFile.lastModified());
                SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy HH:mm");
                String version = df.format(verDate);
                this.jLabelModified.setText("File last updated: " + version);
                try (ZipFile zipFile = new ZipFile(jarFile.getPath());){
                    String builtOn;
                    String builtBy;
                    ZipEntry entry = zipFile.getEntry("META-INF/MANIFEST.MF");
                    if (entry == null) break block18;
                    String buildString = null;
                    InputStream fis = zipFile.getInputStream(entry);
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(fis));){
                        String buff;
                        builtBy = null;
                        builtOn = null;
                        String buildVersion = null;
                        while ((buff = reader.readLine()) != null) {
                            if (buff.startsWith("Built-By")) {
                                builtBy = buff.substring("Built-By: ".length());
                            }
                            if (buff.startsWith("Built-On")) {
                                builtOn = buff.substring("Built-On: ".length());
                            }
                            if (!buff.startsWith("Implementation-Version")) continue;
                            buildVersion = buff.substring("Implementation-Version: ".length());
                            this.jLabelAppVersion.setText("Application version: " + buildVersion);
                        }
                    }
                    if (builtBy != null) {
                        buildString = "Built: " + builtBy;
                    }
                    if (builtOn != null) {
                        buildString = buildString + " : " + builtOn;
                    }
                    if (buildString == null) {
                        buildString = "Build date :    " + df.format(new Date(entry.getTime()));
                    }
                }
            }
            catch (Exception e) {
                this.jLabelAppVersion.setText(e.getMessage());
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabelAppVersion = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabelModified = new JLabel();
        this.jLabelDBVersion = new JLabel();
        this.jLabelicense = new JLabel();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jPanel2.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, new Color(134, 202, 149)));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/splashscreen/splash_3-0.jpg")));
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel1, -1, -1, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel1, -2, 297, Short.MAX_VALUE));
        this.jLabelAppVersion.setFont(new Font("Tahoma", 1, 13));
        this.jLabelAppVersion.setText("Application version:");
        this.jLabel3.setForeground(new Color(102, 102, 102));
        this.jLabel3.setText("Copyright StrataData Ltd.");
        this.jLabelModified.setFont(new Font("Tahoma", 0, 12));
        this.jLabelModified.setText("File last updated: ");
        this.jLabelDBVersion.setFont(new Font("Tahoma", 1, 13));
        this.jLabelDBVersion.setHorizontalAlignment(2);
        this.jLabelDBVersion.setText("Database version:");
        this.jLabelicense.setFont(new Font("Tahoma", 1, 13));
        this.jLabelicense.setText("License expiry:");
        this.jButtonOK.setText("Close");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogHelpAbout this$0;
            {
                DialogHelpAbout dialogHelpAbout = this$0;
                Objects.requireNonNull(dialogHelpAbout);
                this.this$0 = dialogHelpAbout;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jPanel2, -2, -1, -2).add(0, 0, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabelAppVersion, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabelModified, -2, 403, -2).add((Component)this.jLabelDBVersion, -2, 368, -2).add((Component)this.jLabelicense, -2, 376, -2)).add(0, 0, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addContainerGap()))));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(1).add((Component)this.jLabelDBVersion).addPreferredGap(0).add((Component)this.jLabelAppVersion).addPreferredGap(1).add((Component)this.jLabelModified).addPreferredGap(1).add((Component)this.jLabelicense).add(18, 18, 18).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -2, -1, -2));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

