/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import jsbugs.ComboCellRenderer;
import jsbugs.FrameJsbugs;
import model3.IGDColMap;
import model3.IGDInterval;
import model3.IGDIntervalZone;
import model3.SBdb;
import model3.Well;
import model3.WellInterp;
import model3.project.Project;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class DialogIGDColmap
extends SBDialog {
    private static final int INNERMARGIN = 20;
    static final int COL_COL = 0;
    static final int COL_MINHIER = 1;
    static final int COL_MAXHIER = 2;
    static final String[] colTitles = new String[]{"Column", "Level: From", "Level: To"};
    static final int[] colWidths = new int[]{60, 40, 40};
    private final SBdb db;
    private final Well well;
    private final WellInterp wellInterp;
    private final int igdType;
    private final TableModelIGDColmap model = new TableModelIGDColmap(this);
    private final DefaultComboBoxModel modelLevels = new DefaultComboBoxModel();
    private final DefaultComboBoxModel modelProject = new DefaultComboBoxModel();
    private final JComboBox levelCombo = new JComboBox(this.modelLevels);
    private final IGDColmapJPanel panel = new IGDColmapJPanel(this);
    private final IGDColMap colmap;
    private JButton jButtonAddColumn;
    private JButton jButtonCancel;
    private JButton jButtonDeleteColumn;
    private JButton jButtonEditColumn;
    private JButton jButtonHelp;
    private JButton jButtonInsert;
    private JButton jButtonOK;
    private JComboBox jComboBoxProject;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTableLevels;

    public DialogIGDColmap(Frame parent, boolean modal, SBdb db, Well well, WellInterp wellInterp, int igdType) throws SQLException {
        super(parent, modal);
        assert (well.getDataModel() == db);
        this.db = db;
        this.well = well;
        this.wellInterp = wellInterp;
        this.igdType = igdType;
        this.colmap = new IGDColMap(wellInterp.getColMap(well.getWellID(), igdType));
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Column Mapping : " + this.well.getWellName() + " : " + this.wellInterp.getHeader().getDescription() + " : " + IGDInterval.getIGDName(this.igdType));
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.modelLevels.removeAllElements();
        for (int i = 0; i < IGDIntervalZone.getNHier(this.igdType, true); ++i) {
            this.modelLevels.addElement(IGDIntervalZone.getHierName(this.igdType, i + 1));
        }
        this.model.setupTable(this.jTableLevels);
        this.jTableLevels.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this.levelCombo));
        this.jTableLevels.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.levelCombo));
        this.jPanel1.add(this.panel);
        this.panel.setSize(this.jPanel1.getWidth() - 20, this.jPanel1.getHeight() - 20);
        this.panel.repaint();
        this.initProjectCombo();
    }

    private void initProjectCombo() {
        this.modelProject.removeAllElements();
        this.modelProject.addElement("<no project>");
        try {
            for (int projID : this.db.getProjIDs(this.well)) {
                this.modelProject.addElement(this.db.getProject(projID));
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("Error initialising project combo", sql, this.db);
        }
    }

    private void initComponents() {
        this.jProgressBar1 = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableLevels = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonAddColumn = new JButton();
        this.jButtonEditColumn = new JButton();
        this.jButtonDeleteColumn = new JButton();
        this.jButtonInsert = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jComboBoxProject = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(600, 570));
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setForeground(new Color(51, 102, 204));
        this.jLabel1.setText("Click the \"From\" and \"To\" cells to specify hierachy level range for selected column:");
        this.jTableLevels.setModel(this.model);
        this.jTableLevels.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogIGDColmap this$0;
            {
                DialogIGDColmap dialogIGDColmap = this$0;
                Objects.requireNonNull(dialogIGDColmap);
                this.this$0 = dialogIGDColmap;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableLevelsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableLevels);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDColmap this$0;
            {
                DialogIGDColmap dialogIGDColmap = this$0;
                Objects.requireNonNull(dialogIGDColmap);
                this.this$0 = dialogIGDColmap;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDColmap this$0;
            {
                DialogIGDColmap dialogIGDColmap = this$0;
                Objects.requireNonNull(dialogIGDColmap);
                this.this$0 = dialogIGDColmap;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDColmap this$0;
            {
                DialogIGDColmap dialogIGDColmap = this$0;
                Objects.requireNonNull(dialogIGDColmap);
                this.this$0 = dialogIGDColmap;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonAddColumn.setText("New column...");
        this.jButtonAddColumn.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDColmap this$0;
            {
                DialogIGDColmap dialogIGDColmap = this$0;
                Objects.requireNonNull(dialogIGDColmap);
                this.this$0 = dialogIGDColmap;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddColumnActionPerformed(evt);
            }
        });
        this.jButtonEditColumn.setText("Edit name...");
        this.jButtonEditColumn.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDColmap this$0;
            {
                DialogIGDColmap dialogIGDColmap = this$0;
                Objects.requireNonNull(dialogIGDColmap);
                this.this$0 = dialogIGDColmap;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEditColumnActionPerformed(evt);
            }
        });
        this.jButtonDeleteColumn.setText("Delete column");
        this.jButtonDeleteColumn.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDColmap this$0;
            {
                DialogIGDColmap dialogIGDColmap = this$0;
                Objects.requireNonNull(dialogIGDColmap);
                this.this$0 = dialogIGDColmap;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteColumnActionPerformed(evt);
            }
        });
        this.jButtonInsert.setText("Insert column");
        this.jButtonInsert.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDColmap this$0;
            {
                DialogIGDColmap dialogIGDColmap = this$0;
                Objects.requireNonNull(dialogIGDColmap);
                this.this$0 = dialogIGDColmap;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonInsertActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Preview", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanel1.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ DialogIGDColmap this$0;
            {
                DialogIGDColmap dialogIGDColmap = this$0;
                Objects.requireNonNull(dialogIGDColmap);
                this.this$0 = dialogIGDColmap;
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                this.this$0.jPanel1ComponentResized(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 296, Short.MAX_VALUE));
        this.jLabel2.setForeground(new Color(51, 102, 204));
        this.jLabel2.setText("Apply to all wells in project:");
        this.jComboBoxProject.setMaximumRowCount(30);
        this.jComboBoxProject.setModel(this.modelProject);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(0, 0, Short.MAX_VALUE)).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonAddColumn, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonInsert, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEditColumn, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDeleteColumn)).add(2, 2, 2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jComboBoxProject, -2, 160, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jSeparator1)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.linkSize(new Component[]{this.jButtonAddColumn, this.jButtonDeleteColumn, this.jButtonEditColumn, this.jButtonInsert}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonInsert).addPreferredGap(0).add((Component)this.jButtonAddColumn).addPreferredGap(0).add((Component)this.jButtonEditColumn).addPreferredGap(0).add((Component)this.jButtonDeleteColumn)).add((Component)this.jScrollPane1, -2, 110, -2)).addPreferredGap(1).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonOK).add((Component)this.jLabel2).add((Component)this.jComboBoxProject, -2, -1, -2))).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (!this.colmap.check()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Cannot save - check duplicate entries.", this.getTitle(), 2);
            return;
        }
        Project project = null;
        if (this.jComboBoxProject.getSelectedItem() instanceof Project) {
            project = (Project)((Object)this.jComboBoxProject.getSelectedItem());
            try {
                int opt;
                if (this.db.getnWells(project.getID()) > 1 && (opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Do you really want to edit column mapping for all " + this.db.getnWells(project.getID()) + " wells in '" + String.valueOf((Object)project) + "'?", this.getTitle(), 0)) != 0) {
                    return;
                }
            }
            catch (SQLException | SBException sql) {
                FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
                return;
            }
        }
        try {
            if (project != null) {
                Iterator<Well> it = this.db.getWellIterator(project.getID());
                while (it.hasNext()) {
                    Well w = it.next();
                    w.loadInterps();
                    WellInterp i = w.getInterp(this.wellInterp.getHeader().getInterpID());
                    try {
                        i.setColMap(w.getWellID(), this.igdType, this.colmap);
                        i.notifyObservers(this.colmap);
                        this.db.commit();
                    }
                    catch (SBPermissionException pe) {
                        JOptionPane.showMessageDialog((Component)((Object)this), "Cannot edit well: " + String.valueOf(w) + "\n" + pe.getMessage(), this.getTitle(), 2);
                    }
                }
            } else {
                this.wellInterp.setColMap(this.well.getWellID(), this.igdType, this.colmap);
                this.wellInterp.notifyObservers(this.colmap);
                this.db.commit();
            }
            this.setOK();
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog((Component)((Object)this), pe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException | SBException e) {
            this.db.doRollback();
            FrameJsbugs.showStackError("Error", (Exception)e, this.db);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogigdcolmap.html");
    }

    private void jButtonAddColumnActionPerformed(ActionEvent evt) {
        if (this.model.getRowCount() == this.modelLevels.getSize()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Cannot add any more columns.", this.getTitle(), 2);
            return;
        }
        String columnTitle = JOptionPane.showInputDialog((Component)((Object)this), (Object)"Column name");
        if (columnTitle != null) {
            try {
                this.colmap.addEntry(this.modelLevels.getSize(), columnTitle);
                this.model.fireTableDataChanged();
                this.jPanel1.repaint();
                this.panel.repaint();
            }
            catch (RuntimeException re) {
                StackError.showStackError((String)"", (Throwable)re);
            }
        }
    }

    private void jButtonEditColumnActionPerformed(ActionEvent evt) {
        if (this.jTableLevels.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No column selected.", this.getTitle(), 2);
            return;
        }
        int selection = this.jTableLevels.getSelectedRow() + 1;
        try {
            String columnTitle = JOptionPane.showInputDialog((Component)((Object)this), "Column name", this.colmap.getColTitle(selection));
            if (columnTitle != null) {
                this.colmap.setTitle(selection, columnTitle);
                this.model.fireTableDataChanged();
                this.jPanel1.repaint();
                this.panel.repaint();
            }
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
    }

    private void jButtonDeleteColumnActionPerformed(ActionEvent evt) {
        if (this.jTableLevels.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No column selected.", this.getTitle(), 2);
            return;
        }
        try {
            if (this.colmap.getSize() <= 1) {
                JOptionPane.showMessageDialog((Component)((Object)this), "You must have at least 1 column.", this.getTitle(), 2);
                return;
            }
            int selection = this.jTableLevels.getSelectedRow() + 1;
            this.colmap.deleteColumn(selection);
            this.model.fireTableDataChanged();
            this.jPanel1.repaint();
            this.panel.repaint();
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
    }

    private void jButtonInsertActionPerformed(ActionEvent evt) {
        try {
            if (this.colmap.getSize() == this.modelLevels.getSize()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Cannot add any more columns.", this.getTitle(), 2);
                return;
            }
            int insertPoint = this.jTableLevels.getSelectedRow();
            if (insertPoint < 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Select an entry in the list of columns below new entry to be inserted.", this.getTitle(), 2);
                return;
            }
            String columnTitle = JOptionPane.showInputDialog((Component)((Object)this), (Object)"Column name");
            if (columnTitle != null) {
                this.colmap.insertEntry(this.modelLevels.getSize(), insertPoint + 1, columnTitle);
                this.model.fireTableDataChanged();
            }
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
    }

    private void jPanel1ComponentResized(ComponentEvent evt) {
        this.panel.setSize(this.jPanel1.getWidth() - 20, this.jPanel1.getHeight() - 20);
        this.jPanel1.repaint();
        this.panel.repaint();
    }

    private void jTableLevelsMouseClicked(MouseEvent evt) {
        int col;
        if (evt.getClickCount() > 1 && (col = this.jTableLevels.getSelectedColumn()) == 0) {
            this.jButtonEditColumnActionPerformed(null);
        }
    }

    private class TableModelIGDColmap
    extends AbstractTableModel {
        final /* synthetic */ DialogIGDColmap this$0;

        private TableModelIGDColmap(DialogIGDColmap dialogIGDColmap) {
            DialogIGDColmap dialogIGDColmap2 = dialogIGDColmap;
            Objects.requireNonNull(dialogIGDColmap2);
            this.this$0 = dialogIGDColmap2;
        }

        @Override
        public int getRowCount() {
            try {
                return this.this$0.colmap != null ? this.this$0.colmap.getSize() : 0;
            }
            catch (Exception ex) {
                return 0;
            }
        }

        @Override
        public int getColumnCount() {
            return colTitles.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.this$0.colmap == null) {
                return "";
            }
            try {
                switch (columnIndex) {
                    case 0: {
                        return this.this$0.colmap.getColTitle(rowIndex + 1);
                    }
                    case 1: {
                        return IGDIntervalZone.getHierName(this.this$0.igdType, this.this$0.colmap.getMinhier(rowIndex + 1));
                    }
                    case 2: {
                        return IGDIntervalZone.getHierName(this.this$0.igdType, this.this$0.colmap.getMaxhier(rowIndex + 1));
                    }
                }
                return "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            if (this.this$0.colmap == null) {
                return;
            }
            try {
                int index = row + 1;
                String level = obj.toString();
                int hier = IGDIntervalZone.getHierNumber(this.this$0.igdType, level, true);
                switch (col) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (hier > this.this$0.colmap.getMaxhier(index)) {
                            return;
                        }
                        this.this$0.colmap.setHier(index, hier, this.this$0.colmap.getMaxhier(index));
                        this.fireTableDataChanged();
                        if (this.this$0.panel == null) break;
                        this.this$0.panel.repaint();
                        this.this$0.panel.getParent().repaint();
                        break;
                    }
                    case 2: {
                        if (hier < this.this$0.colmap.getMinhier(index)) {
                            return;
                        }
                        this.this$0.colmap.setHier(row + 1, this.this$0.colmap.getMinhier(index), hier);
                        this.fireTableDataChanged();
                        if (this.this$0.panel == null) break;
                        this.this$0.panel.repaint();
                        this.this$0.panel.getParent().repaint();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                default: 
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return false;
                }
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        void setupTable(JTable jTable) {
            SB.setTableHeaderBold((JTable)jTable);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                jTable.getColumnModel().getColumn(i).setHeaderValue(colTitles[i]);
                jTable.getColumnModel().getColumn(i).setPreferredWidth(colWidths[i]);
            }
            jTable.getColumnModel().getColumn(2).setCellRenderer(new ComboCellRenderer());
            jTable.getColumnModel().getColumn(1).setCellRenderer(new ComboCellRenderer());
        }
    }

    private class IGDColmapJPanel
    extends JPanel {
        final /* synthetic */ DialogIGDColmap this$0;

        private IGDColmapJPanel(DialogIGDColmap dialogIGDColmap) {
            DialogIGDColmap dialogIGDColmap2 = dialogIGDColmap;
            Objects.requireNonNull(dialogIGDColmap2);
            this.this$0 = dialogIGDColmap2;
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.this$0.colmap != null) {
                int i;
                Rectangle bounds = this.getBounds(null);
                Rectangle2D.Double backG = new Rectangle2D.Double(20.0, 20.0, ((RectangularShape)bounds).getWidth() - 20.0, ((RectangularShape)bounds).getHeight() - 20.0);
                g.setColor(Color.white);
                g.fillRect((int)backG.getX(), (int)backG.getY(), (int)backG.getWidth(), (int)backG.getHeight());
                Rectangle2D.Double frame = new Rectangle2D.Double(backG.getX() + 20.0, backG.getY() + 20.0, backG.getWidth() - 40.0, backG.getHeight() - 40.0);
                g.setColor(Color.gray);
                g.drawLine((int)frame.getX(), (int)frame.getY(), (int)(frame.getX() + frame.getWidth()), (int)frame.getY());
                g.drawLine((int)frame.getX(), (int)frame.getY(), (int)frame.getX(), (int)(frame.getY() + frame.getHeight()));
                g.drawLine((int)(frame.getX() + frame.getWidth()), (int)frame.getY(), (int)(frame.getX() + frame.getWidth()), (int)(frame.getY() + frame.getHeight()));
                double headerHeight = frame.getHeight() / 3.0;
                g.drawLine((int)frame.getX(), (int)(frame.getY() + headerHeight), (int)(frame.getX() + frame.getWidth()), (int)(frame.getY() + headerHeight));
                int nHier = IGDIntervalZone.getNHier(this.this$0.igdType, true);
                double levelWidth = frame.getWidth() / (double)nHier;
                for (i = 0; i < nHier; ++i) {
                    int x = (int)(frame.getX() + (double)i * levelWidth);
                    g.drawLine(x, (int)(frame.getY() + headerHeight), x, (int)(frame.getY() + frame.getHeight()));
                    String label = IGDIntervalZone.getHierName(this.this$0.igdType, i + 1);
                    int w = g.getFontMetrics().stringWidth(label);
                    int h = g.getFontMetrics().getHeight();
                    double yLabel = frame.getY() + 2.0 * headerHeight - (double)h / 2.0;
                    double xLabel = (double)x + levelWidth / 2.0 - (double)w / 2.0;
                    g.drawString(label, (int)xLabel, (int)yLabel);
                }
                g.setColor(Color.red);
                try {
                    for (i = 0; i < this.this$0.colmap.getSize(); ++i) {
                        String label = this.this$0.colmap.getColTitle(i + 1);
                        int x1 = (int)(frame.getX() + (double)(this.this$0.colmap.getMinhier(i + 1) - 1) * levelWidth);
                        int x2 = (int)(frame.getX() + (double)this.this$0.colmap.getMaxhier(i + 1) * levelWidth);
                        g.drawLine(x1, (int)frame.getY(), x2, (int)frame.getY());
                        g.drawLine(x1, (int)frame.getY(), x1, (int)(frame.getY() + frame.getHeight()));
                        g.drawLine(x2, (int)frame.getY(), x2, (int)(frame.getY() + frame.getHeight()));
                        int w = g.getFontMetrics().stringWidth(label);
                        int h = g.getFontMetrics().getHeight();
                        double yLabel = frame.getY() + headerHeight / 2.0 - (double)h / 2.0;
                        double xLabel = (double)x1 + (double)(x2 - x1) / 2.0 - (double)w / 2.0;
                        g.drawString(label, (int)xLabel, (int)yLabel);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

