/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.io.FileChooserUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import jsbugs.io.JPanelCSVOptions;
import util.FilePathUtils;
import util.gridwriter.CSVExportOptions;

public class DialogIGDZoneExportOptions
extends JDialog {
    private Response response = Response.Cancel;
    private File file = null;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonExport;
    private JButton jButtonSelectFile;
    private JCheckBox jCheckBoxCoreCorrectedCore;
    private JCheckBox jCheckBoxCoreCorrectedCutting;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanelCSVOptions jPanelCSVOptions1;
    private JRadioButton jRadioButtonExtendedOpenWorks;
    private JRadioButton jRadioButtonOpenWorks;
    private JRadioButton jRadioButtonStandard;
    private JTextField jTextFieldFilePath;

    public DialogIGDZoneExportOptions(Frame parent, boolean modal, File file) {
        super(parent, modal);
        this.initComponents();
        this.jPanelCSVOptions1.doLayout();
        this.jPanelCSVOptions1.setDefaults();
        this.file = file;
        this.updateFilePathText();
        this.updateCSVOptionsEnabled();
        this.setTitle("Export Zones");
    }

    public Response showDialog(Component component) {
        this.pack();
        this.setLocationRelativeTo(component);
        this.setVisible(true);
        return this.response;
    }

    public File getSelectedFile() {
        return this.file;
    }

    public Format getSelectedFormat() {
        if (this.jRadioButtonOpenWorks.isSelected()) {
            return Format.OpenWorksGrid;
        }
        if (this.jRadioButtonExtendedOpenWorks.isSelected()) {
            return Format.ExtendedOpenWorksGrid;
        }
        return Format.StandardGrid;
    }

    public boolean getUseCuttingSampleCorrections() {
        return this.jCheckBoxCoreCorrectedCutting.isSelected();
    }

    public boolean getUseCoreSampleCorrections() {
        return this.jCheckBoxCoreCorrectedCore.isSelected();
    }

    public CSVExportOptions getCSVExportOptions() {
        return this.jPanelCSVOptions1.getSelectedOptions();
    }

    private void closeDialog(Response response) {
        this.response = response;
        this.setVisible(false);
    }

    private void updateFilePathText() {
        this.jTextFieldFilePath.setText(this.file.getPath());
    }

    private void updateCSVOptionsEnabled() {
        if (FilePathUtils.isFileExtension((String)this.file.getPath(), (String[])new String[]{"xls", "xlsx"})) {
            this.jPanelCSVOptions1.setEnabled(false);
        } else {
            this.jPanelCSVOptions1.setEnabled(true);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jTextFieldFilePath = new JTextField();
        this.jButtonSelectFile = new JButton();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jRadioButtonStandard = new JRadioButton();
        this.jRadioButtonOpenWorks = new JRadioButton();
        this.jRadioButtonExtendedOpenWorks = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jCheckBoxCoreCorrectedCutting = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jCheckBoxCoreCorrectedCore = new JCheckBox();
        this.jPanel5 = new JPanel();
        this.jPanelCSVOptions1 = new JPanelCSVOptions();
        this.jButtonCancel = new JButton();
        this.jButtonExport = new JButton();
        this.setDefaultCloseOperation(2);
        this.jTextFieldFilePath.setEditable(false);
        this.jTextFieldFilePath.setBackground(new Color(255, 255, 204));
        this.jButtonSelectFile.setText("...");
        this.jButtonSelectFile.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDZoneExportOptions this$0;
            {
                DialogIGDZoneExportOptions dialogIGDZoneExportOptions = this$0;
                Objects.requireNonNull(dialogIGDZoneExportOptions);
                this.this$0 = dialogIGDZoneExportOptions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectFileActionPerformed(evt);
            }
        });
        this.jLabel1.setText("File:");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Format", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroup1.add(this.jRadioButtonStandard);
        this.jRadioButtonStandard.setSelected(true);
        this.jRadioButtonStandard.setText("Standard format (one line per zone)");
        this.buttonGroup1.add(this.jRadioButtonOpenWorks);
        this.jRadioButtonOpenWorks.setText("OpenWorks style format (two lines per zone)");
        this.buttonGroup1.add(this.jRadioButtonExtendedOpenWorks);
        this.jRadioButtonExtendedOpenWorks.setText("OpenWorks style format with additional columns");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonStandard).addComponent(this.jRadioButtonOpenWorks).addComponent(this.jRadioButtonExtendedOpenWorks)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonStandard).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonOpenWorks).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonExtendedOpenWorks)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Options", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        this.jPanel3.setLayout(new FlowLayout(0, 0, 0));
        this.jCheckBoxCoreCorrectedCutting.setText("Output core-corrected depths for cutting samples");
        this.jPanel3.add(this.jCheckBoxCoreCorrectedCutting);
        this.jPanel2.add(this.jPanel3);
        this.jPanel4.setLayout(new FlowLayout(0, 0, 0));
        this.jCheckBoxCoreCorrectedCore.setText("Output core-corrected depths for core samples");
        this.jPanel4.add(this.jCheckBoxCoreCorrectedCore);
        this.jPanel2.add(this.jPanel4);
        this.jPanel5.setLayout(new FlowLayout(0, 0, 0));
        this.jPanelCSVOptions1.setMaximumSize(new Dimension(200, 5000));
        this.jPanel5.add(this.jPanelCSVOptions1);
        this.jPanel2.add(this.jPanel5);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDZoneExportOptions this$0;
            {
                DialogIGDZoneExportOptions dialogIGDZoneExportOptions = this$0;
                Objects.requireNonNull(dialogIGDZoneExportOptions);
                this.this$0 = dialogIGDZoneExportOptions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonExport.setText("Export");
        this.jButtonExport.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIGDZoneExportOptions this$0;
            {
                DialogIGDZoneExportOptions dialogIGDZoneExportOptions = this$0;
                Objects.requireNonNull(dialogIGDZoneExportOptions);
                this.this$0 = dialogIGDZoneExportOptions;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExportActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFilePath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectFile, -2, 28, -2)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonExport).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldFilePath, -2, -1, -2).addComponent(this.jButtonSelectFile)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonExport)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.closeDialog(Response.Cancel);
    }

    private void jButtonExportActionPerformed(ActionEvent evt) {
        this.closeDialog(Response.Export);
    }

    private void jButtonSelectFileActionPerformed(ActionEvent evt) {
        String name = FilePathUtils.extractFileNameWithoutExtension((String)this.file.getName());
        File f = FileChooserUtils.saveAsGridDataDialog((Component)this, (String)this.file.getPath(), (String)name);
        if (f != null) {
            this.file = f;
            this.updateFilePathText();
            this.updateCSVOptionsEnabled();
        }
    }

    public static enum Response {
        Cancel,
        Export;

    }

    public static enum Format {
        StandardGrid,
        OpenWorksGrid,
        ExtendedOpenWorksGrid;

    }
}

