/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.scheme.Boundary;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.DialogSelectSample;
import jsbugs.DialogSelectUnit;
import jsbugs.FrameJsbugs;
import jsbugs.userconnect.DialogSelectAnalyst;
import model3.Fault;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnitBase;
import model3.Lastval;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.Well;
import model3.WellInterp;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.positioners.BalloonTipPositioner;
import net.java.balloontip.positioners.LeftAbovePositioner;
import net.java.balloontip.positioners.LeftBelowPositioner;
import net.java.balloontip.styles.BalloonTipStyle;
import net.java.balloontip.styles.EdgedBalloonStyle;
import net.java.balloontip.utils.TimingUtils;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.exception.StackError;

public class DialogInterval
extends SBDialog {
    private static final int SEPLEN = 10;
    private static final int UNITNAMELEN = 80;
    private static final int SAMPLENAMELEN = 10;
    private final DefaultComboBoxModel analystTopModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel analystBaseModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel schemeModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel hierModel = new DefaultComboBoxModel();
    private final SBdb db;
    private final Well well;
    private final WellInterp wellInterp;
    private final char units;
    private final int igdType;
    private int setHier = -1;
    IGDIntervalZone zone;
    Sample topSample;
    Sample baseSample;
    private IGDUnitBase upperUnit = null;
    private IGDUnitBase lowerUnit = null;
    private Box.Filler filler1;
    private JButton jButtonAnalystBase;
    private JButton jButtonAnalystTop;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonHelp;
    private JButton jButtonLowerUnitName;
    private JButton jButtonOK;
    private JButton jButtonSampleBase;
    private JButton jButtonSampleTop;
    private JButton jButtonUpperUnitName;
    private JCheckBox jCheckBoxLowerUnit;
    private JCheckBox jCheckBoxSyncBnd;
    private JCheckBox jCheckBoxUpperUnit;
    private JComboBox jComboBoxAnalystBase;
    private JComboBox jComboBoxAnalystTop;
    private JComboBox jComboBoxBoundaryBase;
    private JComboBox jComboBoxBoundaryTop;
    private JComboBox jComboBoxColumn;
    private JComboBox jComboBoxScheme;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JTextField jTextFieldCreated;
    private JTextField jTextFieldCreator;
    private JTextField jTextFieldDate;
    private JTextField jTextFieldLastModified;
    private JTextField jTextFieldLowerUnitFormal;
    private JTextField jTextFieldLowerUnitName;
    private JTextField jTextFieldSampleBase;
    private JTextField jTextFieldSampleTop;
    private JTextField jTextFieldSeparator;
    private JTextField jTextFieldUpperUnitFormal;
    private JTextField jTextFieldUpperUnitName;

    public DialogInterval(Frame parent, boolean modal, int igdType, SBdb db, Well well, WellInterp wellInterp, char units, IGDIntervalZone zone, Sample topSample, Sample baseSample, IGDUnitBase unit, IGDScheme scheme, boolean allowDelete) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        this.units = units;
        this.zone = zone;
        this.well = well;
        this.wellInterp = wellInterp;
        this.igdType = igdType;
        if (zone == null) {
            this.topSample = topSample;
            this.baseSample = baseSample;
        }
        this.initComponents();
        this.init(unit, scheme);
        this.jButtonDelete.setVisible(zone != null && allowDelete);
    }

    public DialogInterval(Frame parent, boolean modal, SBdb db, Well well, WellInterp wellInterp, char units, IGDIntervalZone.Builder settings) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        this.units = units;
        this.well = well;
        this.wellInterp = wellInterp;
        this.topSample = settings.getTopSample();
        this.baseSample = settings.getBaseSample();
        this.igdType = settings.igdType;
        this.initComponents();
        if (settings.getSchID() > 0) {
            IGDScheme scheme = db.getIGDScheme(settings.getSchID());
            this.init(scheme.findUnitBase(settings.getUppZone()), scheme);
        } else {
            this.init(null, null);
        }
        if (this.setHier < 0) {
            this.jComboBoxColumn.setSelectedIndex(settings.getHier() - 1);
        }
        this.jButtonDelete.setVisible(false);
    }

    public DialogInterval(JDialog parent, boolean modal, int igdType, SBdb db, Well well, WellInterp wellInterp, char units, IGDIntervalZone zone) throws SQLException, SBException {
        super((Window)parent, modal);
        this.db = db;
        this.units = units;
        this.zone = zone;
        this.well = well;
        this.wellInterp = wellInterp;
        this.igdType = igdType;
        this.initComponents();
        this.init(null, null);
        this.jButtonDelete.setVisible(false);
    }

    private void init(IGDUnitBase iunit, IGDScheme ischeme) throws SQLException, SBException {
        if (this.igdType == 4) {
            this.fillAnalystCombo();
        } else {
            this.jComboBoxAnalystTop.setEnabled(false);
            this.jComboBoxAnalystBase.setEnabled(false);
            this.jButtonAnalystTop.setEnabled(false);
            this.jButtonAnalystBase.setEnabled(false);
        }
        this.fillSchemeCombo();
        this.fillHierCombo();
        if (this.db.isConnected()) {
            this.jCheckBoxSyncBnd.setSelected(Lastval.getInt(this.db, "SYNCBND", 1) == 1);
        }
        if (this.zone == null) {
            int bnd;
            this.setTitle("Interval : Add");
            if (this.igdType == 10) {
                this.jComboBoxBoundaryTop.setSelectedItem(IGDIntervalZone.bnds[3]);
                this.jComboBoxBoundaryBase.setSelectedItem(IGDIntervalZone.bnds[3]);
            } else {
                this.jComboBoxBoundaryTop.setSelectedItem(IGDIntervalZone.bnds[2]);
                this.jComboBoxBoundaryBase.setSelectedItem(IGDIntervalZone.bnds[2]);
            }
            if (ischeme != null) {
                this.jComboBoxScheme.setSelectedItem(ischeme);
                if (iunit != null) {
                    this.upperUnit = iunit;
                    this.jTextFieldUpperUnitFormal.setText(this.upperUnit.toString());
                    this.jTextFieldUpperUnitName.setText(this.upperUnit.toString());
                    this.setHier = this.upperUnit.getHier();
                    this.jComboBoxColumn.setSelectedIndex(this.setHier - 1);
                }
            } else {
                IGDScheme lastScheme;
                this.jComboBoxColumn.setSelectedIndex(IGDIntervalZone.getNHier(this.igdType, true) - 2);
                int lastSchID = Lastval.getInt(this.db, "SCH_ID:" + this.igdType);
                if (lastSchID > 0 && (lastScheme = this.db.getIGDScheme(lastSchID)) != null) {
                    this.jComboBoxScheme.setSelectedItem(lastScheme);
                }
            }
            if (this.topSample != null && (bnd = this.wellInterp.getBoundaryAtSample(this.igdType, this.topSample)) > 0) {
                this.jComboBoxBoundaryTop.setSelectedIndex(bnd - 1);
            }
            if (this.baseSample != null && (bnd = this.wellInterp.getBoundaryAtSample(this.igdType, this.baseSample)) > 0) {
                this.jComboBoxBoundaryBase.setSelectedIndex(bnd - 1);
            }
        } else {
            this.setTitle("Interval : Edit");
            this.topSample = this.zone.getTopSample();
            this.baseSample = this.zone.getBaseSample();
            this.jComboBoxBoundaryTop.setSelectedItem(this.zone.getTopBnd());
            this.jComboBoxBoundaryBase.setSelectedItem(this.zone.getBaseBnd());
            if (this.analystTopModel.getIndexOf(this.zone.getTopAnalystString()) < 0) {
                this.analystTopModel.addElement(this.zone.getTopAnalystString());
            }
            this.jComboBoxAnalystTop.setSelectedItem(this.zone.getTopAnalystString());
            if (this.analystBaseModel.getIndexOf(this.zone.getBaseAnalystString()) < 0) {
                this.analystBaseModel.addElement(this.zone.getBaseAnalystString());
            }
            this.jComboBoxAnalystBase.setSelectedItem(this.zone.getBaseAnalystString());
            IGDScheme scheme = this.db.getIGDScheme(this.zone.getSchID(), this.zone.getIGDType());
            this.jComboBoxScheme.setSelectedItem(scheme);
            if (scheme != null) {
                scheme.loadUnits();
                this.upperUnit = scheme.findUnitBase(this.zone.getUppZone());
                this.lowerUnit = scheme.findUnitBase(this.zone.getLowZone());
                if (this.upperUnit != null) {
                    this.jTextFieldUpperUnitFormal.setText(this.upperUnit.toString());
                }
                if (this.lowerUnit != null && this.lowerUnit != this.upperUnit) {
                    this.jTextFieldLowerUnitFormal.setText(this.lowerUnit.toString());
                }
            }
            this.jComboBoxColumn.setSelectedIndex(this.zone.getHier() - 1);
            this.setHier = this.zone.getHier();
            this.jTextFieldUpperUnitName.setText(this.zone.getUppInf());
            this.jTextFieldLowerUnitName.setText(this.zone.getLowInf());
            this.jCheckBoxUpperUnit.setSelected(this.zone.getQUzone());
            this.jCheckBoxLowerUnit.setSelected(this.zone.getQLzone());
            this.jTextFieldSeparator.setText(this.zone.getSep());
            if (this.zone.getModifier() > 0) {
                this.jTextFieldLastModified.setText(this.db.getUser(this.zone.getModifier()).getName());
            } else {
                this.jTextFieldLastModified.setText("Unknown");
            }
            if (this.zone.getModified() != null) {
                this.jTextFieldDate.setText(SB.df.format(this.zone.getModified()));
            }
            if (this.zone.getCreator() > 0) {
                this.jTextFieldCreator.setText(this.db.getUser(this.zone.getCreator()).getName());
            } else {
                this.jTextFieldCreator.setText("Unknown");
            }
            if (this.zone.getCreated() != null) {
                this.jTextFieldCreated.setText(SB.df.format(this.zone.getCreated()));
            }
        }
        if (this.topSample != null) {
            this.jTextFieldSampleTop.setText(this.topSample.toString(this.units));
        }
        if (this.baseSample != null) {
            this.jTextFieldSampleBase.setText(this.baseSample.toString(this.units));
        }
        if (!this.well.canWrite(this.db, null)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(this.well.getDeniedReason(this.db, "well", false));
            this.jButtonDelete.setEnabled(false);
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
    }

    private void fillSchemeCombo() throws SQLException {
        List<IGDScheme> schemes = this.db.getIGDSchemes(this.igdType, this.wellInterp.getIGDSchemes(this.igdType));
        Collections.sort(schemes);
        this.schemeModel.addAll(schemes);
        this.jComboBoxScheme.repaint();
    }

    private void fillAnalystCombo() throws SQLException, SBException {
        List<Smpdtl> smpdtls = this.well.getAnalyses('\u0000', null, 0);
        this.analystTopModel.removeAllElements();
        this.analystTopModel.addElement("");
        this.analystBaseModel.removeAllElements();
        this.analystBaseModel.addElement("");
        for (Smpdtl s : smpdtls) {
            if (this.analystTopModel.getIndexOf(s.getAnalystAbr()) >= 0) continue;
            this.analystTopModel.addElement(s.getAnalystAbr());
            this.analystBaseModel.addElement(s.getAnalystAbr());
        }
        this.jComboBoxAnalystTop.repaint();
        this.jComboBoxAnalystTop.setSelectedIndex(0);
        this.jComboBoxAnalystBase.repaint();
        this.jComboBoxAnalystBase.setSelectedIndex(0);
    }

    private void fillHierCombo() {
        int nHier = IGDIntervalZone.getNHier(this.igdType, true);
        for (int i = 1; i <= nHier; ++i) {
            this.hierModel.addElement(IGDIntervalZone.getHierName(this.igdType, i));
        }
    }

    private void initComponents() {
        this.jComboBoxScheme = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jTextFieldUpperUnitName = new JTextField();
        this.jTextFieldUpperUnitFormal = new JTextField();
        this.jCheckBoxUpperUnit = new JCheckBox();
        this.jButtonUpperUnitName = new JButton();
        this.jLabel10 = new JLabel();
        this.jTextFieldSeparator = new JTextField();
        this.jTextFieldLowerUnitName = new JTextField();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jTextFieldLowerUnitFormal = new JTextField();
        this.jCheckBoxLowerUnit = new JCheckBox();
        this.jButtonLowerUnitName = new JButton();
        this.jLabel13 = new JLabel();
        this.jTextFieldLastModified = new JTextField();
        this.jLabel14 = new JLabel();
        this.jTextFieldDate = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldSampleTop = new JTextField();
        this.jTextFieldSampleBase = new JTextField();
        this.jButtonSampleBase = new JButton();
        this.jButtonSampleTop = new JButton();
        this.jComboBoxBoundaryBase = new JComboBox();
        this.jComboBoxBoundaryTop = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jComboBoxAnalystBase = new JComboBox();
        this.jComboBoxAnalystTop = new JComboBox();
        this.jButtonAnalystTop = new JButton();
        this.jButtonAnalystBase = new JButton();
        this.jLabel5 = new JLabel();
        this.jCheckBoxSyncBnd = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.jComboBoxColumn = new JComboBox();
        this.filler1 = new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, Short.MAX_VALUE));
        this.jButtonDelete = new JButton();
        this.jLabel15 = new JLabel();
        this.jTextFieldCreator = new JTextField();
        this.jLabel16 = new JLabel();
        this.jTextFieldCreated = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jComboBoxScheme.setMaximumRowCount(30);
        this.jComboBoxScheme.setModel(this.schemeModel);
        this.jComboBoxScheme.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jLabel6.setText("Scheme:");
        this.jLabel8.setText("Upper unit name:");
        this.jLabel9.setText("(Formal name):");
        this.jTextFieldUpperUnitName.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldUpperUnitNameFocusGained(evt);
            }
        });
        this.jTextFieldUpperUnitName.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldUpperUnitNameKeyTyped(evt);
            }
        });
        this.jTextFieldUpperUnitFormal.setEditable(false);
        this.jTextFieldUpperUnitFormal.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldUpperUnitFormalFocusGained(evt);
            }
        });
        this.jTextFieldUpperUnitFormal.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldUpperUnitFormalKeyTyped(evt);
            }
        });
        this.jCheckBoxUpperUnit.setText("?");
        this.jCheckBoxUpperUnit.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxUpperUnit.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonUpperUnitName.setText("...");
        this.jButtonUpperUnitName.setToolTipText("Select unit");
        this.jButtonUpperUnitName.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonUpperUnitName.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonUpperUnitNameActionPerformed(evt);
            }
        });
        this.jLabel10.setText("Separator:");
        this.jTextFieldSeparator.setText("-");
        this.jTextFieldSeparator.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldSeparatorFocusGained(evt);
            }
        });
        this.jTextFieldSeparator.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldSeparatorKeyTyped(evt);
            }
        });
        this.jTextFieldLowerUnitName.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldLowerUnitNameFocusGained(evt);
            }
        });
        this.jTextFieldLowerUnitName.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldLowerUnitNameKeyTyped(evt);
            }
        });
        this.jLabel11.setText("Lower unit name:");
        this.jLabel12.setText("(Formal name):");
        this.jTextFieldLowerUnitFormal.setEditable(false);
        this.jTextFieldLowerUnitFormal.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldLowerUnitFormalFocusGained(evt);
            }
        });
        this.jTextFieldLowerUnitFormal.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldLowerUnitFormalKeyTyped(evt);
            }
        });
        this.jCheckBoxLowerUnit.setText("?");
        this.jCheckBoxLowerUnit.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxLowerUnit.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonLowerUnitName.setText("...");
        this.jButtonLowerUnitName.setToolTipText("Select unit");
        this.jButtonLowerUnitName.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonLowerUnitName.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonLowerUnitNameActionPerformed(evt);
            }
        });
        this.jLabel13.setText("Last modified by:");
        this.jTextFieldLastModified.setEditable(false);
        this.jLabel14.setText("On:");
        this.jTextFieldDate.setEditable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel2.setText("Base:");
        this.jLabel1.setText("Top:");
        this.jLabel3.setText("Sample/Depth:");
        this.jTextFieldSampleTop.setEditable(false);
        this.jTextFieldSampleTop.setBackground(new Color(255, 255, 204));
        this.jTextFieldSampleTop.setColumns(35);
        this.jTextFieldSampleTop.setMaximumSize(new Dimension(6, 20));
        this.jTextFieldSampleTop.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldSampleTopFocusGained(evt);
            }
        });
        this.jTextFieldSampleTop.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldSampleTopKeyTyped(evt);
            }
        });
        this.jTextFieldSampleBase.setEditable(false);
        this.jTextFieldSampleBase.setBackground(new Color(255, 255, 204));
        this.jTextFieldSampleBase.setColumns(35);
        this.jTextFieldSampleBase.setMaximumSize(new Dimension(6, 20));
        this.jTextFieldSampleBase.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldSampleBaseFocusGained(evt);
            }
        });
        this.jTextFieldSampleBase.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldSampleBaseKeyTyped(evt);
            }
        });
        this.jButtonSampleBase.setText("...");
        this.jButtonSampleBase.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonSampleBase.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSampleBaseActionPerformed(evt);
            }
        });
        this.jButtonSampleTop.setText("...");
        this.jButtonSampleTop.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonSampleTop.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSampleTopActionPerformed(evt);
            }
        });
        this.jComboBoxBoundaryBase.setModel(new DefaultComboBoxModel<String>(IGDIntervalZone.bnds));
        this.jComboBoxBoundaryBase.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jComboBoxBoundaryBase.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxBoundaryBaseActionPerformed(evt);
            }
        });
        this.jComboBoxBoundaryTop.setModel(new DefaultComboBoxModel<String>(IGDIntervalZone.bnds));
        this.jComboBoxBoundaryTop.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jComboBoxBoundaryTop.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxBoundaryTopActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Boundary:");
        this.jComboBoxAnalystBase.setModel(this.analystBaseModel);
        this.jComboBoxAnalystBase.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jComboBoxAnalystTop.setModel(this.analystTopModel);
        this.jComboBoxAnalystTop.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jButtonAnalystTop.setText("...");
        this.jButtonAnalystTop.setToolTipText("Select top boundary analyst");
        this.jButtonAnalystTop.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonAnalystTop.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAnalystTopActionPerformed(evt);
            }
        });
        this.jButtonAnalystBase.setText("...");
        this.jButtonAnalystBase.setToolTipText("Select base boundary analyst");
        this.jButtonAnalystBase.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonAnalystBase.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAnalystBaseActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Analyst:");
        this.jCheckBoxSyncBnd.setSelected(true);
        this.jCheckBoxSyncBnd.setText("Synchronise boundary changes across schemes");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jTextFieldSampleTop, -2, 1, Short.MAX_VALUE).add((Component)this.jTextFieldSampleBase, -2, 1, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((Component)this.jButtonSampleTop, -2, 31, -2).add((Component)this.jButtonSampleBase, -2, 31, -2)).add(4, 4, 4)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0, -1, Short.MAX_VALUE))).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((Component)this.jComboBoxBoundaryTop, 0, 110, Short.MAX_VALUE).add((Component)this.jComboBoxBoundaryBase, 0, -1, Short.MAX_VALUE)).add((Component)this.jLabel4)).add(14, 14, 14).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((Component)this.jComboBoxAnalystTop, 0, -1, Short.MAX_VALUE).add((Component)this.jComboBoxAnalystBase, 0, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((Component)this.jButtonAnalystTop, -2, 1, Short.MAX_VALUE).add((Component)this.jButtonAnalystBase, -2, 31, -2))).add((Component)this.jLabel5))).add((Component)this.jCheckBoxSyncBnd, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jLabel4).add((Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldSampleTop, -2, -1, -2).add((Component)this.jButtonSampleTop).add((Component)this.jComboBoxBoundaryTop, -2, -1, -2).add((Component)this.jComboBoxAnalystTop, -2, -1, -2).add((Component)this.jButtonAnalystTop)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldSampleBase, -2, -1, -2).add((Component)this.jButtonSampleBase).add((Component)this.jComboBoxBoundaryBase, -2, -1, -2).add((Component)this.jButtonAnalystBase).add((Component)this.jComboBoxAnalystBase, -2, -1, -2)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jCheckBoxSyncBnd).addContainerGap()));
        this.jLabel7.setText("Level:");
        this.jComboBoxColumn.setModel(this.hierModel);
        this.jComboBoxColumn.putClientProperty("JComboBox.isPopDown", Boolean.TRUE);
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogInterval this$0;
            {
                DialogInterval dialogInterval = this$0;
                Objects.requireNonNull(dialogInterval);
                this.this$0 = dialogInterval;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jLabel15.setText("First created by:");
        this.jTextFieldCreator.setEditable(false);
        this.jLabel16.setText("On:");
        this.jTextFieldCreated.setEditable(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel11).add((Component)this.jLabel12)).add((Component)this.jLabel13).add((Component)this.jLabel15)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldLastModified, -2, 224, -2).addPreferredGap(0, 26, Short.MAX_VALUE).add((Component)this.jLabel14).addPreferredGap(0).add((Component)this.jTextFieldDate, -2, 126, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldCreator, -2, 227, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jLabel16).addPreferredGap(0).add((Component)this.jTextFieldCreated, -2, 126, -2)).add((Component)this.jTextFieldLowerUnitName).add((Component)this.jTextFieldLowerUnitFormal)).addPreferredGap(0).add((Component)this.jCheckBoxLowerUnit).addPreferredGap(0).add((Component)this.jButtonLowerUnitName, -2, 29, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonDelete).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel9).add((Component)this.jLabel8).add((Component)this.jLabel10).add((Component)this.jLabel6)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jComboBoxScheme, 0, -1, Short.MAX_VALUE).add(1, (Component)this.jTextFieldUpperUnitName).add(1, (Component)this.jTextFieldUpperUnitFormal).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldSeparator, -2, 75, -2).addPreferredGap(0).add((Component)this.jLabel7).addPreferredGap(0).add((Component)this.jComboBoxColumn, 0, -1, Short.MAX_VALUE))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jCheckBoxUpperUnit).addPreferredGap(0).add((Component)this.jButtonUpperUnitName, -2, 29, -2)).add(2, (Component)this.filler1, -2, -1, -2)))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonDelete, this.jButtonHelp, this.jButtonOK}, 1);
        layout.linkSize(new Component[]{this.jTextFieldCreator, this.jTextFieldLastModified}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.filler1, -2, -1, -2).addPreferredGap(0, 119, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0, 14, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.jComboBoxScheme, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel8).add((Component)this.jCheckBoxUpperUnit).add((Component)this.jButtonUpperUnitName).add((Component)this.jTextFieldUpperUnitName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel9).add((Component)this.jTextFieldUpperUnitFormal, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel10).add((Component)this.jTextFieldSeparator, -2, -1, -2).add((Component)this.jLabel7).add((Component)this.jComboBoxColumn, -2, -1, -2)).add(18, 18, 18))).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel11).add((Component)this.jCheckBoxLowerUnit).add((Component)this.jButtonLowerUnitName).add((Component)this.jTextFieldLowerUnitName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel12).add((Component)this.jTextFieldLowerUnitFormal, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel15).add((Component)this.jTextFieldCreator, -2, -1, -2).add((Component)this.jTextFieldCreated, -2, -1, -2).add((Component)this.jLabel16)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel13).add((Component)this.jTextFieldLastModified, -2, -1, -2).add((Component)this.jTextFieldDate, -2, -1, -2).add((Component)this.jLabel14)).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).add(1, 1, 1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK).add((Component)this.jButtonDelete)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonUpperUnitNameActionPerformed(ActionEvent evt) {
        IGDScheme scheme = (IGDScheme)this.jComboBoxScheme.getSelectedItem();
        if (scheme == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select a scheme", this.getTitle(), 2);
            return;
        }
        try {
            DialogSelectUnit dialog = new DialogSelectUnit((JDialog)((Object)this), true, scheme, this.upperUnit);
            dialog.setLocationRelativeTo(this.jButtonUpperUnitName);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                if (dialog.selection != null) {
                    boolean resetInf = true;
                    String orig = this.jTextFieldUpperUnitName.getText().trim();
                    if (!(orig.isEmpty() || this.upperUnit != null && this.upperUnit.toString().equalsIgnoreCase(orig))) {
                        resetInf = false;
                    }
                    this.upperUnit = dialog.selection;
                    this.jTextFieldUpperUnitFormal.setText(this.upperUnit.toString());
                    if (resetInf) {
                        this.jTextFieldUpperUnitName.setText(this.upperUnit.toString());
                    }
                    this.jComboBoxColumn.setSelectedItem(IGDIntervalZone.getHierName(this.igdType, this.upperUnit.getHier()));
                } else {
                    this.upperUnit = null;
                    this.jTextFieldUpperUnitFormal.setText("");
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonLowerUnitNameActionPerformed(ActionEvent evt) {
        IGDScheme scheme = (IGDScheme)this.jComboBoxScheme.getSelectedItem();
        try {
            DialogSelectUnit dialog = new DialogSelectUnit((JDialog)((Object)this), true, scheme, this.lowerUnit != null ? this.lowerUnit : this.upperUnit);
            dialog.setLocationRelativeTo(this.jButtonLowerUnitName);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                if (dialog.selection == this.upperUnit) {
                    this.lowerUnit = null;
                    this.jTextFieldLowerUnitFormal.setText(null);
                    this.jTextFieldLowerUnitName.setText(null);
                } else {
                    boolean resetInf = true;
                    String orig = this.jTextFieldLowerUnitName.getText().trim();
                    if (!(orig.isEmpty() || this.lowerUnit != null && this.lowerUnit.toString().equalsIgnoreCase(orig))) {
                        resetInf = false;
                    }
                    this.lowerUnit = dialog.selection;
                    this.jTextFieldLowerUnitFormal.setText(this.lowerUnit.toString());
                    if (resetInf) {
                        this.jTextFieldLowerUnitName.setText(this.lowerUnit.toString());
                    }
                    if (this.upperUnit != null && this.lowerUnit.getHier() > this.upperUnit.getHier()) {
                        this.jComboBoxColumn.setSelectedItem(IGDIntervalZone.getHierName(this.igdType, this.lowerUnit.getHier()));
                    }
                }
            } else {
                this.lowerUnit = null;
                this.jTextFieldLowerUnitFormal.setText("");
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonAnalystBaseActionPerformed(ActionEvent evt) {
        try {
            DialogSelectAnalyst dialog = new DialogSelectAnalyst((JDialog)((Object)this), true, this.db, true);
            dialog.setVisible(true);
            if (dialog.selectedUser != null) {
                if (this.analystBaseModel.getIndexOf(dialog.selectedUser.getAbr()) < 0) {
                    int pos;
                    for (pos = 0; pos < this.analystBaseModel.getSize(); ++pos) {
                        String abr = (String)this.analystBaseModel.getElementAt(pos);
                        if (dialog.selectedUser.getAbr().compareTo(abr) < 0) break;
                    }
                    this.analystBaseModel.insertElementAt(dialog.selectedUser.getAbr(), pos);
                    this.jComboBoxAnalystBase.repaint();
                }
                this.jComboBoxAnalystBase.setSelectedItem(dialog.selectedUser.getAbr());
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void jButtonAnalystTopActionPerformed(ActionEvent evt) {
        try {
            DialogSelectAnalyst dialog = new DialogSelectAnalyst((JDialog)((Object)this), true, this.db, true);
            dialog.setLocation(this.jButtonAnalystTop.getLocationOnScreen());
            dialog.setVisible(true);
            if (dialog.selectedUser != null) {
                if (this.analystTopModel.getIndexOf(dialog.selectedUser.getAbr()) < 0) {
                    int pos;
                    for (pos = 0; pos < this.analystTopModel.getSize(); ++pos) {
                        String abr = (String)this.analystTopModel.getElementAt(pos);
                        if (dialog.selectedUser.getAbr().compareTo(abr) < 0) break;
                    }
                    this.analystTopModel.insertElementAt(dialog.selectedUser.getAbr(), pos);
                    this.jComboBoxAnalystTop.repaint();
                    this.jComboBoxAnalystBase.repaint();
                }
                this.jComboBoxAnalystTop.setSelectedItem(dialog.selectedUser.getAbr());
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void jButtonSampleBaseActionPerformed(ActionEvent evt) {
        try {
            DialogSelectSample dialog = new DialogSelectSample((JDialog)((Object)this), true, this.db, this.well, this.baseSample != null ? this.baseSample : this.topSample, this.units, false);
            dialog.setLocation(this.jButtonSampleBase.getLocationOnScreen());
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.baseSample = dialog.selection;
                this.jTextFieldSampleBase.setText(this.baseSample.toString(this.units));
                int bnd = this.wellInterp.getBoundaryAtSample(this.igdType, this.baseSample);
                if (bnd > 0 && this.jComboBoxBoundaryBase.getSelectedIndex() != bnd - 1) {
                    this.jComboBoxBoundaryBase.setSelectedIndex(bnd - 1);
                    EdgedBalloonStyle style = new EdgedBalloonStyle(new Color(204, 255, 204), Color.BLACK);
                    LeftBelowPositioner positioner = new LeftBelowPositioner(this.jComboBoxBoundaryBase.getWidth(), 10);
                    BalloonTip bTip = new BalloonTip((JComponent)this.jComboBoxBoundaryBase, (JComponent)new JLabel("<html>Boundary updated to agree\nwith disconformity"), (BalloonTipStyle)style, (BalloonTipPositioner)positioner, null);
                    TimingUtils.showTimedBalloon((BalloonTip)bTip, (int)5000);
                }
                if (this.topSample == null || this.topSample.getDepth() > this.baseSample.getDepth()) {
                    this.topSample = this.baseSample;
                    this.jTextFieldSampleTop.setText(this.topSample.toString(this.units));
                    if (bnd > 0) {
                        this.jComboBoxBoundaryTop.setSelectedIndex(bnd - 1);
                    }
                }
            }
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void jButtonSampleTopActionPerformed(ActionEvent evt) {
        try {
            DialogSelectSample dialog = new DialogSelectSample((JDialog)((Object)this), true, this.db, this.well, this.topSample != null ? this.topSample : this.baseSample, this.units, false);
            dialog.setLocation(this.jButtonSampleTop.getLocationOnScreen());
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.topSample = dialog.selection;
                this.jTextFieldSampleTop.setText(this.topSample.toString(this.units));
                int bnd = this.wellInterp.getBoundaryAtSample(this.igdType, this.topSample);
                if (bnd > 0 && this.jComboBoxBoundaryTop.getSelectedIndex() != bnd - 1) {
                    this.jComboBoxBoundaryTop.setSelectedIndex(bnd - 1);
                    EdgedBalloonStyle style = new EdgedBalloonStyle(new Color(204, 255, 204), Color.BLACK);
                    LeftAbovePositioner positioner = new LeftAbovePositioner(this.jComboBoxBoundaryTop.getWidth(), 10);
                    BalloonTip bTip = new BalloonTip((JComponent)this.jComboBoxBoundaryTop, (JComponent)new JLabel("<html>Boundary updated to agree\nwith disconformity"), (BalloonTipStyle)style, (BalloonTipPositioner)positioner, null);
                    TimingUtils.showTimedBalloon((BalloonTip)bTip, (int)5000);
                }
                if (this.baseSample == null || this.baseSample.getDepth() < this.topSample.getDepth()) {
                    this.baseSample = this.topSample;
                    this.jTextFieldSampleBase.setText(this.baseSample.toString(this.units));
                    if (bnd > 0) {
                        this.jComboBoxBoundaryBase.setSelectedIndex(bnd - 1);
                    }
                }
            }
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void jTextFieldSampleBaseKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldSampleBase, (int)10, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldSampleTopKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldSampleTop, (int)10, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldLowerUnitFormalKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldLowerUnitFormal, (int)80, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldLowerUnitNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldLowerUnitName, (int)80, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldSeparatorKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldSeparator, (int)10, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldUpperUnitFormalKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldUpperUnitFormal, (int)80, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldUpperUnitNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldUpperUnitName, (int)80, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldLowerUnitFormalFocusGained(FocusEvent evt) {
        this.jTextFieldLowerUnitFormal.setSelectionStart(0);
        this.jTextFieldLowerUnitFormal.setSelectionEnd(this.jTextFieldLowerUnitFormal.getText().length());
    }

    private void jTextFieldLowerUnitNameFocusGained(FocusEvent evt) {
        this.jTextFieldLowerUnitName.setSelectionStart(0);
        this.jTextFieldLowerUnitName.setSelectionEnd(this.jTextFieldLowerUnitName.getText().length());
    }

    private void jTextFieldSeparatorFocusGained(FocusEvent evt) {
        this.jTextFieldSeparator.setSelectionStart(0);
        this.jTextFieldSeparator.setSelectionEnd(this.jTextFieldSeparator.getText().length());
    }

    private void jTextFieldUpperUnitFormalFocusGained(FocusEvent evt) {
        this.jTextFieldUpperUnitFormal.setSelectionStart(0);
        this.jTextFieldUpperUnitFormal.setSelectionEnd(this.jTextFieldUpperUnitFormal.getText().length());
    }

    private void jTextFieldUpperUnitNameFocusGained(FocusEvent evt) {
        this.jTextFieldUpperUnitName.setSelectionStart(0);
        this.jTextFieldUpperUnitName.setSelectionEnd(this.jTextFieldUpperUnitName.getText().length());
    }

    private void jTextFieldSampleBaseFocusGained(FocusEvent evt) {
        this.jTextFieldSampleBase.setSelectionStart(0);
        this.jTextFieldSampleBase.setSelectionEnd(this.jTextFieldSampleBase.getText().length());
    }

    private void jTextFieldSampleTopFocusGained(FocusEvent evt) {
        this.jTextFieldSampleTop.setSelectionStart(0);
        this.jTextFieldSampleTop.setSelectionEnd(this.jTextFieldSampleTop.getText().length());
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            if (this.topSample == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Top sample blank", this.getTitle(), 2);
                return;
            }
            if (this.baseSample == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Base sample blank", this.getTitle(), 2);
                return;
            }
            int topBnd = this.jComboBoxBoundaryTop.getSelectedIndex() + 1;
            int baseBnd = this.jComboBoxBoundaryBase.getSelectedIndex() + 1;
            if (!this.wellInterp.getFaults().isEmpty()) {
                Boundary tBnd = Boundary.getBnd((int)topBnd);
                for (Fault fault : this.wellInterp.getFaults()) {
                    String msg;
                    if (fault.getSample() != this.topSample || fault.getBnd() == tBnd || JOptionPane.showConfirmDialog((Component)((Object)this), msg = "Top boundary type disagrees with disconformity - should be '" + String.valueOf(fault.getBnd()) + "'.\nDo you want to continue?", this.getTitle(), 0) == 0) continue;
                    return;
                }
                Boundary bBnd = Boundary.getBnd((int)baseBnd);
                for (Fault fault : this.wellInterp.getFaults()) {
                    String msg;
                    if (fault.getSample() != this.baseSample || fault.getBnd() == bBnd || JOptionPane.showConfirmDialog((Component)((Object)this), msg = "Base boundary type disagrees with disconformity - should be '" + String.valueOf(fault.getBnd()) + "'.\nDo you want to continue?", this.getTitle(), 0) == 0) continue;
                    return;
                }
            }
            String topAnaly = (String)this.jComboBoxAnalystTop.getSelectedItem();
            String baseAnaly = (String)this.jComboBoxAnalystBase.getSelectedItem();
            int n = this.jComboBoxColumn.getSelectedIndex() + 1;
            String uppInf = this.jTextFieldUpperUnitName.getText();
            if (uppInf.length() == 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "A unit name is required.", this.getTitle(), 2);
                return;
            }
            String lowInf = this.jTextFieldLowerUnitName.getText();
            IGDScheme scheme = (IGDScheme)this.jComboBoxScheme.getSelectedItem();
            if (scheme == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Select a scheme", this.getTitle(), 2);
                return;
            }
            if (this.upperUnit != null) {
                if (scheme.findUnitBase(this.upperUnit.getUnitID()) == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Upper unit not in selected scheme", this.getTitle(), 2);
                    return;
                }
            } else {
                this.upperUnit = scheme.findUnitBase(uppInf);
            }
            if (this.lowerUnit != null) {
                if (scheme.findUnitBase(this.lowerUnit.getUnitID()) == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Lower unit not in selected scheme", this.getTitle(), 2);
                    return;
                }
            } else if (lowInf.length() > 0) {
                this.lowerUnit = scheme.findUnitBase(lowInf);
            }
            String sep = this.jTextFieldSeparator.getText();
            boolean qu = this.jCheckBoxUpperUnit.isSelected();
            boolean ql = this.jCheckBoxLowerUnit.isSelected();
            IGDIntervalZone.Builder builder = new IGDIntervalZone.Builder(this.db, this.igdType, this.topSample, this.baseSample, n, scheme.getID());
            builder.topAnalyst(this.db.getUserID(topAnaly)).baseAnalyst(this.db.getUserID(baseAnaly)).topBnd(topBnd).baseBnd(baseBnd);
            builder.zones(this.upperUnit, this.lowerUnit).uppInf(uppInf).lowInf(lowInf).qUzone(qu).qLzone(ql).sep(sep);
            this.zone = this.zone == null ? this.wellInterp.addZone(builder, this.well) : this.wellInterp.updateZone(this.zone, builder, this.well, this.db.isConnected() && this.jCheckBoxSyncBnd.isSelected());
            if (this.db.isConnected()) {
                this.db.commit();
            }
            this.wellInterp.notifyObservers(this.zone);
            if (this.db.isConnected()) {
                Lastval.putInt(this.db, "SCH_ID:" + this.igdType, scheme.getID());
                Lastval.putInt(this.db, "SYNCBND", this.jCheckBoxSyncBnd.isSelected() ? 1 : 0);
                this.db.commit();
            }
            this.setOK();
        }
        catch (InvalidFieldException ex) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Error saving interval: " + ex.getMessage(), this.getTitle(), 2);
        }
        catch (SBException ex) {
            StackError.showStackError((String)"Error saving interval", (Throwable)ex);
        }
        catch (SQLException ex) {
            this.db.doRollback();
            FrameJsbugs.showStackError("Error saving interval", ex, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialoginterval.html");
    }

    private void jComboBoxBoundaryTopActionPerformed(ActionEvent evt) {
    }

    private void jComboBoxBoundaryBaseActionPerformed(ActionEvent evt) {
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.zone == null) {
            return;
        }
        int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Really delete this interval?", this.getTitle(), 0);
        if (opt != 0) {
            return;
        }
        LinkedList<IGDIntervalZone> list = new LinkedList<IGDIntervalZone>();
        list.add(this.zone);
        try {
            this.wellInterp.deleteZones(this.well, list);
            this.db.commit();
            this.wellInterp.notifyObservers(this.zone);
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        this.dispose();
    }
}

