/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.HelpUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jsbugs.uiutil.audit.JPanelAuditColumn;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.Intcom;
import model3.SBdb;
import model3.Well;
import model3.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class DialogIntervalComment
extends JDialog {
    private final SBdb db;
    private final Well well;
    private final WellInterp wellInterp;
    private final char units;
    private Intcom intcom;
    private final int igdType;
    private static final int LENDEPTH = 8;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelDepthUnitsBase;
    private JLabel jLabelDepthUnitsTop;
    private JPanelAuditColumn jPanelAudit;
    private JScrollPane jScrollPaneComment;
    private JTextArea jTextAreaComment;
    private JTextField jTextFieldBase;
    private JTextField jTextFieldTop;

    public DialogIntervalComment(Frame parent, boolean modal, SBdb db, Well well, WellInterp wellInterp, Intcom intcom, char units, int igdType) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.intcom = intcom;
        this.well = well;
        this.wellInterp = wellInterp;
        this.units = units;
        this.igdType = igdType;
        if (intcom != null && intcom.getIGDType() != igdType) {
            throw new IllegalArgumentException("Intcom IGD type mismatch");
        }
        this.initComponents();
        this.init();
    }

    public DialogIntervalComment(JDialog parent, boolean modal, SBdb db, Well well, WellInterp wellInterp, Intcom intcom, char units, int igdType) throws SQLException {
        super((Dialog)parent, modal);
        this.db = db;
        this.intcom = intcom;
        this.well = well;
        this.wellInterp = wellInterp;
        this.units = units;
        this.igdType = igdType;
        if (intcom != null && intcom.getIGDType() != igdType) {
            throw new IllegalArgumentException("Intcom IGD type mismatch");
        }
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        if (this.intcom != null) {
            this.jTextFieldTop.setText(SB.floatString((double)DepthUtils.convFromM((double)this.intcom.getTopDepth(), (char)this.units, (char)this.well.getType()), (int)2));
            this.jTextFieldBase.setText(SB.floatString((double)DepthUtils.convFromM((double)this.intcom.getBaseDepth(), (char)this.units, (char)this.well.getType()), (int)2));
            this.jTextAreaComment.setText(this.intcom.getComments());
            this.jPanelAudit.setAuditText(this.intcom.getCreator(), this.intcom.getCreated(), this.intcom.getModifier(), this.intcom.getModified());
            this.setTitle("Interval Comment : Edit");
        } else {
            this.setTitle("Interval Comment : Add");
            this.jPanelAudit.setVisible(false);
        }
        if (this.units == 'F') {
            this.jLabelDepthUnitsTop.setText("ft");
            this.jLabelDepthUnitsBase.setText("ft");
        }
        if (!this.well.canWrite(this.db, null)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(this.well.getDeniedReason(this.db, "well", false));
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        } else {
            this.getRootPane().setDefaultButton(this.jButtonOK);
        }
        this.pack();
    }

    private void initComponents() {
        this.jScrollPaneComment = new JScrollPane();
        this.jTextAreaComment = new JTextArea();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldTop = new JTextField();
        this.jTextFieldBase = new JTextField();
        this.jLabelDepthUnitsTop = new JLabel();
        this.jLabelDepthUnitsBase = new JLabel();
        this.jButtonHelp = new JButton();
        this.jPanelAudit = new JPanelAuditColumn();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 300));
        this.jTextAreaComment.setColumns(20);
        this.jTextAreaComment.setFont(this.jTextAreaComment.getFont());
        this.jTextAreaComment.setLineWrap(true);
        this.jTextAreaComment.setRows(5);
        this.jTextAreaComment.setWrapStyleWord(true);
        this.jScrollPaneComment.setViewportView(this.jTextAreaComment);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIntervalComment this$0;
            {
                DialogIntervalComment dialogIntervalComment = this$0;
                Objects.requireNonNull(dialogIntervalComment);
                this.this$0 = dialogIntervalComment;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIntervalComment this$0;
            {
                DialogIntervalComment dialogIntervalComment = this$0;
                Objects.requireNonNull(dialogIntervalComment);
                this.this$0 = dialogIntervalComment;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Top:");
        this.jLabel2.setText("Base:");
        this.jTextFieldTop.setToolTipText("Enter a depth for the top of this interval");
        this.jTextFieldTop.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogIntervalComment this$0;
            {
                DialogIntervalComment dialogIntervalComment = this$0;
                Objects.requireNonNull(dialogIntervalComment);
                this.this$0 = dialogIntervalComment;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldTopKeyTyped(evt);
            }
        });
        this.jTextFieldBase.setToolTipText("Enter a depth for the base of this interval");
        this.jTextFieldBase.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogIntervalComment this$0;
            {
                DialogIntervalComment dialogIntervalComment = this$0;
                Objects.requireNonNull(dialogIntervalComment);
                this.this$0 = dialogIntervalComment;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldBaseKeyTyped(evt);
            }
        });
        this.jLabelDepthUnitsTop.setText("m");
        this.jLabelDepthUnitsBase.setText("m");
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogIntervalComment this$0;
            {
                DialogIntervalComment dialogIntervalComment = this$0;
                Objects.requireNonNull(dialogIntervalComment);
                this.this$0 = dialogIntervalComment;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jPanelAudit.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(11, 11, 11).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jTextFieldBase).add((Component)this.jTextFieldTop, -1, 118, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelDepthUnitsTop).add((Component)this.jLabelDepthUnitsBase))).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPaneComment)).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanelAudit, -2, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldTop, -2, -1, -2).add((Component)this.jLabel1).add((Component)this.jLabelDepthUnitsTop)).add(3, 3, 3).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldBase, -2, -1, -2).add((Component)this.jLabel2).add((Component)this.jLabelDepthUnitsBase)).addPreferredGap(1).add((Component)this.jScrollPaneComment, -2, 157, -2).addPreferredGap(0).add((Component)this.jPanelAudit, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((Component)this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldTop.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter a top depth", this.getTitle(), 2);
            return;
        }
        if (this.jTextFieldBase.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter a base depth", this.getTitle(), 2);
            return;
        }
        double topDepth = DepthUtils.convToM((double)Double.parseDouble(this.jTextFieldTop.getText()), (char)this.units, (char)this.well.getType());
        double baseDepth = DepthUtils.convToM((double)Double.parseDouble(this.jTextFieldBase.getText()), (char)this.units, (char)this.well.getType());
        String comment = this.jTextAreaComment.getText();
        if (comment.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Enter a comment", this.getTitle(), 2);
            return;
        }
        if (topDepth > baseDepth) {
            JOptionPane.showMessageDialog(this, "Top depth must be above base depth", this.getTitle(), 2);
            return;
        }
        try {
            this.intcom = this.intcom == null ? this.wellInterp.addIntcom(this.well, new Intcom.Builder(this.db, this.igdType, topDepth).baseDepth(baseDepth).comments(comment)) : this.wellInterp.updateIntcom(this.intcom, this.well.getWellID(), topDepth, baseDepth, comment);
            this.db.commit();
            this.wellInterp.notifyObservers(this.intcom);
            this.dispose();
        }
        catch (RuntimeException | SQLException | InvalidFieldException | SBException ex) {
            SbugsExceptionHandler.showStackError("Error saving interval comment", ex, this);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jTextFieldTopKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldTop, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldBaseKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldBase, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"dialogintervalcomments.html");
    }
}

