/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.well.sample.SampleType;
import com.stratadata.model3.wellinterp.LOCNode;
import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jsbugs.DialogSelectIGDType;
import jsbugs.DialogSelectScheme;
import jsbugs.FrameJsbugs;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.IGDUnitBase;
import model3.LOC;
import model3.LithostratUnit;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import model3.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class DialogLOCIntervals
extends SBDialog {
    private final WellInterp wellInterp;
    IGDScheme scheme;
    private final Well well;
    private final SBdb db;
    private JCheckBox[] checkBoxes;
    private static final Logger LOGGER = Logger.getLogger(DialogLOCIntervals.class.getName());
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonSelectScheme;
    private JCheckBox jCheckBox0;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBox2;
    private JCheckBox jCheckBox3;
    private JCheckBox jCheckBox4;
    private JCheckBox jCheckBox5;
    private JCheckBox jCheckBox6;
    private JCheckBox jCheckBox7;
    private JCheckBox jCheckBoxDiscOnly;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonCreate;
    private JRadioButton jRadioButtonSnap;
    private JSeparator jSeparator1;
    private JTextField jTextFieldScheme;
    private JTextField jTextFieldVersion;

    public DialogLOCIntervals(Frame parent, boolean modal, Well well, int interpID, IGDScheme scheme) throws SBException, SQLException {
        super(parent, modal);
        this.well = well;
        this.db = well.getDataModel();
        this.wellInterp = well.getInterp(interpID);
        this.scheme = scheme;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Intervals : Create");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jTextFieldVersion.setText(this.wellInterp.toString());
        this.checkBoxes = new JCheckBox[8];
        this.checkBoxes[0] = this.jCheckBox0;
        this.checkBoxes[1] = this.jCheckBox1;
        this.checkBoxes[2] = this.jCheckBox2;
        this.checkBoxes[3] = this.jCheckBox3;
        this.checkBoxes[4] = this.jCheckBox4;
        this.checkBoxes[5] = this.jCheckBox5;
        this.checkBoxes[6] = this.jCheckBox6;
        this.checkBoxes[7] = this.jCheckBox7;
        this.setScheme();
    }

    private void setScheme() throws SQLException, SBException {
        if (this.scheme != null) {
            this.jTextFieldScheme.setText(this.scheme.toString());
            this.setSchemeLevels(this.scheme);
            if (this.scheme.isBiozone()) {
                if (!this.well.getAnalysts(this.scheme.getDiscipline()).isEmpty()) {
                    this.jCheckBoxDiscOnly.setSelected(true);
                }
            } else {
                this.jCheckBoxDiscOnly.setSelected(false);
                this.jCheckBoxDiscOnly.setEnabled(false);
            }
        } else {
            this.setSchemeLevels(null);
        }
    }

    private void setSchemeLevels(IGDScheme scheme) {
        if (scheme == null) {
            for (JCheckBox b : this.checkBoxes) {
                this.unsetCheck(b);
            }
        } else {
            this.setCheck(this.jCheckBox0, IGDIntervalZone.getHierName(scheme.getIGDType(), 1));
            for (int hier = 1; hier < 8; ++hier) {
                if (IGDIntervalZone.getNHier(scheme.getIGDType(), true) > hier) {
                    this.setCheck(this.checkBoxes[hier], IGDIntervalZone.getHierName(scheme.getIGDType(), hier + 1));
                    continue;
                }
                this.unsetCheck(this.checkBoxes[hier]);
            }
        }
    }

    private void unsetCheck(JCheckBox checkBox) {
        checkBox.setText(null);
        checkBox.setEnabled(false);
        checkBox.setSelected(false);
    }

    private void setCheck(JCheckBox checkBox, String label) {
        checkBox.setText(label);
        checkBox.setEnabled(true);
        checkBox.setSelected(true);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldVersion = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldScheme = new JTextField();
        this.jButtonSelectScheme = new JButton();
        this.jLabel3 = new JLabel();
        this.jCheckBox0 = new JCheckBox();
        this.jCheckBox1 = new JCheckBox();
        this.jCheckBox2 = new JCheckBox();
        this.jCheckBox3 = new JCheckBox();
        this.jCheckBox4 = new JCheckBox();
        this.jCheckBox5 = new JCheckBox();
        this.jCheckBox6 = new JCheckBox();
        this.jCheckBox7 = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jRadioButtonSnap = new JRadioButton();
        this.jRadioButtonCreate = new JRadioButton();
        this.jCheckBoxDiscOnly = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLOCIntervals this$0;
            {
                DialogLOCIntervals dialogLOCIntervals = this$0;
                Objects.requireNonNull(dialogLOCIntervals);
                this.this$0 = dialogLOCIntervals;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLOCIntervals this$0;
            {
                DialogLOCIntervals dialogLOCIntervals = this$0;
                Objects.requireNonNull(dialogLOCIntervals);
                this.this$0 = dialogLOCIntervals;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Version:");
        this.jTextFieldVersion.setEditable(false);
        this.jLabel2.setText("Scheme:");
        this.jTextFieldScheme.setEditable(false);
        this.jTextFieldScheme.setBackground(new Color(255, 255, 204));
        this.jButtonSelectScheme.setText("...");
        this.jButtonSelectScheme.setToolTipText("Select a scheme");
        this.jButtonSelectScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLOCIntervals this$0;
            {
                DialogLOCIntervals dialogLOCIntervals = this$0;
                Objects.requireNonNull(dialogLOCIntervals);
                this.this$0 = dialogLOCIntervals;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectSchemeActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Levels:");
        this.jCheckBox0.setText("jCheckBox0");
        this.jCheckBox1.setText("jCheckBox1");
        this.jCheckBox2.setText("jCheckBox2");
        this.jCheckBox3.setText("jCheckBox3");
        this.jCheckBox4.setText("jCheckBox4");
        this.jCheckBox5.setText("jCheckBox5");
        this.jCheckBox6.setText("jCheckBox6");
        this.jCheckBox7.setText("jCheckBox7");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Sample options", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroup1.add(this.jRadioButtonSnap);
        this.jRadioButtonSnap.setText("<html>Snap boundaries to nearest samples (<strong>note</strong>: always creates sample at unconformities)</html>");
        this.jRadioButtonSnap.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLOCIntervals this$0;
            {
                DialogLOCIntervals dialogLOCIntervals = this$0;
                Objects.requireNonNull(dialogLOCIntervals);
                this.this$0 = dialogLOCIntervals;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonSnapActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonCreate);
        this.jRadioButtonCreate.setText("Always create LOG (pick) samples at interpolated depths");
        this.jRadioButtonCreate.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLOCIntervals this$0;
            {
                DialogLOCIntervals dialogLOCIntervals = this$0;
                Objects.requireNonNull(dialogLOCIntervals);
                this.this$0 = dialogLOCIntervals;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonCreateActionPerformed(evt);
            }
        });
        this.jCheckBoxDiscOnly.setText("Restrict to samples analysed in biozone discipline");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonSnap, -2, -1, -2).add((Component)this.jRadioButtonCreate)).addContainerGap(-1, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(64, 64, 64).add((Component)this.jCheckBoxDiscOnly, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.jRadioButtonCreate, this.jRadioButtonSnap}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonSnap, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jCheckBoxDiscOnly).addPreferredGap(0).add((Component)this.jRadioButtonCreate).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).add(4, 4, 4)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(1))).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jCheckBox0).addPreferredGap(0).add((Component)this.jCheckBox1).addPreferredGap(0).add((Component)this.jCheckBox2).addPreferredGap(1).add((Component)this.jCheckBox3)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jCheckBox4).addPreferredGap(0).add((Component)this.jCheckBox5).addPreferredGap(1).add((Component)this.jCheckBox6).addPreferredGap(0).add((Component)this.jCheckBox7)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldScheme).addPreferredGap(0).add((Component)this.jButtonSelectScheme, -2, 30, -2)).add((Component)this.jTextFieldVersion))).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldVersion, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldScheme, -2, -1, -2).add((Component)this.jButtonSelectScheme)).add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jCheckBox0).add((Component)this.jCheckBox1).add((Component)this.jCheckBox2).add((Component)this.jCheckBox3).add((Component)this.jLabel3)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jCheckBox4).add((Component)this.jCheckBox5).add((Component)this.jCheckBox6).add((Component)this.jCheckBox7)).add(13, 13, 13).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.jSeparator1, -2, 10, -2).add(4, 4, 4).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).add(26, 26, 26)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonSelectSchemeActionPerformed(ActionEvent evt) {
        DialogSelectIGDType dialog = new DialogSelectIGDType((JDialog)((Object)this), true, false, false, false, false);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.isOK()) {
            if (dialog.igdType == 20) {
                JOptionPane.showMessageDialog((Component)((Object)this), "You can't select a composite Standard here", this.getTitle(), 2);
                return;
            }
            if (dialog.igdType == 10) {
                JOptionPane.showMessageDialog((Component)((Object)this), "You can't select a sequence scheme here - this generates intervals, not picks.", this.getTitle(), 2);
                return;
            }
            try {
                DialogSelectScheme dialogScheme = new DialogSelectScheme((JDialog)((Object)this), true, this.db, dialog.igdType, null);
                dialogScheme.setLocationRelativeTo((Component)((Object)this));
                dialogScheme.setVisible(true);
                if (dialogScheme.selection != null && dialogScheme.selection != this.scheme) {
                    this.scheme = dialogScheme.selection;
                    this.scheme.loadUnits();
                    this.setScheme();
                }
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
            catch (SBException sbe) {
                StackError.showStackError((String)"Error", (Throwable)sbe);
            }
            catch (RuntimeException re) {
                StackError.showStackError((String)"", (Throwable)re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        int opt;
        try {
            if (!this.well.canWrite(this.db, null)) {
                JOptionPane.showMessageDialog((Component)((Object)this), this.well.getDeniedReason(this.db, "create intervals", "well", false), this.getTitle(), 2);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        if (this.buttonGroup1.getSelection() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select sample boundary option", this.getTitle(), 1);
            return;
        }
        if (this.scheme == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No scheme selected", this.getTitle(), 1);
            return;
        }
        int igdType = this.scheme.getIGDType();
        LOC loc = this.wellInterp.getLOC();
        if (loc == null || loc.getSize() < 2) {
            JOptionPane.showMessageDialog((Component)((Object)this), "There is no depth/age curve defined.", this.getTitle(), 1);
            return;
        }
        LinkedList<IGDIntervalZone> zones = igdType == 4 ? new LinkedList<IGDIntervalZone>(this.wellInterp.getIGDList(igdType, this.scheme.getID())) : new LinkedList<IGDIntervalZone>(this.wellInterp.getIGDList(igdType));
        if (!zones.isEmpty() && (opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Do you want to clear all existing intervals?", this.getTitle(), 0, 3)) == 0) {
            try {
                this.wellInterp.deleteZones(this.well, zones);
            }
            catch (SQLException | SBException sql) {
                this.db.doRollback();
                FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
                return;
            }
        }
        class AgeDepth {
            double age;
            double depth;
            int bnd;

            AgeDepth(DialogLOCIntervals this$0, double age) {
                Objects.requireNonNull(this$0);
                this.bnd = -1;
                this.age = age;
            }
        }
        HashMap<Long, AgeDepth> ageDepths = new HashMap<Long, AgeDepth>();
        try {
            if (this.scheme.getIGDType() == 2) {
                this.scheme.loadUnits();
                for (LithostratUnit lithostratUnit : this.scheme.getLithostratUnits()) {
                    if (!lithostratUnit.hasAges()) continue;
                    age = (long)(lithostratUnit.getUage() * 1.0E7);
                    System.out.println("unit: " + String.valueOf(lithostratUnit) + " age: " + age);
                    if (ageDepths.get(age) == null) {
                        ageDepths.put(age, new AgeDepth(this, lithostratUnit.getUage()));
                    }
                    if (ageDepths.get(age = (long)((int)(lithostratUnit.getLage() * 1.0E7))) != null) continue;
                    ageDepths.put(age, new AgeDepth(this, lithostratUnit.getLage()));
                }
            } else {
                for (IGDUnit iGDUnit : this.scheme.getUnits()) {
                    if (!iGDUnit.hasAges()) continue;
                    age = (long)(iGDUnit.getUage() * 1.0E7);
                    System.out.println("unit: " + String.valueOf(iGDUnit) + " age: " + age);
                    if (ageDepths.get(age) == null) {
                        ageDepths.put(age, new AgeDepth(this, iGDUnit.getUage()));
                    }
                    if (ageDepths.get(age = (long)((int)(iGDUnit.getLage() * 1.0E7))) != null) continue;
                    ageDepths.put(age, new AgeDepth(this, iGDUnit.getLage()));
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
            return;
        }
        Iterator itAD = ageDepths.values().iterator();
        while (itAD.hasNext()) {
            AgeDepth ageDepth = (AgeDepth)itAD.next();
            Double depth = loc.getDepthOfAge(ageDepth.age, null, null, true);
            if (depth == null) {
                itAD.remove();
                continue;
            }
            ageDepth.depth = depth;
        }
        LOCNode lOCNode = loc.getNode(0);
        AgeDepth ageDepth = new AgeDepth(this, lOCNode.getAge());
        ageDepth.depth = lOCNode.getDepth();
        ageDepth.bnd = lOCNode.getBnd();
        double youngest = ageDepth.age;
        ageDepths.put((long)(youngest * 1.0E7), ageDepth);
        LOCNode lOCNode2 = loc.getNode(loc.getSize() - 1);
        ageDepth = new AgeDepth(this, lOCNode2.getAge());
        ageDepth.depth = lOCNode2.getDepth();
        ageDepth.bnd = lOCNode2.getBnd();
        double oldest = ageDepth.age;
        ageDepths.put((long)(oldest * 1.0E7), ageDepth);
        for (AgeDepth a : ageDepths.values()) {
            a.bnd = loc.getBoundary(a.depth);
        }
        for (AgeDepth ageDepthX : ageDepths.values()) {
            System.out.println("ageDepth : " + ageDepthX.age + ",\t" + ageDepthX.depth + "\tBnd=" + ageDepthX.bnd);
        }
        LinkedList<IGDIntervalZone.Builder> toAdd = new LinkedList<IGDIntervalZone.Builder>();
        LinkedList<Sample> samplesAddedToWell = new LinkedList<Sample>();
        try {
            Sample lastSampleAdded = null;
            Iterator<LithostratUnit> luIt = this.scheme.getLithostratUnits().iterator();
            Iterator<IGDUnit> uIt = this.scheme.getUnits().iterator();
            while (true) {
                Sample baseSample;
                Sample topSample;
                IGDUnitBase unit;
                if (this.scheme.getIGDType() == 2) {
                    if (!luIt.hasNext()) break;
                    LithostratUnit lunit = luIt.next();
                    unit = lunit;
                } else {
                    if (!uIt.hasNext()) break;
                    IGDUnit iunit = uIt.next();
                    unit = iunit;
                }
                if (!this.checkBoxes[unit.getHier() - 1].isSelected() || !unit.hasAges()) continue;
                long topAge = (long)(unit.getUage() * 1.0E7);
                ageDepth = unit.getUage() < youngest ? (AgeDepth)ageDepths.get((long)(youngest * 1.0E7)) : (AgeDepth)ageDepths.get(topAge);
                if (ageDepth == null) continue;
                double topDepth = ageDepth.depth;
                int topBnd = ageDepth.bnd;
                long baseAge = (long)(unit.getLage() * 1.0E7);
                ageDepth = unit.getLage() > oldest ? (AgeDepth)ageDepths.get((long)(oldest * 1.0E7)) : (AgeDepth)ageDepths.get(baseAge);
                if (ageDepth == null) continue;
                double baseDepth = ageDepth.depth;
                int baseBnd = ageDepth.bnd;
                if (this.jRadioButtonSnap.isSelected()) {
                    double depthBase;
                    double ageBase;
                    double depthTop;
                    double ageTop;
                    Object bd;
                    Double td;
                    if (topBnd == 4 || topBnd == 5) {
                        topSample = this.well.getSample(topDepth, null, true);
                        if (topSample == null) {
                            td = this.db.useSampleTops() ? Double.valueOf(topDepth) : null;
                            bd = this.db.useSampleTops() ? null : Double.valueOf(topDepth);
                            lastSampleAdded = topSample = this.well.addSample(td, (Double)bd, "LOG", "from loc (top)");
                            samplesAddedToWell.add(topSample);
                        }
                    } else {
                        int b;
                        topSample = this.well.getSampleNearestBelow(topDepth, false, false, this.scheme.isBiozone() ? this.scheme.getDiscipline() : null);
                        if (topSample != null && (b = loc.getBoundary(topSample.getDepth())) > 0) {
                            topBnd = b;
                        }
                    }
                    if (baseBnd == 4 || baseBnd == 5) {
                        baseSample = this.well.getSample(baseDepth, null, true);
                        System.out.println("Got base sample: " + String.valueOf(baseSample));
                        if (baseSample == null) {
                            td = this.db.useSampleTops() ? Double.valueOf(baseDepth) : null;
                            bd = this.db.useSampleTops() ? null : Double.valueOf(baseDepth);
                            lastSampleAdded = baseSample = this.well.addSample(td, (Double)bd, "LOG", "from loc(base)");
                            samplesAddedToWell.add(baseSample);
                        }
                    } else {
                        int b;
                        baseSample = this.well.getSampleNearestAbove(baseDepth, false, false, this.scheme.isBiozone() ? this.scheme.getDiscipline() : null);
                        if (baseSample != null) {
                            baseSample = this.well.getSample(baseSample.getDepth(), null, true);
                        }
                        if (baseSample != null && (b = loc.getBoundary(baseSample.getDepth())) > 0) {
                            baseBnd = b;
                        }
                    }
                    if (topSample == null || baseSample == null || (ageTop = loc.getAge(depthTop = topSample.getDepth(), false)) > unit.getLage() || (ageBase = loc.getAge(depthBase = baseSample.getDepth(), false)) < unit.getUage() || (topBnd == 4 || topBnd == 5) && (baseBnd == 4 || baseBnd == 5) && topSample == baseSample) {
                        continue;
                    }
                } else {
                    topSample = this.well.getSample(topDepth, null, true);
                    if (topSample == null) {
                        lastSampleAdded = topSample = this.well.addSample(topDepth, SampleType.LOG, "from depth/age (top)");
                        samplesAddedToWell.add(topSample);
                    }
                    if ((baseSample = this.well.getSample(baseDepth, null, true)) == null) {
                        lastSampleAdded = baseSample = this.well.addSample(baseDepth, SampleType.LOG, "from depth/age (base)");
                        samplesAddedToWell.add(baseSample);
                    }
                }
                System.out.println("Creating temporary zone: " + topSample.getDepth() + "," + baseSample.getDepth() + ",Hier=" + unit.getHier() + ",Unit=" + unit.getName() + ", bnd=" + topBnd + "/" + baseBnd);
                IGDIntervalZone.Builder builder = new IGDIntervalZone.Builder(this.db, igdType, topSample, baseSample, unit.getHier(), this.scheme.getID());
                builder.topBnd(topBnd).baseBnd(baseBnd).uppZone(unit.getUnitID()).uppInf(unit.getName());
                boolean addZone = true;
                for (IGDIntervalZone.Builder z : toAdd) {
                    if (builder.getHier() != z.getHier()) continue;
                    if (builder.getTopSample() == z.getTopSample()) {
                        toAdd.remove(z);
                        break;
                    }
                    if (builder.getBaseSample() != z.getBaseSample()) continue;
                    addZone = false;
                    break;
                }
                if (!addZone) continue;
                try {
                    this.wellInterp.checkOverlap(builder, null, false);
                }
                catch (InvalidFieldException e) {
                    System.out.println("Did not add zone: " + e.getMessage());
                }
                toAdd.add(builder);
            }
            if (!samplesAddedToWell.isEmpty()) {
                this.well.getDataModel().commit();
            }
        }
        catch (SBPermissionException pe) {
            JOptionPane.showMessageDialog((Component)((Object)this), pe.getMessage(), this.getTitle(), 2);
            return;
        }
        catch (SQLException | SBException sql) {
            if (!samplesAddedToWell.isEmpty()) {
                try {
                    this.well.deleteSamples(samplesAddedToWell);
                    this.well.getDataModel().commit();
                }
                catch (SQLException | SBPermissionException innerE) {
                    FrameJsbugs.showStackError("Error deleting samples", (Exception)innerE, this.db);
                    System.out.println("Earlier error:");
                    sql.printStackTrace();
                    return;
                }
            }
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
            return;
        }
        int nAdded = 0;
        try {
            IGDIntervalZone zone = null;
            for (IGDIntervalZone.Builder z : toAdd) {
                try {
                    zone = this.wellInterp.addZone(z, this.well);
                    this.well.getDataModel().commit();
                    ++nAdded;
                }
                catch (InvalidFieldException e) {
                    LOGGER.log(Level.WARNING, "Can't insert generated interval: " + String.valueOf(z) + ", message: " + e.toString(), this.well);
                }
            }
            if (zone != null) {
                this.wellInterp.notifyObservers(zone);
            }
            if (!samplesAddedToWell.isEmpty()) {
                this.well.notifyObservers(samplesAddedToWell.get(0));
            }
            this.setOK();
        }
        catch (SQLException | SBException e) {
            FrameJsbugs.showStackError("Error", (Exception)e, this.db);
        }
        finally {
            if (nAdded > 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Number of intervals added: " + nAdded, this.getTitle(), 1);
            }
        }
    }

    private void jRadioButtonCreateActionPerformed(ActionEvent evt) {
        this.jCheckBoxDiscOnly.setEnabled(this.jRadioButtonSnap.isSelected());
    }

    private void jRadioButtonSnapActionPerformed(ActionEvent evt) {
        this.jCheckBoxDiscOnly.setEnabled(this.jRadioButtonSnap.isSelected());
    }
}

