/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsbugs.FrameJsbugs;
import jsbugs.LithologyJPanel;
import model3.Lithdesc;
import model3.Lithology;
import model3.SBdb;
import util.SBException;

public class DialogLithPalette
extends JDialog
implements Observer {
    private final SBdb sbdb;
    List<LithologyJPanel> panels = new LinkedList<LithologyJPanel>();
    static final Dimension DEFAULT_PREF_SIZE = new Dimension(200, 800);
    private JButton jButtonHelp;
    private JTabbedPane jTabbedPaneLithotypes;
    private JTextField jTextFieldDescription;

    public DialogLithPalette(Frame parent, boolean modal, SBdb sbdb) throws SQLException, SBException {
        super(parent, modal);
        this.sbdb = sbdb;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Lithology Palette");
        this.setFocusableWindowState(false);
        Lithdesc lithdesc = this.sbdb.getLithdesc();
        for (Lithdesc.LithType lithType : Lithdesc.LithType.values()) {
            LithologyJPanel lithologyJPanel = new LithologyJPanel(lithdesc.getList(lithType));
            this.panels.add(lithologyJPanel);
            lithologyJPanel.selected.addObserver(this);
            lithologyJPanel.setPreferredSize(DEFAULT_PREF_SIZE);
            JScrollPane scroller = new JScrollPane(lithologyJPanel);
            scroller.setHorizontalScrollBarPolicy(31);
            scroller.getVerticalScrollBar().setUnitIncrement(10);
            this.jTabbedPaneLithotypes.addTab(lithType.getNoun(), scroller);
        }
    }

    private void initComponents() {
        this.jTabbedPaneLithotypes = new JTabbedPane();
        this.jTextFieldDescription = new JTextField();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(new Dimension(350, 300));
        this.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ DialogLithPalette this$0;
            {
                DialogLithPalette dialogLithPalette = this$0;
                Objects.requireNonNull(dialogLithPalette);
                this.this$0 = dialogLithPalette;
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                this.this$0.componentResized(evt);
            }
        });
        this.jTabbedPaneLithotypes.addChangeListener(new ChangeListener(this){
            final /* synthetic */ DialogLithPalette this$0;
            {
                DialogLithPalette dialogLithPalette = this$0;
                Objects.requireNonNull(dialogLithPalette);
                this.this$0 = dialogLithPalette;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.jTabbedPaneLithotypesStateChanged(evt);
            }
        });
        this.jTextFieldDescription.setEditable(false);
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogLithPalette this$0;
            {
                DialogLithPalette dialogLithPalette = this$0;
                Objects.requireNonNull(dialogLithPalette);
                this.this$0 = dialogLithPalette;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPaneLithotypes, -1, 334, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jTextFieldDescription).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPaneLithotypes, -1, 256, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldDescription, -2, -1, -2).addComponent(this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void componentResized(ComponentEvent evt) {
        for (LithologyJPanel panel : this.panels) {
            panel.setPreferredSize(panel.getSize());
            panel.revalidate();
        }
    }

    private void jTabbedPaneLithotypesStateChanged(ChangeEvent evt) {
        LithologyJPanel selectedPanel = this.getSelectedPanel();
        if (selectedPanel != null) {
            this.updateDesc(selectedPanel.selected);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("lithologyeditor.html");
    }

    private void updateDesc(LithologyJPanel.SelectedLithology selected) {
        String descr = selected.getLithology() != null ? selected.getLithology().getDescr() : "";
        this.jTextFieldDescription.setText(descr);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof LithologyJPanel.SelectedLithology) {
            this.updateDesc((LithologyJPanel.SelectedLithology)o);
        }
    }

    private LithologyJPanel getSelectedPanel() {
        JScrollPane scroll = (JScrollPane)this.jTabbedPaneLithotypes.getSelectedComponent();
        if (scroll != null) {
            return (LithologyJPanel)scroll.getViewport().getComponent(0);
        }
        return null;
    }

    Lithology getSelectedLithology() {
        return this.getSelectedPanel().selected.getLithology();
    }
}

