/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import jsbugs.DialogMatch;
import jsbugs.TableModelMatchAnalystHeaders;
import model3.AnalystHeader;
import model3.SBdb;
import model3.Smpdtl;
import model3.WsWell;
import util.SBException;

public class DialogMatchAnalystHeaders
extends JDialog {
    Image backgroundImage;
    TableModelMatchAnalystHeaders model = new TableModelMatchAnalystHeaders();
    WsWell wswell;
    char discID;
    boolean hasChanged = false;
    private JButton jButtonClose;
    private JButton jButtonSuiteNo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableMatchAnalystHeaders;

    public DialogMatchAnalystHeaders(Frame parent, boolean modal, char discID, WsWell wswell, SBdb ws, SBdb db) {
        super(parent, modal);
        this.initComponents();
        this.wswell = wswell;
        this.discID = discID;
        this.model.wssbdb = ws;
        this.model.dbsbdb = db;
        this.init();
    }

    private void init() {
        this.setTitle("Match Analyst Suites : " + SBdb.getDiscAbr(this.discID));
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.backgroundImage = DialogMatch.getBackgroundImage();
        this.initData();
        this.model.setupTable(this.jTableMatchAnalystHeaders);
        this.jTableMatchAnalystHeaders.getTableHeader().setReorderingAllowed(false);
    }

    private void initData() {
        LinkedList<AnalystHeader> wsHdrs = new LinkedList<AnalystHeader>();
        LinkedList<AnalystHeader> dbHdrs = new LinkedList<AnalystHeader>();
        try {
            for (AnalystHeader hdr : this.wswell.getAnalystHeaders()) {
                if (hdr.getDiscID() != this.discID) continue;
                wsHdrs.add(hdr);
            }
            for (AnalystHeader hdr : this.wswell.getLink().getAnalystHeaders()) {
                if (hdr.getDiscID() != this.discID) continue;
                dbHdrs.add(hdr);
            }
            this.model.data.init(wsHdrs, dbHdrs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(this){
            final /* synthetic */ DialogMatchAnalystHeaders this$0;
            {
                DialogMatchAnalystHeaders dialogMatchAnalystHeaders = this$0;
                Objects.requireNonNull(dialogMatchAnalystHeaders);
                this.this$0 = dialogMatchAnalystHeaders;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(this.this$0.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jButtonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchAnalystHeaders = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonSuiteNo = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(500, 250));
        this.jPanel1.setMinimumSize(new Dimension(400, 200));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchAnalystHeaders this$0;
            {
                DialogMatchAnalystHeaders dialogMatchAnalystHeaders = this$0;
                Objects.requireNonNull(dialogMatchAnalystHeaders);
                this.this$0 = dialogMatchAnalystHeaders;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jTableMatchAnalystHeaders.setModel(this.model);
        this.jTableMatchAnalystHeaders.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jTableMatchAnalystHeaders);
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 2));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, this.jLabel2.getFont().getSize() + 2));
        this.jLabel2.setText("...Database");
        this.jButtonSuiteNo.setText("Suite no...");
        this.jButtonSuiteNo.setToolTipText("Edit selected workspace suite number");
        this.jButtonSuiteNo.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchAnalystHeaders this$0;
            {
                DialogMatchAnalystHeaders dialogMatchAnalystHeaders = this$0;
                Objects.requireNonNull(dialogMatchAnalystHeaders);
                this.this$0 = dialogMatchAnalystHeaders;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSuiteNoActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 372, Short.MAX_VALUE).addComponent(this.jLabel2)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 551, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonClose, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSuiteNo, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGap(6, 6, 6).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonSuiteNo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 165, Short.MAX_VALUE).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, -1, 223, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonSuiteNoActionPerformed(ActionEvent evt) {
        Integer newNo;
        if (this.jTableMatchAnalystHeaders.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "Select a workspace analysis suite", this.getTitle(), 2);
            return;
        }
        AnalystHeader ws = (AnalystHeader)this.model.data.get(this.jTableMatchAnalystHeaders.getSelectedRow()).getWs();
        if (ws == null) {
            JOptionPane.showMessageDialog(this, "Select a workspace analysis suite", this.getTitle(), 2);
            return;
        }
        String newNoStrg = JOptionPane.showInputDialog(this, "Enter new suite number:", "" + new Integer(ws.getAnalyNumber() + 1));
        if (newNoStrg == null || newNoStrg.isEmpty()) {
            return;
        }
        try {
            newNo = Integer.parseInt(newNoStrg);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "You must enter an integer number", this.getTitle(), 2);
            return;
        }
        try {
            for (int i = 0; i < this.model.data.size(); ++i) {
                AnalystHeader ah = (AnalystHeader)this.model.data.get(i).getWs();
                if (ah == null || ah.getAnalystUsrid() != ws.getAnalystUsrid() || ah.getAnalyNumber() != newNo.intValue()) continue;
                AnalystHeader changeAbn = null;
                AnalystHeader changeEnv = null;
                if (ah.getAbnSchID() != ws.getAbnSchID()) {
                    if (ah.getAbnSchID() > 0 && ws.getAbnSchID() > 0) {
                        JOptionPane.showMessageDialog(this, "Cannot merge suites: abundance schemes conflict", this.getTitle(), 2);
                        return;
                    }
                    AnalystHeader analystHeader = changeAbn = ah.getAbnSchID() > 0 ? ws : ah;
                }
                if (ah.getEnvSchID() != ws.getEnvSchID()) {
                    if (ah.getEnvSchID() > 0 || ws.getEnvSchID() > 0) {
                        JOptionPane.showMessageDialog(this, "Cannot merge suites: abundance schemes conflict", this.getTitle(), 2);
                        return;
                    }
                    changeEnv = ah.getEnvSchID() > 0 ? ws : ah;
                }
                for (Smpdtl wsDtl : this.wswell.getAnalyses(this.discID, ws.getAnalyst(), ws.getAnalyNumber())) {
                    for (Smpdtl other : this.wswell.getAnalyses(this.discID, ws.getAnalyst(), (int)newNo)) {
                        if (wsDtl.getSample().getSampID() != other.getSample().getSampID()) continue;
                        JOptionPane.showMessageDialog(this, "Cannot merge suites: analyses at the same samples", this.getTitle(), 2);
                        return;
                    }
                }
                if (changeAbn != null) {
                    changeAbn.setAbnScheme(changeAbn == ws ? ah.getAbnSchID() : ws.getAbnSchID());
                }
                if (changeEnv == null) continue;
                changeEnv.setEnvScheme(changeEnv == ws ? ah.getEnvSchID() : ws.getEnvSchID());
            }
            ws.setAnalyNo(newNo);
            this.hasChanged = true;
            this.wswell.updateAnalystHeadersStatus();
            this.initData();
            this.model.fireTableDataChanged();
        }
        catch (SQLException sql) {
            JOptionPane.showMessageDialog(this, "Error: " + sql.getMessage(), this.getTitle(), 0);
            sql.printStackTrace();
        }
        catch (SBException sbe) {
            JOptionPane.showMessageDialog(this, "Error: " + sbe.getMessage(), this.getTitle(), 0);
            sbe.printStackTrace();
        }
    }
}

