/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.user.Userdef;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogMatch;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchBiocom;
import jsbugs.table.ArrowCellRenderer;
import model3.Biocom;
import model3.InterpHdr;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import model3.WellInterp;
import model3.WsWell;
import util.MatchData;
import util.SB;
import util.SBException;
import util.exception.StackError;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

public class DialogMatchBiocoms
extends JDialog {
    WsWell wsWell = null;
    TableModelMatchBiocom model = new TableModelMatchBiocom();
    InterpHdr hdr;
    char discID;
    Image backgroundImage;
    WellInterp wsInterp = null;
    WellInterp dbInterp = null;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonExclude;
    private JButton jButtonSave;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableMatchBioComs;

    public DialogMatchBiocoms(Frame parent, boolean modal, SBdb ws, SBdb db, WsWell well, char discID, char units, InterpHdr hdr) throws SBException, SQLException {
        super(parent, modal);
        this.wsWell = well;
        this.hdr = hdr;
        this.discID = discID;
        this.model.units = units;
        this.initComponents();
        this.init();
    }

    private void init() throws SBException, SQLException {
        this.backgroundImage = this.backgroundImage = DialogMatch.getBackgroundImage();
        this.setTitle("Match Biostratigraphic Comments");
        this.checkLinks();
        int interpID = this.hdr.getInterpID();
        if (this.wsWell.hasInterpLoaded(interpID)) {
            this.wsInterp = this.wsWell.getInterp(interpID);
        }
        if (this.wsWell.getLink() != null && this.hdr.getLink() != null) {
            this.wsWell.getLink().loadInterps();
            int dbInterpID = this.hdr.getLink().getInterpID();
            if (this.wsWell.getLink().hasInterpLoaded(dbInterpID)) {
                this.dbInterp = this.wsWell.getLink().getInterp(dbInterpID);
                this.wsWell.getLink().loadInterp(this.dbInterp);
            }
        }
        this.model.data.init(this.wsInterp != null ? this.wsInterp.getComments(this.discID) : null, this.dbInterp != null ? this.dbInterp.getComments(this.discID) : null);
        SB.setTableHeaderBold((JTable)this.jTableMatchBioComs);
        TableColumnModel columnModel = this.jTableMatchBioComs.getTableHeader().getColumnModel();
        columnModel.getColumn(4).setMaxWidth(TableModelMatchBiocom.colWidths[4]);
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelMatchBiocom.colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(TableModelMatchBiocom.colWidths[i]);
        }
        columnModel.getColumn(0).setCellRenderer((TableCellRenderer)new SbugsStatusRenderer());
        columnModel.getColumn(1).setCellRenderer((TableCellRenderer)new SbugsStatusRenderer());
        this.jTableMatchBioComs.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        this.jTableMatchBioComs.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
        this.jTableMatchBioComs.setRowSorter(new TableRowSorter<TableModelMatchBiocom>(this.model));
        new ColumnSortResetHandler(this.jTableMatchBioComs).attach();
        this.model.fireTableDataChanged();
        this.jTableMatchBioComs.getTableHeader().setReorderingAllowed(false);
    }

    private void checkLinks() throws SQLException, SBException {
        if (this.wsWell.getLink() != null) {
            SBdb ws = this.wsWell.getDataModel();
            if (!this.wsWell.getAnalyses(this.discID, null, 0).isEmpty()) {
                for (Userdef u : ws.getUsers()) {
                    if (u.getLink() != null) continue;
                    throw new SBException("Cannot open dialog, analysts not Matched");
                }
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(this){
            final /* synthetic */ DialogMatchBiocoms this$0;
            {
                DialogMatchBiocoms dialogMatchBiocoms = this$0;
                Objects.requireNonNull(dialogMatchBiocoms);
                this.this$0 = dialogMatchBiocoms;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(this.this$0.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchBioComs = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonExclude = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonSave = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(500, 500));
        this.setModal(true);
        this.jTableMatchBioComs.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableMatchBioComs);
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 2));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, this.jLabel2.getFont().getSize() + 2));
        this.jLabel2.setText("...Database");
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected data from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchBiocoms this$0;
            {
                DialogMatchBiocoms dialogMatchBiocoms = this$0;
                Objects.requireNonNull(dialogMatchBiocoms);
                this.this$0 = dialogMatchBiocoms;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected data from database");
        this.jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchBiocoms this$0;
            {
                DialogMatchBiocoms dialogMatchBiocoms = this$0;
                Objects.requireNonNull(dialogMatchBiocoms);
                this.this$0 = dialogMatchBiocoms;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchBiocoms this$0;
            {
                DialogMatchBiocoms dialogMatchBiocoms = this$0;
                Objects.requireNonNull(dialogMatchBiocoms);
                this.this$0 = dialogMatchBiocoms;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.setToolTipText("Save all unsaved comments to the database");
        this.jButtonSave.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchBiocoms this$0;
            {
                DialogMatchBiocoms dialogMatchBiocoms = this$0;
                Objects.requireNonNull(dialogMatchBiocoms);
                this.this$0 = dialogMatchBiocoms;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel2)).addComponent(this.jScrollPane1, -1, 717, Short.MAX_VALUE)).addGap(10, 10, 10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonClose, -1, 78, Short.MAX_VALUE).addComponent(this.jButtonSave, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonExclude, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 376, Short.MAX_VALUE).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 480, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.deleteBiocom(false);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteBiocom(true);
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        if (this.wsWell.getLink() == null) {
            JOptionPane.showMessageDialog(this, "No linked well - use Match | Wells from main menu.", this.getTitle(), 2);
            return;
        }
        if (this.dbInterp == null) {
            JOptionPane.showMessageDialog(this, "Version not linked - use Match | Versions from main menu.", this.getTitle(), 2);
            return;
        }
        try {
            Well dbWell = this.wsWell.getLink();
            SBdb wsDB = this.wsWell.getDataModel();
            boolean doStore = true;
            Sample sampleAdded = null;
            Statement stmt = null;
            for (int row = 0; row < this.model.data.size(); ++row) {
                Sample baseSample;
                MatchData.MatchPair pair = this.model.data.get(row);
                Biocom ws = (Biocom)pair.getWs();
                Biocom db = (Biocom)pair.getDb();
                if (ws == null || db != null) continue;
                Sample topSample = dbWell.getSample(ws.getTopSample().getTopDepth(), ws.getTopSample().getBaseDepth(), ws.getTopSample().getType());
                if (topSample == null) {
                    int opt = JOptionPane.showConfirmDialog(this, "Sample: " + String.valueOf(ws.getTopSample()) + " does not exist: create it?", this.getTitle(), 0, 3);
                    if (opt != 0) {
                        doStore = false;
                        break;
                    }
                    if (stmt == null) {
                        stmt = dbWell.getDataModel().getDatabase().createStatement();
                    }
                    sampleAdded = dbWell.addSampleCopy(stmt, ws.getTopSample());
                }
                if (ws.getBaseSample() != null && (baseSample = dbWell.getSample(ws.getBaseSample().getTopDepth(), ws.getBaseSample().getBaseDepth(), ws.getBaseSample().getType())) == null) {
                    int opt = JOptionPane.showConfirmDialog(this, "Sample: " + String.valueOf(ws.getTopSample()) + " does not exist: create it?", this.getTitle(), 0, 3);
                    if (opt != 0) {
                        doStore = false;
                        break;
                    }
                    if (stmt == null) {
                        stmt = dbWell.getDataModel().getDatabase().createStatement();
                    }
                    sampleAdded = dbWell.addSampleCopy(stmt, ws.getBaseSample());
                }
                int analystID = 0;
                if (ws.getAnalyst() <= 0) continue;
                Userdef wsUser = wsDB.getUser(ws.getAnalyst());
                if (wsUser == null) {
                    JOptionPane.showMessageDialog(this, "Cannot save: analyst used does not exist in workspace.");
                    doStore = false;
                    break;
                }
                if (wsUser.getLink() == null) {
                    JOptionPane.showMessageDialog(this, "Cannot save: analyst is not matched: " + wsUser.getAbr());
                    doStore = false;
                    break;
                }
                analystID = wsUser.getLink().getUsrID();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (doStore) {
                this.dbInterp.storeComments(this.wsInterp, this.wsWell.getLink().getWellID(), this.discID);
            }
            if (sampleAdded != null) {
                dbWell.notifyObservers(sampleAdded);
            }
            this.wsWell.updateAllBCMStatus(this.wsInterp, this.dbInterp != null ? this.dbInterp.getHeader() : null, this.model.units, true);
            this.model.data.init(this.wsInterp != null ? this.wsInterp.getComments(this.discID) : null, this.dbInterp != null ? this.dbInterp.getComments(this.discID) : null);
            this.model.fireTableDataChanged();
            this.wsWell.getLink().getDataModel().commit();
            this.dbInterp.notifyObservers(19);
        }
        catch (Exception e) {
            this.wsWell.getLink().getDataModel().doRollback();
            StackError.showStackError((String)"Error saving comment", (Throwable)e);
            e.printStackTrace();
        }
    }

    private void deleteBiocom(boolean fromDatabase) {
        if (fromDatabase && this.wsWell.getLink() == null) {
            JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
            return;
        }
        if (this.jTableMatchBioComs.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 2);
            return;
        }
        int[] selected = this.jTableMatchBioComs.getSelectedRows();
        LinkedList<Biocom> toRemove = new LinkedList<Biocom>();
        for (int i : selected) {
            Biocom biocom = fromDatabase ? (Biocom)this.model.data.get(this.jTableMatchBioComs.convertRowIndexToModel(i)).getDb() : (Biocom)this.model.data.get(this.jTableMatchBioComs.convertRowIndexToModel(i)).getWs();
            if (biocom == null) continue;
            toRemove.add(biocom);
        }
        if (fromDatabase && toRemove.size() > 0) {
            Object msg = "Really delete ";
            msg = (String)msg + (String)(toRemove.size() == 1 ? "this comment" : "these " + toRemove.size() + " comment");
            if (JOptionPane.showConfirmDialog(this, msg = (String)msg + (toRemove.size() == 1 ? "?" : "s?"), this.getTitle(), 0, 3) != 0) {
                return;
            }
        }
        try {
            Well deleteFromWell = fromDatabase ? this.wsWell.getLink() : this.wsWell;
            int deleteFromInterpID = fromDatabase ? this.hdr.getLink().getInterpID() : this.hdr.getInterpID();
            WellInterp deleteFromWellInterp = deleteFromWell.getInterp(deleteFromInterpID);
            deleteFromWellInterp.deleteBiocoms(toRemove, deleteFromWell.getWellID());
            String text = fromDatabase ? "deleted" : "excluded";
            JOptionPane.showMessageDialog(this, "Comments " + text + ": " + toRemove.size(), this.getTitle(), 1);
            if (fromDatabase) {
                deleteFromWell.getDataModel().commit();
                deleteFromWellInterp.notifyObservers(19);
            } else {
                this.wsWell.updateAllBCMStatus(this.wsInterp, this.dbInterp != null ? this.dbInterp.getHeader() : null, this.model.units, true);
            }
            this.model.data.init(this.wsInterp != null ? this.wsInterp.getComments(this.discID) : null, this.dbInterp != null ? this.dbInterp.getComments(this.discID) : null);
            this.model.fireTableDataChanged();
        }
        catch (SQLException sql) {
            if (fromDatabase) {
                this.wsWell.getLink().getDataModel().doRollback();
            }
            FrameJsbugs.showStackError("SQL Error " + (fromDatabase ? "deleting" : "excluding"), sql, this.wsWell.getLink().getDataModel());
        }
        catch (SBException sbe) {
            if (fromDatabase) {
                this.wsWell.getLink().getDataModel().doRollback();
            }
            StackError.showStackError((String)("Error " + (fromDatabase ? "deleting" : "excluding")), (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }
}

