/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.table.TableUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.DialogMatchDict;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelSB;
import jsbugs.model2.event.DialogCmpStd;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.table.ColourRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.Audit;
import model3.CompositeStandard;
import model3.CompositeStandardEvent;
import model3.SBdb;
import util.InvalidFieldException;
import util.MatchData;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;
import util.status.SbugsStatus;
import util.status.SbugsStatusRenderer;
import util.status.StringStatus;

public class DialogMatchCmpStd
extends DialogMatchDict {
    private final TableModelMatchCmpStd model = new TableModelMatchCmpStd(this);
    private final SBdb db;
    private final CompositeStandard wsStd;

    public DialogMatchCmpStd(Frame parent, boolean modal, CompositeStandard std, SBdb db, boolean inWizard) throws SBException, SQLException {
        super(parent, modal, inWizard);
        this.db = db;
        this.wsStd = std;
        this.init();
    }

    private void init() throws SBException, SQLException {
        super.init(this.model, "Match Composite Standard Events", this.wsStd.getName());
        this.model.setUpTable(this.jTableMatch);
        this.initStdCombo();
        if (this.wsStd.getLink() == null) {
            this.model.data.init(this.wsStd.getEvents(false), null);
        }
        JButton jButtonExclude = new JButton("Exclude");
        jButtonExclude.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchCmpStd this$0;
            {
                DialogMatchCmpStd dialogMatchCmpStd = this$0;
                Objects.requireNonNull(dialogMatchCmpStd);
                this.this$0 = dialogMatchCmpStd;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.deleteEvents(false);
            }
        });
        this.addSidebarButton(jButtonExclude);
        JButton jButtonDelete = new JButton("Delete");
        jButtonDelete.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchCmpStd this$0;
            {
                DialogMatchCmpStd dialogMatchCmpStd = this$0;
                Objects.requireNonNull(dialogMatchCmpStd);
                this.this$0 = dialogMatchCmpStd;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.this$0.wsStd.getLink() == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this.this$0), "Select a database composite", "Match Composite Standard", 2);
                    return;
                }
                this.this$0.deleteEvents(true);
            }
        });
        this.addSidebarButton(jButtonDelete);
        JButton jButtonSave = new JButton("Save");
        jButtonSave.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchCmpStd this$0;
            {
                DialogMatchCmpStd dialogMatchCmpStd = this$0;
                Objects.requireNonNull(dialogMatchCmpStd);
                this.this$0 = dialogMatchCmpStd;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.jButtonSaveActionPerformed(e);
            }
        });
        this.addSidebarButton(jButtonSave);
    }

    private void initStdCombo() throws SQLException, SBException {
        this.dbModel.removeAllElements();
        this.dbModel.addElement("<Select>");
        for (CompositeStandard std : this.db.getCompositeStandards()) {
            this.dbModel.addElement(std);
        }
        if (this.wsStd.getLink() != null) {
            this.dbModel.setSelectedItem(this.wsStd.getLink());
        } else {
            for (CompositeStandard dbCmpStd : this.db.getCompositeStandards()) {
                if (!dbCmpStd.getName().equalsIgnoreCase(this.wsStd.getName())) continue;
                dbCmpStd.loadEvents();
                this.dbModel.setSelectedItem(dbCmpStd);
                break;
            }
        }
    }

    @Override
    void comboModelActionPerformed() {
        Object item = this.dbModel.getSelectedItem();
        if (item instanceof CompositeStandard) {
            CompositeStandard std = (CompositeStandard)item;
            try {
                std.loadEvents();
                this.wsStd.setLink(std);
                this.model.data.init(this.wsStd.getEvents(false), std.getEvents(false));
            }
            catch (RuntimeException | SQLException | SBException e) {
                SbugsExceptionHandler.showStackError("Error matching composite", e, (Component)((Object)this));
            }
        } else {
            try {
                this.wsStd.setLink(null);
                this.model.data.init(this.wsStd.getEvents(false), null);
            }
            catch (SBException sbe) {
                StackError.showStackError((String)"Error", (Throwable)sbe);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
        }
        this.model.fireTableDataChanged();
    }

    @Override
    void add() {
        try {
            DialogCmpStd dialog = new DialogCmpStd((JDialog)((Object)this), true, this.db, this.wsStd);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.initStdCombo();
                this.dbModel.setSelectedItem(dialog.getCmpStdAdded());
            }
        }
        catch (IllegalStateException ie) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You can't add this Composite Standard: " + ie.toString());
            ie.printStackTrace();
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
        }
    }

    @Override
    void OK() {
        if (this.inWizard && this.wsStd.getLink() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "You must match or add this composite standard.", this.getTitle(), 2);
            return;
        }
        this.setOK();
    }

    @Override
    String getHelpPage() {
        return null;
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        if (this.wsStd.getLink() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Workspace composite must be matched or added before saving", this.getTitle(), 2);
            return;
        }
        try {
            LinkedList<CompositeStandardEvent.Builder> builders = new LinkedList<CompositeStandardEvent.Builder>();
            for (CompositeStandardEvent event : this.wsStd.getEvents(false)) {
                if (event.getStatus() == SbugsStatus.CONFLICT) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Conflicting data in workspace", this.getTitle(), 2);
                    return;
                }
                if (event.getEvent().getLink() == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Cannot save: unlinked event in workspace: " + String.valueOf(event.getEvent()), this.getTitle(), 2);
                    return;
                }
                if (event.getStatus() == SbugsStatus.NOTSTORED) {
                    CompositeStandardEvent.Builder copy = CompositeStandardEvent.Builder.copyOf(event);
                    copy.event(event.getEvent().getLink()).audit(new Audit(this.db, this.wsStd.getDatabase(), event.getAudit()));
                    builders.add(copy);
                    continue;
                }
                if (event.getStatus() != SbugsStatus.PARTSTORED) continue;
                CompositeStandardEvent dbEvt = this.wsStd.getLink().getEvent(event.getEvent().getLink().getEvID(), event.getType());
                if (dbEvt == null) {
                    throw new SBException("Missing event match for part stored event: " + String.valueOf(event));
                }
                this.wsStd.getLink().updateEventComment(dbEvt, event.getComments());
            }
            this.wsStd.getLink().addEvents(builders);
            this.db.commit();
            this.wsStd.updateStatus();
            this.model.data.init(this.wsStd.getEvents(false), this.wsStd.getLink().getEvents(false));
            this.model.fireTableDataChanged();
        }
        catch (IllegalStateException | InvalidFieldException | SBPermissionException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
    }

    private void deleteEvents(boolean fromDatabase) {
        if (this.jTableMatch.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select events to " + (fromDatabase ? "delete" : "exclude"), this.getTitle(), 2);
            return;
        }
        if (fromDatabase) {
            try {
                if (!this.wsStd.getLink().canWrite(this.db, null)) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "You do not have the privilege to edit the database composite", this.getTitle(), 2);
                    return;
                }
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
                return;
            }
        }
        LinkedList<CompositeStandardEvent> toRemove = new LinkedList<CompositeStandardEvent>();
        for (int i : this.jTableMatch.getSelectedRows()) {
            CompositeStandardEvent evt = fromDatabase ? (CompositeStandardEvent)this.model.data.get(i).getDb() : (CompositeStandardEvent)this.model.data.get(i).getWs();
            if (evt == null) continue;
            toRemove.add(evt);
        }
        CompositeStandard std = fromDatabase ? this.wsStd.getLink() : this.wsStd;
        try {
            std.deleteEvents(toRemove);
            this.wsStd.updateStatus();
            if (fromDatabase) {
                this.wsStd.getLink().notifyObservers();
                this.db.commit();
            }
            this.model.data.init(this.wsStd.getEvents(false), this.wsStd.getLink() != null ? this.wsStd.getLink().getEvents(false) : null);
            this.model.fireTableDataChanged();
        }
        catch (SQLException | SBException | SBPermissionException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
        }
    }

    private class TableModelMatchCmpStd
    extends AbstractTableModel {
        static final int COL_WS_EVENT = 0;
        static final int COL_WS_TYPE = 1;
        static final int COL_WS_CSUMINUS = 2;
        static final int COL_WS_CSU = 3;
        static final int COL_WS_CSUPLUS = 4;
        static final int COL_WS_COMMENTS = 5;
        static final int COL_ARROW = 6;
        static final int COL_DB_EVENT = 7;
        static final int COL_DB_TYPE = 8;
        static final int COL_DB_CSUMINUS = 9;
        static final int COL_DB_CSU = 10;
        static final int COL_DB_CSUPLUS = 11;
        static final int COL_DB_COMMENTS = 12;
        final String[] colTitles;
        final int[] colWidths;
        final MatchData data;
        final /* synthetic */ DialogMatchCmpStd this$0;

        private TableModelMatchCmpStd(DialogMatchCmpStd dialogMatchCmpStd) {
            DialogMatchCmpStd dialogMatchCmpStd2 = dialogMatchCmpStd;
            Objects.requireNonNull(dialogMatchCmpStd2);
            this.this$0 = dialogMatchCmpStd2;
            this.colTitles = new String[]{"Event", "Type", "-", "CSU", "+", "Comment", "", "Event", "Type", "-", "CSU", "+", "Comment"};
            this.colWidths = new int[]{60, 15, 5, 20, 5, 25, 20, 60, 15, 5, 20, 5, 25};
            this.data = new MatchData();
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return this.colTitles.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MatchData.MatchPair pair = this.data.get(rowIndex);
            if (pair == null) {
                return "";
            }
            CompositeStandardEvent ws = (CompositeStandardEvent)pair.getWs();
            CompositeStandardEvent db = (CompositeStandardEvent)pair.getDb();
            try {
                switch (columnIndex) {
                    case 0: {
                        return ws == null ? null : new StringStatus(ws.getEvent().toString(), ws.getStatus());
                    }
                    case 1: {
                        return ws == null ? null : new StringStatus(ws.getEvTypeString(), ws.getStatus());
                    }
                    case 2: {
                        return ws == null ? null : new StringStatus((String)(ws.getErrMinus() == null ? "" : "" + ws.getErrMinus()), ws.getStatus());
                    }
                    case 3: {
                        return ws == null ? null : new StringStatus("" + ws.getCSU(), ws.getStatus());
                    }
                    case 4: {
                        return ws == null ? null : new StringStatus((String)(ws.getErrPlus() == null ? "" : "" + ws.getErrPlus()), ws.getStatus());
                    }
                    case 5: {
                        return ws == null ? null : new StringStatus(ws.getComments(), ws.getStatus());
                    }
                    case 6: {
                        return ws != null && db != null ? TableModelSB.linked : TableModelSB.unlinked;
                    }
                    case 7: {
                        return db == null ? null : db.getEvent().toString();
                    }
                    case 8: {
                        return db == null ? null : db.getEvTypeString();
                    }
                    case 9: {
                        return db == null ? null : db.getErrMinus();
                    }
                    case 10: {
                        return db == null ? null : Double.valueOf(db.getCSU());
                    }
                    case 11: {
                        return db == null ? null : db.getErrPlus();
                    }
                    case 12: {
                        return db == null ? null : db.getComments();
                    }
                }
                return "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 6: {
                    return Boolean.class;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return StringStatus.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                default: 
            }
            return false;
        }

        void setUpTable(JTable table) {
            TableUtils.setTableHeaderBold((JTable)table);
            TableColumnModel columnModel = table.getTableHeader().getColumnModel();
            columnModel.getColumn(6).setMaxWidth(this.colWidths[6]);
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                columnModel.getColumn(i).setHeaderValue(this.colTitles[i]);
                columnModel.getColumn(i).setPreferredWidth(this.colWidths[i]);
            }
            table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
            table.setDefaultRenderer(Color.class, new ColourRenderer(true));
            table.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
        }
    }
}

