/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.model3.taxon.SearchMode;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jsbugs.DialogMatch;
import jsbugs.DialogSelectGenus;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelSB;
import jsbugs.table.ArrowCellRenderer;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.Genus;
import model3.SBdb;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class DialogMatchGenera
extends DialogMatch {
    static final int COL_DONCAT = 0;
    static final int COL_DONOR = 1;
    static final int COL_ARROW = 2;
    static final int COL_HOSTCAT = 3;
    static final int COL_HOST = 4;
    static String[] colTitles = new String[]{"Cat.", "Donor Genus", "", "Cat.", "Host Genus"};
    static int[] colWidths = new int[]{20, 50, 20, 20, 50};
    private final SBdb ws;
    private final SBdb db;
    private List<Genus> wsGenera;
    private final TableModelMatchGenera model = new TableModelMatchGenera(this);

    public DialogMatchGenera(Frame parent, boolean modal, SBdb ws, SBdb db, boolean inWizard) {
        super(parent, modal, inWizard);
        this.ws = ws;
        this.db = db;
        this.init();
    }

    private void init() {
        super.init(this.model, "Match Independent Genera", null, null, new ActionListener(this){
            final /* synthetic */ DialogMatchGenera this$0;
            {
                DialogMatchGenera dialogMatchGenera = this$0;
                Objects.requireNonNull(dialogMatchGenera);
                this.this$0 = dialogMatchGenera;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.matchAll();
            }
        }, null, new ActionListener(this){
            final /* synthetic */ DialogMatchGenera this$0;
            {
                DialogMatchGenera dialogMatchGenera = this$0;
                Objects.requireNonNull(dialogMatchGenera);
                this.this$0 = dialogMatchGenera;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.matchRow();
            }
        }, new ActionListener(this){
            final /* synthetic */ DialogMatchGenera this$0;
            {
                DialogMatchGenera dialogMatchGenera = this$0;
                Objects.requireNonNull(dialogMatchGenera);
                this.this$0 = dialogMatchGenera;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.addAll();
            }
        }, null, null, null);
        TableColumnModel columnModel = this.jTableMatch.getColumnModel();
        for (int i = 0; i < colTitles.length; ++i) {
            columnModel.getColumn(i).setHeaderValue(colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
        }
        columnModel.getColumn(2).setMaxWidth(colWidths[2]);
        columnModel.getColumn(2).setCellRenderer(new ArrowCellRenderer());
        SB.setTableHeaderBold((JTable)this.jTableMatch);
        this.jTableMatch.getTableHeader().setReorderingAllowed(false);
        this.jTableMatch.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogMatchGenera this$0;
            {
                DialogMatchGenera dialogMatchGenera = this$0;
                Objects.requireNonNull(dialogMatchGenera);
                this.this$0 = dialogMatchGenera;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() > 1) {
                    this.this$0.matchRow();
                }
            }
        });
        this.wsGenera = new ArrayList<Genus>(this.ws.getIndependentGenera());
        this.refreshSorter();
    }

    boolean hasGenera() {
        return !this.wsGenera.isEmpty();
    }

    @Override
    void OK() {
        if (this.inWizard) {
            for (Genus genus : this.wsGenera) {
                if (genus.getLink() != null) continue;
                JOptionPane.showMessageDialog((Component)((Object)this), "You must match all genera.", this.getTitle(), 2);
                return;
            }
        }
        this.setOK();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void matchAll() {
        boolean ignoreCategory = false;
        try {
            for (Genus genus : this.wsGenera) {
                String cat_mnem;
                if (genus.getLink() != null || (cat_mnem = genus.getCategoryMnemonic()).isEmpty() || this.db.getCategory(cat_mnem) != null) continue;
                if (JOptionPane.showConfirmDialog((Component)((Object)this), "Unknown category found\nDo you want to ignore unknown categories in search?", "Match Genera", 0, 3) != 0) break;
                ignoreCategory = true;
                break;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.ws.matchAllGeneraIndependent(this.db, ignoreCategory);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.refreshSorter();
    }

    private void matchRow() {
        if (this.jTableMatch.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select one row to match", this.getTitle(), 2);
            return;
        }
        Genus selected = this.wsGenera.get(this.getSeletedRows().get(0));
        DialogSelectGenus dialog = new DialogSelectGenus((Dialog)((Object)this), true, this.db, true, selected.getGenusCopy());
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.getSelectedItem() != null) {
            try {
                Genus match = this.db.getGenus(((com.stratadata.model3.taxon.Genus)dialog.getSelectedItem()).getGenID());
                selected.setLink(match);
                this.jTableMatch.repaint();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAll() {
        int toAdd = 0;
        for (Genus genus : this.wsGenera) {
            if (genus.getLink() != null) continue;
            ++toAdd;
        }
        if (toAdd == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "There are no unmatched genera to add.", this.getTitle(), 2);
            return;
        }
        if (JOptionPane.showConfirmDialog((Component)((Object)this), "WARNING: This option may add duplicate, unnecessary, or inconsistent genera to your database.\nDo you want to continue?", "Add all", 0, 2) != 0) {
            return;
        }
        try {
            int nGenera = this.db.getGenusService().getGenusCount();
            if ((nGenera > 9000 || toAdd > 20) && JOptionPane.showConfirmDialog((Component)((Object)this), "WARNING: There are already " + nGenera + " entries in your dictionary.\nAre you sure you want to continue to add these " + toAdd + "?", "Add all", 0, 3) != 0) {
                return;
            }
        }
        catch (RuntimeException sql) {
            SbugsExceptionHandler.showStackError(sql, (Component)((Object)this));
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        int unknownCategory = 0;
        try {
            for (Genus donor : this.wsGenera) {
                if (donor.getLink() != null) continue;
                Genus match = this.lookupGenus(donor);
                if (match != null) {
                    donor.setLink(match);
                    continue;
                }
                if (donor.getCategoryMnemonic().isEmpty() || this.db.getCategory(donor.getCategoryMnemonic()) == null) {
                    ++unknownCategory;
                    continue;
                }
                this.db.fillGenusFromWorkspace(this.ws, donor);
                this.db.commit();
            }
            if (unknownCategory > 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), unknownCategory + (unknownCategory > 1 ? " genera were " : " genus was ") + "not added because the category was blank or not recognised", "Match Genera", 1);
            }
        }
        catch (SBPermissionException sBPermissionException) {
            JOptionPane.showMessageDialog((Component)((Object)this), sBPermissionException.getMessage(), "Permission Error", 2);
        }
        catch (SQLException | SBException throwable) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", (Exception)throwable, this.db);
        }
        catch (RuntimeException runtimeException) {
            StackError.showStackError((String)"", (Throwable)runtimeException);
        }
        finally {
            this.refreshSorter();
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private Genus lookupGenus(Genus wsGenus) throws SQLException {
        if (wsGenus.getLink() == null) {
            String cat_mnem = wsGenus.getCategoryMnemonic();
            if (cat_mnem.isEmpty() || this.db.getCategory(cat_mnem) == null) {
                return null;
            }
            com.stratadata.model3.taxon.Genus genus = wsGenus.getGenusCopy();
            List matchingGenera = this.db.getGenusService().findMatchingGenera(genus, SearchMode.LOOKUP);
            if (!matchingGenera.isEmpty()) {
                return this.db.getGenus(((com.stratadata.model3.taxon.Genus)matchingGenera.get(0)).getGenID());
            }
        }
        return null;
    }

    private class TableModelMatchGenera
    extends AbstractTableModel {
        final /* synthetic */ DialogMatchGenera this$0;

        private TableModelMatchGenera(DialogMatchGenera dialogMatchGenera) {
            DialogMatchGenera dialogMatchGenera2 = dialogMatchGenera;
            Objects.requireNonNull(dialogMatchGenera2);
            this.this$0 = dialogMatchGenera2;
        }

        @Override
        public int getRowCount() {
            if (this.this$0.wsGenera == null) {
                return 0;
            }
            return this.this$0.wsGenera.size();
        }

        @Override
        public int getColumnCount() {
            return colTitles.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Genus ws = this.this$0.wsGenera.get(row);
            if (ws == null) {
                return null;
            }
            switch (col) {
                case 0: {
                    return ws.getCategoryMnemonic();
                }
                case 1: {
                    return ws.toString(false);
                }
                case 2: {
                    return ws.getLink() != null ? TableModelSB.linked : TableModelSB.unlinked;
                }
                case 4: {
                    if (ws.getLink() != null) {
                        return ws.getLink();
                    }
                    return "";
                }
                case 3: {
                    if (ws.getLink() != null) {
                        return ws.getLink().getCategoryMnemonic();
                    }
                    return "";
                }
            }
            return "";
        }
    }
}

