/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.stratadata.util.ui.SBDialog;
import com.stratadata.util.ui.table.ColumnSortResetHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableRowSorter;
import jsbugs.DialogMatch;
import jsbugs.DialogMatchIGDScheme;
import jsbugs.DialogMatchIGDSuggestions;
import jsbugs.DialogSelectScheme;
import jsbugs.DialogSwitchIGDterms;
import jsbugs.FrameJsbugs;
import jsbugs.FrameOrganiser;
import jsbugs.HierReassign;
import jsbugs.TableModelMatchIGD;
import jsbugs.TableModelMatchIGDSchemeUnits;
import jsbugs.TableModelMatchIGDSurfaces;
import jsbugs.model2.igdscheme.DialogIGDScheme;
import jsbugs.organiser.DialogMatchIGDWellUnits;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.IGDInterval;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnitBase;
import model3.SBdb;
import model3.SQPick;
import model3.Surface;
import model3.Well;
import model3.WellInterp;
import model3.WsWell;
import util.InvalidFieldException;
import util.SBException;
import util.SBObservable;
import util.SBPermissionException;
import util.exception.StackError;
import util.status.SbugsStatus;

public class DialogMatchIGD
extends SBDialog
implements Observer {
    private final SBdb ws;
    private final SBdb db;
    private final TableModelMatchIGD model = new TableModelMatchIGD();
    private final TableModelMatchIGDSchemeUnits modelUnits = new TableModelMatchIGDSchemeUnits();
    private final JTable tableUnits = new JTable(this.modelUnits);
    private final JComboBox unitsComboBox = new JComboBox();
    private final TableModelMatchIGDSurfaces modelSurfaces = new TableModelMatchIGDSurfaces();
    private final JTable tableSurfaces = new JTable(this.modelSurfaces);
    private final JComboBox surfaceComboBox = new JComboBox();
    private Image backgroundImage;
    private final boolean[] hasIGD = new boolean[]{false, false, false, false};
    private static final int[] igdTypes = new int[]{3, 2, 4, 10};
    private final FrameOrganiser frameOrganiser;
    Logger LOGGER = Logger.getLogger(DialogMatchIGD.class.getName());
    private JButton jButtonAddScheme;
    private JButton jButtonCancel;
    private JButton jButtonCreatePicks;
    private JButton jButtonExclude;
    private JButton jButtonFindScheme;
    private JButton jButtonHelp;
    private JButton jButtonMatchAll;
    private JButton jButtonMatchScheme;
    private JButton jButtonOK;
    private JButton jButtonSelectScheme;
    private JButton jButtonShowInformal;
    private JButton jButtonSwitchTerms;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTable jTableMatchIGD;

    public DialogMatchIGD(Frame parent, boolean modal, SBdb ws, SBdb db) throws SQLException, SBException {
        super(parent, modal);
        this.frameOrganiser = (FrameOrganiser)parent;
        this.ws = ws;
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SQLException, SBException {
        this.setTitle("Match Stratigraphic Interval Units and Picked Surfaces");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        Iterator<Well> it = this.ws.getWellIterator();
        while (it.hasNext()) {
            Well well = it.next();
            Iterator<WellInterp> iit = well.getInterpIterator();
            while (iit.hasNext()) {
                WellInterp interp = iit.next();
                for (int i = 0; i < this.hasIGD.length - 1; ++i) {
                    if (interp.getIGDList(igdTypes[i], 0).size() <= 0) continue;
                    this.hasIGD[i] = true;
                }
                if (interp.getSQPicks().size() <= 0) continue;
                this.hasIGD[3] = true;
            }
        }
        this.model.setUpTable(this.jTableMatchIGD);
        this.unitsComboBox.setMaximumRowCount(25);
        this.modelUnits.setUpTable(this.tableUnits, 3, this.unitsComboBox);
        this.tableUnits.setRowSorter(new TableRowSorter<TableModelMatchIGDSchemeUnits>(this.modelUnits));
        new ColumnSortResetHandler(this.tableUnits).attach();
        this.tableSurfaces.setRowSorter(new TableRowSorter<TableModelMatchIGDSurfaces>(this.modelSurfaces));
        new ColumnSortResetHandler(this.tableSurfaces).attach();
        this.surfaceComboBox.setMaximumRowCount(25);
        this.modelSurfaces.setUpTable(this.tableSurfaces, this.surfaceComboBox);
        this.jScrollPane1.add(this.tableUnits);
        this.jScrollPane1.setViewportView(this.tableUnits);
        this.initSchemes();
        this.backgroundImage = DialogMatch.getBackgroundImage();
    }

    private void initSchemes() throws SQLException {
        for (int i = 0; i < igdTypes.length; ++i) {
            if (!this.hasIGD[i]) continue;
            int igdType = igdTypes[i];
            for (IGDScheme scheme : this.ws.getIGDSchemes(igdType, true)) {
                this.model.list.add(scheme);
                scheme.addObserver(this);
                scheme.updateStatus();
            }
        }
        this.model.fireTableDataChanged();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(this){
            final /* synthetic */ DialogMatchIGD this$0;
            {
                DialogMatchIGD dialogMatchIGD = this$0;
                Objects.requireNonNull(dialogMatchIGD);
                this.this$0 = dialogMatchIGD;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(this.this$0.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonSelectScheme = new JButton();
        this.jButtonMatchScheme = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane2 = new JScrollPane();
        this.jTableMatchIGD = new JTable();
        this.jButtonAddScheme = new JButton();
        this.jButtonMatchAll = new JButton();
        this.jButtonCreatePicks = new JButton();
        this.jButtonFindScheme = new JButton();
        this.jButtonShowInformal = new JButton();
        this.jButtonExclude = new JButton();
        this.jButtonSwitchTerms = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(600, 300));
        this.setModal(true);
        this.jButtonOK.setText("OK");
        this.jButtonOK.setToolTipText("Commit matches to well data");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGD this$0;
            {
                DialogMatchIGD dialogMatchIGD = this$0;
                Objects.requireNonNull(dialogMatchIGD);
                this.this$0 = dialogMatchIGD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGD this$0;
            {
                DialogMatchIGD dialogMatchIGD = this$0;
                Objects.requireNonNull(dialogMatchIGD);
                this.this$0 = dialogMatchIGD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setToolTipText("Schemes and units will not be unmatched");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGD this$0;
            {
                DialogMatchIGD dialogMatchIGD = this$0;
                Objects.requireNonNull(dialogMatchIGD);
                this.this$0 = dialogMatchIGD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonSelectScheme.setText("Select Scheme...");
        this.jButtonSelectScheme.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonSelectScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGD this$0;
            {
                DialogMatchIGD dialogMatchIGD = this$0;
                Objects.requireNonNull(dialogMatchIGD);
                this.this$0 = dialogMatchIGD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSelectSchemeActionPerformed(evt);
            }
        });
        this.jButtonMatchScheme.setText("Match Scheme...");
        this.jButtonMatchScheme.setToolTipText("Match full scheme (not necessary for import of well data)");
        this.jButtonMatchScheme.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonMatchScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGD this$0;
            {
                DialogMatchIGD dialogMatchIGD = this$0;
                Objects.requireNonNull(dialogMatchIGD);
                this.this$0 = dialogMatchIGD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMatchSchemeActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 1, this.jLabel1.getFont().getSize() + 2));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, this.jLabel2.getFont().getSize() + 2));
        this.jLabel2.setText("...Database");
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.4);
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jSplitPane1.setBottomComponent(this.jScrollPane1);
        this.jScrollPane2.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTableMatchIGD.setModel(this.model);
        this.jTableMatchIGD.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DialogMatchIGD this$0;
            {
                DialogMatchIGD dialogMatchIGD = this$0;
                Objects.requireNonNull(dialogMatchIGD);
                this.this$0 = dialogMatchIGD;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.jTableMatchIGDMouseClicked(evt);
            }
        });
        this.jTableMatchIGD.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogMatchIGD this$0;
            {
                DialogMatchIGD dialogMatchIGD = this$0;
                Objects.requireNonNull(dialogMatchIGD);
                this.this$0 = dialogMatchIGD;
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                this.this$0.jTableMatchIGDKeyReleased(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTableMatchIGD);
        this.jSplitPane1.setLeftComponent(this.jScrollPane2);
        this.jButtonAddScheme.setText("Add Scheme...");
        this.jButtonAddScheme.setToolTipText("Add selected workspace scheme to database");
        this.jButtonAddScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGD this$0;
            {
                DialogMatchIGD dialogMatchIGD = this$0;
                Objects.requireNonNull(dialogMatchIGD);
                this.this$0 = dialogMatchIGD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAddSchemeActionPerformed(evt);
            }
        });
        this.jButtonMatchAll.setText("Match all");
        this.jButtonMatchAll.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGD this$0;
            {
                DialogMatchIGD dialogMatchIGD = this$0;
                Objects.requireNonNull(dialogMatchIGD);
                this.this$0 = dialogMatchIGD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonMatchAllActionPerformed(evt);
            }
        });
        this.jButtonCreatePicks.setText("Create picks");
        this.jButtonCreatePicks.setToolTipText("Create surfaces and picks from selected interval data");
        this.jButtonCreatePicks.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGD this$0;
            {
                DialogMatchIGD dialogMatchIGD = this$0;
                Objects.requireNonNull(dialogMatchIGD);
                this.this$0 = dialogMatchIGD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCreatePicksActionPerformed(evt);
            }
        });
        this.jButtonFindScheme.setText("Suggest scheme...");
        this.jButtonFindScheme.setToolTipText("Find schemes which contains the most likely unit matches ");
        this.jButtonFindScheme.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonFindScheme.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGD this$0;
            {
                DialogMatchIGD dialogMatchIGD = this$0;
                Objects.requireNonNull(dialogMatchIGD);
                this.this$0 = dialogMatchIGD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonFindSchemeActionPerformed(evt);
            }
        });
        this.jButtonShowInformal.setText("Reassign units ...");
        this.jButtonShowInformal.setToolTipText("Show all the formal and informal terms linked to scheme, and resssign to different schemes");
        this.jButtonShowInformal.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonShowInformal.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGD this$0;
            {
                DialogMatchIGD dialogMatchIGD = this$0;
                Objects.requireNonNull(dialogMatchIGD);
                this.this$0 = dialogMatchIGD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonShowInformalActionPerformed(evt);
            }
        });
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude scheme and associated intervals from the workspace");
        this.jButtonExclude.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGD this$0;
            {
                DialogMatchIGD dialogMatchIGD = this$0;
                Objects.requireNonNull(dialogMatchIGD);
                this.this$0 = dialogMatchIGD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonSwitchTerms.setText("Switch terms...");
        this.jButtonSwitchTerms.setToolTipText("Change the order of scheme qualifier terms");
        this.jButtonSwitchTerms.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogMatchIGD this$0;
            {
                DialogMatchIGD dialogMatchIGD = this$0;
                Objects.requireNonNull(dialogMatchIGD);
                this.this$0 = dialogMatchIGD;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSwitchTermsActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 478, Short.MAX_VALUE).addComponent(this.jLabel2)).addComponent(this.jSplitPane1, -1, 657, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonMatchAll, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonSelectScheme, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonFindScheme, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonShowInformal, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonMatchScheme, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAddScheme, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCreatePicks, GroupLayout.Alignment.TRAILING, 0, 0, Short.MAX_VALUE).addComponent(this.jButtonExclude, -2, 113, -2).addComponent(this.jButtonOK, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCancel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addComponent(this.jButtonSwitchTerms, -2, 115, -2)).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jButtonAddScheme, this.jButtonCancel, this.jButtonCreatePicks, this.jButtonExclude, this.jButtonFindScheme, this.jButtonHelp, this.jButtonMatchAll, this.jButtonMatchScheme, this.jButtonOK, this.jButtonSelectScheme, this.jButtonShowInformal);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addGap(12, 12, 12).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonMatchAll).addGap(4, 4, 4).addComponent(this.jButtonSelectScheme).addGap(4, 4, 4).addComponent(this.jButtonFindScheme).addGap(32, 32, 32).addComponent(this.jButtonMatchScheme).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddScheme).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCreatePicks).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExclude).addGap(12, 12, 12).addComponent(this.jButtonShowInformal).addGap(18, 18, 18).addComponent(this.jButtonSwitchTerms).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jSplitPane1, GroupLayout.Alignment.LEADING, -1, 527, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmatchigd.html");
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        Object msg;
        boolean hasSchemeConflicts = false;
        boolean hasUnmatched = false;
        boolean hasUnmatchedPicks = false;
        block5: for (IGDScheme scheme : this.model.list) {
            if (scheme.getLink() == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Not all workspace schemes are linked to database schemes.\nYou need to select a scheme from the database to be assigned to the workspace intervals, or Exclude the scheme.", this.getTitle(), 2);
                return;
            }
            if (scheme.getStatus() == IGDScheme.CONFLICT) {
                hasSchemeConflicts = true;
            }
            try {
                Iterator<Well> it = this.ws.getWellIterator();
                while (it.hasNext()) {
                    Well well = it.next();
                    Iterator<SBObservable> iit = well.getInterpIterator();
                    while (iit.hasNext()) {
                        WellInterp interp = (WellInterp)iit.next();
                        if (scheme.getIGDType() == 10) {
                            List<SQPick> picks = interp.getSQPicks();
                            for (SQPick pick : picks) {
                                Surface s = pick.getSurface();
                                if (s.getLink() != null) continue;
                                hasUnmatchedPicks = true;
                                continue block5;
                            }
                            continue;
                        }
                        List<IGDIntervalZone> zones = interp.getIGDList(scheme.getIGDType(), scheme.getID());
                        for (IGDIntervalZone zone : zones) {
                            if (zone.getUppZone() > 0 && (scheme.findUnitBase(zone.getUppZone()) == null || scheme.findUnitBase(zone.getUppZone()).getLink() == null)) {
                                hasUnmatched = true;
                                if (scheme.findUnitBase(zone.getUppZone()) != null) continue block5;
                                this.LOGGER.log(Level.WARNING, "Workspace unit {0} does not occur in scheme: {1}", new Object[]{zone.getUppZone(), scheme.toString()});
                                continue block5;
                            }
                            if (zone.getLowZone() <= 0 || scheme.findUnitBase(zone.getLowZone()) == null || scheme.findUnitBase(zone.getLowZone()).getLink() != null) continue;
                            hasUnmatched = true;
                        }
                    }
                }
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error checking matches", sql, this.db);
            }
            catch (RuntimeException re) {
                StackError.showStackError((String)"", (Throwable)re);
            }
        }
        if (hasSchemeConflicts) {
            msg = "Warning: some matched schemes have conflicting attributes.\nThe workspace units/surfaces will be replaced by the database units/surfaces.\nInterpreted interval and sequence pick names will be updated as appropriate.";
            System.out.println((String)msg);
        }
        if (hasUnmatched || hasUnmatchedPicks) {
            int opt;
            msg = "";
            if (hasUnmatched) {
                msg = (String)msg + "Warning: There are unmatched units in the workspace.\nIntervals linked to unmatched units will be imported with an informal name only.";
            }
            if (hasUnmatchedPicks) {
                if (!((String)msg).isEmpty()) {
                    msg = (String)msg + "\n";
                }
                msg = (String)msg + "Warning: There are unmatched sequence picks in the workspace.\nAll picks linked to unmatched surfaces will be EXCLUDED from the well data imported.";
            }
            if ((opt = JOptionPane.showConfirmDialog((Component)((Object)this), msg = (String)msg + "\nContinue?", this.getTitle(), 0, 3)) != 0) {
                return;
            }
        }
        try {
            int potential;
            boolean recommended;
            String msg2;
            int opt;
            HierReassign hierReassign = this.assignDbHier(false);
            if (hierReassign.nNotMatchingScheme > 0 && (opt = JOptionPane.showConfirmDialog((Component)((Object)this), msg2 = "There are " + hierReassign.nNotMatchingScheme + " (out of " + hierReassign.nMatchingScheme + ") linked intervals whose hierarchy level does not match the level of the linked unit.\nReassign interval hierarchy levels to match scheme hierarchy? " + ((recommended = hierReassign.nNotMatchingScheme * 3 > hierReassign.nMatchingScheme) ? "(Recommended, but may cause conflicts with overlapping intervals)" : "(Not recommended)"), this.getTitle(), 0, 3)) == 0) {
                this.assignDbHier(true);
            }
            int killedPicks = this.saveSurfaces();
            int informalResult = 0;
            boolean hasInformal = false;
            for (IGDScheme scheme : this.model.list) {
                if (this.getInformals(scheme).isEmpty()) continue;
                hasInformal = true;
                break;
            }
            if (hasInformal && (potential = this.linkInformals(false)) > 0) {
                informalResult = this.linkInformals(true);
            }
            int zonesResult = this.saveUnits();
            Object msg3 = "";
            if (killedPicks > 0) {
                msg3 = (String)msg3 + "Picks deleted: " + killedPicks;
            }
            if (zonesResult > 0) {
                if (!((String)msg3).isEmpty()) {
                    msg3 = (String)msg3 + "\n";
                }
                msg3 = (String)msg3 + "Number of interval names updated with names from matched scheme: " + zonesResult;
            }
            if (informalResult > 0) {
                if (!((String)msg3).isEmpty()) {
                    msg3 = (String)msg3 + "\n";
                }
                msg3 = (String)msg3 + "(Workspace scheme(s) updated, " + informalResult + " units)";
            }
            if (!((String)msg3).isEmpty()) {
                JOptionPane.showMessageDialog((Component)((Object)this), msg3, this.getTitle(), 1);
            }
            this.setOK();
        }
        catch (RuntimeException | SQLException | SBException | SBPermissionException ex) {
            SbugsExceptionHandler.showStackError(ex, (Component)((Object)this));
        }
    }

    private int saveSurfaces() throws SQLException, SBException, SBPermissionException {
        Iterator<Well> it = this.ws.getWellIterator();
        LinkedList<SQPick> toKill = new LinkedList<SQPick>();
        int nDeleted = 0;
        boolean askedInformal = false;
        boolean keepInformalPickName = false;
        while (it.hasNext()) {
            Well well = it.next();
            Iterator<WellInterp> iit = well.getInterpIterator();
            while (iit.hasNext()) {
                WellInterp interp = iit.next();
                toKill.clear();
                for (SQPick pick : interp.getSQPicks()) {
                    if (pick.getSurface().getLink() == null) {
                        toKill.add(pick);
                        continue;
                    }
                    if (pick.getInfName() == null || pick.getInfName().isEmpty() || !pick.getInfName().equals(pick.getSurface().getName())) continue;
                    if (!askedInformal) {
                        int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Do you want to keep informal sequence pick names?", "Match IGD", 0, 3);
                        askedInformal = true;
                        boolean bl = keepInformalPickName = opt == 0;
                    }
                    if (keepInformalPickName) continue;
                    pick.setInfName("");
                }
                nDeleted += toKill.size();
                interp.delete(toKill, 0);
            }
        }
        for (IGDScheme scheme : this.model.list) {
            if (scheme.getIGDType() == 10) {
                for (Surface surface : scheme.getSurfaces()) {
                    if (surface.getLink() == null || surface.getStatus() != SbugsStatus.CONFLICT) continue;
                    surface.copyLink();
                }
            }
            scheme.updateStatus();
        }
        return nDeleted;
    }

    @Override
    public void update(Observable o, Object arg) {
        int row = this.jTableMatchIGD.getSelectedRow();
        int modelRow = this.jTableMatchIGD.convertRowIndexToModel(row);
        this.model.fireTableDataChanged();
        if (modelRow > -1) {
            row = this.jTableMatchIGD.convertRowIndexToView(modelRow);
            this.jTableMatchIGD.setRowSelectionInterval(row, row);
        }
    }

    private int saveUnits() throws SQLException, SBException {
        int nUpdated = 0;
        for (IGDScheme scheme : this.model.list) {
            if (scheme.getIGDType() == 10) continue;
            for (IGDUnitBase unit : scheme.getUnitBases()) {
                if (unit.getLink() == null || unit.getStatus() != SbugsStatus.CONFLICT) continue;
                if (!unit.getName().equalsIgnoreCase(unit.getLink().getName())) {
                    Iterator<Well> pit = this.ws.getWellIterator();
                    while (pit.hasNext()) {
                        Well well = pit.next();
                        Iterator<WellInterp> wit = well.getInterpIterator();
                        while (wit.hasNext()) {
                            WellInterp interp = wit.next();
                            for (IGDIntervalZone zone : interp.getIGDList(scheme.getIGDType(), scheme.getID())) {
                                boolean updated = false;
                                if (zone.getUppZone() == unit.getUnitID() && zone.getUppInf().equals(unit.getName())) {
                                    zone.setUppInf(unit.getLink().getName());
                                    updated = true;
                                }
                                if (zone.getLowZone() == unit.getUnitID() && zone.getLowInf().equals(unit.getName())) {
                                    zone.setLowInf(unit.getLink().getName());
                                    updated = true;
                                }
                                if (!updated) continue;
                                ++nUpdated;
                            }
                        }
                    }
                }
                unit.copyLink();
            }
            scheme.updateStatus();
        }
        return nUpdated;
    }

    private HierReassign assignDbHier(boolean assign) throws SQLException, SBException {
        HierReassign h = new HierReassign();
        h.nNotMatchingScheme = 0;
        h.nMatchingScheme = 0;
        for (int igdType : igdTypes) {
            if (igdType == 10) continue;
            Iterator<Well> it = this.ws.getWellIterator();
            while (it.hasNext()) {
                Well well = it.next();
                Iterator<WellInterp> iit = well.getInterpIterator();
                while (iit.hasNext()) {
                    WellInterp interp = iit.next();
                    List<IGDIntervalZone> igdList = interp.getIGDList(igdType);
                    for (IGDIntervalZone zone : igdList) {
                        IGDUnitBase unit;
                        int uppUnit;
                        IGDUnitBase unit2;
                        if (zone.getSchID() <= 0) continue;
                        IGDScheme scheme = this.ws.getIGDScheme(zone.getSchID());
                        int lowUnit = zone.getLowZone();
                        if (lowUnit > 0 && lowUnit != zone.getUppZone() && (unit2 = scheme.findUnitBase(lowUnit)) != null && unit2.getLink() != null) {
                            if (unit2.getLink().getHier() != zone.getHier()) {
                                if (assign) {
                                    zone.setHier(unit2.getLink().getHier());
                                } else {
                                    ++h.nNotMatchingScheme;
                                }
                            } else {
                                ++h.nMatchingScheme;
                            }
                        }
                        if ((uppUnit = zone.getUppZone()) <= 0 || (unit = scheme.findUnitBase(uppUnit)) == null || unit.getLink() == null) continue;
                        if (unit.getLink().getHier() != zone.getHier()) {
                            if (assign) {
                                zone.setHier(unit.getLink().getHier());
                                continue;
                            }
                            ++h.nNotMatchingScheme;
                            continue;
                        }
                        ++h.nMatchingScheme;
                    }
                }
            }
        }
        return h;
    }

    private int linkInformals(boolean doIt) throws SQLException, SBException {
        int added = 0;
        for (IGDScheme scheme : this.model.list) {
            if (scheme.getIGDType() == 10) continue;
            for (IGDIntervalZone informal : this.getInformals(scheme)) {
                IGDUnitBase linkUnit = null;
                if (informal.getUppZone() == 0) {
                    linkUnit = scheme.getLink().findUnitBase(informal.getUppInf());
                    if (linkUnit == null && informal.getUppInf().split(" ").length > 1) {
                        for (String split : informal.getUppInf().split(" ")) {
                            linkUnit = scheme.getLink().findUnitBase(split);
                            if (linkUnit != null) break;
                        }
                    }
                    if (linkUnit != null) {
                        if (doIt) {
                            IGDUnitBase wsUnit = scheme.findUnitBase(linkUnit.getName());
                            if (wsUnit == null) {
                                try {
                                    wsUnit = scheme.addUnit(IGDUnitBase.Builder.copyOf(linkUnit, this.ws));
                                    wsUnit.setLink(linkUnit, null);
                                }
                                catch (InvalidFieldException ife) {
                                    ife.printStackTrace();
                                }
                            }
                            if (wsUnit != null) {
                                informal.setUppZone(wsUnit.getUnitID());
                                if (informal.getLowZone() == 0 || scheme.findUnitBase(informal.getLowZone()).getHier() < wsUnit.getHier()) {
                                    informal.setHier(wsUnit.getHier());
                                }
                                if (informal.getUppInf().equalsIgnoreCase(wsUnit.getName()) && !informal.getUppInf().equals(wsUnit.getName())) {
                                    informal.setUppInf(wsUnit.getName());
                                }
                            }
                        }
                        ++added;
                    }
                }
                if (informal.getLowZone() != 0 || informal.getLowInf() == null || informal.getLowInf().isEmpty()) continue;
                boolean addedUpper = linkUnit != null;
                linkUnit = scheme.getLink().findUnitBase(informal.getLowInf());
                if (linkUnit == null && informal.getLowInf().split(" ").length > 1) {
                    for (String split : informal.getLowInf().split(" ")) {
                        linkUnit = scheme.getLink().findUnitBase(split);
                        if (linkUnit != null) break;
                    }
                }
                if (linkUnit == null) continue;
                if (doIt) {
                    IGDUnitBase wsUnit = scheme.findUnitBase(linkUnit.getName());
                    if (wsUnit == null) {
                        try {
                            wsUnit = scheme.addUnit(IGDUnitBase.Builder.copyOf(linkUnit, this.ws));
                            wsUnit.setLink(linkUnit, null);
                        }
                        catch (InvalidFieldException ife) {
                            ife.printStackTrace();
                        }
                    }
                    if (wsUnit != null) {
                        informal.setLowZone(wsUnit.getUnitID());
                        if (informal.getUppZone() == 0 || scheme.findUnitBase(informal.getUppZone()).getHier() < wsUnit.getHier()) {
                            informal.setHier(wsUnit.getHier());
                        }
                        if (informal.getLowInf().equalsIgnoreCase(wsUnit.getName()) && !informal.getLowInf().equals(wsUnit.getName())) {
                            informal.setLowInf(wsUnit.getName());
                        }
                    }
                }
                if (addedUpper) continue;
                ++added;
            }
        }
        return added;
    }

    private void jTableMatchIGDMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonSelectSchemeActionPerformed(null);
        }
        this.setTable();
    }

    private void setTable() {
        IGDScheme scheme = this.model.list.get(this.jTableMatchIGD.convertRowIndexToModel(this.jTableMatchIGD.getSelectedRow()));
        try {
            if (scheme.getIGDType() == 10) {
                if (this.jScrollPane1.getViewport().getView() == this.tableUnits) {
                    this.jScrollPane1.remove(this.tableUnits);
                    this.jScrollPane1.add(this.tableSurfaces);
                    this.jScrollPane1.setViewportView(this.tableSurfaces);
                }
                this.modelSurfaces.setSurfaces(scheme, this.ws);
                this.fillSurfaceCombo(scheme);
                this.modelSurfaces.fireTableDataChanged();
            } else {
                if (this.jScrollPane1.getViewport().getView() == this.tableSurfaces) {
                    this.jScrollPane1.remove(this.tableSurfaces);
                    this.jScrollPane1.add(this.tableUnits);
                    this.jScrollPane1.setViewportView(this.tableUnits);
                }
                this.modelUnits.setUpTable(this.tableUnits, scheme.getIGDType(), this.unitsComboBox);
                this.modelUnits.setUnits((JDialog)((Object)this), scheme, this.ws);
                this.fillUnitsCombo(scheme);
                this.modelUnits.fireTableDataChanged();
            }
        }
        catch (SQLException | SBException e) {
            FrameJsbugs.showStackError("Error", (Exception)e, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void fillSurfaceCombo(IGDScheme scheme) throws SQLException, SBException {
        this.surfaceComboBox.removeAllItems();
        if (scheme.getLink() != null) {
            this.surfaceComboBox.addItem(null);
            for (Surface surface : scheme.getLink().getSurfaces()) {
                this.surfaceComboBox.addItem(surface);
            }
        }
    }

    private void fillUnitsCombo(IGDScheme scheme) throws SQLException, SBException {
        this.unitsComboBox.removeAllItems();
        if (scheme.getLink() != null) {
            this.unitsComboBox.addItem(null);
            for (IGDUnitBase unit : scheme.getLink().getUnitBases()) {
                this.unitsComboBox.addItem(unit);
            }
        }
    }

    private void jButtonMatchSchemeActionPerformed(ActionEvent evt) {
        if (this.jTableMatchIGD.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No scheme selected", this.getTitle(), 2);
            return;
        }
        IGDScheme scheme = this.model.list.get(this.jTableMatchIGD.convertRowIndexToModel(this.jTableMatchIGD.getSelectedRow()));
        int n = 0;
        if (scheme.getIGDType() == 10) {
            for (Surface surface : this.modelSurfaces.surfaces) {
                if (surface.getLink() == null || surface.getLink().getName().equalsIgnoreCase(surface.getName())) continue;
                ++n;
            }
        } else {
            for (IGDUnitBase u : this.modelUnits.getList()) {
                if (u.getLink() == null || u.getLink().getName().equalsIgnoreCase(u.getName())) continue;
                ++n;
            }
        }
        if (n > 0) {
            String msg = "There are " + n + " workspace " + (scheme.getIGDType() == 10 ? "surfaces" : "units") + " which have been manually linked.";
            if (JOptionPane.showConfirmDialog((Component)((Object)this), msg = msg + "\nThese links will be reset. Continue?", "Match Schemes", 0) != 0) {
                return;
            }
        }
        try {
            scheme.updateStatus();
            DialogMatchIGDScheme dialog = new DialogMatchIGDScheme((Dialog)((Object)this), true, scheme, this.db, false);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (scheme.getIGDType() == 10) {
                this.fillSurfaceCombo(scheme);
                this.modelSurfaces.fireTableDataChanged();
            } else {
                this.fillUnitsCombo(scheme);
                this.modelUnits.fireTableDataChanged();
            }
            this.model.fireTableDataChanged();
        }
        catch (SQLException | SBException sql) {
            FrameJsbugs.showStackError("SQL Error", (Exception)sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonSelectSchemeActionPerformed(ActionEvent evt) {
        if (this.jTableMatchIGD.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Choose a scheme from the workspace list", this.getTitle(), 2);
            return;
        }
        try {
            int row = this.jTableMatchIGD.getSelectedRow();
            IGDScheme scheme = this.model.list.get(this.jTableMatchIGD.convertRowIndexToModel(row));
            DialogSelectScheme dialog = new DialogSelectScheme((JDialog)((Object)this), true, this.db, scheme.getIGDType(), null);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.selection != null) {
                IGDScheme origLink = scheme.getLink();
                if (dialog.selection != origLink) {
                    dialog.selection.loadUnits();
                    scheme.setLink(dialog.selection);
                    this.setTable();
                    if (scheme.getIGDType() == 10) {
                        this.modelSurfaces.linkSurfaces(scheme);
                        this.fillSurfaceCombo(scheme);
                    } else {
                        assert (scheme == this.modelUnits.scheme);
                        this.fillUnitsCombo(scheme);
                    }
                    this.model.fireTableDataChanged();
                }
                this.jTableMatchIGD.setRowSelectionInterval(row, row);
            }
        }
        catch (SQLException | SBException e) {
            FrameJsbugs.showStackError("Error", (Exception)e, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jTableMatchIGDKeyReleased(KeyEvent evt) {
        if (this.jTableMatchIGD.getSelectedRowCount() != 1) {
            return;
        }
        this.setTable();
    }

    private void jButtonAddSchemeActionPerformed(ActionEvent evt) {
        if (this.jTableMatchIGD.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No scheme selected", this.getTitle(), 2);
            return;
        }
        IGDScheme scheme = this.model.list.get(this.jTableMatchIGD.convertRowIndexToModel(this.jTableMatchIGD.getSelectedRow()));
        try {
            DialogIGDScheme dialog = new DialogIGDScheme((JDialog)((Object)this), true, this.db, scheme, scheme.getIGDType(), null);
            dialog.setLocationRelativeTo((Component)((Object)this));
            dialog.setVisible(true);
            if (dialog.isOK()) {
                scheme.setLink(dialog.getSchemeAdded());
                this.setTable();
                if (scheme.getIGDType() == 10) {
                    this.modelSurfaces.linkSurfaces(scheme);
                    this.fillSurfaceCombo(scheme);
                } else {
                    assert (scheme == this.modelUnits.scheme);
                    this.fillUnitsCombo(scheme);
                }
                this.model.fireTableDataChanged();
            }
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonMatchAllActionPerformed(ActionEvent evt) {
        try {
            for (int igdType : igdTypes) {
                for (IGDScheme scheme : this.ws.getIGDSchemes(igdType, true)) {
                    if (scheme.getLink() != null) continue;
                    for (IGDScheme dbScheme : this.db.getIGDSchemes(igdType, true)) {
                        if (!dbScheme.getName().equalsIgnoreCase(scheme.getName())) continue;
                        dbScheme.loadUnits();
                        scheme.setLink(dbScheme);
                        if (igdType == 10) {
                            this.modelSurfaces.setSurfaces(scheme, this.ws);
                            this.modelSurfaces.linkSurfaces(scheme);
                            continue;
                        }
                        this.modelUnits.setUnits((JDialog)((Object)this), scheme, this.ws);
                        assert (this.modelUnits.scheme == scheme);
                    }
                }
            }
            this.modelSurfaces.fireTableDataChanged();
            this.modelUnits.fireTableDataChanged();
            this.model.fireTableDataChanged();
        }
        catch (SQLException | SBException ex) {
            FrameJsbugs.showStackError("Error", (Exception)ex, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonCreatePicksActionPerformed(ActionEvent evt) {
        if (this.jTableMatchIGD.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No scheme selected", this.getTitle(), 2);
            return;
        }
        int row = this.jTableMatchIGD.getSelectedRow();
        IGDScheme oldScheme = this.model.list.get(this.jTableMatchIGD.convertRowIndexToModel(this.jTableMatchIGD.getSelectedRow()));
        Object msg = "This option will change the selected scheme to a sequence scheme, and a series of surfaces and picks will replace the intervals in the workspace.\nWhere the interval has a sample range, the top sample will be used as the picked sample.\nContinue?";
        if (JOptionPane.showConfirmDialog((Component)((Object)this), msg, this.getTitle(), 0, 3) != 0) {
            return;
        }
        try {
            oldScheme.setLink(null);
            oldScheme.updateStatus();
            this.ws.deleteIGDScheme(oldScheme);
            IGDScheme scheme = IGDScheme.copyToSequence(this.ws, oldScheme);
            this.ws.addIGDScheme(scheme);
            int nPicks = 0;
            int nonInserts = 0;
            Iterator<Well> it = this.ws.getWellIterator();
            while (it.hasNext()) {
                WsWell well = (WsWell)it.next();
                Iterator<WellInterp> iit = well.getInterpIterator();
                while (iit.hasNext()) {
                    WellInterp interp = iit.next();
                    List<IGDIntervalZone> igdList = interp.getIGDList(oldScheme.getIGDType());
                    Iterator<IGDIntervalZone> it2 = igdList.iterator();
                    while (it2.hasNext()) {
                        int uppUnit;
                        IGDIntervalZone zone = it2.next();
                        if (zone.getSchID() != scheme.getID()) continue;
                        int lowUnit = zone.getLowZone();
                        if (lowUnit > 0 && lowUnit != zone.getUppZone()) {
                            System.out.println("Need to create lower pick for: " + zone.getLowInf());
                            IGDUnitBase unit = scheme.findUnitBase(lowUnit);
                            Surface surface = scheme.getSurface(zone.getLowInf(), Surface.SurfaceType.MFS);
                            try {
                                if (surface == null) {
                                    surface = scheme.addSurface(new Surface.Builder(scheme.getDatabase()).name(zone.getLowInf()).age(unit != null ? unit.getLage() : 0.0).type(Surface.SurfaceType.parseType(zone.getLowInf(), Surface.SurfaceType.MFS)));
                                }
                                interp.addSQPick(well, zone.getBaseSample(), surface, zone.getLowInf(), zone.getQLzone(), zone.getBaseBndInt());
                                ++nPicks;
                            }
                            catch (InvalidFieldException se) {
                                System.out.println("Non-insertion of: " + zone.getUppInf() + ": " + se.getMessage());
                                ++nonInserts;
                            }
                        }
                        if ((uppUnit = zone.getUppZone()) > 0) {
                            IGDUnitBase unit = scheme.findUnitBase(uppUnit);
                            Surface surface = scheme.getSurface(zone.getUppInf(), Surface.SurfaceType.MFS);
                            try {
                                if (surface == null) {
                                    surface = scheme.addSurface(new Surface.Builder(scheme.getDatabase()).name(zone.getUppInf()).age(unit != null && unit.getUage() != null ? unit.getUage() : 0.0).type(Surface.SurfaceType.parseType(zone.getUppInf(), Surface.SurfaceType.MFS)));
                                }
                                interp.addSQPick(well, zone.getTopSample(), surface, zone.getUppInf(), zone.getQUzone(), zone.getTopBndInt());
                                ++nPicks;
                            }
                            catch (InvalidFieldException se) {
                                System.out.println("Non-insertion of: " + zone.getUppInf() + ": " + se.getMessage());
                                ++nonInserts;
                            }
                        }
                        it2.remove();
                    }
                    interp.updateSQPickStatus(well.getMonitor(interp.getHeader().getInterpID(), 14), well, well.getWellUnits());
                }
            }
            msg = "Number of picks created: " + nPicks;
            if (nonInserts > 0) {
                msg = (String)msg + "\nNumber of non-inserts (due to overlaps or other errors: " + nonInserts;
            }
            JOptionPane.showMessageDialog((Component)((Object)this), msg, this.getTitle(), 1);
            if (nPicks > 0 || nonInserts > 0) {
                this.model.list.remove(oldScheme);
                this.model.list.add(scheme);
                this.model.fireTableDataChanged();
                this.jTableMatchIGD.setRowSelectionInterval(row, row);
                this.setTable();
                if (!this.frameOrganiser.dataTypes.contains(14)) {
                    this.frameOrganiser.dataTypes.add(14);
                }
                if (this.model.list.isEmpty()) {
                    this.dispose();
                }
            }
        }
        catch (RuntimeException | SQLException | SBException | SBPermissionException e) {
            SbugsExceptionHandler.showStackError(e, (Component)((Object)this));
        }
    }

    private void jButtonFindSchemeActionPerformed(ActionEvent evt) {
        if (this.jTableMatchIGD.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No scheme selected", this.getTitle(), 2);
            return;
        }
        int row = this.jTableMatchIGD.getSelectedRow();
        IGDScheme scheme = this.model.list.get(this.jTableMatchIGD.convertRowIndexToModel(row));
        try {
            if (scheme.getIGDType() == 10) {
                List<IGDScheme.MatchSchemes> matches = scheme.findMatches(this.db);
                if (matches == null || matches.isEmpty()) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "There are no schemes of the type which contain any units with matching names", this.getTitle(), 1);
                    return;
                }
                DialogMatchIGDSuggestions dialog = new DialogMatchIGDSuggestions((JDialog)((Object)this), true, matches, 0);
                dialog.setLocationRelativeTo((Component)((Object)this));
                dialog.setVisible(true);
                if (dialog.selection != null) {
                    IGDScheme origLink = scheme.getLink();
                    if (dialog.selection != origLink) {
                        scheme.setLink(dialog.selection);
                        this.setTable();
                        this.modelSurfaces.linkSurfaces(scheme);
                        this.fillSurfaceCombo(scheme);
                        this.model.fireTableDataChanged();
                    }
                    this.jTableMatchIGD.setRowSelectionInterval(row, row);
                }
            } else {
                List<IGDIntervalZone> informals = this.getInformals(scheme);
                List<IGDScheme.MatchSchemes> matches = scheme.findMatches(this.db, informals);
                if (matches == null || matches.isEmpty()) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "There are no schemes of the type which contain any units with matching names", this.getTitle(), 1);
                    return;
                }
                DialogMatchIGDSuggestions dialog = new DialogMatchIGDSuggestions((JDialog)((Object)this), true, matches, informals.size());
                dialog.setLocationRelativeTo((Component)((Object)this));
                dialog.setVisible(true);
                if (dialog.selection != null) {
                    IGDScheme origLink = scheme.getLink();
                    if (dialog.selection != origLink) {
                        scheme.setLink(dialog.selection);
                        this.setTable();
                        assert (this.modelUnits.scheme == scheme);
                        this.fillUnitsCombo(scheme);
                        this.model.fireTableDataChanged();
                    }
                    this.jTableMatchIGD.setRowSelectionInterval(row, row);
                }
            }
        }
        catch (SQLException | SBException e) {
            FrameJsbugs.showStackError("SQL Error", (Exception)e, this.db);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonShowInformalActionPerformed(ActionEvent evt) {
        if (this.jTableMatchIGD.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No scheme selected", this.getTitle(), 2);
            return;
        }
        IGDScheme scheme = this.model.list.get(this.jTableMatchIGD.convertRowIndexToModel(this.jTableMatchIGD.getSelectedRow()));
        try {
            if (scheme.getIGDType() == 10) {
                JOptionPane.showMessageDialog((Component)((Object)this), "You can't have informal picks in sequence schemes.", this.getTitle(), 1);
            } else {
                DialogMatchIGDWellUnits dialog = new DialogMatchIGDWellUnits((JDialog)((Object)this), true, this.ws, this.db, scheme);
                dialog.setLocationRelativeTo((Component)((Object)this));
                dialog.setVisible(true);
                if (dialog.isOK) {
                    this.model.list.clear();
                    this.initSchemes();
                    this.modelUnits.clearData();
                    this.modelUnits.fireTableDataChanged();
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        if (this.jTableMatchIGD.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No scheme selected", this.getTitle(), 2);
            return;
        }
        LinkedList<IGDScheme> schemesToExclude = new LinkedList<IGDScheme>();
        for (int row : this.jTableMatchIGD.getSelectedRows()) {
            IGDScheme scheme = this.model.list.get(this.jTableMatchIGD.convertRowIndexToModel(row));
            schemesToExclude.add(scheme);
        }
        try {
            boolean yesForAll = false;
            for (IGDScheme scheme : schemesToExclude) {
                if (!yesForAll) {
                    Object[] buttons = new String[]{"Yes", "Yes to all", "No"};
                    int opt = JOptionPane.showOptionDialog((Component)((Object)this), "Exclude '" + scheme.toString() + "' and all associated intervals/picks (formal and informal) from the workspace?", this.getTitle(), 0, 3, null, buttons, buttons[1]);
                    if (opt == 2) continue;
                    if (opt == 1) {
                        yesForAll = true;
                    }
                }
                Iterator<Well> it = this.ws.getWellIterator();
                while (it.hasNext()) {
                    WsWell well = (WsWell)it.next();
                    Iterator<WellInterp> iit = well.getInterpIterator();
                    while (iit.hasNext()) {
                        WellInterp wellInterp = iit.next();
                        if (scheme.getIGDType() == 10) {
                            list = wellInterp.getSQPicks().iterator();
                            while (list.hasNext()) {
                                SQPick pick = (SQPick)list.next();
                                if (pick.getSurface().getSchID() != scheme.getID()) continue;
                                list.remove();
                            }
                        } else {
                            list = wellInterp.getIGDList(scheme.getIGDType()).iterator();
                            while (list.hasNext()) {
                                IGDIntervalZone zone = (IGDIntervalZone)list.next();
                                if (zone.getSchID() != scheme.getID()) continue;
                                list.remove();
                            }
                        }
                        HashSet<Integer> dType = new HashSet<Integer>();
                        dType.add(IGDInterval.igdType2dType(scheme.getIGDType()));
                        if (scheme.getIGDType() == 10) {
                            dType.add(14);
                        }
                        well.resetInterpDataMonitors(dType, wellInterp.getHeader().getInterpID());
                    }
                }
                this.ws.deleteIGDScheme(scheme);
                this.model.list.remove(scheme);
            }
            if (this.modelUnits.getList() != null) {
                this.modelUnits.getList().clear();
                this.modelUnits.fireTableDataChanged();
            }
            if (this.modelSurfaces.surfaces != null) {
                this.modelSurfaces.surfaces.clear();
                this.modelSurfaces.fireTableDataChanged();
                this.model.fireTableDataChanged();
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            StackError.showStackError((String)"Error", (Throwable)sbe);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void jButtonSwitchTermsActionPerformed(ActionEvent evt) {
        DialogSwitchIGDterms dialog = new DialogSwitchIGDterms((JDialog)((Object)this), true, this.ws);
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.isOK && this.jTableMatchIGD.getSelectedRow() >= 0) {
            this.setTable();
        }
    }

    private List<IGDIntervalZone> getInformals(IGDScheme scheme) throws SQLException, SBException {
        LinkedList<IGDIntervalZone> informals = new LinkedList<IGDIntervalZone>();
        Iterator<Well> wells = this.ws.getWellIterator();
        while (wells.hasNext()) {
            Well well = wells.next();
            Iterator<WellInterp> it = well.getInterpIterator();
            while (it.hasNext()) {
                WellInterp wellInterp = it.next();
                List<IGDIntervalZone> zones = wellInterp.getIGDList(scheme.getIGDType(), scheme.getID());
                if (zones == null) continue;
                for (IGDIntervalZone zone : zones) {
                    if ((zone.getUppInf() == null || zone.getUppInf().length() <= 0 || zone.getUppZone() != 0) && (zone.getLowInf() == null || zone.getLowInf().length() <= 0 || zone.getLowZone() != 0)) continue;
                    informals.add(zone);
                }
            }
        }
        return informals;
    }
}

